 
#include <math.h>
#include <iostream.h>
#include <assert.h>

#include "hfloatfu.h"



int
r_prime(const hfloat &b0, hfloat &x, ulong n, 
        hfloat *m/*=NULL*/, int sum0q/*=0*/, long vq/*=0*/)
//
// compute 1-sum_{k=0}^{\infty}{(2^(n-1)*c_n^2)}
//
// for the agm iteration starting with 1 and b0
// if (sum0q!=0) sum_0 given in x (on input)
//
// c_{n+1}:=(a_n-b_n)/2
// c_0=a_0^2-1
//
// if(vq!=0)  print several quantities  (mainly for pi-computations) 
//
// result in x
//
// optional: agm in *m
//
// return number of iterations needed
//
{
    long prec;
    hfloat b(n), sum(n), t(n);

    if ( m!=NULL )  assert( !same_mantissa(*m,x) );


    b = b0;    // B_0= (given as arg)


    // SUM_0 = (1-b^2)/2:
    if (sum0q)
    {
        sum = x;
    }
    else
    {
        sqr(b,t);
	sub(1,t,sum);
	sum /= 2;          // sum_0 = (1-b*b)/2 = 2^-1*c_0^2
    }
    if ( vq )  print("\nSUM_0:\n",sum,vq);


    x = 1;    // B_0 = 1

    int k;
    for (k=1;  ; ++k)  
    {
 	if ( vq )  cout << "\n ----- step " << k << ": ----- " << endl;

        assert( (k<99)*(int)"r_prime(): no convergence" ); 

        add(x,b,t);                      // a+b
        if ( k != 1 )  b *= x;           // new b^2 = a*b  (avoid mult by a_0=1)
        //	if ( vq )  print("\nB_k^2=\n",b,vq);
        div2(t,x);                       // new a:= (a+b)/2 
	if ( vq )  print("\nA_k=\n",x,vq);


        sqr(x,t);                        // new a^2
        //	if ( vq )  print("\nA_k^2=\n",t,vq);
        t -= b;                          // c^2:=a^2-b^2
        //	if ( vq )  print("\nA_k^2-B_k^2=\n",t,vq);
        mul2pow(t,k-1,t);                // 2^(k-1)*(c_k)^2     
	if ( vq )  print("\nADD_k=\n",t,vq);


        //        brq = (t.is_zero() || (-t.exp() > (long)(t.prec()/2)));
        prec = -2*t.exp();
	if ( vq )  cout << "\n precision=" << prec << endl;


        sum += t;                         // sum_k=sum_{k-1} + 2^(k-1)*(C_k)^2     
	isqrt(b,t);                       // 1/sqrt(a*b)
        b *= t;                           // new b:= sqrt(a*b)=a*b* 1/sqrt(a*b)
	if ( vq )  print("\nB_k=\n",b,vq);

        if ( (prec>=(long)n) || t.is_zero() )  break;  // ? next c^2 will be zero 
    }

    if ( m!=NULL )  // AGM
    {
        add(x,b,t);  // a+b
	div2(t,*m);  // m=(a+b)/2  (AGM) 
    }  

    sub(1,sum,x);    // x = 1-sum 

    return k;
}
// ================================= end R_PRIME ==========================
