 
#include <math.h>
#include <iostream.h>
#include <assert.h>

#include "hfloatfu.h"


int
r_prime_4th(const hfloat &b0, hfloat &x, ulong n,
            hfloat *m/*=NULL*/, long vq/*=0*/)
//
// compute 1-sum_{k=0}^{\infty}{(2^(n-1)*c_n^2)}
// with c_{n+1}:=(a_n-b_n)/2
// as 1-sum_{k=0}^{\infty}{(4^(n)*(sa_n^4-((sa_n^2+sb_n^2)/2)^2))}
// 
// for the quartic agm iteration starting with 1 and b0:=sqrt(b)
//
// if (vq==1)  print several quantities  (mainly for pi-computations) 
//
//
// result in x
// optional: agm in *m
//
// returns number of iterations needed
//
{
    long prec;
    hfloat b(n), sum(n);
    hfloat t(n);
    hfloat u(n), v(n), s(n);

    if ( m!=NULL )  assert( !same_mantissa(*m,x) );
    //    assert( (x<1.0) *(int)"log_agm(): out of range" );
    //    assert( (x>0.5) *(int)"log_agm(): out of range" );

    b = b0;    // B_0= (given as arg)


    sqr(b,t);         // b_0^2
    t += 1;             // b_0^2+1
    div2(t,u);        // u_0= (b^2+1)/2
    sqr(u,t);         // ((b_0^2+1)/2)^2
    sub(1,t,sum);     // sum_0 = 1 - ((b_0^2+1)/2)^2
    if ( vq )  print("\n sum_0:\n",sum,vq);


    x = 1;     // a_0=1

    int k;
    for (k=1;  ; ++k)  
    {
 	if ( vq )  cout << "\n ----- step " << k << ": ----- " << endl;

        assert( (k<99)*(int)"r_prime4th(): no convergence" ); 

	add(x,b,t);                    // a+b
        b *= u;                        // b*(a^2+b^2)/2
        if ( k!=1 )  b *= x;           // a*b*(a^2+b^2)/2  (do not multiply with 1)
        root(b,4,b);                   // sqrt(sqrt(.))
	if ( vq )  print("\nB_k=\n",b,vq);


        div2(t,x);                     // (a+b)/2 
	if ( vq )  print("\nA_k=\n",x,vq);


        sqr(x,v);                      // a^2
        sqr(b,u);                      // b^2
        u += v;                        // a^2+b^2
        u /= 2;                        // u = (a^2+b^2)/2

        sqr(u,t);                      // t = ((a^2+b^2)/2)^2
        sqr(v,s);                      // a^4

	s -= t;                        // s = a^4-((a^2+b^2)/2)^2
        mul2pow(s,2*k,s);              // 4^k*(...)     
	if ( vq )  print("\nADD_k=\n",s,vq);


        sum += s;                      // sum+=4^k*(...)     

        //        brq = (s.is_zero() || (-s.exp()>(long)(s.prec()/4)));
        //        if ( brq )  break;                // ? next summand will be zero 

        prec = -4*s.exp();
	if ( vq )  cout << "\n precision=" << prec << endl;
        if ( (prec>=(long)n) || s.is_zero() )  break;  // ? next summand will be zero 
    }


    if ( m!=NULL )
    {
        add(x,b,t); 
	div2(t,*m);
        sqr(*m,*m);  // m = AGM
    }  

    sub(1,sum,x);    // x = 1-sum

    return k;
}
// ================================= end R_PRIME_4TH ==========================
