/*
 *	File: lexconst.h
 *
 *      (C) IWTS
 *          KU Nijmegen
 *          The Netherlands
 *
 *      Author: K. Behnke
 *
 *      History:
 *
 *      - 11 mar 1999, version 1.0
 *
 *      Description:
 *
 *      defines the constants for the lexical statistics functions
 *
 */

#ifndef LEX_CONST_H
#define LEX_CONST_H

/* definitions for integration */

#define NULL_F		0.0
#define EINS_F		1.0
#define EPS     	1.0e-6
#define EPS2 		3.0e-7
#define EPSILON		1.0e-9
#define JMAX		40
#define JMAXP   	JMAX+1
#define K       	5
#define ITMAX 		100          /* required by gammq () */
#define TINY 		1.0e-20      /* required by ludcmp () */
#define ADJSICHCONST	6.767676

/* definitions for simplex downhill parameter fitting */

#define NMAX    	5000
#define ALPHA   	1.0
#define BETA    	0.5
#define GAMMA   	2.0
#define GET_PSUM	for (j=1; j <= ndim; j++){for (i=1, sum=0.0;i<=mpts;i++)\
                                                  sum += p[i][j]; psum[j]=sum;}

#define FUNC2(x)	((*func)(x))

/* definitions for the lexical statistics */

#define MAXWORDLENGTH 	50
#define MAXWORDLENGTH2 	150
#define MAXTOKENS1 	100001    
#define MAXTOKENS2 	220001
#define MAXTYPES1 	20000
#define MAXTYPES2 	22001
#define MAXTYPES3 	60001
#define MAXTYPES4 	80001
#define MAXPERM 	5001
#define MAXCHUNKS1 	2
#define MAXCHUNKS2 	41
#define MAXCHUNKS3    	500			/* maximum number of chunks */
#define MAXCHUNKS4 	101			/* maximal number of chunks */
#define MAXCHUNKS5    	500			/* maximum number of chunks */
#define MAXCHUNKS6   	1000			/* maximum number of chunks */
#define MAXFITS        	4			/* maximum number of attempted fits */
#define MAXITERATIONS	10000			/* maximum number of iterations */
#define MAXM1        	2000			/* maximum number of ranks in spectrum */
#define MAXM2 		2001			/* maximum number of ranks in SPECTRUM (m, Vm) */
#define MAXM3        	6000			/* maximum number of ranks in spectrum */
#define MAXM4 		15000			/* maximum number of frequency ranks in spectrum */
#define MAXM_VM		4			/* m Vm  E[d(f=m)] sqrt(VAR[d(f=m)]) */
#define MAXX 		3.402823466E+38		/* max. float number */
#define NMEASURES 	24
#define NMEASURES2	25
#define MAXE            200                     /* Eqmethod */

/* For big texts, the following values can be used: */
/* #define MAXWORDLENGTH 	50 */
/* #define MAXTOKENS2 		500001  */
/* #define MAXTYPES2 		20000   */

/* definition of default values */

#define DEF_SEED 	1
#define DEF_MAXRANK	15
#define DEF_CHUNKS	20

/* reasonable defaults for integration interval */
#define L_BOUND		NULL_F                  /* lower bound (1) */
#define L_BOUND2	0.000001                /* lower bound (2) */
#define U_BOUND		10000.0                 /* upper bound (1) */
#define U_BOUND2	1000.0                  /* upper bound (2) */

/* mathematical constants */
#define PI		3.1415926535897931159979635
#define PI_2		1.5707963267948965579989817
#define PI_4		0.7853981633974482789994909
#define SQRT2PI		2.5066282746310002416123552

#endif
