(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     23560,        838]*)
(*NotebookOutlinePosition[     24492,        870]*)
(*  CellTagsIndexPosition[     24448,        866]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Chapter 3", "Title",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[TextData[{
  StyleBox["Power Series Solution of ODEs \nand Frobenius Series",
    FontSlant->"Italic"],
  " "
}], "Subtitle",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontWeight->"Bold"],

Cell[CellGroupData[{

Cell["Load ODE.m", "Section",
  FontFamily->"Times New Roman"],

Cell[TextData[{
  "Suppose you have copied the package ",
  StyleBox["ODE.m ",
    FontWeight->"Bold"],
  "in the directory  c:\\ODE. To load it, you have to type ",
  StyleBox["(\[ShiftKey] + \[ReturnIndicator])  in the current ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        SuperscriptBox["Mathematica", 
          StyleBox["\[RegisteredTrademark]",
            FontWeight->"Plain"]], TraditionalForm]]],
  StyleBox[" session",
    FontWeight->"Plain"]
}], "Text",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell["<<c:\\ODE\\ODE.m", "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["3.2  Power Series and the Program Taylor", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["\<\
Examples relative to the built-in functions Series and Normal\
\>", 
  "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(Series[Sin[x], {x, 0, 7}]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(Series[Sin[x\ y], {x, 0, 7}, {y, 0, 7}]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(Normal[Series[Sin[x\ y], {x, 0, 7}, {y, 0, 7}]]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example relative to the program Taylor", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(Taylor[Sin[x\ y], {x, y}, {0, 0}, 7]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["3.5 The Program SerSol", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["\<\
Example 3.3: Material point subjected to an undamped and aging \
spring\
\>", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    StyleBox[
      RowBox[{
        RowBox[{"sys", "=", 
          RowBox[{"{", 
            RowBox[{
              RowBox[{
                SuperscriptBox["x", "\[Prime]",
                  MultilineFunction->None], "==", "y"}], ",", " ", 
              RowBox[{
                SuperscriptBox[
                  SuperscriptBox["y", "\[Prime]",
                    MultilineFunction->None], "\[Prime]",
                  MultilineFunction->None], "==", 
                \(\(-Exp[\(-0.1\)\ t]\)\ x\)}]}], "}"}]}], ";", "\n", 
        \(SerSol[sys, {x, y}, t, {1, 0}, 4, 0, 2, 2000]\)}],
      FontSize->12]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Example 3.4:  Material point subjected to its weight and a \
resistence\
\>", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"sys", "=", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox["x", "\[Prime]",
                MultilineFunction->None], "==", "u"}], ",", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], "==", "w"}], ",", 
            RowBox[{
              SuperscriptBox["u", "\[Prime]",
                MultilineFunction->None], "==", 
              \(\(-0.0001\) \(\@\(u\^2 + w\^2\)\) u\)}], ",", 
            RowBox[{
              SuperscriptBox["w", "\[Prime]",
                MultilineFunction->None], "==", 
              \(\(-10\) - 0.0001 \(\@\( u\^2 + w\^2\)\) w\)}]}], "}"}]}], ";",
       "\n", \(unk = {x, y, u, w}\), ";", "\n", 
      \(unk0 = {0, 0, 100\ Cos[45\ Degree], 100\ Sin[45\ Degree]}\), ";", 
      "\n", "\n", \(SerSol[sys, unk, t, unk0, 4, 0, 14, 1000]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["3.6 Other Applications of SerSol", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Example 3.5: Airy's equation", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"sys", "=", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox["x", "\[Prime]",
                MultilineFunction->None], "==", "y"}], ",", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], "==", \(\(-t\)\ x\)}]}], "}"}]}], 
      ";", "\n", "\n", \(SerSol[sys, {x, y}, t, {1, 1}, 6, 0, 2, 2000]\)}]], 
  "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 3.6: Mathieu's equation", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"sys", "=", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox["x", "\[Prime]",
                MultilineFunction->None], "==", "y"}], ",", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], "==", 
              \(\(-\((1 - Cos[t])\)\)\ x\)}]}], "}"}]}], ";", "\n", "\n", 
      \(SerSol[sys, {x, y}, t, {1, 0}, 4, 0, 2, 2000]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 3.7", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"sys", "=", 
        RowBox[{"{", 
          RowBox[{
            SuperscriptBox["x", "\[Prime]\[Prime]",
              MultilineFunction->None], "==", \(t\^2 + x\^2\)}], "}"}]}], ";",
       "\n", "\n", \(SerSol[sys, {x}, t, {0}, 11, 0, 1.9, 2000]\)}]], "Input",\

  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example  3.8: Hermite's equation", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"sys", "=", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox["x", "\[Prime]",
                MultilineFunction->None], "==", "y"}], ",", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], "==", \(2\ t\ y - 6  x\)}]}], 
          "}"}]}], ";", "\n", "\n", 
      \(SerSol[sys, {x, y}, t, {0, \(-12\)}, 4, 0, 4, 2000]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["3.7 The Program Frobenius", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Example 3.9", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"eq", "=", 
        RowBox[{
          RowBox[{
            RowBox[{\(\(x\ \)\^2\), 
              SuperscriptBox["y", "\[Prime]\[Prime]",
                MultilineFunction->None]}], "-", 
            RowBox[{"x", " ", 
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None]}], "+", \(x\ y\)}], " ", "==", 
          "0"}]}], ";", "\n", \(unk = y\), ";", "\n", \(var = x\), ";", "\n", 
      "\n", \(Frobenius[eq, unk, var, 3, {}, {}, {}]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(\ \)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 3.10", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
    \(eq = \(\(x\ \)\^2\) \(y'\)' + x\ \((1 + x)\) y' - \((1 + x\^3)\) y\  == 
          0\), ";", "\n", \(unk = y\), ";", "\n", \(var = x\), ";", "\n", 
      "\n", 
      StyleBox[
        \(Frobenius[eq, unk, var, 
          5, {0.5, 3}, {y[0.5] == 1, \(y'\)[0.5] == 0.5}, 1000]\),
        FontSize->12]}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example  3.11", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      StyleBox[
        \(eq = \(\(x\ \)\^2\) \(y'\)' + x\ \((5 + x\^2)\) y' + 
              \((4 + x\^2)\) y\  == 0\),
        FontSize->12], 
      StyleBox[";",
        FontSize->12], 
      StyleBox["\n",
        FontSize->12], 
      StyleBox[\(unk = y\),
        FontSize->12], 
      StyleBox[";",
        FontSize->12], 
      StyleBox["\n",
        FontSize->12], 
      StyleBox[\(var = x\),
        FontSize->12], 
      StyleBox[";",
        FontSize->12], "\n", "\n", 
      \(Frobenius[eq, unk, var, 
        5, {0.5, 3}, {y[0.5] == 1, \(y'\)[0.5] == 0.5}, 1000]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 3.12", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{"Frobenius", "[", 
      RowBox[{
        RowBox[{
          RowBox[{
            RowBox[{\(x\^2\), " ", 
              SuperscriptBox[
                SuperscriptBox["y", "\[Prime]",
                  MultilineFunction->None], "\[Prime]",
                MultilineFunction->None]}], "+", 
            RowBox[{\(\(x\ \)\/2\), 
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None]}], "+", 
            \(1\/4\ \((x - Sin[x])\)\ x\ y\)}], "==", "0"}], ",", "y", ",", 
        "x", ",", "7", ",", \({0.2, 5}\), ",", 
        RowBox[{"{", 
          RowBox[{\(y[0.2] == 1\), ",", 
            RowBox[{
              RowBox[{
                SuperscriptBox["y", "\[Prime]",
                  MultilineFunction->None], "[", "0.2", "]"}], "==", 
              "0.5"}]}], "}"}], ",", "1000"}], "]"}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["3.8 Problems", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Exercise 1.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"sys", "=", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox["x", "\[Prime]",
                MultilineFunction->None], "==", "y"}], ",", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], "==", \(\(-4\)\ x + t\ Cos[t]\)}]}],
           "}"}]}], ";", "\n", "\n", 
      \(SerSol[sys, {x, y}, t, {0, 1}, 6, 0, 1.5, 2000]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 2.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"sys", "=", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox["x", "\[Prime]",
                MultilineFunction->None], "==", \(x - y + 2\)}], ",", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], "==", \(y - \ x + t\)}]}], " ", 
          "}"}]}], ";", "\n", "\n", 
      \(SerSol[sys, {x, y}, t, {0, 1}, 6, 0, 2, 2000]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 3.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"sys", "=", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox["x", "\[Prime]",
                MultilineFunction->None], "==", \(y + Exp[t]\)}], ",", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], "==", \(x + Sin[t]\)}]}], "}"}]}], 
      ";", "\n", "\n", \(SerSol[sys, {x, y}, t, {0, 1}, 5, 0, 2, 2000]\)}]], 
  "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 4.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"sys", "=", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox["x", "\[Prime]",
                MultilineFunction->None], "==", "y"}], ",", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], "==", "z"}], ",", 
            RowBox[{
              SuperscriptBox["z", "\[Prime]",
                MultilineFunction->None], "==", 
              \(\(-6\)\ x - 11\ y - 6\ z + Exp[\(-t\)]\)}]}], " ", "}"}]}], 
      ";", "\n", "\n", 
      \(SerSol[sys, {x, y, z}, t, {0, 1, 0}, 20, 0, 2, 2000]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 5.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"sys", "=", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox["x", "\[Prime]",
                MultilineFunction->None], "==", \(-Sin[y]\)}], ",", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], "==", \(x\^2\)}]}], "}"}]}], ";", 
      "\n", "\n", \(SerSol[sys, {x, y}, t, {1, 0.5}, 4, 0, 1, 2000]\)}]], 
  "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 6.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"eq", "=", 
        RowBox[{
          RowBox[{
            RowBox[{\(x\^2\), 
              SuperscriptBox["y", "\[Prime]\[Prime]",
                MultilineFunction->None]}], "-", \(\(x\^3\) y\)}], "==", 
          "0"}]}], ";", "\n", \(unk = y\), ";", "\n", \(var = x\), ";", "\n", 
      "\n", \(Frobenius[eq, unk, var, 6, {}, {}, {}]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 7.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = \(\(x\ \)\^2\) \(y'\)' + x\ y' + 3  x\^2\ y\  == 0; \nunk = y; \n
    var = x; \n\n
    Frobenius[eq, unk, var, 10, {0.5, 3}, {y[0.5] == 1, \(y'\)[0.5] == 0.5}, 
      1000]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 8.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"eq", "=", 
        RowBox[{
          RowBox[{
            RowBox[{\(x\^2\), " ", 
              SuperscriptBox[
                SuperscriptBox["y", "\[Prime]",
                  MultilineFunction->None], "\[Prime]",
                MultilineFunction->None]}], "+", \(\((1\/8 + x\^4)\)\ y\)}], 
          "==", "0"}]}], ";", "\n", 
      \(Frobenius[eq, y, x, 8, {}, {}, 1000]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 9.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = \(\(x\ \)\^2\) \(y'\)' + x\ \ y' + 2  x\ y\  == 0; \n\n
    Frobenius[eq, y, x, 6, {0.3, 3}, {y[0.3] == 0, \(y'\)[0.3] == 1}, 1000]
      \)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 10.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"eq", "=", 
        RowBox[{
          RowBox[{
            RowBox[{\(\(x\ \)\^2\), 
              SuperscriptBox["y", "\[Prime]\[Prime]",
                MultilineFunction->None]}], "-", \(x\ \ y\)}], " ", "==", 
          "0"}]}], ";", "\n", "\n", 
      \(Frobenius[eq, y, x, 5, {}, {}, 1000]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 11.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"eq", "=", 
        RowBox[{
          RowBox[{
            RowBox[{\(x\^2\), 
              SuperscriptBox["y", "\[Prime]\[Prime]",
                MultilineFunction->None]}], "+", 
            RowBox[{"x", " ", 
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None]}], "+", "y"}], "==", "0"}]}], ";", 
      "\n", "\n", 
      \(Frobenius[eq, y, x, 3, {0.5, 5}, {y[0.5] == 1, \(y'\)[0.5] == 3}, 
        1000]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(DSolve[\(x\^2\) \(\(y'\)'\)[x] + x\ \(y'\)[x] + y[x] == 0, y[x], x]\)], 
  "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 12.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"eq", "=", 
        RowBox[{
          RowBox[{
            RowBox[{\(x\^2\), 
              SuperscriptBox["y", "\[Prime]\[Prime]",
                MultilineFunction->None]}], "+", 
            RowBox[{\(x\^2\), " ", 
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None]}], "+", "y"}], "==", "0"}]}], ";", 
      "\n", "\n", \(Frobenius[eq, y, x, 3, {}, {}, 1000]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(DSolve[\(x\^2\) \(\(y'\)'\)[x] + x\^2\ \(y'\)[x] + y[x] == 0, y[x], x]
      \)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 13.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"eq", "=", 
        RowBox[{
          RowBox[{
            RowBox[{\(x\^2\), 
              SuperscriptBox["y", "\[Prime]\[Prime]",
                MultilineFunction->None]}], "+", 
            RowBox[{"x", "  ", 
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None]}], "+", \(\((x\^2 + 1)\) y\)}], "==",
           "0"}]}], ";", "\n", "\n", 
      \(Frobenius[eq, y, x, 3, {}, {}, 1000]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(DSolve[
      \(x\^2\) \(\(y'\)'\)[x] + x\ \ \(y'\)[x] + \((x\^2 + 1)\) y[x] == 0, 
      y[x], x]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 14.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"eq", "=", 
        RowBox[{
          RowBox[{
            RowBox[{\(x\^2\), 
              SuperscriptBox["y", "\[Prime]\[Prime]",
                MultilineFunction->None]}], "+", 
            RowBox[{"x", "  ", 
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None]}], "+", 
            \(\((x\^2 - 1)\) \((x\^2 + 4)\) y\)}], "==", "0"}]}], ";", "\n", 
      "\n", \(Frobenius[eq, y, x, 4, {}, {}, 1000]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 15.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"eq", "=", 
        RowBox[{
          RowBox[{
            RowBox[{\(x\^2\), " ", 
              SuperscriptBox[
                SuperscriptBox["y", "\[Prime]",
                  MultilineFunction->None], "\[Prime]",
                MultilineFunction->None]}], "+", 
            FractionBox[
              RowBox[{"x", " ", 
                SuperscriptBox["y", "\[Prime]",
                  MultilineFunction->None]}], "2"], "+", 
            \(1\/4\ x\ Cos[x]\ y\)}], "==", "0"}]}], ";", "\n", "\n", 
      \(Frobenius[eq, y, x, 4, {}, {}, 1000]\)}]], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 800}, {0, 544}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{674, 498},
WindowMargins->{{25, Automatic}, {Automatic, -4}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"NeXTAutomaticEncoding",
Magnification->1.25
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 132, 4, 129, "Title"],
Cell[1866, 57, 258, 9, 104, "Subtitle"],

Cell[CellGroupData[{
Cell[2149, 70, 62, 1, 65, "Section"],
Cell[2214, 73, 536, 16, 60, "Text"],
Cell[2753, 91, 108, 3, 34, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2898, 99, 156, 2, 65, "Section"],

Cell[CellGroupData[{
Cell[3079, 105, 175, 6, 57, "Subsection"],
Cell[3257, 113, 133, 4, 35, "Input"],
Cell[3393, 119, 147, 4, 35, "Input"],
Cell[3543, 125, 155, 4, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3735, 134, 141, 3, 57, "Subsection"],
Cell[3879, 139, 144, 4, 35, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[4072, 149, 138, 2, 65, "Section"],

Cell[CellGroupData[{
Cell[4235, 155, 182, 6, 57, "Subsection"],
Cell[4420, 163, 707, 19, 56, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5164, 187, 182, 6, 57, "Subsection"],
Cell[5349, 195, 1000, 24, 133, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[6398, 225, 148, 2, 65, "Section"],

Cell[CellGroupData[{
Cell[6571, 231, 131, 3, 57, "Subsection"],
Cell[6705, 236, 530, 15, 77, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7272, 256, 134, 3, 57, "Subsection"],
Cell[7409, 261, 557, 15, 77, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8003, 281, 114, 3, 57, "Subsection"],
Cell[8120, 286, 381, 11, 77, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8538, 302, 135, 3, 57, "Subsection"],
Cell[8676, 307, 549, 15, 77, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[9274, 328, 141, 2, 65, "Section"],

Cell[CellGroupData[{
Cell[9440, 334, 114, 3, 57, "Subsection"],
Cell[9557, 339, 601, 15, 119, "Input"],
Cell[10161, 356, 35, 1, 34, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10233, 362, 115, 3, 57, "Subsection"],
Cell[10351, 367, 421, 11, 119, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10809, 383, 116, 3, 57, "Subsection"],
Cell[10928, 388, 694, 24, 119, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11659, 417, 115, 3, 57, "Subsection"],
Cell[11777, 422, 937, 24, 85, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[12763, 452, 128, 2, 65, "Section"],

Cell[CellGroupData[{
Cell[12916, 458, 114, 3, 57, "Subsection"],
Cell[13033, 463, 552, 15, 77, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13622, 483, 114, 3, 57, "Subsection"],
Cell[13739, 488, 555, 15, 77, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14331, 508, 114, 3, 57, "Subsection"],
Cell[14448, 513, 542, 15, 77, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15027, 533, 114, 3, 57, "Subsection"],
Cell[15144, 538, 718, 19, 77, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15899, 562, 114, 3, 57, "Subsection"],
Cell[16016, 567, 535, 15, 77, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16588, 587, 114, 3, 57, "Subsection"],
Cell[16705, 592, 469, 12, 119, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[17211, 609, 114, 3, 57, "Subsection"],
Cell[17328, 614, 286, 7, 119, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[17651, 626, 114, 3, 57, "Subsection"],
Cell[17768, 631, 508, 14, 81, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[18313, 650, 114, 3, 57, "Subsection"],
Cell[18430, 655, 251, 6, 77, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[18718, 666, 115, 3, 57, "Subsection"],
Cell[18836, 671, 426, 12, 77, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[19299, 688, 115, 3, 57, "Subsection"],
Cell[19417, 693, 575, 16, 77, "Input"],
Cell[19995, 711, 178, 5, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20210, 721, 115, 3, 57, "Subsection"],
Cell[20328, 726, 529, 14, 77, "Input"],
Cell[20860, 742, 185, 5, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[21082, 752, 115, 3, 57, "Subsection"],
Cell[21200, 757, 553, 15, 77, "Input"],
Cell[21756, 774, 206, 6, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[21999, 785, 115, 3, 57, "Subsection"],
Cell[22117, 790, 570, 15, 77, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[22724, 810, 115, 3, 57, "Subsection"],
Cell[22842, 815, 678, 18, 104, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

