(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     12208,        446]*)
(*NotebookOutlinePosition[     13208,        480]*)
(*  CellTagsIndexPosition[     13164,        476]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Chapter 6", "Title",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[TextData[{
  StyleBox["Stability: The Critical Case",
    FontSlant->"Italic"],
  " "
}], "Subtitle",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontWeight->"Bold"],

Cell[CellGroupData[{

Cell["Load ODE.m", "Section",
  FontFamily->"Times New Roman"],

Cell[TextData[{
  "Suppose you have copied the package ",
  StyleBox["ODE.m ",
    FontWeight->"Bold"],
  "in the directory  c:\\ODE. To load it, you have to type ",
  StyleBox["(\[ShiftKey] + \[ReturnIndicator])  in the current ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        SuperscriptBox["Mathematica", 
          StyleBox["\[RegisteredTrademark]",
            FontWeight->"Plain"]], TraditionalForm]]],
  StyleBox[" session",
    FontWeight->"Plain"]
}], "Text",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell["<<c:\\ODE\\ODE.m", "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[
"6.3 The Programs CriticalEqS and CriticalEqN", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Examples 6.1", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {u' == \(-v\) - a\ \[Lambda]\ v\^2 - \(1\/3\) a\ v\^3, 
        v' == u - \[Lambda]\ v\^2 - \(1\/3\) v\^3}; \nunk = {u, v}; \n
    order = 10; \n\nCriticalEqS[sys, unk, order]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(sys = {
        u' == \(-v\) - v\^3\/\(6\ \[Lambda]\^2\) - v\^2\/\(2\ \[Lambda]\), 
        v' == u - v\^3\/3 - v\^2\ \[Lambda]}; \nunk = {u, v}; \norder = 10; \n
    \nCriticalEqS[sys, unk, order]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples 6.2", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {x' == x + y + x\^2 + 2\ x\ y + \(x\^2\) y, 
        y' == \(-2\)\ x - y - x\^2 - 2\ x\ y - x\^2\ y}; \nunk = {x, y}; \n\n
    CriticalEqN[sys, unk]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(Phase2D[sys, {x, y}, {0, 0}, {0.002, 0}, {2, 2}, {0, 800}, 
      5000, {{\(-0.006\), 0.006}, {\(-0.008\), 0.008}}, 0]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples 6.3", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {x' == \(-3\)\ y - x\ \((x\^2 + y\^2)\)\^3, 
        y' == 3\ x - y \((x\^2 + y\^2)\)\^3}; \n\n
    CriticalEqS[sys, {x, y}, 10]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(Phase2D[sys, {x, y}, {0, 0}, {0.02, 0.02}, {3, 0}, {\(-80\), 120}, 
      5000, {{\(-0.06\), 0.06}, {\(-0.06\), 0.06}}, 0]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(Phase2D[sys, {x, y}, {0, 0}, {0.2, 0.2}, {2, 0}, {20, 100}, 
      5000, {{\(-0.5\), 0.5}, {\(-0.5\), 0.5}}, 0]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(Phase2D[sys, {x, y}, {0, 0}, {0.002, 0.002}, {3, 0}, {0, 200}, 
      5000, {{\(-0.006\), 0.006}, {\(-0.006\), 0.006}}, 0]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples 6.4", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {x' == \(-\ y\) + 0.1\ x\ y\^2, y' == x - 0.1\ y\ x\^2}; \n\n
    CriticalEqN[sys, {x, y}]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(sys = {x' == \(-\ y\) + \(1\ \)\/10\ x\ y\^2, 
        y' == x - \(1\ \)\/10\ y\ x\^2}; \n\nCriticalEqS[sys, {x, y}, 20]\)], 
  "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(Phase2D[sys, {x, y}, {0, 0}, {0.2, 0.2}, {5, 0}, {0, 120}, 
      5000, {{\(-1\), 1}, {\(-1\), 1}}, 0]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples 6.5", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {x' == y, y' == \(-x\) - \ x\^3}; \n\n
    CriticalEqS[sys, {x, y}, 20]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(Phase2D[sys, {x, y}, {0, 0}, {0.2, 0.2}, {5, 0}, {0, 20}, 
      5000, {{\(-1.2\), 1.2}, {\(-1.4\), 1.4}}, 0]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["6.5 The Program CManifold", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Examples 6.7", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {{x' == y, y' == \(-x\) - x\ z}, {z' == \(-z\) - c\ x\^2}}; \n
    unk = {{x, y}, {z}}; \n\nCManifold[sys, unk, 2]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples 6.8", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {{x' == \(x\^2\) \((x\^2 + y\^2 + z\^2)\), 
          y' == \(-y\^2\) \((x\^2 + y\^2 + z\^2)\)}, {
          z' == \(-z\) + \(x\^2\) \((x\^2 + y\^2 + z\^2)\)}}; \n
    unk = {{x, y}, {z}}; \n\nCManifold[sys, unk, 3]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples 6.9", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {{x' == \[Epsilon]\ x - x\^3 + x\ y, \[Epsilon]' == 0}, {
          y' == \(-y\) + y\^2 - x\^2}}; \nunk = {{x, \[Epsilon]}, {y}}; \n\n
    CManifold[sys, unk, 3]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["6.6 Problems", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Exercise 1.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {{x' == \(-x\^3\)}, {y' == \(-y\) + x\^2}}; \nunk = {{x}, {y}}; \n
    \nCManifold[sys, unk, 4]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 2.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {{x' == \(-x\^2\) \((x\^2 + y\^2 + z\^2)\)}, {
          y' == \(-y\) - \(x\^2\) \((x\^2 + y\^2 + z\^2)\), 
          z' == \(-z\) + \(x\^2\) \((x\^2 + y\^2 + z\^2)\)}}; \n
    unk = {{x}, {y, z}}; \n\nCManifold[sys, unk, 3]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 3.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {{x' == \(-x\^2\)}, {y' == \(-y\)}}; \nunk = {{x}, {y}}; \n\n
    CManifold[sys, unk, 3]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 4.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {{x' == 0, \[Lambda]' == 0}, {y' == \[Lambda]\ x - y}}; \n
    unk = {{x, \[Lambda]}, {y}}; \n\nCManifold[sys, unk, 3]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 5.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {{x' == \(-y\) + x\ y, y' == x - x\ y\^2}, {
          z' == \(-z\) + x\ z\^2}}; \nunk = {{x, y}, {z}}; \n\n
    CManifold[sys, unk, 4]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 6.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {{x' == \[Mu]\ x + y, y' == \(-x\) + \[Mu]\ x - x\ z, 
          \[Mu]' == 0}, {z' == \(-z\) - c\ x\^2}}; \n
    unk = {{x, y, \[Mu]}, {z}}; \n\nCManifold[sys, unk, 3]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 7.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {{x' == 0, \[Lambda]' == 0}, {y' == \[Lambda]\ x - y}}; \n
    unk = {{x, \[Lambda]}, {y}}; \n\nCManifold[sys, unk, 3]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 8.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {{x' == \(-y\) + x\ y, y' == x - x\ y\^2}, {
          z' == \(-z\) + x\ z\^2}}; \nunk = {{x, y}, {z}}; \n\n
    CManifold[sys, unk, 4]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 9.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {{x' == \[Mu]\ x + y, y' == \(-x\) + \[Mu]\ y - x\ z, 
          \[Mu]' == 0}, {z' == \(-z\) + x\^2}}; \nunk = {{x, y, \[Mu]}, {z}}; 
    \n\nCManifold[sys, unk, 3]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 800}, {0, 544}},
WindowToolbars->"RulerBar",
CellGrouping->Automatic,
WindowSize->{713, 391},
WindowMargins->{{8, Automatic}, {Automatic, 7}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"NeXTAutomaticEncoding",
Magnification->1.25
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 132, 4, 129, "Title"],
Cell[1866, 57, 234, 9, 68, "Subtitle"],

Cell[CellGroupData[{
Cell[2125, 70, 62, 1, 65, "Section"],
Cell[2190, 73, 536, 16, 60, "Text"],
Cell[2729, 91, 108, 3, 34, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2874, 99, 161, 3, 65, "Section"],

Cell[CellGroupData[{
Cell[3060, 106, 115, 3, 57, "Subsection"],
Cell[3178, 111, 289, 6, 144, "Input"],
Cell[3470, 119, 305, 7, 149, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3812, 131, 115, 3, 57, "Subsection"],
Cell[3930, 136, 262, 6, 98, "Input"],
Cell[4195, 144, 226, 5, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4458, 154, 115, 3, 57, "Subsection"],
Cell[4576, 159, 242, 6, 82, "Input"],
Cell[4821, 167, 230, 5, 35, "Input"],
Cell[5054, 174, 219, 5, 35, "Input"],
Cell[5276, 181, 230, 5, 56, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5543, 191, 115, 3, 57, "Subsection"],
Cell[5661, 196, 204, 5, 77, "Input"],
Cell[5868, 203, 231, 6, 102, "Input"],
Cell[6102, 211, 210, 5, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6349, 221, 115, 3, 57, "Subsection"],
Cell[6467, 226, 185, 5, 77, "Input"],
Cell[6655, 233, 217, 5, 35, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[6921, 244, 141, 2, 65, "Section"],

Cell[CellGroupData[{
Cell[7087, 250, 115, 3, 57, "Subsection"],
Cell[7205, 255, 228, 5, 98, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7470, 265, 115, 3, 57, "Subsection"],
Cell[7588, 270, 329, 7, 98, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7954, 282, 115, 3, 57, "Subsection"],
Cell[8072, 287, 275, 6, 98, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[8396, 299, 128, 2, 65, "Section"],

Cell[CellGroupData[{
Cell[8549, 305, 114, 3, 57, "Subsection"],
Cell[8666, 310, 209, 5, 98, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8912, 320, 114, 3, 57, "Subsection"],
Cell[9029, 325, 338, 7, 98, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9404, 337, 114, 3, 57, "Subsection"],
Cell[9521, 342, 202, 5, 98, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9760, 352, 114, 3, 57, "Subsection"],
Cell[9877, 357, 232, 5, 98, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10146, 367, 114, 3, 57, "Subsection"],
Cell[10263, 372, 249, 6, 98, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10549, 383, 114, 3, 57, "Subsection"],
Cell[10666, 388, 281, 6, 98, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10984, 399, 114, 3, 57, "Subsection"],
Cell[11101, 404, 232, 5, 98, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11370, 414, 114, 3, 57, "Subsection"],
Cell[11487, 419, 249, 6, 98, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11773, 430, 114, 3, 57, "Subsection"],
Cell[11890, 435, 278, 6, 98, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

