(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     15243,        528]*)
(*NotebookOutlinePosition[     16182,        560]*)
(*  CellTagsIndexPosition[     16138,        556]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Chapter 8", "Title",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[TextData[{
  StyleBox["The Lindstedt-Poincar\[EAcute] Method",
    FontSlant->"Italic"],
  " "
}], "Subtitle",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontWeight->"Bold"],

Cell[CellGroupData[{

Cell["Load ODE.m", "Section",
  FontFamily->"Times New Roman"],

Cell[TextData[{
  "Suppose you have copied the package ",
  StyleBox["ODE.m ",
    FontWeight->"Bold"],
  "in the directory  c:\\ODE. To load it, you have to type ",
  StyleBox["(\[ShiftKey] + \[ReturnIndicator])  in the current ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        SuperscriptBox["Mathematica", 
          StyleBox["\[RegisteredTrademark]",
            FontWeight->"Plain"]], TraditionalForm]]],
  StyleBox[" session",
    FontWeight->"Plain"]
}], "Text",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell["<<c:\\ODE\\ODE.m", "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[
" 8.3 The Programs LindPoic and GLindPoinc", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Example 8.5", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {x' == y, y' == \(-x\) - \[Epsilon]\ x\^3}; \nunk = {x, y}; \n
    var = t; \npar = \[Epsilon]; \nm = 2; \n\n
    LindPoinc[sys, unk, var, par, m]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(GLindPoinc[sys, unk, var, par, 0.1, {0.3, 0.6, 0.9, 1.2}, {0, 50}]\)], 
  "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 8.6", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {x' == y, y' == \(-x\) - \[Epsilon] \((x + y\^2)\)}; \n
    unk = {x, y}; \nvar = t; \npar = \[Epsilon]; \nm = 1; \n\n
    LindPoinc[sys, unk, var, par, m]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(GLindPoinc[sys, unk, var, par, 0.1, {0.3, 0.6, 0.9, 1.2}, {0, 50}]\)], 
  "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 8.7", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {x' == y, y' == \(-x\) - \[Epsilon]\ y \((9 - x\^2)\)}; \n
    unk = {x, y}; \nvar = t; \npar = \[Epsilon]; \nm = 1; \n\n
    LindPoinc[sys, unk, var, par, m]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(GLindPoinc[sys, unk, var, par, 0.08, {6}, {0, 10}]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(sys = {x' == y, y' == \(-x\) + \[Epsilon]\ y \((9 - x\^2)\)}; \n
    unk = {x, y}; \nvar = t; \npar = \[Epsilon]; \nm = 1; \n\n
    LindPoinc[sys, unk, var, par, m]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(GLindPoinc[sys, unk, var, par, 0.08, {6}, {0, 10}]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 8.8", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {x' == y, y' == \(-x\) + \[Mu]\ y \((1 - x + y)\)}; \n
    unk = {x, y}; \nvar = t; \npar = \[Mu]; \nm = 1; \n\n
    LindPoinc[sys, unk, var, par, m]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 8.9", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {x' == y, y' == \(-x\) + \[Mu] \((y - y\^3\/3)\)}; \n
    unk = {x, y}; \nvar = t; \npar = \[Mu]; \nm = 1; \n\n
    LindPoinc[sys, unk, var, par, m]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(GLindPoinc[sys, unk, var, par, 0.6, {2}, {0, 10}]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 8.10", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {x' == y, y' == \(-x\) - \[Epsilon]\ x\ \ y\^2}; \nunk = {x, y}; 
    \nvar = t; \npar = \[Epsilon]; \nm = 1; \n\n
    LindPoinc[sys, unk, var, par, m]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(GLindPoinc[sys, unk, var, par, 0.1, {0.3, 0.5, 0.8}, {0, 20}]\)], 
  "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    StyleBox[\(<< Calculus`DSolveIntegrals`\),
      FontSize->12]], "Input",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(DifferentialInvariants[{\(x'\)[t] == y[t], 
        \(y'\)[t] == \(-x[t]\) - \[Epsilon]\ x[t]\ \ y[t]\^2}, {x[t], y[t]}, 
      t]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 8.11", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {x' == y, y' == \(-x\) - \[Epsilon]\ \((x\^2 + y\^2 - 2)\)}; \n
    unk = {x, y}; \nvar = t; \npar = \[Epsilon]; \nm = 1; \n\n
    LindPoinc[sys, unk, var, par, m]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(GLindPoinc[sys, unk, var, par, 0.01, {0.5, 1, 1.5}, {0, 20}]\)], "Input",\

  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    StyleBox[\(<< Calculus`DSolveIntegrals`\),
      FontSize->12]], "Input",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(DifferentialInvariants[{\(x'\)[t] == y[t], 
        \(y'\)[t] == \(-x[t]\) - \[Epsilon]\ \((x[t]\^2 + y[t]\^2 - 2)\)}, {
        x[t], y[t]}, t]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 8.12", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {x' == y - \[Mu]\ y\^2, 
        y' == \(-x\) + \[Mu]\ y\^2\/\(x\^2 + y\^2 - 1\)}; \nunk = {x, y}; \n
    var = t; \npar = \[Mu]; \nm = 1; \n\nLindPoinc[sys, unk, var, par, m]\)], 
  "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(GLindPoinc[sys, unk, var, par, 0.2, {0.00006, 0.0002}, {0, 50}]\)], 
  "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(CriticalEqS[sys, unk, 6]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 8.13", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"sys", "=", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox["x", "\[Prime]",
                MultilineFunction->None], "==", 
              \(y - \[Mu]\ x\ \((x\^2 + 4  y\^2 - 4)\)\)}], ",", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], "==", 
              \(\(-x\) - \[Mu]\ y\ \((x\^2 + 4  y\^2 - 4)\)\)}]}], "}"}]}], 
      ";", "\n", \(unk = {x, y}\), ";", "\n", \(var = t\), ";", "\n", 
      \(par = \[Mu]\), ";", "\n", \(m = 1\), ";", "\n", "\n", 
      \(LindPoinc[sys, unk, var, par, m]\)}]], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(GLindPoinc[sys, unk, var, par, 0.1, {2\ \@\(2/5\)}, {0, 10}]\)], "Input",\

  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[" 8.4 Problems", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Exercise 1. ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"sys", "=", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox["x", "\[Prime]",
                MultilineFunction->None], "==", 
              \(y + \[Mu] 
                  \((4\ x - 5\ x\^3 + x\^5 - 5\ x\ y\^2 + 2\ x\^3\ y\^2 + 
                      x\ y\^4)\)\)}], ",", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], "==", 
              \(\(-x\) + 
                \[Mu] \((
                    4\ y - 5\ x\^2\ y + x\^4\ y - 5\ y\^3 + 2\ x\^2\ y\^3 + 
                      y\^5)\)\)}]}], "}"}]}], ";", "\n", \(unk = {x, y}\), 
      ";", "\n", \(var = t\), ";", "\n", \(par = \[Mu]\), ";", "\n", 
      \(m = 1\), ";", "\n", "\n", \(LindPoinc[sys, unk, var, par, m]\)}]], 
  "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(GLindPoinc[sys, unk, var, par, 0.1, {\(-1\), \(-2\)}, {0, 5}]\)], 
  "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 2.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"sys", "=", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox["x", "\[Prime]",
                MultilineFunction->None], "==", 
              \(y - \[Mu]\ x\ \((x\^2 + y\^2 - 4)\)\)}], ",", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], "==", 
              \(\(-x\) - \[Mu]\ y\ \((x\^2 + y\^2 - 2)\)\)}]}], "}"}]}], ";", 
      "\n", \(unk = {x, y}\), ";", "\n", \(var = t\), ";", "\n", 
      \(par = \[Mu]\), ";", "\n", \(m = 1\), ";", "\n", "\n", 
      \(LindPoinc[sys, unk, var, par, m]\)}]], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(GLindPoinc[sys, unk, var, par, 0.2, {\@3}, {0, 10}]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(GLindPoinc[sys, unk, var, par, \(-0.2\), {\@3}, {0, 10}]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 3. ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"sys", "=", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox["x", "\[Prime]",
                MultilineFunction->None], "==", 
              \(y - \[Mu]\ y\ \((x\^2 + y\^2 - 4)\)\)}], ",", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], "==", 
              \(\(-x\) - \[Mu]\ x\ \((x\^2 + y\^2 - 2)\)\)}]}], "}"}]}], ";", 
      "\n", \(unk = {x, y}\), ";", "\n", \(var = t\), ";", "\n", 
      \(par = \[Mu]\), ";", "\n", "\n", 
      \(LindPoinc[sys, unk, var, par, 1]\)}]], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(GLindPoinc[sys, unk, var, par, 0.1, {0.5, 1, 1.5}, {\(-3\), 3}]\)], 
  "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 4. ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"sys", "=", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox["x", "\[Prime]",
                MultilineFunction->None], "==", 
              \(y - \[Mu]\ x\ \((x\^2 + y\^2 - 4)\) \((x\^2 + y\^2 - 2)\)\)}],
             ",", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], "==", 
              \(\(-x\) - 
                \[Mu]\ y\ \((x\^2 + y\^2 - 4)\) \((x\^2 + y\^2 - 2)\)\)}]}], 
          "}"}]}], ";", "\n", \(unk = {x, y}\), ";", "\n", \(var = t\), ";", 
      "\n", \(par = \[Mu]\), ";", "\n", "\n", 
      \(LindPoinc[sys, unk, var, par, 1]\)}]], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(GLindPoinc[sys, unk, var, par, 0.1, {\@2, 2}, {0, 10}]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 5. ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
      RowBox[{"sys", "=", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox["x", "\[Prime]",
                MultilineFunction->None], "==", 
              \(y - \[Mu]\ 
                  \((x - \(2\ x\)\/\@\(x\^2 + y\^2\) + 
                      x\^2\/\(x\^2 + y\^2\) - \(x\ y\)\/\(x\^2 + y\^2\))
                    \)\)}], ",", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], "==", 
              \(\(-x\) - 
                \[Mu]\ \ 
                  \((y - \(2\ y\)\/\@\(x\^2 + y\^2\) + 
                      \(x\ y\)\/\(x\^2 + y\^2\) - y\^2\/\(x\^2 + y\^2\))
                    \)\)}]}], "}"}]}], ";", "\n", \(unk = {x, y}\), ";", "\n",
       \(var = t\), ";", "\n", \(par = \[Mu]\), ";", "\n", "\n", 
      \(LindPoinc[sys, unk, var, par, 1]\)}]], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(GLindPoinc[sys, unk, var, par, 0.01, {2}, {0, 10}]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 800}, {0, 544}},
WindowToolbars->"RulerBar",
CellGrouping->Automatic,
WindowSize->{730, 340},
WindowMargins->{{2, Automatic}, {Automatic, 5}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->False,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"NeXTAutomaticEncoding",
Magnification->1.25
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 132, 4, 129, "Title"],
Cell[1866, 57, 243, 9, 68, "Subtitle"],

Cell[CellGroupData[{
Cell[2134, 70, 62, 1, 65, "Section"],
Cell[2199, 73, 536, 16, 60, "Text"],
Cell[2738, 91, 108, 3, 34, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2883, 99, 158, 3, 65, "Section"],

Cell[CellGroupData[{
Cell[3066, 106, 114, 3, 57, "Subsection"],
Cell[3183, 111, 234, 5, 161, "Input"],
Cell[3420, 118, 151, 4, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3608, 127, 114, 3, 57, "Subsection"],
Cell[3725, 132, 243, 5, 161, "Input"],
Cell[3971, 139, 151, 4, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4159, 148, 114, 3, 57, "Subsection"],
Cell[4276, 153, 246, 5, 161, "Input"],
Cell[4525, 160, 132, 3, 35, "Input"],
Cell[4660, 165, 246, 5, 161, "Input"],
Cell[4909, 172, 132, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5078, 180, 114, 3, 57, "Subsection"],
Cell[5195, 185, 237, 5, 161, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5469, 195, 114, 3, 57, "Subsection"],
Cell[5586, 200, 236, 5, 195, "Input"],
Cell[5825, 207, 131, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5993, 215, 115, 3, 57, "Subsection"],
Cell[6111, 220, 239, 5, 161, "Input"],
Cell[6353, 227, 146, 4, 35, "Input"],
Cell[6502, 233, 124, 3, 33, "Input"],
Cell[6629, 238, 212, 5, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6878, 248, 115, 3, 57, "Subsection"],
Cell[6996, 253, 251, 5, 161, "Input"],
Cell[7250, 260, 144, 4, 35, "Input"],
Cell[7397, 266, 124, 3, 33, "Input"],
Cell[7524, 271, 226, 5, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7787, 281, 115, 3, 57, "Subsection"],
Cell[7905, 286, 266, 6, 194, "Input"],
Cell[8174, 294, 148, 4, 35, "Input"],
Cell[8325, 300, 106, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8468, 308, 115, 3, 57, "Subsection"],
Cell[8586, 313, 708, 17, 161, "Input"],
Cell[9297, 332, 144, 4, 46, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[9490, 342, 129, 2, 65, "Section"],

Cell[CellGroupData[{
Cell[9644, 348, 115, 3, 57, "Subsection"],
Cell[9762, 353, 883, 22, 183, "Input"],
Cell[10648, 377, 146, 4, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10831, 386, 114, 3, 57, "Subsection"],
Cell[10948, 391, 702, 17, 161, "Input"],
Cell[11653, 410, 133, 3, 46, "Input"],
Cell[11789, 415, 138, 3, 46, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11964, 423, 115, 3, 57, "Subsection"],
Cell[12082, 428, 680, 17, 140, "Input"],
Cell[12765, 447, 148, 4, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12950, 456, 115, 3, 57, "Subsection"],
Cell[13068, 461, 758, 19, 140, "Input"],
Cell[13829, 482, 136, 3, 46, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14002, 490, 115, 3, 57, "Subsection"],
Cell[14120, 495, 948, 23, 278, "Input"],
Cell[15071, 520, 132, 3, 35, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

