(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     15006,        501]*)
(*NotebookOutlinePosition[     15944,        533]*)
(*  CellTagsIndexPosition[     15900,        529]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Chapter 9", "Title",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[TextData[{
  StyleBox["Boundary-Value Problems for Second-Order ODEs",
    FontSlant->"Italic"],
  " "
}], "Subtitle",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->24,
  FontWeight->"Bold"],

Cell[CellGroupData[{

Cell["Load ODE.m", "Section",
  FontFamily->"Times New Roman"],

Cell[TextData[{
  "Suppose you have copied the package ",
  StyleBox["ODE.m ",
    FontWeight->"Bold"],
  "in the directory  c:\\ODE. To load it, you have to type ",
  StyleBox["(\[ShiftKey] + \[ReturnIndicator])  in the current ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        SuperscriptBox["Mathematica", 
          StyleBox["\[RegisteredTrademark]",
            FontWeight->"Plain"]], TraditionalForm]]],
  StyleBox[" session",
    FontWeight->"Plain"]
}], "Text",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell["<<c:\\ODE\\ODE.m", "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["9.3  The Program NBoundary", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Example 9.7", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = \(y'\)' - x\ y' + y\^2 == 0; \nunk = y; \nvar = x; 
    \n{a, b} = {0, 1}; \ndata = {y[0] == 1, y[1] == 2}; 
    \n{dymin, dymax} = {1.5, 2}; \nn = 10; \nsteps = 1000; \nansol = 0; \n
    NBoundary[eq, unk, var, {a, b}, data, {dymin, dymax}, n, steps, ansol]\)],
   "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(eq = \(y'\)' - x\ y' + y\^2 == 0; \nunk = y; \nvar = x; 
    \n{a, b} = {0, 1}; \ndata = {y[0] == 1, y[1] == 2}; 
    \n{dymin, dymax} = {1.9, 2.5}; \nn = 10; \nsteps = 1000; \nansol = 0; \n
    NBoundary[eq, unk, var, {a, b}, data, {dymin, dymax}, n, steps, ansol]\)],
   "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 9.8", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = \(y'\)' + y == 0; \nunk = y; \nvar = x; \n{a, b} = {0, 2\ \[Pi]}; 
    \ndata = {y[0] == 0, y[2\ \[Pi]] == 0}; \n{dymin, dymax} = {\(-1\), 1}; \n
    n = 10; \nsteps = 1000; \nansol = 0; \n
    NBoundary[eq, unk, var, {a, b}, data, {dymin, dymax}, n, steps, ansol]\)],
   "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 9.9", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = \(y'\)' + y == 0; \nunk = y; \nvar = x; \n{a, b} = {0, 2\ \[Pi]}; 
    \ndata = {y[0] == 0, y[2\ \[Pi]] == 1}; \n{dymin, dymax} = {\(-1\), 1}; \n
    n = 10; \nsteps = 1000; \nansol = Sin[x]; \n
    NBoundary[eq, unk, var, {a, b}, data, {dymin, dymax}, n, steps, ansol]\)],
   "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 9.10", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = \(y'\)' + x\ y\^2 - 100  x\^3 == 0; \nunk = y; \nvar = x; 
    \n{a, b} = {0, 1}; \ndata = {y[0] == 1, y[1] == 2}; 
    \n{dymin, dymax} = {\(-4\), \(-3.5\)}; \nn = 10; \nsteps = 1000; \n
    ansol = 0; \n
    NBoundary[eq, unk, var, {a, b}, data, {dymin, dymax}, n, steps, ansol]\)],
   "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(eq = \(y'\)' + x\ y\^2 - 100  x\^3 == 0; \nunk = y; \nvar = x; 
    \n{a, b} = {0, 1}; \ndata = {y[0] == 1, y[1] == 2}; 
    \n{dymin, dymax} = {52, 53}; \nn = 10; \nsteps = 1000; \nansol = 0; \n
    NBoundary[eq, unk, var, {a, b}, data, {dymin, dymax}, n, steps, ansol]\)],
   "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 9.11", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = 0.01 \( y'\)' + \((x - 0.5)\)\ y' == 0; \nunk = y; \nvar = x; 
    \n{a, b} = {0, 1}; \ndata = {y[0] == 1, y[1] == \(-1\)}; 
    \n{dymin, dymax} = {\(-1\), 1}; \nn = 10; \nsteps = 5000; \nansol = 0; \n
    NBoundary[eq, unk, var, {a, b}, data, {dymin, dymax}, n, steps, ansol]\)],
   "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 9.12", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = \(y'\)' + x\^2\ y' + Sin[x] - \(x\^2\) Cos[x] == 0; \nunk = y; \n
    var = x; \n{a, b} = {0, 2  \[Pi]}; \n
    data = {y[0] == 0, y[2  \[Pi]] + 2\ \(y'\)[2  \[Pi]] == 2}; 
    \n{dymin, dymax} = {\(-1\), 1.5}; \nn = 10; \nsteps = 2000; \n
    ansol = Sin[x]; \n
    NBoundary[eq, unk, var, {a, b}, data, {dymin, dymax}, n, steps, ansol]\)],
   "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[
"9.5  The Programs NBoundary1 and NBoundary2", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Example 9.14 ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = \(y'\)' + y' == 0; \nunk = y; \nvar = x; \n{a, b} = {0, 2  \[Pi]}; 
    \ndata = {y[0] == 0, y[2  \[Pi]] == 0}; \nn = 50; \nansol = Sin[x]; \n
    NBoundary1[eq, unk, var, {a, b}, data, n, ansol]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 9.15 ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = \(y'\)' + \(x\^2\) y' + Sin[x] - \(x\^2\) Cos[x] == 0; \nunk = y; 
    \nvar = x; \n{a, b} = {0, 2  \[Pi]}; \n
    data = {y[0] == 0, y[2  \[Pi]] + 2\ \(y'\)[2  \[Pi]] == 2}; \nn = 200; \n
    ansol = Sin[x]; \nNBoundary1[eq, unk, var, {a, b}, data, n, ansol]\)], 
  "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 9.16 ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = \(y'\)' + x\ y' - x + x\ Sin[x] + Cos[x] == 0; \nunk = y; \n
    var = x; \n{a, b} = {0, 2  \[Pi]}; \n
    data = {y[0] == 1, y[2  \[Pi]] == 1 + 2  \[Pi]}; \nn = 300; \n
    ansol = x + Cos[x]; \nNBoundary1[eq, unk, var, {a, b}, data, n, ansol]\)],
   "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 9.17 ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = 0.01 \( y'\)' + \((x - 0.5)\) y' == 0; \nunk = y; \nvar = x; 
    \n{a, b} = {0, 1}; \ndata = {y[0] == 1, y[1] == \(-1\)}; \nn = 300; \n
    ansol = 0; \nNBoundary1[eq, unk, var, {a, b}, data, n, ansol]\)], "Input",\

  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 9.18 ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = \(y'\)' + x\ y\^2 - 100\ x\^3 == 0; \nunk = y; \nvar = x; 
    \n{a, b} = {0, 1}; \ndata = {y[0] == 1, y[1] == 2}; \nn = 50; \ns = 1; \n
    steps = 20; \nansol = 0; \n
    NBoundary2[eq, unk, var, {a, b}, data, n, s, steps, ansol]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 9.19 ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = \(y'\)' + y' - x\ y\^2 - Cos[x] + Sin[x] + x\ Sin[x]\^2 == 0; \n
    unk = y; \nvar = x; \n{a, b} = {0, \[Pi]/2}; \n
    data = {y[0] == 0, y[\[Pi]/2] == 1}; \nn = 65; \ns = 1; \nsteps = 20; \n
    ansol = Sin[x]; \n
    NBoundary2[eq, unk, var, {a, b}, data, n, s, steps, ansol]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 9.20 ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = \(y'\)' - 2  y \((1 + y'\^2)\) == 0; \nunk = y; \nvar = x; 
    \n{a, b} = {0, 1}; \ndata = {y[0] == 1, y[1] == 1}; \nn = 50; \ns = 1; \n
    steps = 50; \nansol = 0; \n
    NBoundary2[eq, unk, var, {a, b}, data, n, s, steps, ansol]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(\(eq = \(y'\)' - 2  y \((1 + y'\^2)\) == 0; \nunk = y; \nvar = x; 
    \n{a, b} = {0, 1}; \ndata = {y[0] == 1, y[1] == 1}; 
    \n{dymin, \ dymax} = {\(-1.12\), \(-1.1\)}; \nn = 50; \ns = 1; \n
    steps = 50; \nansol = 0; \n
    NBoundary[eq, \ unk, \ var, \ {a, \ b}, \ data, \ {dymin, \ dymax}, \ n, 
      \ steps, \ ansol]\ \)\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 9.21 ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = \(y'\)' + \(y\^2\) y' + 2 \((Cos[x] + Sin[x])\) Sin[x]\^2 == 0; \n
    unk = y; \nvar = x; \n{a, b} = {0, 2  \[Pi]}; \n
    data = {y[0] == 1, y[2  \[Pi]] == 1}; \nn = 80; \ns = 1; \nsteps = 20; \n
    ansol = Sin[x] + Cos[x]; \n
    NBoundary2[eq, unk, var, {a, b}, data, n, s, steps, ansol]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["9.6  Problems", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Exercise 1.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = \(y'\)' + 10 == 0; \nunk = y; \nvar = x; \n{a, b} = {0, 10}; \n
    data = {y[0] == 1, y[10] == 30}; \n{dymin, dymax} = {50, 60}; \nn = 10; \n
    steps = 2000; \nansol = 0; \n
    NBoundary[eq, unk, var, {a, b}, data, {dymin, dymax}, n, steps, ansol]\)],
   "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 2.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = \(y'\)' + y' - x\ y == 0; \nunk = y; \nvar = x; \n{a, b} = {0, 1}; 
    \ndata = {y[0] == 1, y[1] == 2}; \n{dymin, dymax} = {0, 2}; \nn = 10; \n
    steps = 2000; \nansol = 0; \n
    NBoundary[eq, unk, var, {a, b}, data, {dymin, dymax}, n, steps, ansol]\)],
   "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 3.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = \(y'\)' + \(x\^2\) \((\ y')\)\^2 == 0; \nunk = y; \nvar = x; 
    \n{a, b} = {0, 1}; \ndata = {y[0] == 1, y[1] == 0}; 
    \n{dymin, dymax} = {\(-2\), 1}; \nn = 10; \nsteps = 2000; \nansol = 0; \n
    NBoundary[eq, unk, var, {a, b}, data, {dymin, dymax}, n, steps, ansol]\)],
   "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 4. ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = \(y'\)' + Sin[x]\ y == 0; \nunk = y; \nvar = x; 
    \n{a, b} = {0, \[Pi]}; \n
    \(data = \(data = {y[0] - \(y'\)[0] == 0, y[\[Pi]] == 0.5}\); \); 
    \n{dymin, dymax} = {\(-1\), 0}; \nn = 10; \nsteps = 2000; \nansol = 0; \n
    NBoundary[eq, unk, var, {a, b}, data, {dymin, dymax}, n, steps, ansol]\)],
   "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 5. ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = \(y'\)' + \(x\^2\) y'\^2 - Sin[3  x] == 0; \nunk = y; \nvar = x; 
    \n{a, b} = {0, 1}; \ndata = {y[0] == 1, y[1] == 0}; \nn = 40; \ns = 1; \n
    steps = 20; \nansol = 0; \n
    NBoundary2[eq, unk, var, {a, b}, data, n, s, steps, ansol]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 6. ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = \(y'\)' + \(x\^2\) y - Sin[3\ x] == 0; \nunk = y; \nvar = x; 
    \n{a, b} = {0, 2}; \ndata = {y[0] == 1, y[2] == 0}; \nn = 200; \n
    ansol = 0; \nNBoundary1[eq, unk, var, {a, b}, data, n, ansol]\)], "Input",\

  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 7. ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(eq = \(y'\)' + y' - x\ y == 0; \nunk = y; \nvar = x; \n{a, b} = {0, 1}; 
    \ndata = {y[0] == 1, y[1] == 0}; \nn = 100; \nansol = 0; \n
    NBoundary1[eq, unk, var, {a, b}, data, n, ansol]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 800}, {0, 544}},
WindowToolbars->"RulerBar",
CellGrouping->Automatic,
WindowSize->{730, 461},
WindowMargins->{{1, Automatic}, {Automatic, 5}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"NeXTAutomaticEncoding",
Magnification->1.25
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 132, 4, 129, "Title"],
Cell[1866, 57, 267, 10, 68, "Subtitle"],

Cell[CellGroupData[{
Cell[2158, 71, 62, 1, 65, "Section"],
Cell[2223, 74, 536, 16, 60, "Text"],
Cell[2762, 92, 108, 3, 34, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2907, 100, 142, 2, 65, "Section"],

Cell[CellGroupData[{
Cell[3074, 106, 114, 3, 57, "Subsection"],
Cell[3191, 111, 348, 7, 224, "Input"],
Cell[3542, 120, 350, 7, 224, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3929, 132, 114, 3, 57, "Subsection"],
Cell[4046, 137, 354, 7, 224, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4437, 149, 114, 3, 57, "Subsection"],
Cell[4554, 154, 359, 7, 224, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4950, 166, 115, 3, 57, "Subsection"],
Cell[5068, 171, 370, 8, 224, "Input"],
Cell[5441, 181, 355, 7, 224, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5833, 193, 115, 3, 57, "Subsection"],
Cell[5951, 198, 367, 7, 224, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6355, 210, 115, 3, 57, "Subsection"],
Cell[6473, 215, 427, 9, 224, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[6949, 230, 160, 3, 65, "Section"],

Cell[CellGroupData[{
Cell[7134, 237, 116, 3, 57, "Subsection"],
Cell[7253, 242, 282, 5, 182, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7572, 252, 116, 3, 57, "Subsection"],
Cell[7691, 257, 349, 7, 182, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8077, 269, 116, 3, 57, "Subsection"],
Cell[8196, 274, 334, 7, 182, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8567, 286, 116, 3, 57, "Subsection"],
Cell[8686, 291, 291, 6, 182, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9014, 302, 116, 3, 57, "Subsection"],
Cell[9133, 307, 318, 6, 224, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9488, 318, 116, 3, 57, "Subsection"],
Cell[9607, 323, 366, 7, 224, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10010, 335, 116, 3, 57, "Subsection"],
Cell[10129, 340, 319, 6, 224, "Input"],
Cell[10451, 348, 413, 8, 245, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10901, 361, 116, 3, 57, "Subsection"],
Cell[11020, 366, 379, 7, 224, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[11448, 379, 129, 2, 65, "Section"],

Cell[CellGroupData[{
Cell[11602, 385, 114, 3, 57, "Subsection"],
Cell[11719, 390, 341, 7, 224, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12097, 402, 114, 3, 57, "Subsection"],
Cell[12214, 407, 343, 7, 224, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12594, 419, 114, 3, 57, "Subsection"],
Cell[12711, 424, 361, 7, 224, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13109, 436, 115, 3, 57, "Subsection"],
Cell[13227, 441, 392, 8, 224, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13656, 454, 115, 3, 57, "Subsection"],
Cell[13774, 459, 325, 6, 224, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14136, 470, 115, 3, 57, "Subsection"],
Cell[14254, 475, 286, 6, 182, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14577, 486, 115, 3, 57, "Subsection"],
Cell[14695, 491, 271, 5, 182, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

