/*
 * Decompiled with CFR 0.152.
 */
public class Spiral {
    private int m_nLayers = 0;
    private int m_nRows = 0;
    private int m_nColumns = 0;
    private double m_dD1 = 0.1;
    private double m_dD2 = 0.1;
    private double m_dmu = 0.7;
    private double m_ds = 1.0;
    private double m_di1 = -0.3;
    private double m_di2 = 0.3;
    private double m_dStep = 0.2;
    private double[][][] L;
    private double[][][] Y;
    private static int[] xoffs;
    private static int[] yoffs;

    static {
        int[] nArray = new int[4];
        nArray[2] = -1;
        nArray[3] = 1;
        xoffs = nArray;
        int[] nArray2 = new int[4];
        nArray2[0] = -1;
        nArray2[1] = 1;
        yoffs = nArray2;
    }

    public Spiral(int n, int n2, int n3, double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        this.m_nLayers = n;
        this.m_nRows = n2;
        this.m_nColumns = n3;
        this.m_dD1 = d;
        this.m_dD2 = d2;
        this.m_dmu = d3;
        this.m_ds = d4;
        this.m_di1 = d5;
        this.m_di2 = d6;
        this.m_dStep = d7;
        this.L = new double[this.m_nLayers][2 + this.m_nRows][2 + this.m_nColumns];
        this.Y = new double[this.m_nLayers][2 + this.m_nRows][2 + this.m_nColumns];
    }

    private void Neumann() {
        int n = 0;
        while (n <= this.m_nColumns + 1) {
            this.L[0][0][n] = this.L[0][1][n];
            this.L[0][this.m_nRows + 1][n] = this.L[0][this.m_nRows][n];
            this.L[1][0][n] = this.L[1][1][n];
            this.L[1][this.m_nRows + 1][n] = this.L[1][this.m_nRows][n];
            ++n;
        }
        int n2 = 0;
        while (n2 <= this.m_nRows + 1) {
            this.L[0][n2][0] = this.L[0][n2][1];
            this.L[0][n2][this.m_nColumns + 1] = this.L[0][n2][this.m_nColumns];
            this.L[1][n2][0] = this.L[1][n2][1];
            this.L[1][n2][this.m_nColumns + 1] = this.L[1][n2][this.m_nColumns];
            ++n2;
        }
    }

    public void compute() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double[] dArray = new double[4];
        dArray[0] = 0.5;
        dArray[1] = 0.5;
        dArray[2] = 1.0;
        double[] dArray2 = dArray;
        double[] dArray3 = new double[4];
        double[] dArray4 = new double[4];
        n = 1;
        while (n <= this.m_nRows) {
            n2 = 1;
            while (n2 <= this.m_nColumns) {
                d2 = this.L[0][n][n2];
                d3 = this.L[1][n][n2];
                n3 = 0;
                while (n3 < 4) {
                    d = -this.L[0][n][n2] + (1.0 + this.m_dmu) * this.Y[0][n][n2] - this.m_ds * this.Y[1][n][n2] + this.m_dD1 * this.foldY(0, n, n2) + this.m_di1;
                    dArray3[n3] = this.m_dStep * d;
                    d = -this.L[1][n][n2] + this.m_ds * this.Y[0][n][n2] + (1.0 + this.m_dmu) * this.Y[1][n][n2] + this.m_dD2 * this.foldY(1, n, n2) + this.m_di2;
                    dArray4[n3] = this.m_dStep * d;
                    this.L[0][n][n2] = d2 + dArray2[n3] * dArray3[n3];
                    this.Y[0][n][n2] = this.inRange(this.L[0][n][n2]);
                    this.L[1][n][n2] = d3 + dArray2[n3] * dArray4[n3];
                    this.Y[1][n][n2] = this.inRange(this.L[1][n][n2]);
                    ++n3;
                }
                this.L[0][n][n2] = d2 + (dArray3[0] + 2.0 * (dArray3[1] + dArray3[2]) + dArray3[3]) / 6.0;
                this.L[1][n][n2] = d3 + (dArray4[0] + 2.0 * (dArray4[1] + dArray4[2]) + dArray4[3]) / 6.0;
                ++n2;
            }
            ++n;
        }
        this.Neumann();
        n = 0;
        while (n < this.m_nRows + 2) {
            n2 = 0;
            while (n2 < this.m_nColumns + 2) {
                this.Y[0][n][n2] = this.inRange(this.L[0][n][n2]);
                this.Y[1][n][n2] = this.inRange(this.L[1][n][n2]);
                ++n2;
            }
            ++n;
        }
    }

    private double foldY(int n, int n2, int n3) {
        double d = 0.0;
        int n4 = 0;
        while (n4 < 4) {
            d += this.Y[n][n2 + xoffs[n4]][n3 + yoffs[n4]];
            ++n4;
        }
        return d -= 4.0 * this.Y[n][n2][n3];
    }

    public double getOutput(int n, int n2, int n3) {
        return this.Y[n][1 + n2][1 + n3];
    }

    public double getState(int n, int n2, int n3) {
        return this.L[n][1 + n2][1 + n3];
    }

    private double inRange(double d) {
        return d < -1.0 ? -1.0 : (d > 1.0 ? 1.0 : d);
    }

    public void init() {
        this.Neumann();
    }

    public void setInput(int n, int n2, int n3, double d) {
        this.L[n][1 + n2][1 + n3] = d;
        this.Y[n][1 + n2][1 + n3] = this.inRange(d);
    }
}

