/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class SpiralDemo
extends Applet
implements Runnable,
ActionListener,
ItemListener {
    private Checker IDC_OUTPUT1 = null;
    private Checker IDC_OUTPUT2 = null;
    private Choice IDC_LIST = null;
    private Button IDC_STEP = null;
    private Button IDC_START = null;
    private Button IDC_STOP = null;
    private int m_nLayers = 2;
    private int m_nRows = 44;
    private int m_nColumns = 44;
    private Spiral cnn = null;
    private Thread m_tWorker = null;
    private Object m_tLocker = new int[1];
    private int m_nStep = 0;

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.IDC_STEP && this.m_tWorker == null) {
            this.showStatus("Running single step " + this.m_nStep++);
            this.cnn.compute();
            this.display();
            this.showStatus("Ready");
        } else if (object == this.IDC_START && this.m_tWorker == null) {
            this.m_tWorker = new Thread(this);
            this.m_tWorker.setPriority(5);
            this.m_tWorker.start();
        } else if (object == this.IDC_STOP && this.m_tWorker != null) {
            this.m_tWorker.stop();
            this.m_tWorker = null;
            this.showStatus("Ready");
        }
    }

    private void display() {
        int n = 0;
        while (n < this.m_nRows) {
            int n2 = 0;
            while (n2 < this.m_nColumns) {
                this.IDC_OUTPUT1.setValue(n, n2, this.norm(this.cnn.getState(0, n, n2)));
                ++n2;
            }
            ++n;
        }
        this.IDC_OUTPUT1.repaint();
    }

    public void init() {
        Color[] colorArray = new Color[256];
        int n = 0;
        while (n < 256) {
            colorArray[n] = new Color(0, 0, n);
            ++n;
        }
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.fill = 1;
        this.IDC_OUTPUT1 = new Checker(this.m_nRows, this.m_nColumns);
        this.add(this.IDC_OUTPUT1);
        this.IDC_OUTPUT1.setColorMap(colorArray);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(8, 8, 2, 8);
        gridBagLayout.setConstraints(this.IDC_OUTPUT1, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        this.IDC_LIST = new Choice();
        this.add(this.IDC_LIST);
        this.IDC_LIST.addItemListener(this);
        this.IDC_LIST.addItem("Select one");
        this.IDC_LIST.addItem("Four Arm Vortex");
        this.IDC_LIST.addItem("Reverberator");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(2, 8, 2, 8);
        gridBagLayout.setConstraints(this.IDC_LIST, gridBagConstraints);
        this.IDC_START = new Button("Start");
        this.add(this.IDC_START);
        this.IDC_START.addActionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(2, 8, 8, 2);
        gridBagLayout.setConstraints(this.IDC_START, gridBagConstraints);
        this.IDC_STOP = new Button("Stop");
        this.add(this.IDC_STOP);
        this.IDC_STOP.addActionListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(2, 2, 8, 2);
        gridBagLayout.setConstraints(this.IDC_STOP, gridBagConstraints);
        this.IDC_STEP = new Button("Step");
        this.add(this.IDC_STEP);
        this.IDC_STEP.addActionListener(this);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(2, 2, 8, 8);
        gridBagLayout.setConstraints(this.IDC_STEP, gridBagConstraints);
        this.cnn = new Spiral(2, this.m_nRows, this.m_nColumns, 0.1, 0.1, 0.7, 1.0, -0.3, 0.3, 0.2);
        this.display();
        this.showStatus("Ready");
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getItem();
        if (object.equals("Four Arm Vortex")) {
            int n = 0;
            while (n < this.m_nRows) {
                int n2 = 0;
                while (n2 < this.m_nColumns) {
                    this.cnn.setInput(0, n, n2, SpiralFactory.FourArmVortexHi[n][n2]);
                    this.cnn.setInput(1, n, n2, SpiralFactory.FourArmVortexLow[n][n2]);
                    ++n2;
                }
                ++n;
            }
            this.cnn.init();
            this.display();
            this.m_nStep = 0;
        } else if (object.equals("Reverberator")) {
            int n = 0;
            while (n < this.m_nRows) {
                int n3 = 0;
                while (n3 < this.m_nColumns) {
                    this.cnn.setInput(0, n, n3, SpiralFactory.ReverberatorHi[n][n3]);
                    this.cnn.setInput(1, n, n3, SpiralFactory.ReverberatorLow[n][n3]);
                    ++n3;
                }
                ++n;
            }
            this.cnn.init();
            this.display();
            this.m_nStep = 0;
        }
    }

    private int norm(double d) {
        if (d < -3.0) {
            d = -3.0;
        }
        if (d > 2.0) {
            d = 2.0;
        }
        return (int)((d + 3.0) * 255.0 / 5.0);
    }

    public void run() {
        while (true) {
            Object object = this.m_tLocker;
            synchronized (object) {
                this.cnn.compute();
                this.display();
                this.showStatus("Running step " + this.m_nStep++);
            }
            try {
                Thread.sleep(200L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public void stop() {
        if (this.m_tWorker != null) {
            this.m_tWorker.stop();
            this.m_tWorker = null;
        }
    }
}

