(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     16364,        545]*)
(*NotebookOutlinePosition[     17294,        577]*)
(*  CellTagsIndexPosition[     17250,        573]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Chapter 2", "Title",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[TextData[{
  StyleBox["Linear ODEs with Constant Coefficients ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontWeight->"Bold"]
}], "Subtitle",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->24],

Cell[CellGroupData[{

Cell["Load ODE.m", "Section",
  FontFamily->"Times New Roman"],

Cell[TextData[{
  "Suppose you have copied the package ",
  StyleBox["ODE.m ",
    FontWeight->"Bold"],
  "in the directory  c:\\ODE. To load it, you have to type ",
  StyleBox["(\[ShiftKey] + \[ReturnIndicator])  in the current ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        SuperscriptBox["Mathematica", 
          StyleBox["\[RegisteredTrademark]",
            FontWeight->"Plain"]], TraditionalForm]]],
  StyleBox[" session",
    FontWeight->"Plain"]
}], "Text",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell["<<c:\\ODE\\ODE.m", "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[
"2.2  The General Solution of Linear Differential Systems with Constant \
Coefficients", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Example 2.1", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{"DSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{
                SuperscriptBox["x", "\[Prime]",
                  MultilineFunction->None], "[", "t", "]"}], "==", \(y[t]\)}],
             ",", 
            RowBox[{
              RowBox[{
                SuperscriptBox["y", "\[Prime]",
                  MultilineFunction->None], "[", "t", "]"}], "==", 
              \(\(-\(5\/4\)\) x[t] - y[t]\)}]}], "}"}], ",", \({x[t], y[t]}\),
         ",", "t"}], "]"}]], "Input",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(A = {{0, 1}, {\(-5\)/4, \(-1\)}}; \nb = {0, 0}; \nunk = {x, y}; \n
    unk0 = {x0, y0}; \n\nLinSys[A, b, unk, unk0]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["2.3 The Program LinSys", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Example 2.2: Asymptotically stable focus", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    RowBox[{
    \(A = {{\(-1\), 1}, {\(-1\), \(-1\)}}\), ";", "\n", \(b = {0, 0}\), ";", 
      "\n", \(unk = {x, y}\), ";", "\n", \(unk0 = {x0, y0}\), ";", "\n", 
      RowBox[{"eq1", "=", 
        RowBox[{
          SuperscriptBox["x", "\[Prime]",
            MultilineFunction->None], "==", \(\(-x\) + y\)}]}], ";", "\n", 
      RowBox[{"eq2", "=", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "==", \(\(-x\) - y\)}]}], ";", "\n", 
      \(sys = {eq1, eq2}\), ";", "\n", "\n", \(LinSys[A, b, unk, unk0]\)}], 
  \(Phase2D[sys, {x, y}, {0, 0}, {0.5, 0.5}, {2, 2}, {\(-16\), 15}, 
      1000, {{\(-2\), 2}, {\(-2\), 2}}, 1]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 2.3: Asymptotically stable node", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(A = {{\(-3\), 0}, {0, \(-3\)}}; \nb = {0, 0}; \nunk = {x, y}; \n
    unk0 = {x0, y0}; \neq1 = x' == \(-3\)\ x; \neq2 = y' == \(-3\)\ y; \n
    sys = {eq1, eq2}; \ \n\nLinSys[A, b, unk, unk0]\ \), 
    \(Phase2D[sys, {x, y}, {0, 0}, {0.5, 0.5}, {3, 2}, {\(-15\), 15}, 
      1000, {{\(-2\), 2}, {\(-2\), 2}}, 1]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 2.4: Asymptotically stable node", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(A = {{\(-1\), 1}, {0, \(-1\)}}; \nb = {0, 0}; \nunk = {x, y}; \n
    unk0 = {x0, y0}; \neq1 = x' == \(-x\) + y; \neq2 = y' == \ \(-y\); \n
    sys = {eq1, eq2}; \n\nLinSys[A, b, unk, unk0]\), 
    \(Phase2D[sys, {x, y}, {0, 0}, {0.5, 0.5}, {3, 2}, {\(-15\), 15}, 
      1000, {{\(-2\), 2}, {\(-2\), 2}}, 1]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 2.5: Asymptotically stable node", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(A = {{\(-2\), \(-3\)}, {0, \(-1\)}}; \nb = {0, 0}; \nunk = {x, y}; \n
    unk0 = {x0, y0}; \neq1 = x' == \(-2\)\ x - 3\ y; \neq2 = y' == \(-\ y\); 
    \nsys = {eq1, eq2}; \n\nLinSys[A, b, unk, unk0]\), 
    \(Phase2D[sys, {x, y}, {0, 0}, {0.5, 0.5}, {3, 2}, {\(-15\), 15}, 
      1000, {{\(-2\), 2}, {\(-2\), 2}}, 1]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 2.6:  Neutrally stable center", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(A = {{0, 1}, {\(-1\), 0}}; \nb = {0, 0}; \nunk = {x, y}; \n
    unk0 = {x0, y0}; \neq1 = x' == y; \neq2 = y' == \(-x\); \n
    sys = {eq1, eq2}; \n\nLinSys[A, b, unk, unk0]\), 
    \(Phase2D[sys, {x, y}, {0, 0}, {0.5, 0.5}, {4, 0}, {\(-2\), 2}, 
      1000, {{\(-2.3\), 2.3}, {\(-2.3\), 2.3}}, 1]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 2.7:  Unstable saddlepoint", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(A = {{1, 4}, {1, 1}}; \nb = {0, 0}; \nunk = {x, y}; \nunk0 = {x0, y0}; 
    \neq1 = x' == x + 4  y; \neq2 = y' == x + \ y; \nsys = {eq1, eq2}; \n\n
    LinSys[A, b, unk, unk0]\), 
    \(Phase2D[sys, {x, y}, {0, 0}, {0.5, 0.5}, {3, 2}, {\(-15\), 15}, 
      1000, {{\(-2\), 2}, {\(-2\), 2}}, 1]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 2.8:  Unstable focus", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(A = {{1, \(-1\)}, {1, 1}}; \nb = {0, 0}; \nunk = {x, y}; \n
    unk0 = {x0, y0}; \neq1 = x' == x - y; \neq2 = y' == x + \ y; \n
    sys = {eq1, eq2}; \n\nLinSys[A, b, unk, unk0]\), 
    \(Phase2D[sys, {x, y}, {0, 0}, {0.5, 0.5}, {2, 2}, {\(-5\), 5}, 
      1000, {{\(-2\), 2}, {\(-2\), 2}}, 1]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 2.9:  Unstable node", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(A = {{2, 0}, {0, 2}}; \nb = {0, 0}; \nunk = {x, y}; \nunk0 = {x0, y0}; 
    \neq1 = x' == 2  x; \neq2 = y' == 2\ y; \nsys = {eq1, eq2}; \ \n\n
    LinSys[A, b, unk, unk0]\ \), 
    \(Phase2D[sys, {x, y}, {0, 0}, {0.5, 0.5}, {3, 2}, {\(-15\), 15}, 
      1000, {{\(-2\), 2}, {\(-2\), 2}}, 1]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 2.10:  Unstable node", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(A = {{2, 3}, {0, 1}}; \nb = {0, 0}; \nunk = {x, y}; \nunk0 = {x0, y0}; 
    \neq1 = x' == 2\ x + 3\ y; \neq2 = y' == y; \nsys = {eq1, eq2}; \n\n
    LinSys[A, b, unk, unk0]\), 
    \(Phase2D[sys, {x, y}, {0, 0}, {0.5, 0.5}, {3, 2}, {\(-15\), 15}, 
      1000, {{\(-2\), 2}, {\(-2\), 2}}, 1]\)}], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["2.4  Problems", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Exercise 1. Unstable node", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(A = {{1, 1}, {0, 1}}; \nb = {0, 0}; \nunk = {x, y}; \nunk0 = {x0, y0}; 
    \neq1 = x' == x + y; \neq2 = y' == \ y; \nsys = {eq1, eq2}; \n\n
    LinSys[A, b, unk, unk0]\), 
    \(Phase2D[sys, {x, y}, {0, 0}, {0.5, 0.5}, {3, 2}, {\(-15\), 15}, 
      1000, {{\(-2\), 2}, {\(-2\), 2}}, 1]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 2. Stable focus", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(A = {{0, 1}, {\(-1\), \(-\(1\/2\)\)}}; \nb = {0, 0}; \nunk = {x, y}; \n
    unk0 = {x0, y0}; \neq1 = x' == y; \neq2 = y' == \(-x\) - 1\/2\ y; \n
    sys = {eq1, eq2}; \n\nLinSys[A, b, unk, unk0]\), 
    \(Phase2D[sys, {x, y}, {0, 0}, {1\/2, 1\/2}, {3, 0}, {\(-15\), 15}, 
      1000, {{\(-40\), 40}, {\(-60\), 60}}, 2]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 3. Stable node", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(A = {{\(-1\), 0}, {0, \(-5\)}}; \nb = {0, 0}; \nunk = {x, y}; \n
    unk0 = {x0, y0}; \neq1 = x' == \(-x\); \neq2 = y' == \(-5\)\ y; \n
    sys = {eq1, eq2}; \n\nLinSys[A, b, unk, unk0]\), 
    \(Phase2D[sys, {x, y}, {0, 0}, {0.5, 0.5}, {3, 2}, {\(-15\), 15}, 
      1000, {{\(-2\), 2}, {\(-2\), 2}}, 1]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 4. Neutrally stable center", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(A = {{0, 2}, {\(-1\), 0}}; \nb = {0, 0}; \nunk = {x, y}; \n
    unk0 = {x0, y0}; \neq1 = x' == 2  y; \neq2 = y' == \(-x\); \n
    sys = {eq1, eq2}; \n\nLinSys[A, b, unk, unk0]\), 
    \(Phase2D[sys, {x, y}, {0, 0}, {0.5, 0.5}, {4, 0}, {\(-2\), 2}, 
      1000, {{\(-2.1\), 2.1}, {\(-1.6\), 1.6}}, 1]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 5. Unstable saddlepoint", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(A = {{\(-1\), 0}, {0, 5}}; \nb = {0, 0}; \nunk = {x, y}; \n
    unk0 = {x0, y0}; \neq1 = x' == \(-x\); \neq2 = y' == 5\ y; \n
    sys = {eq1, eq2}; \n\nLinSys[A, b, unk, unk0]\), 
    \(Phase2D[sys, {x, y}, {0, 0}, {0.5, 0.5}, {3, 2}, {\(-15\), 15}, 
      1000, {{\(-2\), 2}, {\(-2\), 2}}, 1]\)}], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 6. Forced vibration", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(\(A = {{0, 1}, {\(-1\), \(-2\)}}; \nb = {0, Cos[t]}; \nunk = {x, y}; \n
    unk0 = {x0, y0}; \n\nLinSys[A, b, unk, unk0]\ \ \)\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 7. Forced vibration", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(A = {{0, 1}, {\(-1\), 0}}; \nb = {0, Sin[2  t]}; \nunk = {x, y}; \n
    unk0 = {x0, y0}; \n\nLinSys[A, b, unk, unk0]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 8.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(A = {{0, 1}, {\(-4\), 0}}; \nb = {0, Tan[t]}; \nunk = {x, y}; \n
    unk0 = {x0, y0}; \n\nLinSys[A, b, unk, unk0]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 9.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(A = {{\(-1\), 1}, {\(-1\), \(-1\)}}; \nb = {Cos[t], 0}; \nunk = {x, y}; 
    \nunk0 = {x0, y0}; \n\nLinSys[A, b, unk, unk0]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 10.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(A = {{0, 1}, {\(-9\), 0}}; \nb = {0, 1 - Exp[\(-t\)]}; \nunk = {x, y}; 
    \nunk0 = {x0, y0}; \n\nLinSys[A, b, unk, unk0]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 11.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(A = {{\(-1\), 0}, {0, 1}}; \nb = {0, Cos[t]}; \nunk = {x, y}; \n
    unk0 = {x0, y0}; \n\nLinSys[A, b, unk, unk0]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 12.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(A = {{0, \(-1\)}, {\(-5\)/4, \(-1\)}}; \nb = {0, 0}; \nunk = {x, y}; \n
    unk0 = {x0, y0}; \n\nLinSys[A, b, unk, unk0]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 13.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(A = {{0, 1, 0}, {0, 0, 1}, {1, 0, 0}}; \nb = {0, 0, t\ Exp[\(-t\)]}; \n
    unk = {x, y, z}; \nunk0 = {x0, y0, z0}; \n\nLinSys[A, b, unk, unk0]\)], 
  "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 14.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(A = {{0, 1, 0, 0}, {0, 0, 1, 0}, {0, 0, 0, 1}, {1, 0, 0, 0}}; \n
    b = {0, 0, 0, Sin[t] + Cos[t]}; \nunk = {x1, x2, x3, x4}; \n
    unk0 = {x01, x02, x03, x04}; \n\nLinSys[A, b, unk, unk0]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 800}, {0, 544}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{693, 436},
WindowMargins->{{9, Automatic}, {Automatic, 5}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"NeXTAutomaticEncoding",
Magnification->1.25
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 132, 4, 129, "Title"],
Cell[1866, 57, 297, 11, 68, "Subtitle"],

Cell[CellGroupData[{
Cell[2188, 72, 62, 1, 65, "Section"],
Cell[2253, 75, 536, 16, 60, "Text"],
Cell[2792, 93, 108, 3, 34, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2937, 101, 202, 4, 90, "Section"],

Cell[CellGroupData[{
Cell[3164, 109, 114, 3, 57, "Subsection"],
Cell[3281, 114, 613, 17, 57, "Input"],
Cell[3897, 133, 197, 4, 140, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[4143, 143, 138, 2, 65, "Section"],

Cell[CellGroupData[{
Cell[4306, 149, 143, 3, 57, "Subsection"],
Cell[4452, 154, 755, 16, 224, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5244, 175, 142, 3, 57, "Subsection"],
Cell[5389, 180, 394, 7, 224, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5820, 192, 142, 3, 57, "Subsection"],
Cell[5965, 197, 390, 7, 224, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6392, 209, 142, 3, 57, "Subsection"],
Cell[6537, 214, 401, 7, 224, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6975, 226, 140, 3, 57, "Subsection"],
Cell[7118, 231, 380, 7, 224, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7535, 243, 137, 3, 57, "Subsection"],
Cell[7675, 248, 377, 7, 224, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8089, 260, 131, 3, 57, "Subsection"],
Cell[8223, 265, 377, 7, 224, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8637, 277, 130, 3, 57, "Subsection"],
Cell[8770, 282, 374, 7, 224, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9181, 294, 131, 3, 57, "Subsection"],
Cell[9315, 299, 374, 7, 224, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[9738, 312, 129, 2, 65, "Section"],

Cell[CellGroupData[{
Cell[9892, 318, 128, 3, 57, "Subsection"],
Cell[10023, 323, 396, 8, 224, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10456, 336, 127, 3, 57, "Subsection"],
Cell[10586, 341, 428, 8, 302, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11051, 354, 126, 3, 57, "Subsection"],
Cell[11180, 359, 413, 8, 224, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11630, 372, 138, 3, 57, "Subsection"],
Cell[11771, 377, 409, 8, 224, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12217, 390, 135, 3, 57, "Subsection"],
Cell[12355, 395, 403, 8, 224, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12795, 408, 131, 3, 57, "Subsection"],
Cell[12929, 413, 234, 5, 140, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13200, 423, 131, 3, 57, "Subsection"],
Cell[13334, 428, 224, 5, 140, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13595, 438, 114, 3, 57, "Subsection"],
Cell[13712, 443, 221, 5, 140, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13970, 453, 114, 3, 57, "Subsection"],
Cell[14087, 458, 231, 5, 140, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14355, 468, 115, 3, 57, "Subsection"],
Cell[14473, 473, 230, 5, 140, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14740, 483, 115, 3, 57, "Subsection"],
Cell[14858, 488, 221, 5, 140, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15116, 498, 115, 3, 57, "Subsection"],
Cell[15234, 503, 228, 5, 140, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15499, 513, 115, 3, 57, "Subsection"],
Cell[15617, 518, 254, 6, 140, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15908, 529, 115, 3, 57, "Subsection"],
Cell[16026, 534, 298, 6, 140, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

