(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      9135,        313]*)
(*NotebookOutlinePosition[     10074,        345]*)
(*  CellTagsIndexPosition[     10030,        341]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Chapter 4", "Title",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[TextData[{
  StyleBox["Poincar\[EAcute]'s Perturbation Method",
    FontSlant->"Italic"],
  " "
}], "Subtitle",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->24,
  FontWeight->"Bold"],

Cell[CellGroupData[{

Cell["Load ODE.m", "Section",
  FontFamily->"Times New Roman"],

Cell[TextData[{
  "Suppose you have copied the package ",
  StyleBox["ODE.m ",
    FontWeight->"Bold"],
  "in the directory  c:\\ODE. To load it, you have to type ",
  StyleBox["(\[ShiftKey] + \[ReturnIndicator])  in the current ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        SuperscriptBox["Mathematica", 
          StyleBox["\[RegisteredTrademark]",
            FontWeight->"Plain"]], TraditionalForm]]],
  StyleBox[" session",
    FontWeight->"Plain"]
}], "Text",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell["<<c:\\ODE\\ODE.m", "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["4.4 The Program Poincare", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Examples 4.4", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {x' == \ y, y' == \(-x\) + \[Mu]\ \((1 - \ x\^2)\)\ y}; \n
    unk = {x, y}; \nvar = t; \nunk0 = {1, 0}; \npar = \[Mu]; \nm = 1; \n
    r = 0.1; \nT1 = 0; \nT2 = 20; \nsteps = 2000; \npref = frac; \n\n
    Poincare[sys, unk, var, unk0, par, m, r, T1, T2, steps, \ pref]\)], 
  "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples 4.5", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {x' == \(-\ y\) + \[Mu]\ y\^2, y' == x + \[Mu]\ x\^2}; \n
    unk = {x, y}; \nvar = t; \nunk0 = {1, 1}; \npar = \[Mu]; \nm = 2; \n
    r = 0.1; \nT1 = 0; \nT2 = 10; \nsteps = 2000; \npref = frac; \n\n
    Poincare[sys, unk, var, unk0, par, m, r, T1, T2, steps, \ pref]\)], 
  "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples 4.6", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {x' == \(-x\) + \[Mu]\ x\ y\^2, y' == x}; \nunk = {x, y}; \n
    var = t; \nunk0 = {1, 0}; \npar = \[Mu]; \nm = 1; \nr = 0.1; \nT1 = 0; \n
    T2 = 5; \nsteps = 2000; \npref = frac; \n\n
    Poincare[sys, unk, var, unk0, par, m, r, T1, T2, steps, pref]\)], "Input",\

  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples 4.7", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {x' == y, y' == \(-10\) x + \[Mu]\ x\^3}; \nunk = {x, y}; \n
    var = t; \nunk0 = {1, 0}; \npar = \[Mu]; \nm = 1; \nr = 0.1; \nT1 = 0; \n
    T2 = 10; \nsteps = 2000; \n\n
    Poincare[sys, unk, var, unk0, par, m, r, T1, T2, steps, frac]\)], "Input",\

  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples 4.8", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {x' == y + \[Mu]\ \((x\^2 - y\^2)\), y' == \(-x\) + \[Mu]\ y\^3}; 
    \nunk = {x, y}; \nvar = t; \nunk0 = {1/2, 0}; \npar = \[Mu]; \nm = 1; \n
    r = 0.1; \nT1 = 0; \nT2 = 10; \nsteps = 5000; \n\n
    Poincare[sys, unk, var, unk0, par, m, r, T1, T2, steps, frac]\)], "Input",\

  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples 4.9", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {x' == y + \[Mu]\ y\ \((x\^2 - y\^2 - 1)\), 
        y' == \(-x\) + \[Mu]\ x\ \((x\^2 - y\^2 - 1)\)}; \nunk = {x, y}; \n
    var = t; \nunk0 = {1, 0}; \npar = \[Mu]; \nm = 2; \nr = 0.1; \nT1 = 0; \n
    T2 = 15; \nsteps = 2000; \n\n
    Poincare[sys, unk, var, unk0, par, m, r, T1, T2, steps, frac]\)], "Input",\

  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["4.5 Problems", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Exercise 1.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {x' == u, y' == v, z' == w, u' == \(-\[Mu]\)\ \((w - v)\), 
        v' == \(-\[Mu]\)\ u, w' == \(-1\) - \[Mu]\ u}; \n
    unk = {x, y, z, u, v, w}; \nvar = t; \nunk0 = {0, 0, 1, 0, 0, 0}; \n
    par = \[Mu]; \nm = 2; \nr = 0.002; \nT1 = 0; \nT2 = 1; \nsteps = 2000; \n
    \nPoincare[sys, unk, var, unk0, par, m, r, T1, T2, steps, frac]\)], 
  "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 2.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {x' == \(-y\) - \[Mu]\ x\ \((x\^2 - y\^2 + 1)\), 
        y' == x - \[Mu]\ y\ \((x\^2 - y\^2 + 1)\)}; \nunk = {x, y}; \n
    var = t; \nunk0 = {1, 0}; \npar = \[Mu]; \nm = 2; \nr = 0.1; \nT1 = 0; \n
    T2 = 10; \nsteps = 2000; \n\n
    Poincare[sys, unk, var, unk0, par, m, r, T1, T2, steps, frac]\)], "Input",\

  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 3.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {x' == y, y' == \(-\[Mu]\)\ Sin[x]}; \nunk = {x, y}; \nvar = t; \n
    unk0 = {1, 1}; \npar = \[Mu]; \nm = 2; \nr = 0.1; \nT1 = 0; \nT2 = 14; \n
    steps = 2000; \n\n
    Poincare[sys, unk, var, unk0, par, m, r, T1, T2, steps, frac]\)], "Input",\

  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 4.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {x' == y - \[Mu]\ x\^3, y' == \(-x\) - \[Mu]\ y\^3}; \n
    unk = {x, y}; \nvar = t; \nunk0 = {0, 1}; \npar = \[Mu]; \nm = 2; \n
    r = 0.1; \nT1 = 0; \nT2 = 8; \nsteps = 2000; \n\n
    Poincare[sys, unk, var, unk0, par, m, r, T1, T2, steps, frac]\)], "Input",\

  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 5.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {x' == 2\ x, y' == \(-y\) - \[Mu]\ Exp[\(-y\)]}; \nunk = {x, y}; 
    \nvar = t; \nunk0 = {1, 0}; \npar = \[Mu]; \nm = 3; \nr = 0.1; \nT1 = 0; 
    \nT2 = 20; \nsteps = 2000; \n\n
    Poincare[sys, unk, var, unk0, par, m, r, T1, T2, steps, frac]\)], "Input",\

  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 800}, {0, 544}},
WindowToolbars->"RulerBar",
CellGrouping->Automatic,
WindowSize->{737, 422},
WindowMargins->{{4, Automatic}, {Automatic, 10}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"NeXTAutomaticEncoding",
Magnification->1.25
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 132, 4, 129, "Title"],
Cell[1866, 57, 260, 10, 68, "Subtitle"],

Cell[CellGroupData[{
Cell[2151, 71, 62, 1, 65, "Section"],
Cell[2216, 74, 536, 16, 60, "Text"],
Cell[2755, 92, 108, 3, 34, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2900, 100, 140, 2, 65, "Section"],

Cell[CellGroupData[{
Cell[3065, 106, 115, 3, 57, "Subsection"],
Cell[3183, 111, 386, 8, 287, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3606, 124, 115, 3, 57, "Subsection"],
Cell[3724, 129, 385, 8, 287, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4146, 142, 115, 3, 57, "Subsection"],
Cell[4264, 147, 368, 8, 287, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4669, 160, 115, 3, 57, "Subsection"],
Cell[4787, 165, 354, 8, 266, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5178, 178, 115, 3, 57, "Subsection"],
Cell[5296, 183, 380, 8, 266, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5713, 196, 115, 3, 57, "Subsection"],
Cell[5831, 201, 414, 9, 266, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[6294, 216, 128, 2, 65, "Section"],

Cell[CellGroupData[{
Cell[6447, 222, 114, 3, 57, "Subsection"],
Cell[6564, 227, 453, 9, 266, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7054, 241, 114, 3, 57, "Subsection"],
Cell[7171, 246, 414, 9, 266, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7622, 260, 114, 3, 57, "Subsection"],
Cell[7739, 265, 323, 7, 266, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8099, 277, 114, 3, 57, "Subsection"],
Cell[8216, 282, 364, 8, 266, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8617, 295, 114, 3, 57, "Subsection"],
Cell[8734, 300, 361, 8, 266, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

