(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     10900,        417]*)
(*NotebookOutlinePosition[     11838,        449]*)
(*  CellTagsIndexPosition[     11794,        445]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Chapter 5", "Title",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[TextData[{
  StyleBox["Problems of Stability",
    FontSlant->"Italic"],
  " "
}], "Subtitle",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->24,
  FontWeight->"Bold"],

Cell[CellGroupData[{

Cell["Load ODE.m", "Section",
  FontFamily->"Times New Roman"],

Cell[TextData[{
  "Suppose you have copied the package ",
  StyleBox["ODE.m ",
    FontWeight->"Bold"],
  "in the directory  c:\\ODE. To load it, you have to type ",
  StyleBox["(\[ShiftKey] + \[ReturnIndicator])  in the current ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        SuperscriptBox["Mathematica", 
          StyleBox["\[RegisteredTrademark]",
            FontWeight->"Plain"]], TraditionalForm]]],
  StyleBox[" session",
    FontWeight->"Plain"]
}], "Text",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell["<<c:\\ODE\\ODE.m", "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["5.5 The Program Liapunov", "Section",
  FontFamily->"Times New Roman"]], "Section",
  TextAlignment->Left,
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Examples 5.3", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {x' == y + x\ y\^4 - 2  x\^3, y' == 2\ x + 2\ x\^2\ y\^3 - y\^7}; 
    \n\nLiapunov[sys, {x, y}, x\^2 + y\^2, 2, {\(-2\), 2}, {\(-2\), 2}, 1, 1, 
      50]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples 5.4 ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {x' == \(-\ y\), y' == \(-x\) - 2\ y - y\^3}; \n\n
    Liapunov[sys, {x, y}, x\^2 + y\^2, 2, {\(-3\), 3}, {\(-3\), 3}, 0.6, 
      0.75, 50]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples 5.5 ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {x' == \(-x\) + \ y, y' == \(-x\) - y - x\^3}; \n\n
    Liapunov[sys, {x, y}, x\^2 + x\ y + y\^2, 2, {\(-3\), 3}, {\(-3\), 3}, 
      1.4, 1, 50]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples 5.6 ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {x' == \(-\ x\), y' == \(-y\) + y\^2}; \n\n
    Liapunov[sys, {x, y}, x\^2 + y\^2, 2, {\(-2\), 2}, {\(-2\), 2}, 0.5, 
      0.75, 50]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples 5.7", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {x' == \(-y\) - x\ \((x\^2 + y\^2)\), 
        y' == x - y\ \((x\^2 + y\^2)\)}; \n\n
    Liapunov[sys, {x, y}, x\^2 + y\^2, 2, {\(-2\), 2}, {\(-2\), 2}, 1, 1, 50]
      \)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["5.7 The Program LStability", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Examples 5.8", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {x' == 2\ x\ y, y' == 1 - 3\ x\^2 - y\^2}; \n
    xe = {{0, \(-1\)}, {0, 1}, {\(-1\)/\@3, 0}, {1/\@3, 0}}; \n\n
    LStability[sys, {x, y}, xe]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples 5.9 ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {x' == \(-x\) + y, y' == \(-x\) + 2\ x\ y}; \n
    xe = {{0, 0}, {1/2, 1/2}}; \n\nLStability[sys, {x, y}, xe]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples 5.10", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {x' == x + y, y' == 2\ x\ y}; \nxe = {{0, 0}}; \n\n
    LStability[sys, {x, y}, xe]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["5.8 Problems", "Section",
  FontFamily->"Times New Roman"]], "Section",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Exercise 1. ", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(Solve[{\(-x\) + y == 0, \(-x\) + 2\ x\ y == 0}, {x, y}]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(sys = {x' == \(-x\) + y, y' == \(-x\) + 2\ x\ y}; \n
    xe = {{1/2, 1/2}, {0, 0}}; \n\nLStability[sys, {x, y}, xe]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 2.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {x' == \(-x\) + y, y' == \(-x\) - y}; \nxe = {{0, 0}}; \n\n
    LStability[sys, {x, y}, xe]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 3.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(Solve[{x - y == 0, \(-x\) - y - x\^3 == 0}, {x, y}]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(sys = {x' == x - y, y' == \(-x\) - y - x\^3}; \nxe = {{0, 0}}; \n\n
    LStability[sys, {x, y}, xe]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 4.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(Solve[{y == 0, \(-x\) + \((1\/2 - x\^2)\) y == 0}, {x, y}]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(sys = {x' == y, y' == \(-x\) + \((1\/2 - x\^2)\) y}; \nxe = {{0, 0}}; \n
    \nLStability[sys, {x, y}, xe]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 5.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {x' == \(-2\)\ x - y - x\ \((x\^2 + y\^2)\), 
        y' == x - y + y\ \((x\^2 + y\^2)\)}; \nxe = {{0, 0}}; \n\n
    LStability[sys, {x, y}, xe]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 6.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(Solve[{\((1 + x)\) Sin[x - 3\ y] == 0, 1 - x - Cos[y] == 0}, {x, y}]\)],
   "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(sys = {x' == \((1 + x)\) Sin[x - 3\ y], y' == 1 - x - Cos[y]}; \n
    xe = {{0, 0}, {\(-1\), \(-ArcCos[2]\)}, {\(-1\), ArcCos[2]}}; \n\n
    LStability[sys, {x, y}, xe]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 7.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {x' == \((1 + y)\) - Exp[\(-x\)], y' == y - Sin[x]}; \n
    xe = {{0, 0}}; \n\nLStability[sys, {x, y}, xe]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 8.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(Solve[{\(-x\) == 0, \(-y\) + y\^3 == 0}, {x, y}]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12],

Cell[BoxData[
    \(sys = {x' == \(-x\), y' == \(-y\) + y\^3}; \n
    xe = {{0, 0}, {0, \(-1\)}, {0, 1}}; \n\nLStability[sys, {x, y}, xe]\)], 
  "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 9.", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(sys = {x' == y, y' == \(-x\)}; \nxe = {{0, 0}}; \n\n
    LStability[sys, {x, y}, xe]\)], "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 800}, {0, 544}},
WindowToolbars->"RulerBar",
CellGrouping->Automatic,
WindowSize->{719, 362},
WindowMargins->{{7, Automatic}, {Automatic, 5}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"NeXTAutomaticEncoding",
Magnification->1.25
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 132, 4, 129, "Title"],
Cell[1866, 57, 243, 10, 68, "Subtitle"],

Cell[CellGroupData[{
Cell[2134, 71, 62, 1, 65, "Section"],
Cell[2199, 74, 536, 16, 60, "Text"],
Cell[2738, 92, 108, 3, 34, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2883, 100, 163, 3, 65, "Section"],

Cell[CellGroupData[{
Cell[3071, 107, 115, 3, 57, "Subsection"],
Cell[3189, 112, 269, 6, 78, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3495, 123, 116, 3, 57, "Subsection"],
Cell[3614, 128, 254, 6, 78, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3905, 139, 116, 3, 57, "Subsection"],
Cell[4024, 144, 259, 6, 78, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4320, 155, 116, 3, 57, "Subsection"],
Cell[4439, 160, 247, 6, 78, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4723, 171, 115, 3, 57, "Subsection"],
Cell[4841, 176, 283, 7, 78, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[5173, 189, 142, 2, 65, "Section"],

Cell[CellGroupData[{
Cell[5340, 195, 115, 3, 57, "Subsection"],
Cell[5458, 200, 257, 6, 116, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5752, 211, 116, 3, 57, "Subsection"],
Cell[5871, 216, 223, 5, 98, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6131, 226, 116, 3, 57, "Subsection"],
Cell[6250, 231, 197, 5, 98, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[6496, 242, 128, 2, 65, "Section"],

Cell[CellGroupData[{
Cell[6649, 248, 115, 3, 57, "Subsection"],
Cell[6767, 253, 163, 4, 35, "Input"],
Cell[6933, 259, 223, 5, 98, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7193, 269, 114, 3, 57, "Subsection"],
Cell[7310, 274, 205, 5, 98, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7552, 284, 114, 3, 57, "Subsection"],
Cell[7669, 289, 159, 4, 35, "Input"],
Cell[7831, 295, 207, 5, 98, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8075, 305, 114, 3, 57, "Subsection"],
Cell[8192, 310, 166, 4, 57, "Input"],
Cell[8361, 316, 214, 5, 123, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8612, 326, 114, 3, 57, "Subsection"],
Cell[8729, 331, 258, 6, 98, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9024, 342, 114, 3, 57, "Subsection"],
Cell[9141, 347, 179, 5, 35, "Input"],
Cell[9323, 354, 276, 6, 98, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9636, 365, 114, 3, 57, "Subsection"],
Cell[9753, 370, 220, 5, 98, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10010, 380, 114, 3, 57, "Subsection"],
Cell[10127, 385, 156, 4, 35, "Input"],
Cell[10286, 391, 228, 6, 98, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10551, 402, 114, 3, 57, "Subsection"],
Cell[10668, 407, 192, 5, 98, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

