(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     38997,       1518]*)
(*NotebookOutlinePosition[     39974,       1552]*)
(*  CellTagsIndexPosition[     39930,       1548]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["The Package ODE.m ", "Title",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->36,
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell["Load ODE.m", "Section",
  FontFamily->"Times New Roman"],

Cell[TextData[{
  "Suppose you have copied the package ",
  StyleBox["ODE.m ",
    FontWeight->"Bold"],
  "in the directory  c:\\ODE. To load it, you have to type ",
  StyleBox["(\[ShiftKey] + \[ReturnIndicator])  in the current ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        SuperscriptBox["Mathematica", 
          StyleBox["\[RegisteredTrademark]",
            FontWeight->"Plain"]], TraditionalForm]]],
  StyleBox[" session",
    FontWeight->"Plain"]
}], "Text",
  FontFamily->"Times New Roman",
  FontSize->12],

Cell["<<c:\\ODE\\ODE.m", "Input",
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Sysn",
  FontWeight->"Bold"]], "Subtitle",
  TextAlignment->Center,
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["The Aim of the Program Sysn", "Section",
    FontFamily->"Times New Roman"],
  StyleBox["\n", "Section"],
  StyleBox[
  "\[FilledDiamond] The program evalutes and represents the numerical \
solutions of a system of ordinary differential equations corresponding to a \
fixed set of initial data and shows their plots as well as the phase portrait \
of an arbitrary pair of unknowns.\n\nFor more information about the program \
Sysn type in ",
    FontSize->12,
    FontWeight->"Plain"]
}], "Section",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(UsageSysn[]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["How to Use the Program Sysn", "Section",
    FontFamily->"Times New Roman"],
  StyleBox["\n", "Section"],
  StyleBox[
  "\[FilledDiamond]  The command raw is \n Sysn[sys, unk, var, data, T1, \
index, steps]\n\nFor more information about the program Sysn type in",
    FontSize->12,
    FontWeight->"Plain"]
}], "Section",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(HelpSysn[\ ]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Phase2D",
  FontWeight->"Bold"]], "Subtitle",
  TextAlignment->Center,
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["The Aim of the Program Phase2D", "Section",
    FontFamily->"Times New Roman"],
  StyleBox["\n", "Section"],
  StyleBox["\[FilledDiamond] ",
    FontSize->12,
    FontWeight->"Plain"],
  StyleBox[
  "The program draws the phase portrait of a planar autonomous differential \
system in Cartesian coordinates.", "Text",
    FontSize->12,
    FontWeight->"Plain"],
  StyleBox["\n\nFor more information about the program Phase2D type in ",
    FontSize->12,
    FontWeight->"Plain"]
}], "Section",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(UsagePhase2D[]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["How to Use the Program Phase2D", "Section",
    FontFamily->"Times New Roman"],
  StyleBox["\n", "Section"],
  StyleBox[
  " \[FilledDiamond]  The command raw is\n Phase2D[sys, unk, unk0, h, n, {T1, \
T2}, steps, unkvar, graph]\n\nFor more information about the program Phase2D \
type in ",
    FontSize->12,
    FontWeight->"Plain"]
}], "Section",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(HelpPhase2D[\ ]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["PolarPhase",
  FontWeight->"Bold"]], "Subtitle",
  TextAlignment->Center,
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["The Aim of the Program PolarPhase", "Section",
    FontFamily->"Times New Roman"],
  StyleBox["\n", "Section"],
  StyleBox[
  "\[FilledDiamond] The program draws the phase portrait of a planar \
autonomous differential system in polar coordinates.\n\nFor more information \
about the program PolarPhase type in",
    FontSize->12,
    FontWeight->"Plain"]
}], "Section",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(UsagePolarPhase[]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["How to Use the Program PolarPhase", "Section",
    FontFamily->"Times New Roman"],
  StyleBox["\n", "Section"],
  StyleBox[
  " \[FilledDiamond]  The command raw is\n PolarPhase[sys, unk, unk0, h, n, \
{T1, T2}, steps, unkvar, graph]\n\nFor more information about the program \
PolarPhase type ",
    FontSize->12,
    FontWeight->"Plain"]
}], "Section",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(HelpPolarPhase[\ ]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Phase3D",
  FontWeight->"Bold"]], "Subtitle",
  TextAlignment->Center,
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["The Aim of the Program Phase3D", "Section",
    FontFamily->"Times New Roman"],
  StyleBox["\n", "Section"],
  StyleBox[
  "\[FilledDiamond] The program draws the phase portrait of a 3D autonomous \
differential system in Cartesian coordinates.\n\nFor more information about \
the program Phase3D type in ",
    FontSize->12,
    FontWeight->"Plain"]
}], "Section",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(UsagePhase3D[]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["How to Use the Program Phase3D", "Section",
    FontFamily->"Times New Roman"],
  StyleBox["\n", "Section"],
  StyleBox[
  " \[FilledDiamond]  The command raw is\n Phase3D[sys, unk, unk0, h, n, {T1, \
T2}, {\[Tau]1, \[Tau]2} steps, unkvar]\n\nFor further information about the \
program Phase3D type in",
    FontSize->12,
    FontWeight->"Plain"]
}], "Section",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(HelpPhase3D[\ ]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["LinSys",
  FontWeight->"Bold"]], "Subtitle",
  TextAlignment->Center,
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["The Aim of the Program ", "Section",
    FontFamily->"Times New Roman"],
  "LinSys",
  StyleBox["\n", "Section"],
  StyleBox[
  "\[FilledDiamond] The program supplies the general analytical solution of a \
linear differential system with constant coefficients.\n\nFor more \
information about the program LinSys type in ",
    FontSize->12,
    FontWeight->"Plain"]
}], "Section",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(UsageLinSys[]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["How to Use the Program ", "Section",
    FontFamily->"Times New Roman"],
  "LinSys",
  StyleBox["\n", "Section"],
  StyleBox[
  "\[FilledDiamond]  The command raw is \n LinSys[A, b, unk, unk0]\n\nFor \
more information about the program LinSys type in",
    FontSize->12,
    FontWeight->"Plain"]
}], "Section",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(HelpLinSys[\ ]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["SerSol",
  FontWeight->"Bold"]], "Subtitle",
  TextAlignment->Center,
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["The Aim of the Program ", "Section",
    FontFamily->"Times New Roman"],
  "SerSol",
  StyleBox["\n", "Section"],
  StyleBox[
  "\[FilledDiamond] The program gives the approximate solution of a Cauchy \
problem by a power expansion up to a fixed order.\n\nFor more information \
about the program SerSol type in ",
    FontSize->12,
    FontWeight->"Plain"]
}], "Section",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(UsageSerSol[]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["How to Use the Program ", "Section",
    FontFamily->"Times New Roman"],
  "SerSol",
  StyleBox["\n", "Section"],
  StyleBox[
  "\[FilledDiamond]  The command raw is \n SerSol[sys, unk, var, unk0, r, T1, \
T2, steps]\n\nFor more information about the program SerSol type in",
    FontSize->12,
    FontWeight->"Plain"]
}], "Section",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(HelpSerSol[\ ]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Frobenius",
  FontWeight->"Bold"]], "Subtitle",
  TextAlignment->Center,
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["The Aim of the Program ", "Section",
    FontFamily->"Times New Roman"],
  "Frobenius",
  StyleBox["\n", "Section"],
  StyleBox[
  "\[FilledDiamond] The program supplies the solution of a linear second \
order differential equation at the regular singular origin as Frobenius \
series  up to a fixed order.\n\nFor more information about the program \
Frobenius type in ",
    FontSize->12,
    FontWeight->"Plain"]
}], "Section",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(UsageFrobenius[]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["How to Use the Program ", "Section",
    FontFamily->"Times New Roman"],
  "Frobenius",
  StyleBox["\n", "Section"],
  StyleBox[
  "\[FilledDiamond]  The command raw is \n Frobenius[eq, unk, var, order, \
data1, data2, steps]\n\nFor more information about the program Frobenius type \
in",
    FontSize->12,
    FontWeight->"Plain"]
}], "Section",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(HelpFrobenius[\ ]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Poincare",
  FontWeight->"Bold"]], "Subtitle",
  TextAlignment->Center,
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["The Aim of the Program ", "Section",
    FontFamily->"Times New Roman"],
  "Poincare",
  StyleBox["\n", "Section"],
  StyleBox[
  "\[FilledDiamond] The program gives the solution of a differential system \
containing a small parameter \[Mu] as a power series of \[Mu].\n\nFor more \
information about the program Poincare type in ",
    FontSize->12,
    FontWeight->"Plain"]
}], "Section",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(UsagePoincare[]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["How to Use the Program ", "Section",
    FontFamily->"Times New Roman"],
  "Poincare",
  StyleBox["\n", "Section"],
  StyleBox[
  "\[FilledDiamond]  The command raw is \n Poincare[sys, unk, var, unk0, par, \
m, r, T1, T2, steps, pref]\n\nFor more information about the program Poincare \
type in",
    FontSize->12,
    FontWeight->"Plain"]
}], "Section",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(HelpPoincare[\ ]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Liapunov",
  FontWeight->"Bold"]], "Subtitle",
  TextAlignment->Center,
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["The Aim of the Program ", "Section",
    FontFamily->"Times New Roman"],
  "Liapunov",
  StyleBox["\n", "Section"],
  StyleBox[
  "\[FilledDiamond] The program determines a polynomial function V for a \
given system of a planar differential system and evaluates the regions around \
the origin in which V is positive and its derivative is negative.\n\nFor more \
information about the program Liapunov type in ",
    FontSize->12,
    FontWeight->"Plain"]
}], "Section",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(UsageLiapunov[]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["How to Use the Program ", "Section",
    FontFamily->"Times New Roman"],
  "Liapunov",
  StyleBox["\n", "Section"],
  StyleBox[
  "\[FilledDiamond]  The command raw is \n Liapunov[sys, unk, W, m, viewx, \
viewy, valV, valV1, options]\n\nFor more information about the program \
Liapunov type in",
    FontSize->12,
    FontWeight->"Plain"]
}], "Section",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(HelpLiapunov[\ ]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["LStability",
  FontWeight->"Bold"]], "Subtitle",
  TextAlignment->Center,
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["The Aim of the Program ", "Section",
    FontFamily->"Times New Roman"],
  "LStability",
  StyleBox["\n", "Section"],
  StyleBox[
  "\[FilledDiamond] The program verifies the equilibrium stability by the \
eigenvalues of the Jacobian matrix of the right-hand side of the system at \
the equilibrium points.\n\nFor more information about the program LStability \
type in ",
    FontSize->12,
    FontWeight->"Plain"]
}], "Section",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(UsageLStability[]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["How to Use the Program ", "Section",
    FontFamily->"Times New Roman"],
  "LStability",
  StyleBox["\n", "Section"],
  StyleBox[
  "\[FilledDiamond]  The command raw is \n LStability[sys, unk, xe]\n\nFor \
more information about the program LStability type in",
    FontSize->12,
    FontWeight->"Plain"]
}], "Section",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(HelpLStability[\ ]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["CriticalEqN",
  FontWeight->"Bold"]], "Subtitle",
  TextAlignment->Center,
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["The Aim of the Program ", "Section",
    FontFamily->"Times New Roman"],
  "CriticalEqN",
  StyleBox["\n", "Section"],
  StyleBox[
  "\[FilledDiamond] The program evaluates the origin stability of a planar \
system with numerical coefficients in the critical case corresponding to \
eigenvalues \[PlusMinus]i\[Beta] , \[Beta]>0 of the Jacobian matrix at the \
origin by Poincar\[EAcute]s method. The program is applicable also when the \
system is not in the canonical form.\n\nFor more information about the \
program CriticaleqN type in ",
    FontSize->12,
    FontWeight->"Plain"]
}], "Section",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(UsageCriticalEqN[]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["How to Use the Program ", "Section",
    FontFamily->"Times New Roman"],
  "CriticalEqN",
  StyleBox["\n", "Section"],
  StyleBox[
  "\[FilledDiamond]  The command raw is \n CriticalEqN[sys, unk]\n\nFor more \
information about the program CriticalEqN type in",
    FontSize->12,
    FontWeight->"Plain"]
}], "Section",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(HelpCriticalEqN[\ ]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["CriticalEqS",
  FontWeight->"Bold"]], "Subtitle",
  TextAlignment->Center,
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["The Aim of the Program CriticalEqS", "Section",
    FontFamily->"Times New Roman"],
  StyleBox["\n", "Section"],
  StyleBox[
  "\[FilledDiamond] The program evaluates the origin stability of a planar \
system with symbolic coefficients in the critical case corresponding to \
eigenvalues \[PlusMinus]i\[Beta] , \[Beta]>0 of the Jacobian matrix at the \
origin by Poincar\[EAcute]s method. The system has to be in the canonical \
form.\n\nFor more information about the program CriticalEqS type in ",
    FontSize->12,
    FontWeight->"Plain"]
}], "Section",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(UsageCriticalEqS[]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["How to Use the Program CriticalEqS", "Section",
    FontFamily->"Times New Roman"],
  StyleBox["\n", "Section"],
  StyleBox[
  "\[FilledDiamond]  The command raw is \n CriticalEqS[sys, unk, order]\n\n\
For more information about the program CriticalEqS type in",
    FontSize->12,
    FontWeight->"Plain"]
}], "Section",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(HelpCriticalEqS[\ ]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["CManifold",
  FontWeight->"Bold"]], "Subtitle",
  TextAlignment->Center,
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["The Aim of the Program CManifold", "Section",
    FontFamily->"Times New Roman"],
  StyleBox["\n", "Section"],
  StyleBox[
  "\[FilledDiamond] The program studies the stability properties of an \
equilibrium position by the center manifold method.\n\nFor more information \
about the program CManifold type in ",
    FontSize->12,
    FontWeight->"Plain"]
}], "Section",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(UsageCManifold[]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["How to Use the Program CManifold", "Section",
    FontFamily->"Times New Roman"],
  StyleBox["\n", "Section"],
  StyleBox[
  "\[FilledDiamond]  The command raw is \n CManifold[sys, unk, r]\n\nFor more \
information about the program CManifold type in",
    FontSize->12,
    FontWeight->"Plain"]
}], "Section",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(HelpCManifold[\ ]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Bif1",
  FontWeight->"Bold"]], "Subtitle",
  TextAlignment->Center,
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["The Aim of the Program Bif1", "Section",
    FontFamily->"Times New Roman"],
  StyleBox["\n", "Section"],
  StyleBox[
  "\[FilledDiamond] The program analyzes the origin equilibrium properties of \
a first-order differential equation on varying a parameter.\n\nFor more \
information about the program Bif1 type in ",
    FontSize->12,
    FontWeight->"Plain"]
}], "Section",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(UsageBif1[]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["How to Use the Program Bif1", "Section",
    FontFamily->"Times New Roman"],
  StyleBox["\n", "Section"],
  StyleBox[
  "\[FilledDiamond]  The command raw is \n Bif1[eq, unk, par]\n\nFor more \
information about the program Bif1 type in",
    FontSize->12,
    FontWeight->"Plain"]
}], "Section",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(HelpBif1[\ ]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Bif1G",
  FontWeight->"Bold"]], "Subtitle",
  TextAlignment->Center,
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["The Aim of the Program Bif1G", "Section",
    FontFamily->"Times New Roman"],
  " ",
  StyleBox["\n", "Section"],
  StyleBox[
  "\[FilledDiamond] The program supplies a graphical analysis of the \
equilibrium positions and their properties in a differential equation \
containing one parameter.\n\nFor more information about the program BifG type \
in ",
    FontSize->12,
    FontWeight->"Plain"]
}], "Section",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(UsageBif1G[]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["How to Use the Program ", "Section",
    FontFamily->"Times New Roman"],
  "Bif1G",
  StyleBox["\n", "Section"],
  StyleBox[
  "\[FilledDiamond]  The command raw is \n Bif1G[eq, unk, par, a, b, points]\n\
\nFor more information about the program Bif1G type in",
    FontSize->12,
    FontWeight->"Plain"]
}], "Section",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(HelpBif1G[\ ]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Bif2",
  FontWeight->"Bold"]], "Subtitle",
  TextAlignment->Center,
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["The Aim of the Program Bif2", "Section",
    FontFamily->"Times New Roman"],
  StyleBox["\n", "Section"],
  StyleBox[
  "\[FilledDiamond] The program analyzes the origin equilibrium properties of \
a first-order differential equation on varying two parameters.\n\nFor more \
information about the program Bif2 type in ",
    FontSize->12,
    FontWeight->"Plain"]
}], "Section",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(UsageBif2[]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["How to Use the Program Bif2", "Section",
    FontFamily->"Times New Roman"],
  StyleBox["\n", "Section"],
  StyleBox[
  "\[FilledDiamond]  The command raw is \n Bif2[eq, unk, par]\n\nFor more \
information about the program Bif2 type in",
    FontSize->12,
    FontWeight->"Plain"]
}], "Section",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(HelpBif2[\ ]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Bif2G",
  FontWeight->"Bold"]], "Subtitle",
  TextAlignment->Center,
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["The Aim of the Program Bif2G ", "Section",
    FontFamily->"Times New Roman"],
  StyleBox["\n", "Section"],
  StyleBox[
  "\[FilledDiamond] The program supplies a graphical analysis of the \
equilibrium positions and their properties in a differential equation \
containing two parameters. \n\nFor more information about the program Bif2G \
type in ",
    FontSize->12,
    FontWeight->"Plain"]
}], "Section",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(UsageBif2G[]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["How to Use the Program Bif2G", "Section",
    FontFamily->"Times New Roman"],
  StyleBox["\n", "Section"],
  StyleBox[
  "\[FilledDiamond]  The command raw is \n Bif2G[eq, unk, par, a, b, points, \
valpar]\n\nFor more information about the program Bif2G type in",
    FontSize->12,
    FontWeight->"Plain"]
}], "Section",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(HelpBif2G[\ ]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["HopfBif",
  FontWeight->"Bold"]], "Subtitle",
  TextAlignment->Center,
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["The Aim of the Program HopfBif", "Section",
    FontFamily->"Times New Roman"],
  StyleBox["\n", "Section"],
  StyleBox[
  "\[FilledDiamond] The program analyzes the Hopf's bifurcation of the origin \
in a planar system with numeric coefficients.\n\nFor more information about \
the program HopfBif type in ",
    FontSize->12,
    FontWeight->"Plain"]
}], "Section",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(UsageHopfBif[]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["How to Use the Program HopfBif", "Section",
    FontFamily->"Times New Roman"],
  "  ",
  StyleBox["\n", "Section"],
  StyleBox[
  "\[FilledDiamond]  The command raw is \n HopfBif[sys, unk, par, valpar, {h, \
n}, {k, m}, {T1, T2}, steps ]\n\nFor more information about the program \
HopfBif type in",
    FontSize->12,
    FontWeight->"Plain"]
}], "Section",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(HelpHopfBif[\ ]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["LindPoinc",
  FontWeight->"Bold"]], "Subtitle",
  TextAlignment->Center,
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["The Aim of the Program LindPoinc", "Section",
    FontFamily->"Times New Roman"],
  StyleBox["\n", "Section"],
  StyleBox[
  "\[FilledDiamond] The program finds the periodic orbits of a planar \
autonomous system containing a parameter.\n\nFor more information about the \
program LindPoinc type in ",
    FontSize->12,
    FontWeight->"Plain"]
}], "Section",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(UsageLindPoinc[]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["How to Use the Program ", "Section",
    FontFamily->"Times New Roman"],
  "LindPoinc",
  StyleBox["\n", "Section"],
  StyleBox[
  "\[FilledDiamond]  The command raw is \n LindPoinc[sys, unk, var, par, m]\n\
\nFor more information about the program LindPoinc type in",
    FontSize->12,
    FontWeight->"Plain"]
}], "Section",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(HelpLindPoinc[\ ]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["GLindPoinc",
  FontWeight->"Bold"]], "Subtitle",
  TextAlignment->Center,
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["The Aim of the Program G", "Section",
    FontFamily->"Times New Roman"],
  "LindPoinc",
  StyleBox["\n", "Section"],
  StyleBox[
  "\[FilledDiamond] The program compares the approximate orbits derived by \
LindPoinc with the numerical ones. \n\nFor more information about the program \
GLindPoinc type in ",
    FontSize->12,
    FontWeight->"Plain"]
}], "Section",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(UsageGLindPoinc[]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["How to Use the Program G", "Section",
    FontFamily->"Times New Roman"],
  "LindPoinc",
  StyleBox["\n", "Section"],
  StyleBox[
  "\[FilledDiamond]  The command raw is \n GLindPoinc[sys, unk, var, par, r, \
x0, {T1,T2}]\n\nFor more information about the program GLindPoinc type in",
    FontSize->12,
    FontWeight->"Plain"]
}], "Section",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(HelpGLindPoinc[\ ]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["NBoundary",
  FontWeight->"Bold"]], "Subtitle",
  TextAlignment->Center,
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["The Aim of the Program ", "Section",
    FontFamily->"Times New Roman"],
  "NBoundary",
  StyleBox["\n", "Section"],
  StyleBox[
  "\[FilledDiamond] The program solves by shooting method a mixed boundary \
value problem for any second order differential equation.\n\nFor more \
information about the program NBoundary type in ",
    FontSize->12,
    FontWeight->"Plain"]
}], "Section",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(UsageNBoundary[]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["How to Use the Program ", "Section",
    FontFamily->"Times New Roman"],
  "NBoundary",
  StyleBox["\n", "Section"],
  StyleBox[
  "\[FilledDiamond]  The command raw is \n NBoundary[eq, unk, var, {a, b}, \
data, {dymin, dymax}, n, steps, ansol]\n\nFor more information about the \
program NBoundary type in",
    FontSize->12,
    FontWeight->"Plain"]
}], "Section",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(HelpNBoundary[\ ]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["NBoundary1",
  FontWeight->"Bold"]], "Subtitle",
  TextAlignment->Center,
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["The Aim of the Program ", "Section",
    FontFamily->"Times New Roman"],
  "NBoundary1",
  StyleBox["\n", "Section"],
  StyleBox[
  "\[FilledDiamond] The program solves by the finite difference method a \
mixed boundary value problem for any linear second order differential \
equation.\n\nFor more information about the program NBoundary1 type in ",
    FontSize->12,
    FontWeight->"Plain"]
}], "Section",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(UsageNBoundary1[]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["How to Use the Program ", "Section",
    FontFamily->"Times New Roman"],
  "NBoundary1",
  StyleBox["\n", "Section"],
  StyleBox[
  "\[FilledDiamond]  The command raw is \n NBoundary1[eq, unk, var, {a, b}, \
data, n, ansol]\n\nFor more information about the program NBoundary1 type in",
    
    FontSize->12,
    FontWeight->"Plain"]
}], "Section",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(HelpNBoundary1[\ ]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["NBoundary2",
  FontWeight->"Bold"]], "Subtitle",
  TextAlignment->Center,
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["The Aim of the Program ", "Section",
    FontFamily->"Times New Roman"],
  "NBoundary2",
  StyleBox["\n", "Section"],
  StyleBox[
  "\[FilledDiamond] The program solves by the finite difference method a \
mixed boundary value problem for any nonlinear second order differential \
equation.\n\nFor more information about the program Nboundary2  type in ",
    FontSize->12,
    FontWeight->"Plain"]
}], "Section",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(UsageNBoundary2[]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["How to Use the Program ", "Section",
    FontFamily->"Times New Roman"],
  "NBoundary2",
  StyleBox["\n", "Section"],
  StyleBox[
  "\[FilledDiamond]  The command raw is \n NBoundary[eq, unk, var, {a, b}, \
data, n, s, steps, ansol]\n\nFor more information about the program \
NBoundary2 type in",
    FontSize->12,
    FontWeight->"Plain"]
}], "Section",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(HelpNBoundary2[\ ]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Poinsot",
  FontWeight->"Bold"]], "Subtitle",
  TextAlignment->Center,
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["The Aim of the Program Poinsot", "Section",
    FontFamily->"Times New Roman"],
  StyleBox["\n", "Section"],
  StyleBox[
  "\[FilledDiamond] The program gives the free motions of a solid with a \
fixed point.\n\nFor more information about the program Poinsot type in ",
    FontSize->12,
    FontWeight->"Plain"]
}], "Section",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(UsagePoinsot[]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["How to Use the Program Poinsot", "Section",
    FontFamily->"Times New Roman"],
  StyleBox["\n", "Section"],
  StyleBox[
  "\[FilledDiamond]  The command raw is \n Poinsot[A, B, C0, r0, \[Theta]0, \
b, \[Alpha], steps]\n\nFor more information about the program Poinsot type \
in",
    FontSize->12,
    FontWeight->"Plain"]
}], "Section",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(HelpPoinsot[\ ]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Solid",
  FontWeight->"Bold"]], "Subtitle",
  TextAlignment->Center,
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["The Aim of the Program Solid", "Section",
    FontFamily->"Times New Roman"],
  StyleBox["\n", "Section"],
  StyleBox[
  "\[FilledDiamond] The program gives the motions of a solid with a fixed \
point.\n\nFor more information about the program Solid type in ",
    FontSize->12,
    FontWeight->"Plain"]
}], "Section",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(UsageSolid[]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["How to Use the Program Solid", "Section",
    FontFamily->"Times New Roman"],
  StyleBox["\n", "Section"],
  StyleBox[
  "\[FilledDiamond]  The command raw is \n Solid[A, B, C0, {\[Psi], \
\[CurlyPhi], \[Theta], t}, z, F, p0, q0, r0, \[Psi]0, \[CurlyPhi]0, \
\[Theta]0, T, steps]\n\nFor more information about the program Solid type in",
    
    FontSize->12,
    FontWeight->"Plain"]
}], "Section",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(HelpSolid[\ ]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["NormalForm",
  FontWeight->"Bold"]], "Subtitle",
  TextAlignment->Center,
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["The Aim of the Program ", "Section",
    FontFamily->"Times New Roman"],
  "NormalForm",
  StyleBox["\n", "Section"],
  StyleBox[
  "\[FilledDiamond] The program reduces a planar system to the normal form.\n\
\nFor more information about the program NormalForm type in ",
    FontSize->12,
    FontWeight->"Plain"]
}], "Section",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(UsageNormalForm[]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["How to Use the Program ", "Section",
    FontFamily->"Times New Roman"],
  "NormalForm",
  StyleBox["\n", "Section"],
  StyleBox[
  "\[FilledDiamond]  The command raw is \n NormalForm[sys, unk]\n\nFor more \
information about the program NormalForm type in",
    FontSize->12,
    FontWeight->"Plain"]
}], "Section",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(HelpNormalForm[\ ]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Zeros",
  FontWeight->"Bold"]], "Subtitle",
  TextAlignment->Center,
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["The Aim of the Program ", "Section",
    FontFamily->"Times New Roman"],
  "Zeros",
  StyleBox["\n", "Section"],
  StyleBox[
  "\[FilledDiamond] The program searches for the zeros of a system of two or \
three finite equations.\n\nFor more information about the program Zeros type \
in ",
    FontSize->12,
    FontWeight->"Plain"]
}], "Section",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(UsageZeros[]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["How to Use the Program ", "Section",
    FontFamily->"Times New Roman"],
  "Zeros",
  StyleBox["\n", "Section"],
  StyleBox[
  "\[FilledDiamond]  The command raw is \n Zeros[sys, unk, int, n, tol]\n\n\
For more information about the program Zeros type in",
    FontSize->12,
    FontWeight->"Plain"]
}], "Section",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(HelpZeros[\ ]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Taylor",
  FontWeight->"Bold"]], "Subtitle",
  TextAlignment->Center,
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["The Aim of the Program Taylor", "Section",
    FontFamily->"Times New Roman"],
  StyleBox["\n", "Section"],
  StyleBox[
  "\[FilledDiamond] The program gives the Taylor expansion of a function \
depending on one or more variables.\n\nFor more information about the program \
Taylor type in ",
    FontSize->12,
    FontWeight->"Plain"]
}], "Section",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(UsageTaylor[]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["How to Use the Program Taylor", "Section",
    FontFamily->"Times New Roman"],
  StyleBox["\n", "Section"],
  StyleBox[
  "\[FilledDiamond]  The command raw is \n Taylor[f, var, var0, r]\n\nFor \
more information about the program Taylor type in",
    FontSize->12,
    FontWeight->"Plain"]
}], "Section",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(HelpTaylor[\ ]\)], "Input",
  FontFamily->"Times New Roman",
  FontSize->12]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 800}, {0, 544}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{677, 385},
WindowMargins->{{12, Automatic}, {Automatic, 6}},
PrintingCopies->1,
PrintingPageRange->{1, 1},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"NeXTAutomaticEncoding",
Magnification->1.25
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 180, 6, 129, "Title"],

Cell[CellGroupData[{
Cell[1936, 61, 62, 1, 65, "Section"],
Cell[2001, 64, 536, 16, 60, "Text"],
Cell[2540, 82, 108, 3, 34, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2685, 90, 124, 3, 68, "Subtitle"],

Cell[CellGroupData[{
Cell[2834, 97, 560, 13, 160, "Section"],
Cell[3397, 112, 93, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3527, 120, 382, 10, 141, "Section"],
Cell[3912, 132, 94, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[4055, 141, 127, 3, 68, "Subtitle"],

Cell[CellGroupData[{
Cell[4207, 148, 554, 16, 145, "Section"],
Cell[4764, 166, 96, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4897, 174, 409, 11, 141, "Section"],
Cell[5309, 187, 97, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[5455, 196, 130, 3, 68, "Subtitle"],

Cell[CellGroupData[{
Cell[5610, 203, 431, 11, 141, "Section"],
Cell[6044, 216, 99, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6180, 224, 415, 11, 141, "Section"],
Cell[6598, 237, 100, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[6747, 246, 127, 3, 68, "Subtitle"],

Cell[CellGroupData[{
Cell[6899, 253, 426, 11, 141, "Section"],
Cell[7328, 266, 96, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7461, 274, 423, 11, 141, "Section"],
Cell[7887, 287, 97, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[8033, 296, 126, 3, 68, "Subtitle"],

Cell[CellGroupData[{
Cell[8184, 303, 441, 12, 141, "Section"],
Cell[8628, 317, 95, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8760, 325, 372, 11, 141, "Section"],
Cell[9135, 338, 96, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[9280, 347, 126, 3, 68, "Subtitle"],

Cell[CellGroupData[{
Cell[9431, 354, 433, 12, 141, "Section"],
Cell[9867, 368, 95, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9999, 376, 394, 11, 141, "Section"],
Cell[10396, 389, 96, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[10541, 398, 129, 3, 68, "Subtitle"],

Cell[CellGroupData[{
Cell[10695, 405, 490, 13, 141, "Section"],
Cell[11188, 420, 98, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11323, 428, 408, 12, 141, "Section"],
Cell[11734, 442, 99, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[11882, 451, 128, 3, 68, "Subtitle"],

Cell[CellGroupData[{
Cell[12035, 458, 451, 12, 141, "Section"],
Cell[12489, 472, 97, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12623, 480, 416, 12, 141, "Section"],
Cell[13042, 494, 98, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[13189, 503, 128, 3, 68, "Subtitle"],

Cell[CellGroupData[{
Cell[13342, 510, 531, 13, 141, "Section"],
Cell[13876, 525, 97, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14010, 533, 415, 12, 141, "Section"],
Cell[14428, 547, 98, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[14575, 556, 130, 3, 68, "Subtitle"],

Cell[CellGroupData[{
Cell[14730, 563, 491, 13, 141, "Section"],
Cell[15224, 578, 99, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15360, 586, 381, 11, 141, "Section"],
Cell[15744, 599, 100, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[15893, 608, 131, 3, 68, "Subtitle"],

Cell[CellGroupData[{
Cell[16049, 615, 660, 15, 160, "Section"],
Cell[16712, 632, 100, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16849, 640, 380, 11, 141, "Section"],
Cell[17232, 653, 101, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[17382, 662, 131, 3, 68, "Subtitle"],

Cell[CellGroupData[{
Cell[17538, 669, 618, 13, 160, "Section"],
Cell[18159, 684, 100, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[18296, 692, 381, 10, 141, "Section"],
Cell[18680, 704, 101, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[18830, 713, 129, 3, 68, "Subtitle"],

Cell[CellGroupData[{
Cell[18984, 720, 431, 11, 122, "Section"],
Cell[19418, 733, 98, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[19553, 741, 371, 10, 141, "Section"],
Cell[19927, 753, 99, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[20075, 762, 124, 3, 68, "Subtitle"],

Cell[CellGroupData[{
Cell[20224, 769, 436, 11, 141, "Section"],
Cell[20663, 782, 93, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20793, 790, 357, 10, 141, "Section"],
Cell[21153, 802, 94, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[21296, 811, 125, 3, 68, "Subtitle"],

Cell[CellGroupData[{
Cell[21446, 818, 473, 13, 141, "Section"],
Cell[21922, 833, 94, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[22053, 841, 380, 11, 141, "Section"],
Cell[22436, 854, 95, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[22580, 863, 124, 3, 68, "Subtitle"],

Cell[CellGroupData[{
Cell[22729, 870, 439, 11, 141, "Section"],
Cell[23171, 883, 93, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[23301, 891, 357, 10, 141, "Section"],
Cell[23661, 903, 94, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[23804, 912, 125, 3, 68, "Subtitle"],

Cell[CellGroupData[{
Cell[23954, 919, 470, 12, 141, "Section"],
Cell[24427, 933, 94, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[24558, 941, 382, 10, 141, "Section"],
Cell[24943, 953, 95, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[25087, 962, 127, 3, 68, "Subtitle"],

Cell[CellGroupData[{
Cell[25239, 969, 428, 11, 141, "Section"],
Cell[25670, 982, 96, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[25803, 990, 419, 12, 141, "Section"],
Cell[26225, 1004, 97, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[26371, 1013, 129, 3, 68, "Subtitle"],

Cell[CellGroupData[{
Cell[26525, 1020, 420, 11, 122, "Section"],
Cell[26948, 1033, 98, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[27083, 1041, 387, 11, 141, "Section"],
Cell[27473, 1054, 99, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[27621, 1063, 130, 3, 68, "Subtitle"],

Cell[CellGroupData[{
Cell[27776, 1070, 427, 12, 122, "Section"],
Cell[28206, 1084, 99, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[28342, 1092, 403, 11, 141, "Section"],
Cell[28748, 1105, 100, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[28897, 1114, 129, 3, 68, "Subtitle"],

Cell[CellGroupData[{
Cell[29051, 1121, 447, 12, 141, "Section"],
Cell[29501, 1135, 98, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[29636, 1143, 427, 12, 141, "Section"],
Cell[30066, 1157, 99, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[30214, 1166, 130, 3, 68, "Subtitle"],

Cell[CellGroupData[{
Cell[30369, 1173, 469, 12, 141, "Section"],
Cell[30841, 1187, 99, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[30977, 1195, 410, 12, 141, "Section"],
Cell[31390, 1209, 100, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[31539, 1218, 130, 3, 68, "Subtitle"],

Cell[CellGroupData[{
Cell[31694, 1225, 473, 12, 141, "Section"],
Cell[32170, 1239, 99, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[32306, 1247, 416, 12, 141, "Section"],
Cell[32725, 1261, 100, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[32874, 1270, 127, 3, 68, "Subtitle"],

Cell[CellGroupData[{
Cell[33026, 1277, 388, 10, 122, "Section"],
Cell[33417, 1289, 96, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[33550, 1297, 399, 11, 141, "Section"],
Cell[33952, 1310, 97, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[34098, 1319, 125, 3, 68, "Subtitle"],

Cell[CellGroupData[{
Cell[34248, 1326, 379, 10, 122, "Section"],
Cell[34630, 1338, 94, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[34761, 1346, 461, 12, 141, "Section"],
Cell[35225, 1360, 95, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[35369, 1369, 130, 3, 68, "Subtitle"],

Cell[CellGroupData[{
Cell[35524, 1376, 390, 11, 122, "Section"],
Cell[35917, 1389, 99, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[36053, 1397, 377, 11, 141, "Section"],
Cell[36433, 1410, 100, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[36582, 1419, 125, 3, 68, "Subtitle"],

Cell[CellGroupData[{
Cell[36732, 1426, 407, 12, 122, "Section"],
Cell[37142, 1440, 94, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[37273, 1448, 375, 11, 141, "Section"],
Cell[37651, 1461, 95, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[37795, 1470, 126, 3, 68, "Subtitle"],

Cell[CellGroupData[{
Cell[37946, 1477, 411, 11, 122, "Section"],
Cell[38360, 1490, 95, 3, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[38492, 1498, 366, 10, 141, "Section"],
Cell[38861, 1510, 96, 3, 35, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

