/*
 * Decompiled with CFR 0.152.
 */
public class Life {
    private int m_nRows = 0;
    private int m_nColumns = 0;
    private double m_dStep = 1.0;
    private double[][] U;
    private double[][] X;
    private double[][] Y;
    private static int[] xoffs;
    private static int[] yoffs;

    static {
        int[] nArray = new int[9];
        nArray[0] = -1;
        nArray[2] = 1;
        nArray[3] = -1;
        nArray[5] = 1;
        nArray[6] = -1;
        nArray[8] = 1;
        xoffs = nArray;
        int[] nArray2 = new int[9];
        nArray2[0] = -1;
        nArray2[1] = -1;
        nArray2[2] = -1;
        nArray2[6] = 1;
        nArray2[7] = 1;
        nArray2[8] = 1;
        yoffs = nArray2;
    }

    public Life(int n, int n2) {
        this.m_nRows = n;
        this.m_nColumns = n2;
        this.U = new double[this.m_nRows + 2][this.m_nColumns + 2];
        this.X = new double[this.m_nRows + 2][this.m_nColumns + 2];
        this.Y = new double[this.m_nRows + 2][this.m_nColumns + 2];
    }

    public void compute() {
        int n = 0;
        int n2 = 0;
        double d = 0.0;
        n = 1;
        while (n <= this.m_nRows) {
            n2 = 1;
            while (n2 <= this.m_nColumns) {
                d = -this.X[n][n2] + this.foldA(n, n2);
                double[] dArray = this.X[n];
                int n3 = n2++;
                dArray[n3] = dArray[n3] + this.m_dStep * d;
            }
            ++n;
        }
        n = 1;
        while (n <= this.m_nRows) {
            n2 = 1;
            while (n2 <= this.m_nColumns) {
                this.Y[n][n2] = this.inRange(this.X[n][n2]);
                ++n2;
            }
            ++n;
        }
    }

    private double foldA(int n, int n2) {
        double d = 0.0;
        int n3 = 0;
        while (n3 < 9) {
            d += n3 == 4 ? (this.Y[n][n2] < -0.9 ? -0.5 : (this.Y[n][n2] < -0.27 ? -1.0 : (this.Y[n][n2] <= -0.13 ? 1.0 : (this.Y[n][n2] <= 0.9 ? -1.0 : -0.45)))) : (this.Y[n + xoffs[n3]][n2 + yoffs[n3]] > 0.9 ? 0.1 : 0.0);
            ++n3;
        }
        return d;
    }

    public double getOutput(int n, int n2) {
        return this.Y[1 + n][1 + n2] == -1.0 ? 0.0 : this.Y[1 + n][1 + n2];
    }

    public double getState(int n, int n2) {
        return this.X[1 + n][1 + n2] == -1.0 ? 0.0 : this.X[1 + n][1 + n2];
    }

    private double inRange(double d) {
        return d < -1.0 ? -1.0 : (d > 1.0 ? 1.0 : d);
    }

    public void init() {
        int n = 0;
        while (n < this.m_nRows + 2) {
            this.Y[n][0] = 0.0;
            this.Y[n][this.m_nColumns + 1] = 0.0;
            ++n;
        }
        int n2 = 0;
        while (n2 < this.m_nColumns + 2) {
            this.X[0][n2] = 0.0;
            this.X[this.m_nRows + 1][n2] = 0.0;
            ++n2;
        }
    }

    public void setInput(int n, int n2, double d) {
        this.X[1 + n][1 + n2] = d == 0.0 ? -1.0 : d;
        this.Y[1 + n][1 + n2] = d == 0.0 ? -1.0 : d;
    }
}

