/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class LogicDemo
extends Applet
implements Runnable,
ActionListener,
ItemListener {
    private Checker IDC_OUTPUT = null;
    private Checker IDC_INPUT1 = null;
    private Checker IDC_INPUT2 = null;
    private Choice IDC_TEMPLATE = null;
    private Button IDC_STEP = null;
    private Button IDC_START = null;
    private Button IDC_STOP = null;
    private int m_nRows = 15;
    private int m_nColumns = 15;
    private CNN cnn = null;
    private Thread m_tWorker = null;
    private Object m_tLocker = new int[1];
    private int m_nStep = 0;

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.IDC_STEP && this.m_tWorker == null) {
            this.showStatus("Running single step " + this.m_nStep++);
            this.cnn.compute();
            this.display();
            this.showStatus("Ready");
        } else if (object == this.IDC_START && this.m_tWorker == null) {
            this.m_tWorker = new Thread(this);
            this.m_tWorker.setPriority(5);
            this.m_tWorker.start();
        } else if (object == this.IDC_STOP && this.m_tWorker != null) {
            this.m_tWorker.stop();
            this.m_tWorker = null;
            this.showStatus("Ready");
        }
    }

    private int denorm(double d) {
        if (d < -1.0) {
            return 255;
        }
        if (d > 1.0) {
            return 0;
        }
        return (int)((d * -1.0 + 1.0) * 255.0 / 2.0);
    }

    private void display() {
        int n = 0;
        while (n < this.m_nRows) {
            int n2 = 0;
            while (n2 < this.m_nColumns) {
                this.IDC_OUTPUT.setValue(n, n2, this.denorm(this.cnn.getOutput(n, n2)));
                ++n2;
            }
            ++n;
        }
        this.IDC_OUTPUT.repaint();
    }

    private void display0() {
        int n = 0;
        while (n < this.m_nRows) {
            int n2 = 0;
            while (n2 < this.m_nColumns) {
                this.IDC_INPUT1.setValue(n, n2, this.denorm(this.cnn.getInput(n, n2)));
                this.IDC_INPUT2.setValue(n, n2, this.denorm(this.cnn.getState(n, n2)));
                ++n2;
            }
            ++n;
        }
        this.IDC_INPUT1.repaint();
        this.IDC_INPUT2.repaint();
    }

    public void init() {
        Color[] colorArray = new Color[256];
        int n = 0;
        while (n < 256) {
            colorArray[n] = new Color(n, n, n);
            ++n;
        }
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.fill = 1;
        this.IDC_INPUT1 = new Checker(this.m_nRows, this.m_nColumns);
        this.add(this.IDC_INPUT1);
        this.IDC_INPUT1.setColorMap(colorArray);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(8, 8, 2, 2);
        gridBagLayout.setConstraints(this.IDC_INPUT1, gridBagConstraints);
        this.IDC_INPUT2 = new Checker(this.m_nRows, this.m_nColumns);
        this.add(this.IDC_INPUT2);
        this.IDC_INPUT2.setColorMap(colorArray);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(8, 2, 2, 2);
        gridBagLayout.setConstraints(this.IDC_INPUT2, gridBagConstraints);
        this.IDC_OUTPUT = new Checker(this.m_nRows, this.m_nColumns);
        this.add(this.IDC_OUTPUT);
        this.IDC_OUTPUT.setColorMap(colorArray);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(8, 2, 2, 8);
        gridBagLayout.setConstraints(this.IDC_OUTPUT, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        this.IDC_TEMPLATE = new Choice();
        this.add(this.IDC_TEMPLATE);
        this.IDC_TEMPLATE.addItemListener(this);
        this.IDC_TEMPLATE.addItem("Select one");
        this.IDC_TEMPLATE.addItem("AND");
        this.IDC_TEMPLATE.addItem("OR");
        this.IDC_TEMPLATE.addItem("NOT");
        this.IDC_TEMPLATE.addItem("DIFF");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(2, 8, 2, 8);
        gridBagLayout.setConstraints(this.IDC_TEMPLATE, gridBagConstraints);
        this.IDC_START = new Button("Start");
        this.add(this.IDC_START);
        this.IDC_START.addActionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(2, 8, 8, 2);
        gridBagLayout.setConstraints(this.IDC_START, gridBagConstraints);
        this.IDC_STOP = new Button("Stop");
        this.add(this.IDC_STOP);
        this.IDC_STOP.addActionListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(2, 2, 8, 2);
        gridBagLayout.setConstraints(this.IDC_STOP, gridBagConstraints);
        this.IDC_STEP = new Button("Step");
        this.add(this.IDC_STEP);
        this.IDC_STEP.addActionListener(this);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(2, 2, 8, 8);
        gridBagLayout.setConstraints(this.IDC_STEP, gridBagConstraints);
        this.cnn = new CNN(this.m_nRows, this.m_nColumns);
        this.display();
        this.showStatus("Ready");
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getItem();
        if (object.equals("AND")) {
            int n = 0;
            while (n < this.m_nRows) {
                int n2 = 0;
                while (n2 < this.m_nColumns) {
                    this.cnn.setInput(n, n2, this.norm(BinaryFactory.Vertical[n][n2]));
                    this.cnn.setState(n, n2, this.norm(BinaryFactory.Horizontal[n][n2]));
                    this.cnn.setOutput(n, n2, -1.0);
                    ++n2;
                }
                ++n;
            }
            double[][] dArrayArray = new double[3][];
            dArrayArray[0] = new double[3];
            double[] dArray = new double[3];
            dArray[1] = 2.0;
            dArrayArray[1] = dArray;
            dArrayArray[2] = new double[3];
            double[][] dArrayArray2 = dArrayArray;
            double[][] dArrayArray3 = new double[3][];
            dArrayArray3[0] = new double[3];
            double[] dArray2 = new double[3];
            dArray2[1] = 1.0;
            dArrayArray3[1] = dArray2;
            dArrayArray3[2] = new double[3];
            double[][] dArrayArray4 = dArrayArray3;
            this.cnn.setTemplates(dArrayArray2, dArrayArray4, -1.0);
            this.cnn.init();
            this.display0();
            this.display();
            this.m_nStep = 0;
        } else if (object.equals("OR")) {
            int n = 0;
            while (n < this.m_nRows) {
                int n3 = 0;
                while (n3 < this.m_nColumns) {
                    this.cnn.setInput(n, n3, this.norm(BinaryFactory.Vertical[n][n3]));
                    this.cnn.setState(n, n3, this.norm(BinaryFactory.Horizontal[n][n3]));
                    this.cnn.setOutput(n, n3, -1.0);
                    ++n3;
                }
                ++n;
            }
            double[][] dArrayArray = new double[3][];
            dArrayArray[0] = new double[3];
            double[] dArray = new double[3];
            dArray[1] = 2.0;
            dArrayArray[1] = dArray;
            dArrayArray[2] = new double[3];
            double[][] dArrayArray5 = dArrayArray;
            double[][] dArrayArray6 = new double[3][];
            dArrayArray6[0] = new double[3];
            double[] dArray3 = new double[3];
            dArray3[1] = 1.0;
            dArrayArray6[1] = dArray3;
            dArrayArray6[2] = new double[3];
            double[][] dArrayArray7 = dArrayArray6;
            this.cnn.setTemplates(dArrayArray5, dArrayArray7, 1.0);
            this.display0();
            this.display();
            this.cnn.init();
            this.m_nStep = 0;
        } else if (object.equals("NOT")) {
            int n = 0;
            while (n < this.m_nRows) {
                int n4 = 0;
                while (n4 < this.m_nColumns) {
                    this.cnn.setInput(n, n4, this.norm(BinaryFactory.Strange[n][n4]));
                    this.cnn.setState(n, n4, -1.0);
                    this.cnn.setOutput(n, n4, -1.0);
                    ++n4;
                }
                ++n;
            }
            double[][] dArrayArray = new double[3][];
            dArrayArray[0] = new double[3];
            double[] dArray = new double[3];
            dArray[1] = 1.0;
            dArrayArray[1] = dArray;
            dArrayArray[2] = new double[3];
            double[][] dArrayArray8 = dArrayArray;
            double[][] dArrayArray9 = new double[3][];
            dArrayArray9[0] = new double[3];
            double[] dArray4 = new double[3];
            dArray4[1] = -2.0;
            dArrayArray9[1] = dArray4;
            dArrayArray9[2] = new double[3];
            double[][] dArrayArray10 = dArrayArray9;
            this.cnn.setTemplates(dArrayArray8, dArrayArray10, 0.0);
            this.cnn.init();
            this.display0();
            this.display();
            this.m_nStep = 0;
        } else if (object.equals("DIFF")) {
            int n = 0;
            while (n < this.m_nRows) {
                int n5 = 0;
                while (n5 < this.m_nColumns) {
                    this.cnn.setInput(n, n5, this.norm(BinaryFactory.Diamond[n][n5]));
                    this.cnn.setState(n, n5, this.norm(BinaryFactory.Vertical[n][n5]));
                    this.cnn.setOutput(n, n5, -1.0);
                    ++n5;
                }
                ++n;
            }
            double[][] dArrayArray = new double[3][];
            dArrayArray[0] = new double[3];
            double[] dArray = new double[3];
            dArray[1] = 2.0;
            dArrayArray[1] = dArray;
            dArrayArray[2] = new double[3];
            double[][] dArrayArray11 = dArrayArray;
            double[][] dArrayArray12 = new double[3][];
            dArrayArray12[0] = new double[3];
            double[] dArray5 = new double[3];
            dArray5[1] = -1.0;
            dArrayArray12[1] = dArray5;
            dArrayArray12[2] = new double[3];
            double[][] dArrayArray13 = dArrayArray12;
            this.cnn.setTemplates(dArrayArray11, dArrayArray13, -1.0);
            this.cnn.init();
            this.display0();
            this.display();
            this.m_nStep = 0;
        }
    }

    private double norm(int n) {
        return -1.0 * ((double)n * 2.0 / 255.0 - 1.0);
    }

    public void run() {
        while (true) {
            Object object = this.m_tLocker;
            synchronized (object) {
                this.cnn.compute();
                this.display();
                this.showStatus("Running step " + this.m_nStep++);
            }
            try {
                Thread.sleep(200L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public void stop() {
        if (this.m_tWorker != null) {
            this.m_tWorker.stop();
            this.m_tWorker = null;
        }
    }
}

