/*
 * Decompiled with CFR 0.152.
 */
package kom.itbeankit.mm.compression.mva.model;

import java.io.Serializable;
import kom.itbeankit.mm.compression.mva.model.ByteMap;
import kom.itbeankit.mm.compression.mva.model.MacroBlock;
import kom.itbeankit.mm.compression.mva.model.MacroBlockMatrix;
import kom.itbeankit.mm.compression.mva.model.MotionVectorMatrix;
import kom.itbeankit.mm.compression.mva.model.MotionVectorMatrixBFrame;
import kom.itbeankit.mm.compression.mva.model.RGBByteMap;
import kom.itbeankit.mm.compression.mva.model.ThreeLayerByteMap;
import kom.itbeankit.util.Convert;

public class YUVByteMap
extends ThreeLayerByteMap
implements Serializable,
Cloneable {
    protected int compRate;

    public YUVByteMap(int n, int n2) {
        this(n, n2, 1);
    }

    public YUVByteMap(int n, int n2, int n3) {
        super(n / n3 * n3, n2 / n3 * n3);
        this.Map1 = new ByteMap(n / n3, n2 / n3);
        this.Map2 = new ByteMap(n / n3, n2 / n3);
        this.compRate = n3;
    }

    public YUVByteMap(int n, int n2, int n3, byte by, byte by2, byte by3) {
        this(n, n2, n3);
        this.Map0.fill(0, this.Map0.width - 1, 0, this.Map0.height - 1, by);
        this.Map1.fill(0, this.Map1.width - 1, 0, this.Map1.height - 1, by2);
        this.Map2.fill(0, this.Map2.width - 1, 0, this.Map2.height - 1, by3);
    }

    public void add(MacroBlock macroBlock, int n, int n2) {
        this.Map0.add(macroBlock.Map0, n, n2);
        this.Map1.add(macroBlock.Map1, n / 2, n2 / 2);
        this.Map2.add(macroBlock.Map2, n / 2, n2 / 2);
    }

    public void add(YUVByteMap yUVByteMap) {
        this.Map0.add(yUVByteMap.Map0);
        this.Map1.add(yUVByteMap.Map1);
        this.Map2.add(yUVByteMap.Map2);
    }

    public Object clone() {
        YUVByteMap yUVByteMap = new YUVByteMap(this.width, this.height, this.compRate);
        yUVByteMap.Map0 = (ByteMap)this.Map0.clone();
        yUVByteMap.Map1 = (ByteMap)this.Map1.clone();
        yUVByteMap.Map2 = (ByteMap)this.Map2.clone();
        return yUVByteMap;
    }

    public void compensateMotion(MacroBlockMatrix macroBlockMatrix, MacroBlockMatrix macroBlockMatrix2, MotionVectorMatrixBFrame motionVectorMatrixBFrame) {
        YUVByteMap yUVByteMap = (YUVByteMap)this.clone();
        this.compensateMotion(macroBlockMatrix, motionVectorMatrixBFrame);
        yUVByteMap.compensateMotion(macroBlockMatrix2, motionVectorMatrixBFrame.backwVectors);
        this.Map0.medium(yUVByteMap.Map0);
        this.Map1.medium(yUVByteMap.Map1);
        this.Map2.medium(yUVByteMap.Map2);
    }

    public void compensateMotion(MacroBlockMatrix macroBlockMatrix, MotionVectorMatrix motionVectorMatrix) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < motionVectorMatrix.height) {
            int n4 = n3 * 16;
            int n5 = 0;
            while (n5 < motionVectorMatrix.width) {
                if (motionVectorMatrix.vectors[n5][n3].x != Integer.MIN_VALUE) {
                    n = n5 * 16 + motionVectorMatrix.vectors[n5][n3].x;
                    n2 = n4 + motionVectorMatrix.vectors[n5][n3].y;
                    this.copyYUV(macroBlockMatrix.mbm[n5][n3], n, n2);
                }
                ++n5;
            }
            Thread.yield();
            ++n3;
        }
    }

    public YUVByteMap compress(int n) {
        if (n > 0) {
            YUVByteMap yUVByteMap = new YUVByteMap(this.width, this.height, 2);
            yUVByteMap.Map0 = this.Map0;
            yUVByteMap.Map1 = this.Map1.reduce(n);
            yUVByteMap.Map2 = this.Map2.reduce(n);
            return yUVByteMap;
        }
        return this;
    }

    public void copyYUV(YUVByteMap yUVByteMap, int n, int n2) {
        this.Map0.copy(yUVByteMap.Map0, 0, yUVByteMap.width, 0, yUVByteMap.height - 1, n, n2);
        this.Map1.copy(yUVByteMap.Map1, 0, yUVByteMap.Map1.width, 0, yUVByteMap.Map1.height, n / yUVByteMap.compRate, n2 / yUVByteMap.compRate);
        this.Map2.copy(yUVByteMap.Map2, 0, yUVByteMap.Map2.width, 0, yUVByteMap.Map2.height, n / yUVByteMap.compRate, n2 / yUVByteMap.compRate);
    }

    public YUVByteMap expand(int n, int n2) {
        if (this.compRate <= 1) {
            return this;
        }
        YUVByteMap yUVByteMap = new YUVByteMap(this.width, this.height, 1);
        yUVByteMap.Map0 = (ByteMap)this.Map0.clone();
        yUVByteMap.Map1 = this.Map1.extend(n, n2);
        yUVByteMap.Map2 = this.Map2.extend(n, n2);
        return yUVByteMap;
    }

    public void makeBlack() {
        this.Map0.fill(0, this.Map0.width - 1, 0, this.Map0.height - 1, Convert.int2byte(16));
        this.Map1.fill(0, this.Map1.width - 1, 0, this.Map1.height - 1, Convert.int2byte(128));
        this.Map2.fill(0, this.Map2.width - 1, 0, this.Map2.height - 1, Convert.int2byte(128));
    }

    public MacroBlock yuv2mb() {
        if (this.width != 16 || this.height != 16) {
            throw new IllegalArgumentException("YUVByteMap size is not equal to MacroBlock.SIZE");
        }
        MacroBlock macroBlock = new MacroBlock();
        macroBlock.Map0 = this.Map0;
        macroBlock.Map1 = this.Map1;
        macroBlock.Map2 = this.Map2;
        return macroBlock;
    }

    public MacroBlockMatrix yuv2mbm() {
        MacroBlockMatrix macroBlockMatrix = new MacroBlockMatrix(this.width / 16, this.height / 16);
        int n = 0;
        while (n < macroBlockMatrix.yNumber) {
            int n2 = 0;
            while (n2 < macroBlockMatrix.xNumber) {
                macroBlockMatrix.mbm[n2][n].Map0.copy(this.Map0, n2 * 16, (n2 + 1) * 16 - 1, n * 16, (n + 1) * 16 - 1, 0, 0);
                macroBlockMatrix.mbm[n2][n].Map1.copy(this.Map1, n2 * 8, (n2 + 1) * 8 - 1, n * 8, (n + 1) * 8 - 1, 0, 0);
                macroBlockMatrix.mbm[n2][n].Map2.copy(this.Map2, n2 * 8, (n2 + 1) * 8 - 1, n * 8, (n + 1) * 8 - 1, 0, 0);
                ++n2;
            }
            ++n;
        }
        return macroBlockMatrix;
    }

    public RGBByteMap yuv2rgb() {
        RGBByteMap rGBByteMap = new RGBByteMap(this.width, this.height);
        int n = 0;
        while (n < this.height) {
            int n2 = 0;
            while (n2 < this.width) {
                byte[] byArray = this.yuv2rgb(this.Map0.theMap[n2][n], this.Map1.theMap[n2][n], this.Map2.theMap[n2][n]);
                rGBByteMap.Map0.theMap[n2][n] = byArray[0];
                rGBByteMap.Map1.theMap[n2][n] = byArray[1];
                rGBByteMap.Map2.theMap[n2][n] = byArray[2];
                ++n2;
            }
            Thread.yield();
            ++n;
        }
        return rGBByteMap;
    }

    public byte[] yuv2rgb(byte by, byte by2, byte by3) {
        int n = Convert.byte2int(by) - 16;
        int n2 = Convert.byte2int(by2) - 128;
        int n3 = Convert.byte2int(by3) - 128;
        long l = 104635 * n3;
        long l2 = -25690 * n2 + -53294 * n3;
        long l3 = 132278 * n2;
        long l4 = n * 76310;
        int n4 = Convert.chop((int)((l += l4) >> 16));
        int n5 = Convert.chop((int)((l2 += l4) >> 16));
        int n6 = Convert.chop((int)((l3 += l4) >> 16));
        byte[] byArray = new byte[]{Convert.int2byte(n4), Convert.int2byte(n5), Convert.int2byte(n6)};
        return byArray;
    }
}

