/*
 * Decompiled with CFR 0.152.
 */
package kom.itbeankit.mm.diskscheduling.schedulingview;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;

public class SchedulingGraph
extends Canvas {
    static final int GraphWidth = 300;
    static final int GraphHeight = 180;
    private int xMargin;
    private int yMargin;
    private int xPixel;
    private int yPixel;
    private int[][] Fkt = new int[2][1000];
    private int TimeIndex;
    protected float ScalingSize = 1.0f;
    protected int Timebase = 200;
    protected String Algorithm = new String("Scheduling Algorithm");
    public String YLabel = new String("Track");
    public String XLabel = new String("Time");

    public SchedulingGraph() {
        this.setSize(300, 180);
        this.xMargin = 15;
        this.yMargin = 18;
        this.xPixel = 300 - 3 * this.xMargin;
        this.yPixel = 180 - 2 * this.yMargin;
        this.repaint(0, 0, 300, 180);
    }

    public SchedulingGraph(float f) {
        this.setSize(300, 180);
        this.xMargin = 15;
        this.yMargin = 18;
        this.xPixel = 300 - 3 * this.xMargin;
        this.yPixel = 180 - 2 * this.yMargin;
        this.repaint(0, 0, 300, 180);
    }

    public float getScalingSize() {
        return this.ScalingSize;
    }

    public void setScalingSize(float f) {
        float f2 = this.ScalingSize;
        int n = this.yMargin;
        int n2 = this.yPixel;
        this.ScalingSize = f;
        this.setSize(Math.round(this.ScalingSize * 300.0f), Math.round(this.ScalingSize * 180.0f));
        this.xMargin = Math.round(this.ScalingSize * 300.0f / 20.0f);
        this.yMargin = Math.round(this.ScalingSize * 180.0f / 10.0f);
        this.xPixel = Math.round(this.ScalingSize * 300.0f) - 3 * this.xMargin;
        this.yPixel = Math.round(this.ScalingSize * 180.0f) - 2 * this.yMargin;
        int n3 = 0;
        while (n3 <= this.TimeIndex) {
            this.Fkt[0][n3] = Math.round(n3 * (this.xPixel - 6) / this.Timebase);
            this.Fkt[1][n3] = Math.round(this.ScalingSize * 180.0f - (float)this.yMargin - (f2 * 180.0f - (float)n - (float)(this.Fkt[1][n3] * 128 / n2)) * (float)this.yPixel / 128.0f);
            ++n3;
        }
        this.repaint();
    }

    public int getTimebase() {
        return this.Timebase;
    }

    public void setTimebase(int n) {
        this.Timebase = n;
        int n2 = 0;
        while (n2 <= this.TimeIndex) {
            this.Fkt[0][n2] = Math.round(n2 * (this.xPixel - 6) / this.Timebase);
            ++n2;
        }
        this.repaint(2 * this.xMargin, this.yMargin, this.xPixel, this.yPixel);
    }

    public String getAlgorithm() {
        return this.Algorithm;
    }

    public void setAlgorithm(String string) {
        this.Algorithm = string;
        this.repaint();
    }

    public void function(int[] nArray, boolean bl) {
        this.Fkt[0][this.TimeIndex] = Math.round(this.TimeIndex * (this.xPixel - 6) / this.Timebase);
        this.Fkt[1][this.TimeIndex] = Math.round(this.ScalingSize * 180.0f - (float)this.yMargin - (float)(nArray[0] * this.yPixel / 128));
        if (bl) {
            if (this.TimeIndex < this.Fkt[0].length - 1) {
                ++this.TimeIndex;
            }
        } else {
            --this.TimeIndex;
        }
        this.Fkt[0][this.TimeIndex] = Math.round(this.TimeIndex * (this.xPixel - 6) / this.Timebase);
        this.Fkt[1][this.TimeIndex] = Math.round(this.ScalingSize * 180.0f - (float)this.yMargin - (float)(nArray[1] * this.yPixel / 128));
        this.repaint(2 * this.xMargin, this.yMargin, this.xPixel, this.yPixel);
    }

    public void resetFunction() {
        int n = 0;
        while (n < this.TimeIndex) {
            this.Fkt[0][n] = 0;
            this.Fkt[1][n] = 0;
            ++n;
        }
        this.TimeIndex = 0;
        this.repaint(2 * this.xMargin, this.yMargin, this.xPixel, this.yPixel);
    }

    public void paint(Graphics graphics) {
        int n = this.TimeIndex;
        if (this.TimeIndex > this.Timebase) {
            n = this.Timebase;
        }
        graphics.setColor(Color.black);
        graphics.fill3DRect(2 * this.xMargin, this.yMargin, 3, this.yPixel, true);
        graphics.fill3DRect(2 * this.xMargin, Math.round(this.ScalingSize * 180.0f) - this.yMargin, this.xPixel, 3, true);
        graphics.setColor(Color.blue);
        graphics.drawString(this.YLabel, 12, 15);
        graphics.drawString("128", 2, 32);
        graphics.drawString("0", 15, Math.round(this.ScalingSize * 176.0f));
        graphics.drawString(this.XLabel, Math.round(this.ScalingSize * 260.0f), Math.round(this.ScalingSize * 176.0f));
        graphics.setColor(Color.black);
        graphics.setFont(new Font("Dialog", 1, 14));
        graphics.drawString(this.Algorithm, Math.round(this.ScalingSize * 300.0f / 2.0f) - 3 * this.Algorithm.length(), 15);
        graphics.setColor(Color.red);
        int n2 = 0;
        while (n2 < n) {
            graphics.drawLine(this.Fkt[0][n2] + 3 + 2 * this.xMargin, this.Fkt[1][n2], this.Fkt[0][n2 + 1] + 3 + 2 * this.xMargin, this.Fkt[1][n2 + 1]);
            ++n2;
        }
    }
}

