/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import symantec.itools.awt.AlignStyle;
import symantec.itools.awt.BevelStyle;
import symantec.itools.awt.util.ColorUtils;
import symantec.itools.beans.PropertyChangeSupport;
import symantec.itools.beans.VetoableChangeSupport;
import symantec.itools.util.GeneralUtils;

public class Label3D
extends Component
implements AlignStyle,
BevelStyle {
    public static final int INDENT_ZERO = 0;
    public static final int INDENT_ONE = 1;
    public static final int INDENT_TWO = 2;
    protected String sLabel3D;
    protected int alignStyle;
    protected int bevelStyle;
    protected int indent = 0;
    protected Color textColor;
    protected Color borderedColor;
    protected Color hilightColor;
    protected Color shadowColor;
    protected Color cachedBackground;
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);
    private transient FontMetrics fm;
    private transient int xTemp;
    private transient int yTemp;
    private transient boolean bOsFlag = false;

    public Label3D() {
        this("", 1, 1, Color.black, 0);
    }

    public Label3D(String string, int n, int n2) {
        this(string, n, n2, Color.black, 0);
    }

    public Label3D(String string, int n, int n2, Color color) {
        this(string, n, n2, color, 0);
    }

    public Label3D(String string, int n, int n2, int n3) {
        this(string, n, n2, Color.black, n3);
    }

    public Label3D(String string, int n, int n2, Color color, int n3) {
        String string2 = System.getProperty("os.name");
        if (string2.startsWith("S") || string2.startsWith("OSF")) {
            this.bOsFlag = true;
            this.setFont(new Font("Dialog", 0, 10));
        } else {
            this.bOsFlag = false;
        }
        this.sLabel3D = string;
        this.textColor = color;
        this.borderedColor = Color.black;
        this.cachedBackground = this.getBackground();
        try {
            this.setBorderIndent(n3);
            this.setAlignStyle(n);
            this.setBevelStyle(n2);
            return;
        }
        catch (PropertyVetoException propertyVetoException) {
            return;
        }
    }

    public void setAlignStyle(int n) throws PropertyVetoException {
        if (this.alignStyle != n) {
            Integer n2 = new Integer(this.alignStyle);
            Integer n3 = new Integer(n);
            this.vetos.fireVetoableChange("AlignStyle", n2, n3);
            this.alignStyle = n;
            this.repaint();
            this.changes.firePropertyChange("AlignStyle", n2, n3);
        }
    }

    public int getAlignStyle() {
        return this.alignStyle;
    }

    public void setBevelStyle(int n) throws PropertyVetoException {
        if (this.bevelStyle != n) {
            Integer n2 = new Integer(this.bevelStyle);
            Integer n3 = new Integer(n);
            this.vetos.fireVetoableChange("BevelStyle", n2, n3);
            this.bevelStyle = n;
            this.repaint();
            this.changes.firePropertyChange("BevelStyle", n2, n3);
        }
    }

    public int getBevelStyle() {
        return this.bevelStyle;
    }

    public void setBorderIndent(int n) throws PropertyVetoException {
        if (n < 0) {
            n = 0;
        } else if (n > 2) {
            n = 2;
        }
        if (this.indent != n) {
            Integer n2 = new Integer(this.indent);
            Integer n3 = new Integer(n);
            this.vetos.fireVetoableChange("BorderIndent", n2, n3);
            this.indent = n;
            this.repaint();
            this.changes.firePropertyChange("BorderIndent", n2, n3);
        }
    }

    public int getBorderIndent() {
        return this.indent;
    }

    public void setBorderedColor(Color color) throws PropertyVetoException {
        if (!GeneralUtils.objectsEqual(this.borderedColor, color)) {
            Color color2 = this.borderedColor;
            this.vetos.fireVetoableChange("BorderedColor", color2, color);
            this.borderedColor = color;
            this.repaint();
            this.changes.firePropertyChange("BorderedColor", color2, color);
        }
    }

    public Color getBorderedColor() {
        return this.borderedColor;
    }

    public void setText(String string) throws PropertyVetoException {
        if (!GeneralUtils.objectsEqual(this.sLabel3D, string)) {
            String string2 = this.sLabel3D;
            this.vetos.fireVetoableChange("Text", string2, string);
            this.sLabel3D = string;
            this.repaint();
            this.changes.firePropertyChange("Text", string2, string);
        }
    }

    public String getText() {
        return this.sLabel3D;
    }

    public void setTextColor(Color color) throws PropertyVetoException {
        if (!GeneralUtils.objectsEqual(this.textColor, color)) {
            Color color2 = this.textColor;
            this.vetos.fireVetoableChange("TextColor", color2, color);
            this.textColor = color;
            this.repaint();
            this.changes.firePropertyChange("TextColor", color2, color);
        }
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void paint(Graphics graphics) {
        Color color;
        Color color2;
        Color color3 = this.getBackground();
        if (!GeneralUtils.objectsEqual(color3, this.cachedBackground)) {
            this.cachedBackground = color3;
            this.calculateHilightColors(color3);
        }
        Rectangle rectangle = this.bounds();
        Color color4 = graphics.getColor();
        graphics.setFont(this.getFont());
        switch (this.bevelStyle) {
            case 0: {
                color2 = this.shadowColor;
                color = this.hilightColor;
                break;
            }
            case 1: {
                color2 = this.hilightColor;
                color = this.shadowColor;
                break;
            }
            case 2: {
                color2 = this.borderedColor;
                color = this.borderedColor;
                break;
            }
            default: {
                color = null;
                color2 = null;
            }
        }
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, rectangle.width - 1, rectangle.height - 1);
        if (color2 != null) {
            graphics.setColor(color2);
            graphics.drawLine(1 + this.indent, this.indent, rectangle.width - 3 - this.indent, this.indent);
            graphics.setColor(color);
            graphics.drawLine(1 + this.indent, rectangle.height - 1 - this.indent, rectangle.width - 3 - this.indent, rectangle.height - 1 - this.indent);
            graphics.setColor(color2);
            graphics.drawLine(this.indent, this.indent, this.indent, rectangle.height - 1 - this.indent);
            graphics.setColor(color);
            graphics.drawLine(rectangle.width - 2 - this.indent, this.indent, rectangle.width - 2 - this.indent, rectangle.height - 1 - this.indent);
            graphics.clipRect(2 + this.indent, 1 + this.indent, rectangle.width - 9 - this.indent, rectangle.height - 4 - this.indent);
            this.yTemp = 1 + this.indent;
        } else {
            graphics.drawRect(this.indent, this.indent, rectangle.width - 2 - this.indent, rectangle.height - 1 - this.indent);
            graphics.clipRect(2, 1, rectangle.width - 7, rectangle.height - 2);
            this.yTemp = 1;
        }
        graphics.setColor(this.textColor);
        this.fm = this.getFontMetrics(graphics.getFont());
        this.yTemp = (rectangle.height - this.yTemp + this.fm.getAscent()) / 2;
        switch (this.alignStyle) {
            case 0: {
                if (this.bevelStyle == 2) {
                    graphics.drawString(this.sLabel3D, 4, this.yTemp);
                    break;
                }
                graphics.drawString(this.sLabel3D, 8, this.yTemp);
                break;
            }
            case 2: {
                this.xTemp = rectangle.width - this.fm.stringWidth(this.sLabel3D);
                if (this.bevelStyle == 2) {
                    graphics.drawString(this.sLabel3D, this.xTemp - 6, this.yTemp);
                    break;
                }
                graphics.drawString(this.sLabel3D, this.xTemp - 10, this.yTemp);
                break;
            }
            case 1: {
                this.xTemp = (rectangle.width - this.fm.stringWidth(this.sLabel3D)) / 2;
                graphics.drawString(this.sLabel3D, this.xTemp, this.yTemp);
                break;
            }
        }
        graphics.setColor(color4);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.size();
        Dimension dimension2 = this.minimumSize();
        return new Dimension(Math.max(dimension.width, dimension2.width), Math.max(dimension.height, dimension2.height));
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        Dimension dimension = new Dimension(18, 10);
        Font font = this.getFont();
        if (font == null) {
            if (this.bOsFlag) {
                dimension.height = 29;
            }
        } else {
            this.fm = this.getFontMetrics(font);
            dimension.width = this.fm.stringWidth(this.sLabel3D) + 18;
            dimension.height = this.fm.getHeight() + 10;
            if (this.bOsFlag && dimension.height < 29) {
                dimension.height = 29;
            }
        }
        return dimension;
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.addVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.removeVetoableChangeListener(vetoableChangeListener);
    }

    protected void calculateHilightColors(Color color) {
        this.hilightColor = ColorUtils.calculateHilightColor(color);
        this.shadowColor = ColorUtils.calculateShadowColor(color);
    }
}

