/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt.util;

import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.util.Date;
import symantec.itools.awt.ComboBox;
import symantec.itools.awt.util.spinner.NumericSpinner;
import symantec.itools.beans.PropertyChangeSupport;
import symantec.itools.beans.VetoableChangeSupport;
import symantec.itools.lang.OS;
import symantec.itools.util.GeneralUtils;

public class Calendar
extends Panel {
    String actionCommand;
    ActionListener actionListener;
    protected ComboBox combo;
    protected boolean bNeedsPlatformHelp;
    protected NumericSpinner sc;
    protected Date dCurrent;
    protected Date dLast;
    protected Color selectedColor;
    protected String[][] cal;
    protected int edgePad = 2;
    protected int dateSelectedx = -1;
    protected int dateSelectedy = -1;
    protected int lastSelectedDate = -1;
    protected int maxMonthx = -1;
    protected int maxMonthy = -1;
    protected int firstDay = -1;
    protected int topRow = -1;
    protected int selectHeight = -1;
    protected int centerNumber = -1;
    protected int heightAdjust = -1;
    protected int numberAdjust = -1;
    private Action action;
    private Mouse mouse;
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public Calendar() {
        this(new Date());
    }

    public Calendar(Date date) {
        super.setLayout(null);
        this.bNeedsPlatformHelp = ComboBox.needsPlatformHelp();
        this.dLast = this.dCurrent = date;
        this.combo = new ComboBox();
        try {
            DateFormatSymbols dateFormatSymbols = new DateFormatSymbols();
            String[] stringArray = dateFormatSymbols.getMonths();
            int n = stringArray.length > 12 ? 12 : stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                this.combo.addItem(stringArray[n2]);
                ++n2;
            }
        }
        catch (PropertyVetoException propertyVetoException) {}
        this.add(this.combo);
        this.sc = new NumericSpinner();
        this.add(this.sc);
        try {
            this.sc.setMin(1900);
            this.sc.setMax(9999);
            this.sc.setCurrent(1900 + this.dCurrent.getYear());
            this.sc.setEditable(false);
            this.combo.select(this.dCurrent.getMonth());
        }
        catch (PropertyVetoException propertyVetoException) {}
        this.selectedColor = OS.isMacintosh() ? Color.black : Color.blue;
        if (!OS.isMacintosh()) {
            if (this.bNeedsPlatformHelp) {
                ((Component)this).setFont(new Font("Dialog", 0, 9));
                return;
            }
            ((Component)this).setFont(new Font("Dialog", 1, 10));
        }
    }

    public void setDate(String string) throws PropertyVetoException {
        String string2 = this.getDate();
        if (!GeneralUtils.objectsEqual(string2, string)) {
            Date date;
            this.vetos.fireVetoableChange("Date", string2, string);
            try {
                date = new Date(string);
            }
            catch (Exception exception) {
                date = new Date();
            }
            if (!this.dCurrent.equals(date)) {
                this.dCurrent = date;
                this.combo.select(this.dCurrent.getMonth());
                this.sc.setCurrent(1900 + this.dCurrent.getYear());
                this.firstDay = -1;
                this.lastSelectedDate = -1;
                this.repaint();
            }
            this.changes.firePropertyChange("Date", string2, string);
        }
    }

    public String getDate() {
        DateFormat dateFormat = DateFormat.getDateInstance(1);
        String string = dateFormat.format(this.dCurrent);
        return string;
    }

    public void setSelectedColor(Color color) throws PropertyVetoException {
        Color color2 = this.selectedColor;
        if (!GeneralUtils.objectsEqual(color2, color)) {
            this.vetos.fireVetoableChange("SelectedColor", color2, color);
            this.selectedColor = color;
            this.repaint();
            this.changes.firePropertyChange("SelectedColor", color2, color);
        }
    }

    public Color getSelectedColor() {
        return this.selectedColor;
    }

    public synchronized void addNotify() {
        super.addNotify();
        if (this.mouse == null) {
            this.mouse = new Mouse();
            this.addMouseListener(this.mouse);
        }
        if (this.action == null) {
            this.action = new Action();
            this.sc.addActionListener(this.action);
            this.combo.addActionListener(this.action);
        }
    }

    public synchronized void removeNotify() {
        if (this.mouse != null) {
            this.removeMouseListener(this.mouse);
            this.mouse = null;
        }
        if (this.action != null) {
            this.sc.removeActionListener(this.action);
            this.combo.removeActionListener(this.action);
            this.action = null;
        }
        super.removeNotify();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        int n;
        if (!this.sc.getBackground().equals(this.getBackground())) {
            this.sc.setBackground(this.getBackground());
        }
        Dimension dimension = this.sc.getPreferredSize();
        this.sc.setBounds(this.getSize().width - dimension.width - this.edgePad, this.edgePad, dimension.width, dimension.height);
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        Rectangle rectangle = this.bounds();
        if (this.bNeedsPlatformHelp) {
            this.combo.reshape(12, 20, 100, 34);
            this.topRow = 70;
            this.selectHeight = fontMetrics.getHeight() + 2;
            this.centerNumber = 14;
            this.heightAdjust = 6;
            this.numberAdjust = 6;
        } else {
            Dimension dimension2 = this.combo.getPreferredSize();
            this.combo.setBounds(this.edgePad, this.edgePad, dimension2.width, dimension2.height);
            this.topRow = dimension.height + this.edgePad + 2;
            this.selectHeight = fontMetrics.getHeight();
            this.centerNumber = 14;
            this.heightAdjust = 2;
            this.numberAdjust = 0;
        }
        int n2 = rectangle.width - 2 * this.edgePad;
        int n3 = n2 / 7;
        int n4 = (rectangle.height - this.topRow - this.edgePad) / 7;
        int n5 = n3 / 2;
        int n6 = n5 - fontMetrics.stringWidth("S") / 2;
        int n7 = this.topRow + this.centerNumber;
        if (this.dateSelectedx < 0) {
            int n8 = rectangle.width - this.edgePad;
            n = this.topRow + 7 * n4;
            graphics.setColor(Color.black);
            graphics.drawLine(this.edgePad, this.topRow, rectangle.width - this.edgePad - 2, this.topRow);
            graphics.setColor(Color.lightGray);
            graphics.drawLine(this.edgePad, n, n8 - 3, n);
            graphics.setColor(Color.white);
            graphics.drawLine(this.edgePad + 1, n + 1, n8 - 2, n + 1);
            graphics.setColor(Color.black);
            graphics.drawLine(this.edgePad, this.topRow, this.edgePad, n);
            graphics.setColor(Color.lightGray);
            graphics.drawLine(n8 - 2, this.topRow, n8 - 2, n);
            graphics.setColor(Color.white);
            graphics.drawLine(n8 - 1, this.topRow, n8 - 1, n);
            graphics.fillRect(this.edgePad + 1, this.topRow + n4, n2 - 3, 6 * n4);
            graphics.setColor(Color.gray);
            graphics.fillRect(this.edgePad + 1, this.topRow + 1, n2 - 3, n4 + 1);
            graphics.setColor(Color.white);
            if (OS.isMacintosh()) {
                n7 += (n4 + 1) / 2 - fontMetrics.getHeight() / 2;
            }
            graphics.drawString("S", n6, n7 - 1);
            n6 = n3 + (n5 - fontMetrics.stringWidth("M") / 2);
            graphics.drawString("M", n6, n7 - 1);
            n6 = n3 * 2 + (n5 - fontMetrics.stringWidth("T") / 2);
            graphics.drawString("T", n6, n7 - 1);
            n6 = n3 * 3 + (n5 - fontMetrics.stringWidth("W") / 2);
            graphics.drawString("W", n6, n7 - 1);
            n6 = n3 * 4 + (n5 - fontMetrics.stringWidth("T") / 2);
            graphics.drawString("T", n6, n7 - 1);
            n6 = n3 * 5 + (n5 - fontMetrics.stringWidth("FM") / 2);
            graphics.drawString("F", n6, n7 - 1);
            n6 = n3 * 6 + (n5 - fontMetrics.stringWidth("S") / 2);
            graphics.drawString("S", n6, n7 - 1);
        }
        Date date = new Date(this.dCurrent.getYear(), this.dCurrent.getMonth(), 1);
        date = new Date(this.dCurrent.getYear(), this.dCurrent.getMonth(), 1);
        if (this.firstDay < 0) {
            this.firstDay = date.getDay();
        }
        n = -1;
        int n9 = 1;
        int n10 = -1;
        int n11 = this.dCurrent.getMonth() + 1;
        if (this.lastSelectedDate < 1) {
            n = this.dCurrent.getDate();
        } else if (this.dateSelectedx < 0) {
            n = this.lastSelectedDate;
        }
        graphics.setColor(Color.black);
        int n12 = 0;
        block0: while (n12 < 6) {
            int n13 = 0;
            while (n13 < 7) {
                if (this.maxMonthy < this.dateSelectedy || this.maxMonthy == this.dateSelectedy && this.maxMonthx < this.dateSelectedx) {
                    this.dateSelectedx = -1;
                    this.dateSelectedy = -1;
                    break block0;
                }
                if (n12 == 0 && n13 < this.firstDay) {
                    if (this.dateSelectedx == n13 && this.dateSelectedy == n12) {
                        this.dateSelectedx = -1;
                        this.dateSelectedy = -1;
                        break block0;
                    }
                } else {
                    n6 = n13 * n3 + (n5 - fontMetrics.stringWidth(Integer.toString(n9)) / 2);
                    n7 = this.topRow + this.heightAdjust + 4 + this.numberAdjust + ((n12 + 2) * n4 - fontMetrics.getHeight());
                    if (this.dateSelectedx < 0 && n != n9) {
                        if (n9 < 10) {
                            graphics.drawString(Integer.toString(n9), n6, n7);
                        } else {
                            graphics.drawString(Integer.toString(n9), n6, n7);
                        }
                    } else if (this.dateSelectedx == n13 && this.dateSelectedy == n12 || n == n9) {
                        if (this.dateSelectedx == n13 && this.dateSelectedy == n12) {
                            int n14 = this.dCurrent.getYear();
                            int n15 = this.dCurrent.getMonth();
                            this.dCurrent = new Date();
                            this.dCurrent = new Date();
                            this.dCurrent.setDate(n9);
                            this.dCurrent.setYear(n14);
                            this.dCurrent.setMonth(n15);
                        }
                        graphics.setColor(this.selectedColor);
                        if (n9 < 10) {
                            graphics.fillRect(n6, n7 - this.selectHeight + this.heightAdjust, fontMetrics.stringWidth(Integer.toString(n9)) + 2, this.selectHeight);
                        } else {
                            graphics.fillRect(n6, n7 - this.selectHeight + this.heightAdjust, fontMetrics.stringWidth(Integer.toString(n9)), this.selectHeight);
                        }
                        graphics.setColor(Color.white);
                        if (n9 < 10) {
                            graphics.drawString(Integer.toString(n9), n6, n7);
                        } else {
                            graphics.drawString(Integer.toString(n9), n6, n7);
                        }
                        n10 = n9;
                        graphics.setColor(Color.black);
                    } else if (n9 == this.lastSelectedDate) {
                        graphics.setColor(Color.white);
                        if (n9 < 10) {
                            graphics.fillRect(n6, n7 - this.selectHeight + this.heightAdjust, fontMetrics.stringWidth(Integer.toString(n9)) + 2, this.selectHeight);
                        } else {
                            graphics.fillRect(n6, n7 - this.selectHeight + this.heightAdjust, fontMetrics.stringWidth(Integer.toString(n9)), this.selectHeight);
                        }
                        graphics.setColor(Color.black);
                        if (n9 < 10) {
                            graphics.drawString(Integer.toString(n9), n6, n7);
                        } else {
                            graphics.drawString(Integer.toString(this.lastSelectedDate), n6, n7);
                        }
                        this.lastSelectedDate = -1;
                    }
                    if (n9 >= 31) {
                        this.maxMonthx = n13;
                        this.maxMonthy = n12;
                        break block0;
                    }
                    if (n9 >= 30 && (n11 == 4 || n11 == 6 || n11 == 9 || n11 == 11)) {
                        this.maxMonthx = n13;
                        this.maxMonthy = n12;
                        break block0;
                    }
                    if (n9 >= 29 && n11 == 2) {
                        this.maxMonthx = n13;
                        this.maxMonthy = n12;
                        break block0;
                    }
                    if (n9 >= 28 && n11 == 2 && !this.isLeapYear(this.dCurrent.getYear())) {
                        this.maxMonthx = n13;
                        this.maxMonthy = n12;
                        break block0;
                    }
                    ++n9;
                }
                ++n13;
            }
            ++n12;
        }
        if (this.lastSelectedDate < 0) {
            this.lastSelectedDate = n10;
        }
        this.dateSelectedx = -1;
        this.dateSelectedy = -1;
        if (!this.dLast.equals(this.dCurrent)) {
            this.dLast = this.dCurrent;
            this.sourceActionEvent();
        }
    }

    public Dimension preferredSize() {
        return new Dimension(250, 200);
    }

    public Dimension minimumSize() {
        return new Dimension(250, 200);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.addVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void setActionCommand(String string) throws PropertyVetoException {
        String string2 = this.actionCommand;
        this.vetos.fireVetoableChange("ActionCommand", string2, string);
        this.actionCommand = string;
        this.changes.firePropertyChange("ActionCommand", string2, string);
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public void sourceActionEvent() {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.actionCommand));
        }
    }

    public void setLayout(LayoutManager layoutManager) {
    }

    boolean isLeapYear(int n) {
        return n % 4 == 0 && n != 2100;
    }

    class Mouse
    extends MouseAdapter {
        public synchronized void mousePressed(MouseEvent mouseEvent) {
            int n = -1;
            int n2 = mouseEvent.getX();
            int n3 = mouseEvent.getY();
            if (Calendar.this.bNeedsPlatformHelp) {
                n = 70;
                Calendar.this.centerNumber = 14;
                Calendar.this.heightAdjust = 6;
                Calendar.this.numberAdjust = 6;
            } else {
                n = 40;
                Calendar.this.numberAdjust = 0;
            }
            Rectangle rectangle = Calendar.this.bounds();
            int n4 = (rectangle.height - n - 14) / 7;
            int n5 = (rectangle.width - 32) / 7;
            if (n2 >= 15 && n2 < rectangle.width - 15 && n3 >= n + n4 && n3 < rectangle.height - 14) {
                Calendar.this.dateSelectedx = (n2 - 16) / n5;
                Calendar.this.dateSelectedy = (n3 - n - n4) / n4;
                Calendar.this.repaint();
                Calendar.this.firstDay = -1;
            }
        }

        Mouse() {
            Calendar.this = Calendar.this;
        }
    }

    class Action
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int n2;
            int n3;
            Object object = actionEvent.getSource();
            if (object instanceof ComboBox) {
                n3 = Calendar.this.dCurrent.getDate();
                n2 = Calendar.this.combo.getSelectedIndex();
                n = Calendar.this.dCurrent.getYear();
                Calendar.this.dCurrent = new Date(n, n2, n3);
                while (Calendar.this.dCurrent.getMonth() != n2) {
                    Calendar.this.dCurrent = new Date(n, n2, --n3);
                    Calendar.this.lastSelectedDate = -1;
                }
                Calendar.this.firstDay = -1;
                Calendar.this.repaint();
            }
            if (object == Calendar.this.sc) {
                n3 = Calendar.this.dCurrent.getDate();
                n2 = Calendar.this.dCurrent.getMonth();
                n = Calendar.this.sc.getCurrent() - 1900;
                Calendar.this.dCurrent = new Date(n, n2, n3);
                while (Calendar.this.dCurrent.getMonth() != n2) {
                    Calendar.this.dCurrent = new Date(n, n2, --n3);
                    Calendar.this.lastSelectedDate = -1;
                }
                Calendar.this.firstDay = -1;
                Calendar.this.repaint();
            }
        }

        Action() {
            Calendar.this = Calendar.this;
        }
    }
}

