/*
 * Decompiled with CFR 0.152.
 */
package kom.itbeankit.common.message;

import java.awt.Component;
import java.awt.Frame;
import java.awt.TextArea;
import kom.itbeankit.common.message.MessageDialog;
import kom.itbeankit.common.message.MessageEvent;
import kom.itbeankit.common.message.MessageListener;
import kom.itbeankit.common.message.Messenger;

public class Messenger
extends TextArea
implements MessageListener {
    public Messenger() {
        this.setSize(0, 0);
    }

    public void deliverMessage(MessageEvent me) {
        if (me != null) {
            String fromString = " from " + me.getMsgSource();
            if (me.getMsgSource().equals("")) {
                fromString = "";
            }
            int displayType = me.getDisplayType();
            switch (displayType) {
                case 701: {
                    this.appendText(String.valueOf(this.getEventTypeString(me.getMsgType())) + fromString + ": " + me.getMsg() + "\n");
                    break;
                }
                case 702: {
                    this.openDialog(me);
                    break;
                }
                case 703: {
                    this.openDialog(me);
                    this.appendText(String.valueOf(this.getEventTypeString(me.getMsgType())) + fromString + ": " + me.getMsg() + "\n");
                    break;
                }
            }
        }
    }

    void openDialog(MessageEvent me) {
        Component c = this;
        while (!(c instanceof Frame)) {
            c = c.getParent();
        }
        new MessageDialog((Frame)c, me).setVisible(true);
    }

    String getEventTypeString(int msgType) {
        switch (msgType) {
            case 710: {
                return "INFO";
            }
            case 711: {
                return "WARNING";
            }
            case 712: {
                return "ERROR";
            }
            case 713: {
                return "QUESTION";
            }
        }
        return "";
    }

    public static void main(String[] args) {
        new 1.DriverFrame().show();
    }
}

