/*
 * Decompiled with CFR 0.152.
 */
package kom.itbeankit.nw.ethernet;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.util.Vector;
import kom.itbeankit.common.message.MessageEvent;
import kom.itbeankit.common.message.MessageListener;
import kom.itbeankit.common.vcr.ClkEvent;
import kom.itbeankit.common.vcr.ClkListener;
import kom.itbeankit.nw.ethernet.AlgorithmInterface;
import kom.itbeankit.nw.ethernet.BusSegment;
import kom.itbeankit.nw.ethernet.DataEvent;
import kom.itbeankit.nw.ethernet.DataListener;
import kom.itbeankit.nw.ethernet.Ethernet;
import kom.itbeankit.nw.ethernet.EthernetInterface;
import kom.itbeankit.nw.ethernet.Host;
import symantec.itools.awt.BorderPanel;
import symantec.itools.awt.VerticalSlider;

public class Ethernet
extends Container
implements EthernetInterface,
ClkListener,
MessageListener {
    protected AlgorithmInterface algorithm;
    protected boolean usePadField;
    protected int numOfHosts = 8;
    private Vector messageListeners = new Vector();
    protected int scenario = 0;
    Label csmaLabel;
    Panel ethernetPanel;
    Panel hostTopPanel;
    Host host1;
    Host host3;
    Host host5;
    Host host7;
    Panel busPanel;
    BusSegment busSegment1;
    BusSegment busSegment2;
    BusSegment busSegment3;
    BusSegment busSegment4;
    Panel hostBottomPanel;
    Host host2;
    Host host4;
    Host host6;
    Host host8;
    BorderPanel efficiencyPanel;
    VerticalSlider performanceSlider;
    Label maxLabel;
    Label minLabel;
    Button helpButton;

    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.host1.setEnabled(b);
        this.host2.setEnabled(b);
        this.host3.setEnabled(b);
        this.host4.setEnabled(b);
        this.host5.setEnabled(b);
        this.host6.setEnabled(b);
        this.host7.setEnabled(b);
        this.host8.setEnabled(b);
    }

    public void doScenario(ClkEvent e) {
        switch (this.scenario) {
            case 0: {
                this.scenarioNone(e);
                break;
            }
            case 1: {
                this.scenarioNormal(e);
                break;
            }
            case 2: {
                this.scenarioCollision(e);
                break;
            }
            case 3: {
                this.scenarioBroadcast(e);
                break;
            }
            case 4: {
                this.scenarioShortFrame(e);
                break;
            }
        }
    }

    void scenarioNone(ClkEvent e) {
        if (e.isRisingEdge()) {
            this.showEfficiency();
        }
        this.busSegment1.clkReceived(e);
        this.host1.clkReceived(e);
        this.host2.clkReceived(e);
        if (this.numOfHosts > 2) {
            this.host3.clkReceived(e);
            this.host4.clkReceived(e);
            this.busSegment2.clkReceived(e);
        }
        if (this.numOfHosts > 4) {
            this.host5.clkReceived(e);
            this.host6.clkReceived(e);
            this.busSegment3.clkReceived(e);
        }
        if (this.numOfHosts > 6) {
            this.busSegment4.clkReceived(e);
            this.host7.clkReceived(e);
            this.host8.clkReceived(e);
        }
    }

    void scenarioNormal(ClkEvent e) {
        this.setNumOfHosts(8);
        this.msg("scenario normal operation", "\n  in this scenario host5 sends\n   a frame to host8");
        this.host5.setFrameSize(56);
        this.host5.setAutoRepeat(false);
        this.host5.setDestinationHost(8);
        this.scenario = 0;
    }

    void scenarioCollision(ClkEvent e) {
        this.setNumOfHosts(8);
        this.msg("scenario collision", "\n   in this scenario host2 and\n   host7 send frames at the same\n   time to host5 and host1");
        this.host2.setFrameSize(56);
        this.host2.setAutoRepeat(false);
        this.host7.setFrameSize(56);
        this.host7.setAutoRepeat(false);
        this.host2.setDestinationHost(5);
        this.host7.setDestinationHost(1);
        this.scenario = 0;
    }

    void scenarioBroadcast(ClkEvent e) {
        this.setNumOfHosts(8);
        this.msg("scenario broadcast", "\n  in this scenario host4 sends\n   a frame to all other hosts");
        this.host4.setFrameSize(56);
        this.host4.setAutoRepeat(false);
        this.host4.setDestinationHost(0);
        this.scenario = 0;
    }

    void scenarioShortFrame(ClkEvent e) {
        this.setNumOfHosts(8);
        this.msg("scenario short frame", "\n   in this scenario host1 and\n   host8 send frames at the same\n   time to host5 and host2. host1\n   sends a too short frame and cannot\n   detect that a collision happens\n   try this scenario with and without\n   use of pad field to see the difference");
        this.host1.setFrameSize(16);
        this.host1.setAutoRepeat(false);
        this.host8.setFrameSize(56);
        this.host8.setAutoRepeat(false);
        this.host1.setDestinationHost(5);
        this.host8.setDestinationHost(2);
        this.scenario = 0;
    }

    public void setScenario(int scenario) {
        this.scenario = scenario;
    }

    public int getScenario() {
        return this.scenario;
    }

    void msg(String subject, String message) {
        this.deliverMessage(new MessageEvent(this, 701, 710, subject, message));
    }

    public void deliverMessage(MessageEvent me) {
        MessageEvent event = new MessageEvent(this, me);
        int i = 0;
        while (i < this.messageListeners.size()) {
            MessageListener ml = (MessageListener)this.messageListeners.elementAt(i);
            ml.deliverMessage(event);
            ++i;
        }
    }

    public synchronized void addMessageListener(MessageListener lis) {
        this.messageListeners.addElement(lis);
    }

    public synchronized void removeMessageListener(MessageListener lis) {
        this.messageListeners.removeElement(lis);
    }

    public void setNumOfHosts(int num) {
        switch (num) {
            case 2: {
                this.numOfHosts = 2;
                this.set2ndPairVisible(false);
                this.set3rdPairVisible(false);
                this.set4thPairVisible(false);
                break;
            }
            case 4: {
                this.numOfHosts = 4;
                this.set2ndPairVisible(true);
                this.set3rdPairVisible(false);
                this.set4thPairVisible(false);
                break;
            }
            case 6: {
                this.numOfHosts = 6;
                this.set2ndPairVisible(true);
                this.set3rdPairVisible(true);
                this.set4thPairVisible(false);
                break;
            }
            case 8: {
                this.numOfHosts = 8;
                this.set2ndPairVisible(true);
                this.set3rdPairVisible(true);
                this.set4thPairVisible(true);
                break;
            }
        }
    }

    void set2ndPairVisible(boolean b) {
        this.host3.setVisible(b);
        this.host4.setVisible(b);
        this.busSegment2.setVisible(b);
        if (!b) {
            this.host3.reset();
            this.host4.reset();
            this.busSegment2.reset();
        }
    }

    void set3rdPairVisible(boolean b) {
        this.host5.setVisible(b);
        this.host6.setVisible(b);
        this.busSegment3.setVisible(b);
        if (!b) {
            this.host5.reset();
            this.host6.reset();
            this.busSegment3.reset();
        }
    }

    void set4thPairVisible(boolean b) {
        this.host7.setVisible(b);
        this.host8.setVisible(b);
        this.busSegment4.setVisible(b);
        if (!b) {
            this.host7.reset();
            this.host8.reset();
            this.busSegment4.reset();
        }
    }

    public int getNumOfHosts() {
        return this.numOfHosts;
    }

    public void setAlgorithm(String algorithmName) {
        this.algorithm = this.algorithm;
        this.host1.setAlgorithm(algorithmName);
        this.host2.setAlgorithm(algorithmName);
        this.host3.setAlgorithm(algorithmName);
        this.host4.setAlgorithm(algorithmName);
        this.host5.setAlgorithm(algorithmName);
        this.host6.setAlgorithm(algorithmName);
        this.host7.setAlgorithm(algorithmName);
        this.host8.setAlgorithm(algorithmName);
    }

    public AlgorithmInterface getAlgorithm() {
        return this.algorithm;
    }

    public void setUsePadField(boolean usePadField) {
        this.usePadField = usePadField;
        this.host1.setUsePadField(usePadField);
        this.host2.setUsePadField(usePadField);
        this.host3.setUsePadField(usePadField);
        this.host4.setUsePadField(usePadField);
        this.host5.setUsePadField(usePadField);
        this.host6.setUsePadField(usePadField);
        this.host7.setUsePadField(usePadField);
        this.host8.setUsePadField(usePadField);
    }

    public boolean isUsePadField() {
        return this.usePadField;
    }

    public Ethernet() {
        this.setLayout(new BorderLayout(0, 0));
        this.setSize(500, 240);
        this.csmaLabel = new Label(" Carrier Sense Multiple Access Protocols");
        this.csmaLabel.setBounds(0, 0, 500, 31);
        this.csmaLabel.setFont(new Font("DialogInput", 1, 20));
        this.add("North", this.csmaLabel);
        this.ethernetPanel = new Panel();
        this.ethernetPanel.setLayout(null);
        this.ethernetPanel.setBounds(0, 31, 400, 209);
        this.add("West", this.ethernetPanel);
        this.hostTopPanel = new Panel();
        this.hostTopPanel.setLayout(null);
        this.hostTopPanel.setBounds(10, 10, 400, 74);
        this.ethernetPanel.add(this.hostTopPanel);
        this.host1 = new Host();
        this.host1.setLayout(null);
        this.host1.setBounds(0, 0, 80, 74);
        this.hostTopPanel.add(this.host1);
        this.host1.setCursor(new Cursor(12));
        this.host3 = new Host();
        this.host3.setID(3);
        this.host3.setLayout(null);
        this.host3.setBounds(90, 0, 80, 74);
        this.hostTopPanel.add(this.host3);
        this.host3.setCursor(new Cursor(12));
        this.host5 = new Host();
        this.host5.setID(5);
        this.host5.setLayout(null);
        this.host5.setBounds(180, 0, 80, 74);
        this.hostTopPanel.add(this.host5);
        this.host5.setCursor(new Cursor(12));
        this.host7 = new Host();
        this.host7.setID(7);
        this.host7.setLayout(null);
        this.host7.setBounds(270, 0, 80, 74);
        this.hostTopPanel.add(this.host7);
        this.host7.setCursor(new Cursor(12));
        this.busPanel = new Panel();
        this.busPanel.setLayout(null);
        this.busPanel.setBounds(10, 84, 400, 45);
        this.ethernetPanel.add(this.busPanel);
        this.busSegment1 = new BusSegment();
        this.busSegment1.setLayout(null);
        this.busSegment1.setBounds(0, 0, 90, 45);
        this.busPanel.add(this.busSegment1);
        this.busSegment2 = new BusSegment();
        this.busSegment2.setLayout(null);
        this.busSegment2.setBounds(90, 0, 90, 45);
        this.busPanel.add(this.busSegment2);
        this.busSegment3 = new BusSegment();
        this.busSegment3.setLayout(null);
        this.busSegment3.setBounds(180, 0, 90, 45);
        this.busPanel.add(this.busSegment3);
        this.busSegment4 = new BusSegment();
        this.busSegment4.setLayout(null);
        this.busSegment4.setBounds(270, 0, 90, 45);
        this.busPanel.add(this.busSegment4);
        this.hostBottomPanel = new Panel();
        this.hostBottomPanel.setLayout(null);
        this.hostBottomPanel.setBounds(10, 129, 400, 74);
        this.ethernetPanel.add(this.hostBottomPanel);
        this.host2 = new Host();
        this.host2.setOverTheBus(false);
        this.host2.setID(2);
        this.host2.setLayout(null);
        this.host2.setBounds(25, 0, 80, 74);
        this.hostBottomPanel.add(this.host2);
        this.host2.setCursor(new Cursor(12));
        this.host4 = new Host();
        this.host4.setOverTheBus(false);
        this.host4.setID(4);
        this.host4.setLayout(null);
        this.host4.setBounds(115, 0, 80, 74);
        this.hostBottomPanel.add(this.host4);
        this.host4.setCursor(new Cursor(12));
        this.host6 = new Host();
        this.host6.setOverTheBus(false);
        this.host6.setID(6);
        this.host6.setLayout(null);
        this.host6.setBounds(205, 0, 80, 74);
        this.hostBottomPanel.add(this.host6);
        this.host6.setCursor(new Cursor(12));
        this.host8 = new Host();
        this.host8.setOverTheBus(false);
        this.host8.setID(8);
        this.host8.setLayout(null);
        this.host8.setBounds(295, 0, 80, 74);
        this.hostBottomPanel.add(this.host8);
        this.host8.setCursor(new Cursor(12));
        this.efficiencyPanel = new BorderPanel();
        try {
            this.efficiencyPanel.setLabel("Efficiency");
        }
        catch (PropertyVetoException propertyVetoException) {}
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.efficiencyPanel.setLayout(gridBagLayout);
        this.efficiencyPanel.setBounds(420, 31, 80, 209);
        this.add("East", this.efficiencyPanel);
        this.performanceSlider = new VerticalSlider();
        try {
            this.performanceSlider.setMaxValue(100);
        }
        catch (PropertyVetoException propertyVetoException) {}
        try {
            this.performanceSlider.setMinValue(0);
        }
        catch (PropertyVetoException propertyVetoException) {}
        try {
            this.performanceSlider.setValue(100);
        }
        catch (PropertyVetoException propertyVetoException) {}
        try {
            this.performanceSlider.setTickFreq(10);
        }
        catch (PropertyVetoException propertyVetoException) {}
        try {
            this.performanceSlider.setTickStyle(0);
        }
        catch (PropertyVetoException propertyVetoException) {}
        this.performanceSlider.setBounds(5, 0, 20, 165);
        this.performanceSlider.setBackground(new Color(0xC0C0C0));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 5, -20, 0);
        gbc.ipadx = 12;
        ((GridBagLayout)this.efficiencyPanel.getLayout()).setConstraints(this.performanceSlider, gbc);
        this.efficiencyPanel.add(this.performanceSlider);
        this.performanceSlider.setEnabled(false);
        this.maxLabel = new Label("100%", 2);
        this.maxLabel.setBounds(25, 0, 34, 23);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 0, 0, 0);
        ((GridBagLayout)this.efficiencyPanel.getLayout()).setConstraints(this.maxLabel, gbc);
        this.efficiencyPanel.add(this.maxLabel);
        this.minLabel = new Label("0%", 2);
        this.minLabel.setBounds(35, 145, 24, 23);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.anchor = 13;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 10, 0, 0);
        ((GridBagLayout)this.efficiencyPanel.getLayout()).setConstraints(this.minLabel, gbc);
        this.efficiencyPanel.add(this.minLabel);
        this.helpButton = new Button();
        this.helpButton.setLabel("?");
        this.helpButton.setBounds(36, 72, 21, 23);
        this.helpButton.setFont(new Font("Dialog", 1, 12));
        this.helpButton.setForeground(new Color(255));
        this.helpButton.setBackground(new Color(0xC0C0C0));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 10, 0, 0);
        ((GridBagLayout)this.efficiencyPanel.getLayout()).setConstraints(this.helpButton, gbc);
        this.efficiencyPanel.add(this.helpButton);
        this.helpButton.setCursor(new Cursor(12));
        try {
            this.efficiencyPanel.setLabel("Efficiency");
        }
        catch (PropertyVetoException propertyVetoException) {}
        this.setAlgorithm("kom.itbeankit.nw.ethernet.OnePersistentAlgorithm");
        this.setNumOfHosts(8);
        SymData lSymData = new SymData();
        this.busSegment1.addDataListener(lSymData);
        this.busSegment2.addDataListener(lSymData);
        this.busSegment3.addDataListener(lSymData);
        this.busSegment4.addDataListener(lSymData);
        this.host1.addDataListener(lSymData);
        this.host2.addDataListener(lSymData);
        this.host3.addDataListener(lSymData);
        this.host5.addDataListener(lSymData);
        this.host7.addDataListener(lSymData);
        this.host4.addDataListener(lSymData);
        this.host6.addDataListener(lSymData);
        this.host8.addDataListener(lSymData);
        SymMessage lSymMessage = new SymMessage();
        this.host1.addMessageListener(lSymMessage);
        this.host2.addMessageListener(lSymMessage);
        this.host3.addMessageListener(lSymMessage);
        this.host4.addMessageListener(lSymMessage);
        this.host5.addMessageListener(lSymMessage);
        this.host6.addMessageListener(lSymMessage);
        this.host7.addMessageListener(lSymMessage);
        this.host8.addMessageListener(lSymMessage);
        SymAction lSymAction = new SymAction();
        this.helpButton.addActionListener(lSymAction);
    }

    public void clkReceived(ClkEvent e) {
        this.doScenario(e);
    }

    public void reset() {
        this.busSegment1.reset();
        this.busSegment2.reset();
        this.busSegment3.reset();
        this.busSegment4.reset();
        this.host1.reset();
        this.host2.reset();
        this.host3.reset();
        this.host4.reset();
        this.host5.reset();
        this.host6.reset();
        this.host7.reset();
        this.host8.reset();
        this.clkReceived(new ClkEvent(this, true));
        this.clkReceived(new ClkEvent(this, false));
        this.clkReceived(new ClkEvent(this, true));
    }

    public void resetDataSize() {
        try {
            this.performanceSlider.setValue(100);
        }
        catch (PropertyVetoException propertyVetoException) {}
        this.host1.resetDataSize();
        this.host2.resetDataSize();
        this.host3.resetDataSize();
        this.host4.resetDataSize();
        this.host5.resetDataSize();
        this.host6.resetDataSize();
        this.host7.resetDataSize();
        this.host8.resetDataSize();
    }

    public int getEfficiency() {
        double sentDataSize = 0.0;
        double receivedDataSize = 0.0;
        sentDataSize = this.host1.getSentDataSize() + this.host2.getSentDataSize() + this.host3.getSentDataSize() + this.host4.getSentDataSize() + this.host5.getSentDataSize() + this.host6.getSentDataSize() + this.host7.getSentDataSize() + this.host8.getSentDataSize();
        receivedDataSize = this.host1.getReceivedDataSize() + this.host2.getReceivedDataSize() + this.host3.getReceivedDataSize() + this.host4.getReceivedDataSize() + this.host5.getReceivedDataSize() + this.host6.getReceivedDataSize() + this.host7.getReceivedDataSize() + this.host8.getReceivedDataSize();
        double returnValue = -1.0;
        if (sentDataSize != 0.0) {
            returnValue = receivedDataSize / sentDataSize * 100.0;
        }
        return (int)returnValue;
    }

    void showEfficiency() {
        block2: {
            int eff = this.getEfficiency();
            if (eff == -1) break block2;
            try {
                this.performanceSlider.setValue(100 - eff);
            }
            catch (Exception exception) {}
        }
    }

    public static void main(String[] args) {
        new 1.DriverFrame().show();
    }

    void busSegment1_dataToRight(DataEvent event) {
        this.busSegment2.dataFromLeft(event);
    }

    void busSegment2_dataToRight(DataEvent event) {
        this.busSegment3.dataFromLeft(event);
    }

    void busSegment3_dataToRight(DataEvent event) {
        this.busSegment4.dataFromLeft(event);
    }

    void busSegment4_dataToLeft(DataEvent event) {
        this.busSegment3.dataFromRight(event);
    }

    void busSegment3_dataToLeft(DataEvent event) {
        this.busSegment2.dataFromRight(event);
    }

    void busSegment2_dataToLeft(DataEvent event) {
        this.busSegment1.dataFromRight(event);
    }

    void busSegment1_dataToTop(DataEvent event) {
        this.host1.dataFromBottom(event);
    }

    void busSegment1_dataToBottom(DataEvent event) {
        this.host2.dataFromTop(event);
    }

    void busSegment2_dataToTop(DataEvent event) {
        this.host3.dataFromBottom(event);
    }

    void busSegment2_dataToBottom(DataEvent event) {
        this.host4.dataFromTop(event);
    }

    void busSegment3_dataToTop(DataEvent event) {
        this.host5.dataFromBottom(event);
    }

    void busSegment3_dataToBottom(DataEvent event) {
        this.host6.dataFromTop(event);
    }

    void busSegment4_dataToTop(DataEvent event) {
        this.host7.dataFromBottom(event);
    }

    void busSegment4_dataToBottom(DataEvent event) {
        this.host8.dataFromTop(event);
    }

    void host1_dataToBottom(DataEvent event) {
        this.busSegment1.dataFromTop(event);
    }

    void host2_dataToTop(DataEvent event) {
        this.busSegment1.dataFromBottom(event);
    }

    void host3_dataToBottom(DataEvent event) {
        this.busSegment2.dataFromTop(event);
    }

    void host5_dataToBottom(DataEvent event) {
        this.busSegment3.dataFromTop(event);
    }

    void host7_dataToBottom(DataEvent event) {
        this.busSegment4.dataFromTop(event);
    }

    void host4_dataToTop(DataEvent event) {
        this.busSegment2.dataFromBottom(event);
    }

    void host6_dataToTop(DataEvent event) {
        this.busSegment3.dataFromBottom(event);
    }

    void host8_dataToTop(DataEvent event) {
        this.busSegment4.dataFromBottom(event);
    }

    void host_deliverMessage(MessageEvent event) {
        this.deliverMessage(event);
    }

    void helpButton_ActionPerformed(ActionEvent event) {
        this.deliverMessage(new MessageEvent(this, 702, 710, "Efficiency", " Shows the proportion of received data to the sent data by all hosts."));
    }

    class SymData
    implements DataListener {
        public void dataToRight(DataEvent event) {
            Object object = event.getSource();
            if (object == Ethernet.this.busSegment1) {
                Ethernet.this.busSegment1_dataToRight(event);
            } else if (object == Ethernet.this.busSegment2) {
                Ethernet.this.busSegment2_dataToRight(event);
            } else if (object == Ethernet.this.busSegment3) {
                Ethernet.this.busSegment3_dataToRight(event);
            }
        }

        public void dataToTop(DataEvent event) {
            Object object = event.getSource();
            if (object == Ethernet.this.busSegment1) {
                Ethernet.this.busSegment1_dataToTop(event);
            } else if (object == Ethernet.this.busSegment2) {
                Ethernet.this.busSegment2_dataToTop(event);
            } else if (object == Ethernet.this.busSegment3) {
                Ethernet.this.busSegment3_dataToTop(event);
            } else if (object == Ethernet.this.busSegment4) {
                Ethernet.this.busSegment4_dataToTop(event);
            } else if (object == Ethernet.this.host2) {
                Ethernet.this.host2_dataToTop(event);
            } else if (object == Ethernet.this.host4) {
                Ethernet.this.host4_dataToTop(event);
            } else if (object == Ethernet.this.host6) {
                Ethernet.this.host6_dataToTop(event);
            } else if (object == Ethernet.this.host8) {
                Ethernet.this.host8_dataToTop(event);
            }
        }

        public void dataToBottom(DataEvent event) {
            Object object = event.getSource();
            if (object == Ethernet.this.busSegment1) {
                Ethernet.this.busSegment1_dataToBottom(event);
            } else if (object == Ethernet.this.busSegment2) {
                Ethernet.this.busSegment2_dataToBottom(event);
            } else if (object == Ethernet.this.busSegment3) {
                Ethernet.this.busSegment3_dataToBottom(event);
            } else if (object == Ethernet.this.busSegment4) {
                Ethernet.this.busSegment4_dataToBottom(event);
            } else if (object == Ethernet.this.host1) {
                Ethernet.this.host1_dataToBottom(event);
            } else if (object == Ethernet.this.host3) {
                Ethernet.this.host3_dataToBottom(event);
            } else if (object == Ethernet.this.host5) {
                Ethernet.this.host5_dataToBottom(event);
            } else if (object == Ethernet.this.host7) {
                Ethernet.this.host7_dataToBottom(event);
            }
        }

        public void dataToLeft(DataEvent event) {
            Object object = event.getSource();
            if (object == Ethernet.this.busSegment4) {
                Ethernet.this.busSegment4_dataToLeft(event);
            } else if (object == Ethernet.this.busSegment3) {
                Ethernet.this.busSegment3_dataToLeft(event);
            } else if (object == Ethernet.this.busSegment2) {
                Ethernet.this.busSegment2_dataToLeft(event);
            }
        }

        SymData() {
            Ethernet.this = Ethernet.this;
        }
    }

    class SymMessage
    implements MessageListener {
        public void deliverMessage(MessageEvent event) {
            Ethernet.this.host_deliverMessage(event);
        }

        SymMessage() {
            Ethernet.this = Ethernet.this;
        }
    }

    class SymAction
    implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == Ethernet.this.helpButton) {
                Ethernet.this.helpButton_ActionPerformed(event);
            }
        }

        SymAction() {
            Ethernet.this = Ethernet.this;
        }
    }
}

