/*
 * Decompiled with CFR 0.152.
 */
package kom.itbeankit.nw.ethernet;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Panel;
import java.util.Vector;
import kom.itbeankit.common.vcr.ClkEvent;
import kom.itbeankit.common.vcr.ClkListener;
import kom.itbeankit.nw.ethernet.BusElement;
import kom.itbeankit.nw.ethernet.BusElementStatus;
import kom.itbeankit.nw.ethernet.DataEvent;
import kom.itbeankit.nw.ethernet.DataListener;
import kom.itbeankit.nw.ethernet.EthernetInterface;
import symantec.itools.beans.PropertyChangeSupport;

public class BusElement
extends Container
implements EthernetInterface,
ClkListener {
    Panel panel;
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);
    protected int dataType;
    protected boolean dark;
    protected BusElementStatus newStatus;
    protected BusElementStatus oldStatus;
    private Vector dataListeners = new Vector();

    public BusElement() {
        this.setLayout(new BorderLayout(0, 0));
        this.setSize(20, 20);
        this.panel = new Panel();
        this.panel.setLayout(null);
        this.panel.setBounds(0, 0, 20, 20);
        this.panel.setBackground(new Color(0xC0C0C0));
        this.add("Center", this.panel);
        this.panel.setBackground(new Color(13684194));
        this.newStatus = new BusElementStatus();
        this.oldStatus = new BusElementStatus();
        this.dataType = 0;
        this.dark = false;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.panel.setSize(this.getSize());
    }

    public void reset() {
        this.oldStatus = new BusElementStatus();
        this.newStatus = new BusElementStatus();
        this.dark = false;
    }

    public void clkReceived(ClkEvent clkEvent) {
        if (clkEvent.isRisingEdge()) {
            this.processOldStatus();
            return;
        }
        this.oldStatus.setStatus(this.newStatus);
        this.newStatus = new BusElementStatus();
    }

    private void processOldStatus() {
        this.setDataType(this.oldStatus.getDataType());
        this.setColor();
        int n = 0;
        while (n < this.dataListeners.size()) {
            DataEvent dataEvent;
            DataListener dataListener = (DataListener)this.dataListeners.elementAt(n);
            if (this.oldStatus.fromLeftDataEvent != null) {
                dataEvent = new DataEvent(this, this.oldStatus.fromLeftDataEvent);
                dataListener.dataToRight(dataEvent);
                dataListener.dataToTop(dataEvent);
                dataListener.dataToBottom(dataEvent);
                this.oldStatus.fromLeftDataEvent = null;
            }
            if (this.oldStatus.fromRightDataEvent != null) {
                dataEvent = new DataEvent(this, this.oldStatus.fromRightDataEvent);
                dataListener.dataToLeft(dataEvent);
                dataListener.dataToTop(dataEvent);
                dataListener.dataToBottom(dataEvent);
                this.oldStatus.fromRightDataEvent = null;
            }
            if (this.oldStatus.fromTopDataEvent != null) {
                dataEvent = new DataEvent(this, this.oldStatus.fromTopDataEvent);
                dataListener.dataToRight(dataEvent);
                dataListener.dataToLeft(dataEvent);
                dataListener.dataToBottom(dataEvent);
                this.oldStatus.fromTopDataEvent = null;
            }
            if (this.oldStatus.fromBottomDataEvent != null) {
                dataEvent = new DataEvent(this, this.oldStatus.fromBottomDataEvent);
                dataListener.dataToRight(dataEvent);
                dataListener.dataToTop(dataEvent);
                dataListener.dataToLeft(dataEvent);
                this.oldStatus.fromBottomDataEvent = null;
            }
            ++n;
        }
    }

    public synchronized void addDataListener(DataListener dataListener) {
        this.dataListeners.addElement(dataListener);
    }

    public synchronized void removeDataListener(DataListener dataListener) {
        this.dataListeners.removeElement(dataListener);
    }

    public void dataFromRight(DataEvent dataEvent) {
        if (this.newStatus.fromRightDataEvent != null) {
            dataEvent = new DataEvent(this, 4, 0, 0, 0, false, false);
        }
        this.newStatus.fromRightDataEvent = dataEvent;
    }

    public void dataFromLeft(DataEvent dataEvent) {
        if (this.newStatus.fromLeftDataEvent != null) {
            dataEvent = new DataEvent(this, 4, 0, 0, 0, false, false);
        }
        this.newStatus.fromLeftDataEvent = dataEvent;
    }

    public void dataFromTop(DataEvent dataEvent) {
        if (this.newStatus.fromTopDataEvent != null) {
            dataEvent = new DataEvent(this, 4, 0, 0, 0, false, false);
        }
        this.newStatus.fromTopDataEvent = dataEvent;
    }

    public void dataFromBottom(DataEvent dataEvent) {
        if (this.newStatus.fromBottomDataEvent != null) {
            dataEvent = new DataEvent(this, 4, 0, 0, 0, false, false);
        }
        this.newStatus.fromBottomDataEvent = dataEvent;
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    private void setColor() {
        var1_1 = 0;
        if (!this.dark) ** GOTO lbl16
        switch (this.dataType) {
            case 0: {
                var1_1 = 13684194;
                break;
            }
            case 2: {
                var1_1 = -16760704;
                break;
            }
            case 3: {
                var1_1 = 14014979;
                break;
            }
            case 4: {
                var1_1 = 14157313;
                break;
            }
lbl16:
            // 1 sources

            switch (this.dataType) {
                case 0: {
                    var1_1 = 13684194;
                    break;
                }
                case 2: {
                    var1_1 = -16750704;
                    break;
                }
                case 3: {
                    var1_1 = 0xFFFF00;
                    break;
                }
                case 4: {
                    var1_1 = 0xFF0000;
                }
            }
            break;
        }
        this.panel.setBackground(new Color(var1_1));
    }

    public void setDataType(int n) {
        if (n != 0) {
            this.dark = !this.dark;
        }
        this.dataType = n;
    }

    public int getDataType() {
        return this.dataType;
    }

    public static void main(String[] stringArray) {
        new 1.DriverFrame().show();
    }
}

