/*
 * Decompiled with CFR 0.152.
 */
package kom.itbeankit.nw.ethernet;

import kom.itbeankit.nw.ethernet.DataEvent;
import kom.itbeankit.nw.ethernet.OnePersistentAlgorithm;

public class NonPersistentAlgorithm
extends OnePersistentAlgorithm {
    public void onCarrierSense() {
        this.host.carrierSense = 1;
        this.host.collisionDetect = 0;
        this.host.sendDataEvent = null;
        if (this.dataEvent != null) {
            this.host.carrierSense = 2;
            if (this.isNewFrameReceived()) {
                this.msg(711, "abort sensing carrier, \n   begin receiving from host" + this.dataEvent.getSourceHost() + ".");
                this.beginReceiving();
                return;
            }
            this.host.countdownTime = this.getRandomTime();
            this.msg(711, "bus is busy, \n   begin countdown.");
            this.host.onStatus(1);
            return;
        }
        if (this.isDataToSend()) {
            int dSize = this.host.frameSize;
            if (dSize == 16 && this.host.usePadField) {
                dSize = 56;
            }
            this.host.sendDataEvent = new DataEvent(this.host, 2, dSize, this.host.ID, this.host.destinationHost, true, false);
            this.host.remainingSendDataSize = this.host.frameSize - 1;
            ++this.host.sentDataSize;
            this.host.carrierSense = 0;
            this.host.collisionDetect = 1;
            this.msg(710, "bus is free, \n   begin sending to " + this.getDestinationString(this.host.destinationHost) + ".");
            this.host.onStatus(13);
            return;
        }
        this.msg(711, "nothing to do, going idle.");
        this.host.onStatus(0);
    }
}

