/*
 * Decompiled with CFR 0.152.
 */
package kom.itbeankit.nw.ethernet;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Panel;
import java.beans.PropertyVetoException;
import kom.itbeankit.nw.ethernet.Arrow;
import kom.itbeankit.nw.ethernet.EthernetInterface;
import symantec.itools.awt.shape.HorizontalLine;
import symantec.itools.awt.shape.Line;
import symantec.itools.awt.shape.VerticalLine;

public class Arrow
extends Container
implements EthernetInterface {
    Panel panel;
    Label arrowTimerLabel;
    Line arrowLeftEdgeLine;
    Line arrowRightEdgeLine;
    VerticalLine arrowLeftVerticalLine;
    VerticalLine arrowRightVerticalLine;
    HorizontalLine arrowLeftHorizontalLine;
    HorizontalLine arrowRighthorizontalLine;
    HorizontalLine arrowTopHorizontalLine;
    protected int status = 0;
    protected int number;

    public Arrow() {
        this.setLayout(new BorderLayout(0, 0));
        this.setSize(104, 42);
        this.panel = new Panel();
        this.panel.setLayout(null);
        this.panel.setBounds(0, 0, 104, 42);
        this.add("Center", this.panel);
        this.arrowTimerLabel = new Label("");
        this.arrowTimerLabel.setVisible(false);
        this.arrowTimerLabel.setBounds(8, 25, 18, 12);
        this.panel.add(this.arrowTimerLabel);
        this.arrowLeftEdgeLine = new Line();
        this.arrowLeftEdgeLine.setBounds(0, 15, 12, 12);
        this.panel.add(this.arrowLeftEdgeLine);
        this.arrowRightEdgeLine = new Line();
        try {
            this.arrowRightEdgeLine.setPositiveSlope(true);
        }
        catch (PropertyVetoException propertyVetoException) {}
        this.arrowRightEdgeLine.setBounds(10, 14, 13, 13);
        this.panel.add(this.arrowRightEdgeLine);
        this.arrowLeftVerticalLine = new VerticalLine();
        this.arrowLeftVerticalLine.setBounds(5, 0, 1, 15);
        this.panel.add(this.arrowLeftVerticalLine);
        this.arrowRightVerticalLine = new VerticalLine();
        this.arrowRightVerticalLine.setBounds(17, 0, 1, 15);
        this.panel.add(this.arrowRightVerticalLine);
        this.arrowLeftHorizontalLine = new HorizontalLine();
        this.arrowLeftHorizontalLine.setBounds(0, 14, 5, 1);
        this.panel.add(this.arrowLeftHorizontalLine);
        this.arrowRighthorizontalLine = new HorizontalLine();
        this.arrowRighthorizontalLine.setBounds(18, 14, 5, 1);
        this.panel.add(this.arrowRighthorizontalLine);
        this.arrowTopHorizontalLine = new HorizontalLine();
        this.arrowTopHorizontalLine.setBounds(5, 0, 12, 1);
        this.panel.add(this.arrowTopHorizontalLine);
        this.setSize(42, 42);
    }

    public Arrow(int number, int status) {
        this();
        this.setStatus(status);
        this.setNumber(number);
    }

    public void setStatus(int status) {
        if (this.status != status) {
            switch (status) {
                case 0: {
                    this.turnOff();
                    break;
                }
                case 2: {
                    this.turnThickUp();
                    break;
                }
                case -2: {
                    this.turnThickDown();
                    break;
                }
                case 1: {
                    this.turnCountdownUp();
                    break;
                }
                case -1: {
                    this.turnCountdownDown();
                    break;
                }
            }
        }
    }

    public void fill(Color c) {
        this.arrowTimerLabel.setVisible(false);
        this.arrowTimerLabel.setText("");
        Graphics g = this.panel.getGraphics();
        g.setColor(c);
        switch (this.status) {
            case 2: {
                int[] tuX = new int[]{12, 15, 15, 26, 26, 28, 20};
                int[] tuY = new int[]{13, 13, 39, 39, 13, 13, 4};
                g.fillPolygon(tuX, tuY, 7);
                break;
            }
            case -2: {
                int[] tdX = new int[]{12, 20, 28, 26, 26, 15, 15};
                int[] tdY = new int[]{32, 40, 32, 32, 7, 7, 32};
                g.fillPolygon(tdX, tdY, 7);
                break;
            }
        }
    }

    public void turnOff() {
        this.status = 0;
        this.arrowTimerLabel.setText("");
        this.arrowTimerLabel.setVisible(false);
        this.showLines(false);
    }

    public void turnThickUp() {
        this.status = 2;
        this.arrowTimerLabel.setText("");
        this.arrowTimerLabel.setVisible(false);
        this.arrowLeftEdgeLine.setBounds(10, 2, 12, 12);
        this.arrowRightEdgeLine.setBounds(19, 2, 12, 12);
        this.arrowLeftVerticalLine.setBounds(13, 13, 2, 26);
        this.arrowRightVerticalLine.setBounds(26, 13, 2, 26);
        this.arrowLeftHorizontalLine.setBounds(9, 13, 5, 2);
        this.arrowRighthorizontalLine.setBounds(27, 13, 5, 2);
        this.arrowTopHorizontalLine.setBounds(13, 39, 15, 2);
        this.adjustEdgeLines(3, true);
        this.showLines(true);
    }

    public void turnThickDown() {
        this.status = -2;
        this.arrowTimerLabel.setText("");
        this.arrowTimerLabel.setVisible(false);
        this.arrowLeftEdgeLine.setBounds(10, 31, 12, 12);
        this.arrowRightEdgeLine.setBounds(19, 31, 12, 12);
        this.arrowLeftVerticalLine.setBounds(13, 5, 2, 27);
        this.arrowRightVerticalLine.setBounds(26, 5, 2, 27);
        this.arrowLeftHorizontalLine.setBounds(9, 30, 5, 2);
        this.arrowRighthorizontalLine.setBounds(27, 30, 5, 2);
        this.arrowTopHorizontalLine.setBounds(13, 5, 13, 2);
        this.adjustEdgeLines(3, false);
        this.showLines(true);
    }

    public void turnCountdownUp() {
        this.status = 1;
        this.arrowTimerLabel.setVisible(true);
        this.arrowTimerLabel.setBounds(14, 18, 14, 12);
        this.arrowLeftEdgeLine.setBounds(8, 8, 12, 12);
        this.arrowRightEdgeLine.setBounds(20, 8, 13, 13);
        this.arrowLeftVerticalLine.setBounds(11, 20, 1, 15);
        this.arrowRightVerticalLine.setBounds(30, 20, 1, 15);
        this.arrowLeftHorizontalLine.setBounds(9, 20, 2, 1);
        this.arrowRighthorizontalLine.setBounds(30, 20, 3, 1);
        this.arrowTopHorizontalLine.setBounds(11, 35, 19, 1);
        this.adjustEdgeLines(1, true);
        this.showLines(true);
    }

    public void turnCountdownDown() {
        this.arrowTimerLabel.setVisible(true);
        this.status = -1;
        this.arrowTimerLabel.setBounds(14, 10, 14, 12);
        this.arrowLeftEdgeLine.setBounds(9, 20, 12, 12);
        this.arrowRightEdgeLine.setBounds(20, 19, 13, 13);
        this.arrowLeftVerticalLine.setBounds(11, 5, 1, 15);
        this.arrowRightVerticalLine.setBounds(30, 5, 1, 15);
        this.arrowLeftHorizontalLine.setBounds(9, 19, 2, 1);
        this.arrowRighthorizontalLine.setBounds(30, 19, 3, 1);
        this.arrowTopHorizontalLine.setBounds(11, 5, 19, 1);
        this.adjustEdgeLines(1, false);
        this.showLines(true);
    }

    private void adjustEdgeLines(int thickness, boolean up) {
        try {
            this.arrowLeftEdgeLine.setLineThickness(thickness);
        }
        catch (PropertyVetoException propertyVetoException) {}
        try {
            this.arrowRightEdgeLine.setLineThickness(thickness);
        }
        catch (PropertyVetoException propertyVetoException) {}
        try {
            this.arrowRightEdgeLine.setPositiveSlope(!up);
        }
        catch (PropertyVetoException propertyVetoException) {}
        try {
            this.arrowLeftEdgeLine.setPositiveSlope(up);
        }
        catch (PropertyVetoException propertyVetoException) {}
    }

    private void showLines(boolean show) {
        this.arrowLeftEdgeLine.setVisible(show);
        this.arrowRightEdgeLine.setVisible(show);
        this.arrowLeftVerticalLine.setVisible(show);
        this.arrowRightVerticalLine.setVisible(show);
        this.arrowLeftHorizontalLine.setVisible(show);
        this.arrowRighthorizontalLine.setVisible(show);
        this.arrowTopHorizontalLine.setVisible(show);
    }

    public int getStatus() {
        return this.status;
    }

    public void setNumber(int number) {
        if (this.number != number) {
            this.number = number;
            String numStr = new Integer(number).toString();
            if (number < 10) {
                numStr = "0" + numStr;
            }
            this.arrowTimerLabel.setText(numStr);
            this.repaint();
        }
    }

    public int getNumber() {
        return this.number;
    }

    public static void main(String[] args) {
        new 1.DriverFrame().show();
    }
}

