/*
 * Decompiled with CFR 0.152.
 */
package kom.itbeankit.nw.ethernet;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.util.Vector;
import kom.itbeankit.common.message.MessageEvent;
import kom.itbeankit.common.message.MessageListener;
import kom.itbeankit.common.vcr.ClkEvent;
import kom.itbeankit.common.vcr.ClkListener;
import kom.itbeankit.nw.ethernet.AlgorithmInterface;
import kom.itbeankit.nw.ethernet.Arrow;
import kom.itbeankit.nw.ethernet.DataEvent;
import kom.itbeankit.nw.ethernet.DataListener;
import kom.itbeankit.nw.ethernet.EthernetInterface;
import kom.itbeankit.nw.ethernet.Host;
import kom.itbeankit.nw.ethernet.HostDialog;
import kom.itbeankit.nw.ethernet.Signal;
import symantec.itools.awt.BorderPanel;
import symantec.itools.awt.shape.HorizontalLine;
import symantec.itools.awt.shape.Line;
import symantec.itools.awt.shape.VerticalLine;

public class Host
extends Container
implements EthernetInterface,
ClkListener {
    private Vector dataListeners = new Vector();
    private Vector messageListeners = new Vector();
    protected HostDialog hostDialog;
    protected int ID = 1;
    protected boolean overTheBus = true;
    protected int status = 0;
    protected MessageEvent msgEvent;
    protected AlgorithmInterface algorithm;
    protected DataEvent sendDataEvent;
    protected int destinationHost = -1;
    protected int frameSize = 56;
    protected int remainingSendDataSize;
    protected int sentDataSize;
    protected int countdownTime;
    protected int carrierSense = 0;
    protected int collisionDetect = 0;
    protected int maxCollisionCount = 10;
    protected int collisionCount;
    protected boolean autoRepeat = false;
    protected boolean usePadField = false;
    protected DataEvent oldReceiveDataEvent;
    protected DataEvent newReceiveDataEvent;
    protected int sourceHost;
    protected int bufferedReceivedDataSize;
    protected int receivedDataSize;
    protected int remainingReceiveDataSize;
    Panel panel;
    Line dTopLeft;
    Line dTopRight;
    Line mTopLeft;
    Line mTopRight;
    Line dRightBottom;
    Line mRightBottom;
    HorizontalLine mTopBack;
    VerticalLine mRightBack;
    HorizontalLine dTopBack;
    VerticalLine dRightBack;
    BorderPanel dFrontPanel;
    Label hostNumberLabel;
    Signal csSignal;
    Signal cdSignal;
    BorderPanel mFrontPanel;
    Arrow arrow;

    public Host() {
        this.setLayout(new BorderLayout(0, 0));
        this.setSize(80, 74);
        this.panel = new Panel();
        this.panel.setLayout(null);
        this.panel.setBounds(0, 0, 104, 74);
        this.add("Center", this.panel);
        this.dTopLeft = new Line();
        try {
            this.dTopLeft.setPositiveSlope(true);
        }
        catch (PropertyVetoException propertyVetoException) {}
        this.dTopLeft.setBounds(0, 38, 20, 20);
        this.panel.add(this.dTopLeft);
        this.dTopRight = new Line();
        try {
            this.dTopRight.setPositiveSlope(true);
        }
        catch (PropertyVetoException propertyVetoException) {}
        this.dTopRight.setBounds(59, 38, 20, 20);
        this.panel.add(this.dTopRight);
        this.mTopLeft = new Line();
        try {
            this.mTopLeft.setPositiveSlope(true);
        }
        catch (PropertyVetoException propertyVetoException) {}
        this.mTopLeft.setBounds(12, 0, 10, 10);
        this.panel.add(this.mTopLeft);
        this.mTopRight = new Line();
        try {
            this.mTopRight.setPositiveSlope(true);
        }
        catch (PropertyVetoException propertyVetoException) {}
        this.mTopRight.setBounds(55, 0, 10, 10);
        this.panel.add(this.mTopRight);
        this.dRightBottom = new Line();
        try {
            this.dRightBottom.setPositiveSlope(true);
        }
        catch (PropertyVetoException propertyVetoException) {}
        this.dRightBottom.setBounds(60, 53, 20, 20);
        this.panel.add(this.dRightBottom);
        this.mRightBottom = new Line();
        try {
            this.mRightBottom.setPositiveSlope(true);
        }
        catch (PropertyVetoException propertyVetoException) {}
        this.mRightBottom.setBounds(55, 43, 10, 10);
        this.panel.add(this.mRightBottom);
        this.mTopBack = new HorizontalLine();
        this.mTopBack.setBounds(22, 0, 44, 1);
        this.panel.add(this.mTopBack);
        this.mRightBack = new VerticalLine();
        this.mRightBack.setBounds(65, 0, 1, 44);
        this.panel.add(this.mRightBack);
        this.dTopBack = new HorizontalLine();
        this.dTopBack.setBounds(66, 38, 14, 1);
        this.panel.add(this.dTopBack);
        this.dRightBack = new VerticalLine();
        this.dRightBack.setBounds(79, 38, 1, 16);
        this.panel.add(this.dRightBack);
        this.dFrontPanel = new BorderPanel();
        try {
            this.dFrontPanel.setIPadBottom(0);
        }
        catch (PropertyVetoException propertyVetoException) {}
        try {
            this.dFrontPanel.setIPadSides(1);
        }
        catch (PropertyVetoException propertyVetoException) {}
        try {
            this.dFrontPanel.setPaddingRight(0);
        }
        catch (PropertyVetoException propertyVetoException) {}
        try {
            this.dFrontPanel.setPaddingBottom(0);
        }
        catch (PropertyVetoException propertyVetoException) {}
        try {
            this.dFrontPanel.setPaddingTop(0);
        }
        catch (PropertyVetoException propertyVetoException) {}
        try {
            this.dFrontPanel.setIPadTop(1);
        }
        catch (PropertyVetoException propertyVetoException) {}
        try {
            this.dFrontPanel.setPaddingLeft(0);
        }
        catch (PropertyVetoException propertyVetoException) {}
        this.dFrontPanel.setLayout(new GridLayout(1, 1, 0, 0));
        this.dFrontPanel.setBounds(0, 58, 60, 16);
        this.dFrontPanel.setBackground(new Color(-1644826));
        this.panel.add(this.dFrontPanel);
        this.dFrontPanel.setCursor(new Cursor(12));
        this.hostNumberLabel = new Label("1", 1);
        this.hostNumberLabel.setBounds(0, 0, 19, 14);
        this.dFrontPanel.add(this.hostNumberLabel);
        this.csSignal = new Signal();
        this.csSignal.setText("CS");
        this.csSignal.setAlignment(0);
        this.csSignal.setBounds(19, 0, 19, 14);
        this.csSignal.setFont(new Font("Dialog", 1, 12));
        this.csSignal.setForeground(new Color(0x808080));
        this.dFrontPanel.add(this.csSignal);
        this.cdSignal = new Signal();
        this.cdSignal.setText("CD");
        this.cdSignal.setAlignment(0);
        this.cdSignal.setBounds(38, 0, 19, 14);
        this.cdSignal.setFont(new Font("Dialog", 1, 12));
        this.cdSignal.setForeground(new Color(0x808080));
        this.dFrontPanel.add(this.cdSignal);
        this.mFrontPanel = new BorderPanel();
        try {
            this.mFrontPanel.setIPadBottom(0);
        }
        catch (PropertyVetoException propertyVetoException) {}
        try {
            this.mFrontPanel.setIPadSides(1);
        }
        catch (PropertyVetoException propertyVetoException) {}
        try {
            this.mFrontPanel.setPaddingRight(0);
        }
        catch (PropertyVetoException propertyVetoException) {}
        try {
            this.mFrontPanel.setPaddingBottom(0);
        }
        catch (PropertyVetoException propertyVetoException) {}
        try {
            this.mFrontPanel.setPaddingTop(0);
        }
        catch (PropertyVetoException propertyVetoException) {}
        try {
            this.mFrontPanel.setIPadTop(1);
        }
        catch (PropertyVetoException propertyVetoException) {}
        try {
            this.mFrontPanel.setPaddingLeft(0);
        }
        catch (PropertyVetoException propertyVetoException) {}
        this.mFrontPanel.setLayout(new BorderLayout(0, 0));
        this.mFrontPanel.setBounds(12, 10, 44, 44);
        this.mFrontPanel.setBackground(new Color(0xFFFFFF));
        this.panel.add(this.mFrontPanel);
        this.arrow = new Arrow();
        this.arrow.setLayout(new BorderLayout(0, 0));
        this.arrow.setBounds(0, 0, 41, 42);
        this.mFrontPanel.add("Center", this.arrow);
        this.dFrontPanel.setBackground(new Color(13684194));
        this.arrow.turnOff();
        this.setSize(80, 74);
        SymMouse aSymMouse = new SymMouse();
        this.panel.addMouseListener(aSymMouse);
        this.arrow.addMouseListener(aSymMouse);
        this.csSignal.addMouseListener(aSymMouse);
        this.cdSignal.addMouseListener(aSymMouse);
        this.hostNumberLabel.addMouseListener(aSymMouse);
        this.dFrontPanel.addMouseListener(aSymMouse);
        this.mFrontPanel.addMouseListener(aSymMouse);
    }

    public void fill(Color c) {
        Graphics g = this.panel.getGraphics();
        g.setColor(c);
        int[] mTopX = new int[]{23, 64, 55, 13};
        int[] mTopY = new int[]{1, 1, 10, 10};
        g.fillPolygon(mTopX, mTopY, 4);
        int[] mSideX = new int[]{56, 65, 65, 56};
        int[] mSideY = new int[]{11, 2, 43, 52};
        g.fillPolygon(mSideX, mSideY, 4);
        int[] dTopX = new int[]{12, 12, 56, 66, 66, 78, 59, 1};
        int[] dTopY = new int[]{48, 54, 54, 44, 39, 39, 58, 58};
        g.fillPolygon(dTopX, dTopY, 8);
        int[] dSideX = new int[]{60, 79, 79, 60};
        int[] dSideY = new int[]{58, 39, 53, 72};
        g.fillPolygon(dSideX, dSideY, 4);
    }

    public void reset() {
        this.status = 0;
        this.oldReceiveDataEvent = null;
        this.newReceiveDataEvent = null;
        this.sendDataEvent = null;
        this.carrierSense = 0;
        this.collisionDetect = 0;
        this.setDestinationHost(-1);
        this.setFrameSize(56);
        this.setAutoRepeat(false);
        this.countdownTime = 0;
        this.collisionCount = 0;
        this.sentDataSize = 0;
        this.remainingSendDataSize = 0;
        this.bufferedReceivedDataSize = 0;
        this.receivedDataSize = 0;
        this.remainingReceiveDataSize = 0;
    }

    public void resetDataSize() {
        this.sentDataSize = 0;
        this.receivedDataSize = 0;
    }

    public synchronized void addDataListener(DataListener lis) {
        this.dataListeners.addElement(lis);
    }

    public synchronized void removeDataListener(DataListener lis) {
        this.dataListeners.removeElement(lis);
    }

    public synchronized void addMessageListener(MessageListener lis) {
        this.messageListeners.addElement(lis);
    }

    public synchronized void removeMessageListener(MessageListener lis) {
        this.messageListeners.removeElement(lis);
    }

    public void dataFromTop(DataEvent e) {
        this.newReceiveDataEvent = e;
    }

    public void dataFromBottom(DataEvent e) {
        this.newReceiveDataEvent = e;
    }

    public void clkReceived(ClkEvent e) {
        if (e.isRisingEdge()) {
            this.algorithm.processStatus(this.status);
        } else {
            this.oldReceiveDataEvent = this.newReceiveDataEvent;
            this.newReceiveDataEvent = null;
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(80, 74);
    }

    public void paint(Graphics g) {
        this.setSize(this.getPreferredSize());
        super.paint(g);
    }

    public void onStatus(int hostStatus) {
        this.status = hostStatus;
        if (this.sendDataEvent != null) {
            if (this.overTheBus) {
                this.dataToBottom(this.sendDataEvent);
            } else {
                this.dataToTop(this.sendDataEvent);
            }
        }
        if (this.msgEvent != null) {
            this.fireMessageEvent(this.msgEvent);
            this.msgEvent = null;
        }
        this.csSignal.setStatus(this.carrierSense);
        this.cdSignal.setStatus(this.collisionDetect);
        switch (this.status) {
            case 0: {
                this.arrow.turnOff();
                break;
            }
            case 2: {
                this.setArrowThin();
                this.arrow.arrowTimerLabel.setText("");
                this.arrow.arrowTimerLabel.setVisible(false);
                break;
            }
            case 1: {
                this.setArrowThin();
                this.arrow.setNumber(this.countdownTime);
                break;
            }
            case 11: {
                this.setArrowReceive(-16750704);
                break;
            }
            case 12: {
                this.setArrowReceive(0xFFFF00);
                break;
            }
            case 13: {
                this.setArrowSend(-16750704);
                break;
            }
            case 14: {
                this.setArrowSend(0xFFFF00);
                break;
            }
            case 15: {
                this.setArrowSend(0xFF0000);
                break;
            }
        }
        int background = 13684194;
        if (this.status > 10) {
            background = -16750704;
        }
        this.fill(new Color(background));
    }

    void setArrowThin() {
        if (this.overTheBus) {
            this.arrow.turnCountdownDown();
        } else {
            this.arrow.turnCountdownUp();
        }
    }

    void setArrowReceive(int colorCode) {
        if (this.overTheBus) {
            this.arrow.turnThickUp();
        } else {
            this.arrow.turnThickDown();
        }
        this.arrow.fill(new Color(colorCode));
    }

    void setArrowSend(int colorCode) {
        if (this.overTheBus) {
            this.arrow.turnThickDown();
        } else {
            this.arrow.turnThickUp();
        }
        this.arrow.fill(new Color(colorCode));
    }

    public void setStatus(int hostStatus) {
        this.status = hostStatus;
    }

    public int getStatus() {
        return this.status;
    }

    public void setID(int ID) {
        this.ID = ID;
        this.hostNumberLabel.setText(new Integer(ID).toString());
    }

    public int getID() {
        return this.ID;
    }

    public void setDestinationHost(int destinationHost) {
        this.destinationHost = destinationHost;
        if (this.hostDialog != null) {
            this.hostDialog.setDestinationHost(destinationHost);
        }
    }

    public int getDestinationHost() {
        return this.destinationHost;
    }

    public void setFrameSize(int frameSize) {
        this.frameSize = frameSize;
        if (this.hostDialog != null) {
            this.hostDialog.setFrameSize(frameSize);
        }
    }

    public int getFrameSize() {
        return this.frameSize;
    }

    public void setAutoRepeat(boolean autoRepeat) {
        this.autoRepeat = autoRepeat;
        if (this.hostDialog != null) {
            this.hostDialog.setAutoRepeat(autoRepeat);
        }
    }

    public boolean isAutoRepeat() {
        return this.autoRepeat;
    }

    public void setUsePadField(boolean usePadField) {
        this.usePadField = usePadField;
    }

    public boolean isUsePadField() {
        return this.usePadField;
    }

    public void setCountdownTime(int countdownTime) {
        this.countdownTime = countdownTime;
    }

    public int getCountdownTime() {
        return this.countdownTime;
    }

    public int getReceivedDataSize() {
        return this.receivedDataSize;
    }

    public void setReceivedDataSize(int receivedDataSize) {
        this.receivedDataSize = receivedDataSize;
    }

    public int getSentDataSize() {
        return this.sentDataSize;
    }

    public void setSentDataSize(int sentDataSize) {
        this.sentDataSize = sentDataSize;
    }

    public void setOverTheBus(boolean overTheBus) {
        this.overTheBus = overTheBus;
    }

    public boolean isOverTheBus() {
        return this.overTheBus;
    }

    public void setAlgorithm(String algorithmName) {
        if (this.algorithm != null) {
            this.algorithm.cleanup();
        }
        try {
            this.algorithm = (AlgorithmInterface)Class.forName(algorithmName).newInstance();
        }
        catch (Exception exception) {}
        this.algorithm.setHost(this);
    }

    public static void main(String[] args) {
        new 1.DriverFrame().show();
    }

    void host_mouseClicked(MouseEvent event) {
        if (this.isEnabled()) {
            Container c = this;
            while (!(c instanceof Frame)) {
                c = c.getParent();
            }
            if (this.hostDialog != null) {
                this.hostDialog.toFront();
            } else {
                this.hostDialog = new HostDialog((Frame)c, this);
                this.hostDialog.setVisible(true);
            }
        }
    }

    void dataToBottom(int dataType, int dataSize, int destination, boolean startBit, boolean stopBit) {
        int i = 0;
        while (i < this.dataListeners.size()) {
            DataListener dl = (DataListener)this.dataListeners.elementAt(i);
            dl.dataToBottom(new DataEvent(this, dataSize, dataType, this.ID, destination, startBit, stopBit));
            ++i;
        }
    }

    void dataToTop(int dataType, int dataSize, int destination, boolean startBit, boolean stopBit) {
        int i = 0;
        while (i < this.dataListeners.size()) {
            DataListener dl = (DataListener)this.dataListeners.elementAt(i);
            dl.dataToTop(new DataEvent(this, dataSize, dataType, this.ID, destination, startBit, stopBit));
            ++i;
        }
    }

    void dataToBottom(DataEvent event) {
        int i = 0;
        while (i < this.dataListeners.size()) {
            DataListener dl = (DataListener)this.dataListeners.elementAt(i);
            dl.dataToBottom(event);
            ++i;
        }
    }

    void dataToTop(DataEvent event) {
        int i = 0;
        while (i < this.dataListeners.size()) {
            DataListener dl = (DataListener)this.dataListeners.elementAt(i);
            dl.dataToTop(event);
            ++i;
        }
    }

    public void cleanup() {
        if (this.hostDialog != null) {
            this.hostDialog.host = null;
            this.hostDialog = null;
            this.hostDialog.dispose();
        }
    }

    void fireMessageEvent(MessageEvent me) {
        int i = 0;
        while (i < this.messageListeners.size()) {
            MessageListener ml = (MessageListener)this.messageListeners.elementAt(i);
            ml.deliverMessage(me);
            ++i;
        }
    }

    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.dFrontPanel.setEnabled(b);
        if (b) {
            this.dFrontPanel.setCursor(new Cursor(12));
        } else {
            this.dFrontPanel.setCursor(new Cursor(0));
        }
    }

    class SymMouse
    extends MouseAdapter {
        public void mouseClicked(MouseEvent event) {
            Host.this.host_mouseClicked(event);
        }

        SymMouse() {
            Host.this = Host.this;
        }
    }
}

