/*
 * Decompiled with CFR 0.152.
 */
package kom.itbeankit.applet.jpeg;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;

public class ImagePanel
extends Panel {
    static final int preferredWidth = 351;
    static final int preferredHeight = 288;
    static final int preferredBorder = 5;
    static final Color preferredBorderColor = Color.black;
    private Graphics g;
    private int width;
    private int height;
    private int border;
    private Image output;
    private Color borderColor;

    public ImagePanel() {
        this(351, 288, 5);
    }

    public ImagePanel(int n, int n2, int n3) {
        this.setWidth(n);
        this.setHeight(n2);
        this.setBorder(n3);
        this.setBorderColor(preferredBorderColor);
        this.g = this.getGraphics();
        this.repaint();
    }

    public int getBorder() {
        return this.border;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public int getHeight() {
        return this.height;
    }

    public Image getOutput() {
        return this.output;
    }

    public int getWidth() {
        return this.width;
    }

    public void paint(Graphics graphics) {
        this.paintBorder(graphics);
        if (this.output != null) {
            graphics.drawImage(this.output, this.border, this.border, this);
        }
    }

    private void paintBorder(Graphics graphics) {
        int n = 0;
        while (n < this.border) {
            graphics.setColor(this.borderColor);
            graphics.drawRect(n, n, this.width - 2 * n, this.height - 2 * n);
            ++n;
        }
    }

    public void setBorder(int n) {
        this.border = n;
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
        this.repaint();
    }

    public void setHeight(int n) {
        this.height = n;
        this.setSize(this.width, this.height);
    }

    public synchronized void setOutput(Image image) {
        this.output = image.getScaledInstance(this.width - 2 * this.border, this.height - 2 * this.border, 2);
        this.repaint();
    }

    public void setWidth(int n) {
        this.width = n;
        this.setSize(this.width, this.height);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

