/*
 * Decompiled with CFR 0.152.
 */
package kom.itbeankit.mm.compression.quantization.model;

import kom.itbeankit.mm.compression.dct.model.DCTMatrix;
import kom.itbeankit.mm.compression.quantization.model.QuantMatrix;

public class Quantization {
    private int quality = 1;
    private int[][] zigZag = new int[64][2];
    private int[][] quantum_luminance = new int[8][8];
    private int[][] quantum_chrominance = new int[8][8];
    private short[][] quantBlock = new short[8][8];
    private short[][][][] YMatrixDCT;
    private short[][][][] UMatrixDCT;
    private short[][][][] VMatrixDCT;
    private int xNum = 5;
    private int yNum = 10;
    QuantMatrix matrix;
    DCTMatrix matrix1;

    public Quantization() {
        this.initZigZag();
        this.initMatrix(this.quality);
    }

    public void initMatrix(int n) {
        this.quality = n;
        int[] nArray = new int[]{16, 11, 10, 16, 24, 40, 51, 61, 12, 12, 14, 19, 26, 58, 60, 55, 14, 13, 16, 24, 40, 57, 69, 56, 14, 17, 22, 29, 51, 87, 80, 62, 18, 22, 37, 56, 68, 109, 103, 77, 24, 35, 55, 64, 81, 104, 113, 92, 49, 64, 78, 87, 103, 121, 120, 101, 72, 92, 95, 98, 112, 100, 103, 99};
        int n2 = 0;
        while (n2 <= 7) {
            int n3 = 0;
            while (n3 <= 7) {
                this.quantum_luminance[n2][n3] = this.quality * nArray[n3 + 8 * n2];
                ++n3;
            }
            ++n2;
        }
        int[] nArray2 = new int[]{17, 18, 24, 47, 99, 99, 99, 99, 18, 21, 26, 66, 99, 99, 99, 99, 24, 26, 56, 99, 99, 99, 99, 99, 47, 66, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99};
        int n4 = 0;
        while (n4 <= 7) {
            int n5 = 0;
            while (n5 <= 7) {
                this.quantum_chrominance[n4][n5] = this.quality * nArray2[n5 + 8 * n4];
                ++n5;
            }
            ++n4;
        }
    }

    public void initZigZag() {
        this.zigZag[0][0] = 0;
        this.zigZag[0][1] = 0;
        this.zigZag[1][0] = 0;
        this.zigZag[1][1] = 1;
        this.zigZag[2][0] = 1;
        this.zigZag[2][1] = 0;
        this.zigZag[3][0] = 2;
        this.zigZag[3][1] = 0;
        this.zigZag[4][0] = 1;
        this.zigZag[4][1] = 1;
        this.zigZag[5][0] = 0;
        this.zigZag[5][1] = 2;
        this.zigZag[6][0] = 0;
        this.zigZag[6][1] = 3;
        this.zigZag[7][0] = 1;
        this.zigZag[7][1] = 2;
        this.zigZag[8][0] = 2;
        this.zigZag[8][1] = 1;
        this.zigZag[9][0] = 3;
        this.zigZag[9][1] = 0;
        this.zigZag[10][0] = 4;
        this.zigZag[10][1] = 0;
        this.zigZag[11][0] = 3;
        this.zigZag[11][1] = 1;
        this.zigZag[12][0] = 2;
        this.zigZag[12][1] = 2;
        this.zigZag[13][0] = 1;
        this.zigZag[13][1] = 3;
        this.zigZag[14][0] = 0;
        this.zigZag[14][1] = 4;
        this.zigZag[15][0] = 0;
        this.zigZag[15][1] = 5;
        this.zigZag[16][0] = 1;
        this.zigZag[16][1] = 4;
        this.zigZag[17][0] = 2;
        this.zigZag[17][1] = 3;
        this.zigZag[18][0] = 3;
        this.zigZag[18][1] = 2;
        this.zigZag[19][0] = 4;
        this.zigZag[19][1] = 1;
        this.zigZag[20][0] = 5;
        this.zigZag[20][1] = 0;
        this.zigZag[21][0] = 6;
        this.zigZag[21][1] = 0;
        this.zigZag[22][0] = 5;
        this.zigZag[22][1] = 1;
        this.zigZag[23][0] = 4;
        this.zigZag[23][1] = 2;
        this.zigZag[24][0] = 3;
        this.zigZag[24][1] = 3;
        this.zigZag[25][0] = 2;
        this.zigZag[25][1] = 4;
        this.zigZag[26][0] = 1;
        this.zigZag[26][1] = 5;
        this.zigZag[27][0] = 0;
        this.zigZag[27][1] = 6;
        this.zigZag[28][0] = 0;
        this.zigZag[28][1] = 7;
        this.zigZag[29][0] = 1;
        this.zigZag[29][1] = 6;
        this.zigZag[30][0] = 2;
        this.zigZag[30][1] = 5;
        this.zigZag[31][0] = 3;
        this.zigZag[31][1] = 4;
        this.zigZag[32][0] = 4;
        this.zigZag[32][1] = 3;
        this.zigZag[33][0] = 5;
        this.zigZag[33][1] = 2;
        this.zigZag[34][0] = 6;
        this.zigZag[34][1] = 1;
        this.zigZag[35][0] = 7;
        this.zigZag[35][1] = 0;
        this.zigZag[36][0] = 7;
        this.zigZag[36][1] = 1;
        this.zigZag[37][0] = 6;
        this.zigZag[37][1] = 2;
        this.zigZag[38][0] = 5;
        this.zigZag[38][1] = 3;
        this.zigZag[39][0] = 4;
        this.zigZag[39][1] = 4;
        this.zigZag[40][0] = 3;
        this.zigZag[40][1] = 5;
        this.zigZag[41][0] = 2;
        this.zigZag[41][1] = 6;
        this.zigZag[42][0] = 1;
        this.zigZag[42][1] = 7;
        this.zigZag[43][0] = 2;
        this.zigZag[43][1] = 7;
        this.zigZag[44][0] = 3;
        this.zigZag[44][1] = 6;
        this.zigZag[45][0] = 4;
        this.zigZag[45][1] = 5;
        this.zigZag[46][0] = 5;
        this.zigZag[46][1] = 4;
        this.zigZag[47][0] = 6;
        this.zigZag[47][1] = 3;
        this.zigZag[48][0] = 7;
        this.zigZag[48][1] = 2;
        this.zigZag[49][0] = 7;
        this.zigZag[49][1] = 3;
        this.zigZag[50][0] = 6;
        this.zigZag[50][1] = 4;
        this.zigZag[51][0] = 5;
        this.zigZag[51][1] = 5;
        this.zigZag[52][0] = 4;
        this.zigZag[52][1] = 6;
        this.zigZag[53][0] = 3;
        this.zigZag[53][1] = 7;
        this.zigZag[54][0] = 4;
        this.zigZag[54][1] = 7;
        this.zigZag[55][0] = 5;
        this.zigZag[55][1] = 6;
        this.zigZag[56][0] = 6;
        this.zigZag[56][1] = 5;
        this.zigZag[57][0] = 7;
        this.zigZag[57][1] = 4;
        this.zigZag[58][0] = 7;
        this.zigZag[58][1] = 5;
        this.zigZag[59][0] = 6;
        this.zigZag[59][1] = 6;
        this.zigZag[60][0] = 5;
        this.zigZag[60][1] = 7;
        this.zigZag[61][0] = 6;
        this.zigZag[61][1] = 7;
        this.zigZag[62][0] = 7;
        this.zigZag[62][1] = 6;
        this.zigZag[63][0] = 7;
        this.zigZag[63][1] = 7;
    }

    public int[][] getZigZagMatrix() {
        return this.zigZag;
    }

    public int getXNum() {
        return this.xNum;
    }

    public int getYNum() {
        return this.yNum;
    }

    public QuantMatrix quantitizeYUV(DCTMatrix dCTMatrix, int n) {
        this.matrix = new QuantMatrix(dCTMatrix.XNumber, dCTMatrix.YNumber);
        int n2 = 0;
        while (n2 < dCTMatrix.XNumber) {
            int n3 = 0;
            while (n3 < dCTMatrix.YNumber) {
                int n4 = 0;
                while (n4 < 64) {
                    int n5 = this.zigZag[n4][0];
                    int n6 = this.zigZag[n4][1];
                    this.matrix.QuanY[n2][n3][n4] = (short)(5 * dCTMatrix.YMatrixDCT[n2][n3][n5][n6] / this.quantum_luminance[n5][n6] / n);
                    this.matrix.QuanU[n2][n3][n4] = (short)(5 * dCTMatrix.UMatrixDCT[n2][n3][n5][n6] / this.quantum_chrominance[n5][n6] / n);
                    this.matrix.QuanV[n2][n3][n4] = (short)(5 * dCTMatrix.VMatrixDCT[n2][n3][n5][n6] / this.quantum_chrominance[n5][n6] / n);
                    ++n4;
                }
                this.matrix.QuanY[n2][n3][0] = (short)(5 * dCTMatrix.YMatrixDCT[n2][n3][0][0] / this.quantum_luminance[0][0]);
                this.matrix.QuanU[n2][n3][0] = (short)(5 * dCTMatrix.UMatrixDCT[n2][n3][0][0] / this.quantum_chrominance[0][0]);
                this.matrix.QuanV[n2][n3][0] = (short)(5 * dCTMatrix.VMatrixDCT[n2][n3][0][0] / this.quantum_chrominance[0][0]);
                ++n3;
            }
            ++n2;
        }
        return this.matrix;
    }

    private short[][] quantizationmatrix() {
        short[][] sArray = new short[8][8];
        int n = 0;
        while (n < 8) {
            int n2 = 0;
            while (n2 < 8) {
                sArray[n][n2] = (short)(1.0 + 2.5 * (double)(1 + n + n2));
                ++n2;
            }
            ++n;
        }
        sArray[0][0] = 1;
        return sArray;
    }

    public QuantMatrix quantitizeRGB(DCTMatrix dCTMatrix, int n) {
        this.matrix = new QuantMatrix(dCTMatrix.XNumber, dCTMatrix.YNumber);
        short[][] sArray = this.quantizationmatrix();
        int n2 = 0;
        while (n2 < dCTMatrix.XNumber) {
            int n3 = 0;
            while (n3 < dCTMatrix.YNumber) {
                int n4 = 0;
                while (n4 < 64) {
                    int n5 = this.zigZag[n4][0];
                    int n6 = this.zigZag[n4][1];
                    this.matrix.QuanY[n2][n3][n4] = (short)(dCTMatrix.YMatrixDCT[n2][n3][n5][n6] / sArray[n5][n6] / n);
                    this.matrix.QuanU[n2][n3][n4] = (short)(dCTMatrix.UMatrixDCT[n2][n3][n5][n6] / sArray[n5][n6] / n);
                    this.matrix.QuanV[n2][n3][n4] = (short)(dCTMatrix.VMatrixDCT[n2][n3][n5][n6] / sArray[n5][n6] / n);
                    ++n4;
                }
                ++n3;
            }
            ++n2;
        }
        return this.matrix;
    }

    public DCTMatrix dequantitizeYUV(QuantMatrix quantMatrix) {
        this.matrix1 = new DCTMatrix(quantMatrix.XNumber, quantMatrix.YNumber);
        int n = 0;
        while (n < quantMatrix.XNumber) {
            int n2 = 0;
            while (n2 < quantMatrix.YNumber) {
                int n3 = 0;
                while (n3 < 64) {
                    int n4 = this.zigZag[n3][0];
                    int n5 = this.zigZag[n3][1];
                    this.matrix1.YMatrixDCT[n][n2][n4][n5] = (short)(quantMatrix.QuanY[n][n2][n3] * this.quantum_luminance[n4][n5] / 5);
                    this.matrix1.UMatrixDCT[n][n2][n4][n5] = (short)(quantMatrix.QuanU[n][n2][n3] * this.quantum_chrominance[n4][n5] / 5);
                    this.matrix1.VMatrixDCT[n][n2][n4][n5] = (short)(quantMatrix.QuanV[n][n2][n3] * this.quantum_chrominance[n4][n5] / 5);
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        return this.matrix1;
    }

    public DCTMatrix dequantitizeRGB(QuantMatrix quantMatrix) {
        this.matrix1 = new DCTMatrix(quantMatrix.XNumber, quantMatrix.YNumber);
        short[][] sArray = this.quantizationmatrix();
        int n = 0;
        while (n < quantMatrix.XNumber) {
            int n2 = 0;
            while (n2 < quantMatrix.YNumber) {
                int n3 = 0;
                while (n3 < 64) {
                    int n4 = this.zigZag[n3][0];
                    int n5 = this.zigZag[n3][1];
                    this.matrix1.YMatrixDCT[n][n2][n4][n5] = (short)(quantMatrix.QuanY[n][n2][n3] * sArray[n4][n5]);
                    this.matrix1.UMatrixDCT[n][n2][n4][n5] = (short)(quantMatrix.QuanU[n][n2][n3] * sArray[n4][n5]);
                    this.matrix1.VMatrixDCT[n][n2][n4][n5] = (short)(quantMatrix.QuanV[n][n2][n3] * sArray[n4][n5]);
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        return this.matrix1;
    }

    public short[][] quantitizeBlock(DCTMatrix dCTMatrix, int n, int n2, int n3, int n4, int n5) {
        short[][] sArray = new short[8][8];
        short[][] sArray2 = this.quantizationmatrix();
        int n6 = 0;
        while (n6 < 8) {
            int n7 = 0;
            while (n7 < 8) {
                sArray[n6][n7] = 0;
                if (n5 == 0) {
                    sArray[n6][n7] = n3 == 1 ? (short)(5 * dCTMatrix.YMatrixDCT[n][n2][n6][n7] / this.quantum_luminance[n6][n7] / n4) : (n3 == 2 ? (short)(5 * dCTMatrix.UMatrixDCT[n][n2][n6][n7] / this.quantum_chrominance[n6][n7] / n4) : (short)(5 * dCTMatrix.VMatrixDCT[n][n2][n6][n7] / this.quantum_chrominance[n6][n7] / n4));
                } else if (n5 == 1) {
                    sArray[n6][n7] = n3 == 1 ? (short)(dCTMatrix.YMatrixDCT[n][n2][n6][n7] / sArray2[n6][n7] / n4) : (n3 == 2 ? (short)(dCTMatrix.UMatrixDCT[n][n2][n6][n7] / sArray2[n6][n7] / n4) : (short)(dCTMatrix.VMatrixDCT[n][n2][n6][n7] / sArray2[n6][n7] / n4));
                }
                ++n7;
            }
            ++n6;
        }
        sArray[0][0] = (short)(sArray[0][0] * n4);
        return sArray;
    }

    public short[][] getBlock(DCTMatrix dCTMatrix, int n, int n2, int n3) {
        short[][] sArray = new short[8][8];
        sArray = n3 == 1 ? dCTMatrix.YMatrixDCT[n][n2] : (n3 == 2 ? dCTMatrix.UMatrixDCT[n][n2] : dCTMatrix.VMatrixDCT[n][n2]);
        return sArray;
    }
}

