/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt.util.spinner;

import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import symantec.itools.awt.util.spinner.Spinner;
import symantec.itools.beans.PropertyChangeSupport;
import symantec.itools.beans.VetoableChangeSupport;

public class NumericSpinner
extends Spinner
implements Serializable {
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public NumericSpinner() {
        try {
            this.setIncrement(1);
        }
        catch (PropertyVetoException propertyVetoException) {}
        this.min = 0;
        this.max = 10;
    }

    public void setMin(int i) throws PropertyVetoException {
        super.setMin(i);
        if (this.added) {
            int oldValue = this.textWidth;
            this.textWidth = Math.max(Integer.toString(this.min).length(), Integer.toString(this.max).length());
        }
    }

    public void setMax(int i) throws PropertyVetoException {
        super.setMax(i);
        if (this.added) {
            int oldValue = this.textWidth;
            this.textWidth = Math.max(Integer.toString(this.min).length(), Integer.toString(this.max).length());
        }
    }

    public void setIncrement(int i) throws PropertyVetoException {
        Integer oldValue = new Integer(this.increment);
        Integer newValue = new Integer(i);
        this.vetos.fireVetoableChange("increment", oldValue, newValue);
        this.increment = i;
        this.changes.firePropertyChange("increment", oldValue, newValue);
    }

    public int getIncrement() {
        return this.increment;
    }

    public String getCurrentText() {
        return Integer.toString(this.current);
    }

    public void addNotify() {
        this.textWidth = Math.max(Integer.toString(this.min).length(), Integer.toString(this.max).length());
        this.text = Integer.toString(this.current);
        super.addNotify();
        this.updateText(false);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
        this.changes.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        super.removePropertyChangeListener(listener);
        this.changes.removePropertyChangeListener(listener);
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener listener) {
        super.addVetoableChangeListener(listener);
        this.vetos.addVetoableChangeListener(listener);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener listener) {
        super.removeVetoableChangeListener(listener);
        this.vetos.removeVetoableChangeListener(listener);
    }
}

