/*
 * Decompiled with CFR 0.152.
 */
package kom.itbeankit.nw.ethernet;

import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import kom.itbeankit.common.message.MessageEvent;
import kom.itbeankit.nw.ethernet.EthernetInterface;
import kom.itbeankit.nw.ethernet.Host;

public class HostDialog
extends Dialog
implements EthernetInterface {
    Button applyButton;
    Button doneButton;
    Label destinationLabel;
    Choice destinationChoice;
    Label farmeSizeLabel;
    Button helpButton;
    Choice frameSizeChoice;
    Label repeatLabel;
    Choice repeatChoice;
    Host host;
    boolean fComponentsAdjusted = false;

    public HostDialog(Frame frame, boolean bl) {
        super(frame, bl);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.setVisible(false);
        ((Component)this).setSize(200, 160);
        ((Component)this).setFont(new Font("Dialog", 0, 12));
        ((Component)this).setBackground(new Color(0xC0C0C0));
        this.applyButton = new Button();
        this.applyButton.setLabel(" Apply ");
        this.applyButton.setBounds(5, 128, 49, 23);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 5, 2, 0);
        ((GridBagLayout)this.getLayout()).setConstraints(this.applyButton, gridBagConstraints);
        this.add(this.applyButton);
        this.applyButton.setCursor(new Cursor(12));
        this.doneButton = new Button();
        this.doneButton.setLabel(" Done ");
        this.doneButton.setBounds(145, 128, 50, 23);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        ((GridBagLayout)this.getLayout()).setConstraints(this.doneButton, gridBagConstraints);
        this.add(this.doneButton);
        this.doneButton.setCursor(new Cursor(12));
        this.destinationLabel = new Label("Destination");
        this.destinationLabel.setBounds(5, 0, 74, 33);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 5, 2, 0);
        ((GridBagLayout)this.getLayout()).setConstraints(this.destinationLabel, gridBagConstraints);
        this.add(this.destinationLabel);
        this.destinationChoice = new Choice();
        this.destinationChoice.addItem("None");
        this.destinationChoice.addItem("Broadcast");
        this.destinationChoice.addItem("1");
        this.destinationChoice.addItem("2");
        this.destinationChoice.addItem("3");
        this.destinationChoice.addItem("4");
        this.destinationChoice.addItem("5");
        this.destinationChoice.addItem("6");
        this.destinationChoice.addItem("7");
        this.destinationChoice.addItem("8");
        try {
            this.destinationChoice.select(0);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.destinationChoice.setBounds(114, 9, 77, 21);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        ((GridBagLayout)this.getLayout()).setConstraints(this.destinationChoice, gridBagConstraints);
        this.add(this.destinationChoice);
        this.destinationChoice.setCursor(new Cursor(12));
        this.farmeSizeLabel = new Label("Frame Size");
        this.farmeSizeLabel.setBounds(5, 40, 74, 33);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 5, 2, 0);
        ((GridBagLayout)this.getLayout()).setConstraints(this.farmeSizeLabel, gridBagConstraints);
        this.add(this.farmeSizeLabel);
        this.helpButton = new Button();
        this.helpButton.setLabel("?");
        this.helpButton.setBounds(83, 48, 21, 23);
        this.helpButton.setFont(new Font("Dialog", 1, 12));
        this.helpButton.setForeground(new Color(255));
        this.helpButton.setBackground(new Color(0xC0C0C0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 0, 2, 10);
        ((GridBagLayout)this.getLayout()).setConstraints(this.helpButton, gridBagConstraints);
        this.add(this.helpButton);
        this.frameSizeChoice = new Choice();
        this.frameSizeChoice.addItem("Normal");
        this.frameSizeChoice.addItem("too short");
        this.frameSizeChoice.addItem("too long");
        try {
            this.frameSizeChoice.select(0);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.frameSizeChoice.setBounds(114, 49, 81, 21);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        ((GridBagLayout)this.getLayout()).setConstraints(this.frameSizeChoice, gridBagConstraints);
        this.add(this.frameSizeChoice);
        this.frameSizeChoice.setCursor(new Cursor(12));
        this.repeatLabel = new Label("Auto Repeat");
        this.repeatLabel.setBounds(5, 80, 78, 40);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 5, 2, 0);
        ((GridBagLayout)this.getLayout()).setConstraints(this.repeatLabel, gridBagConstraints);
        this.add(this.repeatLabel);
        this.repeatChoice = new Choice();
        this.repeatChoice.addItem("NO");
        this.repeatChoice.addItem("YES");
        try {
            this.repeatChoice.select(0);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.repeatChoice.setBounds(114, 89, 81, 21);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        ((GridBagLayout)this.getLayout()).setConstraints(this.repeatChoice, gridBagConstraints);
        this.add(this.repeatChoice);
        this.repeatChoice.setCursor(new Cursor(12));
        this.setTitle("Host No. ");
        this.setResizable(false);
        SymWindow symWindow = new SymWindow();
        this.addWindowListener(symWindow);
        SymAction symAction = new SymAction();
        this.applyButton.addActionListener(symAction);
        this.doneButton.addActionListener(symAction);
        this.helpButton.addActionListener(symAction);
    }

    public HostDialog(Frame frame, Host host) {
        this(frame, false);
        this.host = host;
        String string = new Integer(host.getID()).toString();
        this.setTitle(String.valueOf(this.getTitle()) + string);
        this.destinationChoice.remove(host.getID() + 1);
        this.setDestinationHost(host.getDestinationHost());
        this.setFrameSize(host.getFrameSize());
        this.setAutoRepeat(host.isAutoRepeat());
    }

    public HostDialog(Frame frame, String string, boolean bl) {
        this(frame, bl);
        this.setTitle(string);
    }

    public void addNotify() {
        Dimension dimension = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        ((Component)this).setSize(this.insets().left + this.insets().right + dimension.width, this.insets().top + this.insets().bottom + dimension.height);
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            Point point = componentArray[n].getLocation();
            point.translate(this.insets().left, this.insets().top);
            componentArray[n].setLocation(point);
            ++n;
        }
        this.fComponentsAdjusted = true;
    }

    public void setVisible(boolean bl) {
        if (bl) {
            Rectangle rectangle = this.getParent().bounds();
            Rectangle rectangle2 = this.bounds();
            ((Component)this).setLocation(rectangle.x + (rectangle.width - rectangle2.width) / 2, rectangle.y + (rectangle.height - rectangle2.height));
        }
        super.setVisible(bl);
    }

    void HostDialog_WindowClosing(WindowEvent windowEvent) {
        this.host.hostDialog = null;
        this.host = null;
        this.dispose();
    }

    void doneButton_Clicked(ActionEvent actionEvent) {
        this.applyButton_Clicked(actionEvent);
        this.host.hostDialog = null;
        this.host = null;
        this.dispose();
    }

    void applyButton_Clicked(ActionEvent actionEvent) {
        this.host.setFrameSize(this.getFrameSize());
        this.host.setAutoRepeat(this.isAutoRepeat());
        this.host.setDestinationHost(this.getDestinationHost());
    }

    public int getFrameSize() {
        int n = 0;
        switch (this.frameSizeChoice.getSelectedIndex()) {
            case 0: {
                n = 56;
                break;
            }
            case 1: {
                n = 16;
                break;
            }
            case 2: {
                n = 192;
            }
        }
        return n;
    }

    public int getDestinationHost() {
        String string = this.destinationChoice.getSelectedItem();
        int n = this.destinationChoice.getSelectedIndex();
        switch (n) {
            case 0: {
                return -1;
            }
            case 1: {
                return 0;
            }
        }
        return new Integer(string);
    }

    public boolean isAutoRepeat() {
        return this.repeatChoice.getSelectedIndex() == 1;
    }

    public void setFrameSize(int n) {
        int n2 = 0;
        switch (n) {
            case 16: {
                n2 = 1;
                break;
            }
            case 192: {
                n2 = 2;
            }
        }
        this.frameSizeChoice.select(n2);
    }

    public void setDestinationHost(int n) {
        switch (n) {
            case -1: {
                this.destinationChoice.select(0);
                return;
            }
            case 0: {
                this.destinationChoice.select(1);
                return;
            }
        }
        this.destinationChoice.select(new Integer(n).toString());
    }

    public void setAutoRepeat(boolean bl) {
        int n = 0;
        if (bl) {
            n = 1;
        }
        this.repeatChoice.select(n);
    }

    void helpButton_ActionPerformed(ActionEvent actionEvent) {
        this.host.fireMessageEvent(new MessageEvent(this.host, 702, 710, "Host Dialog", "Sending too short frames may avoid collision detection. Try the related scenario to see the effect. Too long frames produce long delay times."));
    }

    class SymWindow
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            Object object = windowEvent.getSource();
            if (object == HostDialog.this) {
                HostDialog.this.HostDialog_WindowClosing(windowEvent);
            }
        }

        SymWindow() {
            HostDialog.this = HostDialog.this;
        }
    }

    class SymAction
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == HostDialog.this.applyButton) {
                HostDialog.this.applyButton_Clicked(actionEvent);
                return;
            }
            if (object == HostDialog.this.doneButton) {
                HostDialog.this.doneButton_Clicked(actionEvent);
                return;
            }
            if (object == HostDialog.this.helpButton) {
                HostDialog.this.helpButton_ActionPerformed(actionEvent);
            }
        }

        SymAction() {
            HostDialog.this = HostDialog.this;
        }
    }
}

