/*
 * Decompiled with CFR 0.152.
 */
package kom.itbeankit.common.vcr;

import java.awt.Button;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

public class ControlButtonPanel
extends Panel {
    Button stopButton;
    Button backwardsButton;
    Button stepButton;
    Button playButton;
    Button hideButton;
    Label userComplexityLevelLabel;
    Button levelDownButton;
    Button levelUpButton;
    private int theComplexityLevel = 1;
    private int numberOfComplexityLevels = 10;
    private Vector actionListeners = new Vector();
    private boolean play = false;
    public int timerDelay = 1000;
    public static final int STOP_BUTTON = 7000;
    public static final int BACKWARD_BUTTON = 7001;
    public static final int FORWARD_BUTTON = 7002;
    public static final int PLAY_BUTTON = 7003;
    public static final int HIDE_BUTTON = 7004;
    public static final int DOWN_BUTTON = 7005;
    public static final int UP_BUTTON = 7006;

    public ControlButtonPanel() {
        this.setLayout(new GridLayout(1, 0, 0, 0));
        this.setSize(462, 40);
        this.stopButton = new Button();
        this.stopButton.setLabel("stop");
        this.stopButton.setBounds(0, 0, 462, 40);
        this.stopButton.setBackground(new Color(0xC0C0C0));
        this.add(this.stopButton);
        this.stopButton.setCursor(new Cursor(12));
        this.backwardsButton = new Button();
        this.backwardsButton.setActionCommand("backwards");
        this.backwardsButton.setLabel("<< step");
        this.backwardsButton.setBounds(57, 0, 231, 40);
        this.backwardsButton.setBackground(new Color(0xC0C0C0));
        this.add(this.backwardsButton);
        this.backwardsButton.setCursor(new Cursor(12));
        this.stepButton = new Button();
        this.stepButton.setActionCommand("forwards");
        this.stepButton.setLabel("step >>");
        this.stepButton.setBounds(114, 0, 77, 40);
        this.stepButton.setBackground(new Color(0xC0C0C0));
        this.add(this.stepButton);
        this.stepButton.setCursor(new Cursor(12));
        this.playButton = new Button();
        this.playButton.setLabel("play");
        this.playButton.setBounds(171, 0, 77, 40);
        this.playButton.setBackground(new Color(0xC0C0C0));
        this.add(this.playButton);
        this.playButton.setCursor(new Cursor(12));
        this.hideButton = new Button();
        this.hideButton.setLabel("hide");
        this.hideButton.setBounds(228, 0, 77, 40);
        this.hideButton.setBackground(new Color(0xC0C0C0));
        this.add(this.hideButton);
        this.hideButton.setCursor(new Cursor(12));
        this.userComplexityLevelLabel = new Label("Level: ", 1);
        this.userComplexityLevelLabel.setBounds(285, 0, 66, 40);
        this.userComplexityLevelLabel.setBackground(new Color(0xFFFFFF));
        this.add(this.userComplexityLevelLabel);
        this.levelDownButton = new Button();
        this.levelDownButton.setActionCommand("levelDown");
        this.levelDownButton.setLabel("<<");
        this.levelDownButton.setBounds(342, 0, 57, 40);
        this.levelDownButton.setBackground(new Color(0xC0C0C0));
        this.add(this.levelDownButton);
        this.levelDownButton.setEnabled(false);
        this.levelDownButton.setCursor(new Cursor(12));
        this.levelUpButton = new Button();
        this.levelUpButton.setActionCommand("levelUp");
        this.levelUpButton.setLabel(">>");
        this.levelUpButton.setBounds(399, 0, 57, 40);
        this.levelUpButton.setBackground(new Color(0xC0C0C0));
        this.add(this.levelUpButton);
        this.levelUpButton.setCursor(new Cursor(12));
        this.theComplexityLevel = 1;
        this.userComplexityLevelLabel.setText(String.valueOf(this.userComplexityLevelLabel.getText()) + this.theComplexityLevel);
        SymAction symAction = new SymAction();
        this.playButton.addActionListener(symAction);
        this.stopButton.addActionListener(symAction);
        this.stepButton.addActionListener(symAction);
        this.backwardsButton.addActionListener(symAction);
        this.hideButton.addActionListener(symAction);
        this.levelDownButton.addActionListener(symAction);
        this.levelUpButton.addActionListener(symAction);
    }

    void playButton_ActionPerformed(ActionEvent actionEvent) {
        this.playButton.setLabel("play");
        this.fireActionEvent(this.playButton.getActionCommand());
    }

    void stopButton_ActionPerformed(ActionEvent actionEvent) {
        if (this.play) {
            this.playButton.setLabel("play");
        }
        this.play = false;
        this.fireActionEvent(this.stopButton.getActionCommand());
    }

    void stepButton_ActionPerformed(ActionEvent actionEvent) {
        this.fireActionEvent(this.stepButton.getActionCommand());
    }

    void backwardsButton_ActionPerformed(ActionEvent actionEvent) {
        this.fireActionEvent(this.backwardsButton.getActionCommand());
    }

    void hideButton_ActionPerformed(ActionEvent actionEvent) {
        this.fireActionEvent(this.hideButton.getActionCommand());
    }

    public void setNumberOfComplexityLevels(int n) {
        this.numberOfComplexityLevels = n;
        if (this.numberOfComplexityLevels == 1) {
            this.levelDownButton.setEnabled(false);
            this.levelUpButton.setEnabled(false);
        }
    }

    public int getNumberOfComplexityLevels() {
        return this.numberOfComplexityLevels;
    }

    void levelDownButton_ActionPerformed(ActionEvent actionEvent) {
        if (this.theComplexityLevel == 2) {
            this.levelDownButton.setEnabled(false);
            this.levelUpButton.setEnabled(true);
            --this.theComplexityLevel;
        } else if (this.theComplexityLevel <= this.numberOfComplexityLevels & this.theComplexityLevel > 2) {
            this.levelUpButton.setEnabled(true);
            --this.theComplexityLevel;
        } else if (this.theComplexityLevel == 1) {
            this.levelDownButton.setEnabled(false);
        }
        this.fireActionEvent(this.levelDownButton.getActionCommand());
        this.userComplexityLevelLabel.setText("Level: " + this.theComplexityLevel);
        this.userComplexityLevelLabel.setAlignment(1);
    }

    void levelUpButton_ActionPerformed(ActionEvent actionEvent) {
        if (this.theComplexityLevel == this.numberOfComplexityLevels - 1) {
            this.levelUpButton.setEnabled(false);
            this.levelDownButton.setEnabled(true);
            ++this.theComplexityLevel;
        } else if (this.theComplexityLevel >= 1 & this.theComplexityLevel < this.numberOfComplexityLevels) {
            this.levelDownButton.setEnabled(true);
            ++this.theComplexityLevel;
        } else if (this.theComplexityLevel == this.numberOfComplexityLevels) {
            this.levelUpButton.setEnabled(false);
        }
        this.fireActionEvent(this.levelUpButton.getActionCommand());
        this.userComplexityLevelLabel.setText("Level: " + this.theComplexityLevel);
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.actionListeners.addElement(actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.actionListeners.removeElement(actionListener);
    }

    public void fireActionEvent(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        int n = 0;
        while (n < this.actionListeners.size()) {
            ActionListener actionListener = (ActionListener)this.actionListeners.elementAt(n);
            actionListener.actionPerformed(new ActionEvent(this, 1001, string));
            ++n;
        }
    }

    public void fireActionEvent(String string) {
        int n = 0;
        while (n < this.actionListeners.size()) {
            ActionListener actionListener = (ActionListener)this.actionListeners.elementAt(n);
            actionListener.actionPerformed(new ActionEvent(this, 1001, string));
            ++n;
        }
    }

    public int getTimerDelay() {
        return this.timerDelay;
    }

    public void setTimerDelay(int n) {
        this.timerDelay = n;
    }

    public void setComplexityLevel(int n) {
        this.theComplexityLevel = n;
    }

    public int getComplexityLevel() {
        return this.theComplexityLevel;
    }

    public void setEnabled(boolean bl) {
        this.stopButton.setEnabled(bl);
        this.stepButton.setEnabled(bl);
        this.backwardsButton.setEnabled(bl);
        this.playButton.setEnabled(bl);
    }

    public void setEnabled(int n, boolean bl) {
        switch (n) {
            case 7000: {
                this.stopButton.setEnabled(bl);
                return;
            }
            case 7001: {
                this.backwardsButton.setEnabled(bl);
                return;
            }
            case 7002: {
                this.stepButton.setEnabled(bl);
                return;
            }
            case 7003: {
                this.playButton.setEnabled(bl);
                return;
            }
            case 7004: {
                this.hideButton.setEnabled(bl);
                return;
            }
            case 7005: {
                this.levelDownButton.setEnabled(bl);
                return;
            }
            case 7006: {
                this.levelUpButton.setEnabled(bl);
                return;
            }
        }
    }

    class SymAction
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == ControlButtonPanel.this.playButton) {
                ControlButtonPanel.this.playButton_ActionPerformed(actionEvent);
                return;
            }
            if (object == ControlButtonPanel.this.stopButton) {
                ControlButtonPanel.this.stopButton_ActionPerformed(actionEvent);
                return;
            }
            if (object == ControlButtonPanel.this.stepButton) {
                ControlButtonPanel.this.stepButton_ActionPerformed(actionEvent);
                return;
            }
            if (object == ControlButtonPanel.this.backwardsButton) {
                ControlButtonPanel.this.backwardsButton_ActionPerformed(actionEvent);
                return;
            }
            if (object == ControlButtonPanel.this.hideButton) {
                ControlButtonPanel.this.hideButton_ActionPerformed(actionEvent);
                return;
            }
            if (object == ControlButtonPanel.this.levelDownButton) {
                ControlButtonPanel.this.levelDownButton_ActionPerformed(actionEvent);
                return;
            }
            if (object == ControlButtonPanel.this.levelUpButton) {
                ControlButtonPanel.this.levelUpButton_ActionPerformed(actionEvent);
            }
        }

        SymAction() {
            ControlButtonPanel.this = ControlButtonPanel.this;
        }
    }
}

