/*
 * Decompiled with CFR 0.152.
 */
package kom.itbeankit.mm.diskscheduling.schedulingmodel;

import java.awt.Container;
import kom.itbeankit.mm.diskscheduling.schedulingmodel.AccurateSCANEDF_Scheduling;
import kom.itbeankit.mm.diskscheduling.schedulingmodel.CSCAN_Scheduling;
import kom.itbeankit.mm.diskscheduling.schedulingmodel.EDF_Scheduling;
import kom.itbeankit.mm.diskscheduling.schedulingmodel.FCFS_Scheduling;
import kom.itbeankit.mm.diskscheduling.schedulingmodel.GroupSweepingScheduling;
import kom.itbeankit.mm.diskscheduling.schedulingmodel.MultimediaDiskScheduling;
import kom.itbeankit.mm.diskscheduling.schedulingmodel.SCANEDF_Scheduling;
import kom.itbeankit.mm.diskscheduling.schedulingmodel.SCAN_Scheduling;
import kom.itbeankit.mm.diskscheduling.schedulingmodel.Scheduling;

public class DiskSchedulingModel
extends Container {
    static final int TradAlgorithms = 3;
    static final int MultAlgorithms = 4;
    private static Scheduling[] schedulingModel = new Scheduling[3];
    private static MultimediaDiskScheduling[] multimediaScheduling = new MultimediaDiskScheduling[4];
    private String[] ModelName = new String[7];
    private short[] InputShortStream;
    private byte[] InputByteStream;
    protected boolean FCFS_Active = false;
    protected boolean SCAN_Active = false;
    protected boolean CSCAN_Active = false;
    protected boolean EDF_Active = false;
    protected boolean SCANEDF_Active = false;
    protected boolean AccurateSCANEDF_Active = false;
    protected boolean GroupSweeping_Active = false;

    public DiskSchedulingModel() throws ClassNotFoundException {
        this.ModelName[0] = new String("kom.itbeankit.mm.diskscheduling.schedulingmodel.FCFS_Scheduling");
        this.ModelName[1] = new String("kom.itbeankit.mm.diskscheduling.schedulingmodel.SCAN_Scheduling");
        this.ModelName[2] = new String("kom.itbeankit.mm.diskscheduling.schedulingmodel.CSCAN_Scheduling");
        this.ModelName[3] = new String("kom.itbeankit.mm.diskscheduling.schedulingmodel.EDF_Scheduling");
        this.ModelName[4] = new String("kom.itbeankit.mm.diskscheduling.schedulingmodel.SCANEDF_Scheduling");
        this.ModelName[5] = new String("kom.itbeankit.mm.diskscheduling.schedulingmodel.AccurateSCANEDF_Scheduling");
        this.ModelName[6] = new String("kom.itbeankit.mm.diskscheduling.schedulingmodel.GroupSweepingScheduling");
        try {
            DiskSchedulingModel.schedulingModel[0] = (FCFS_Scheduling)Class.forName(this.ModelName[0]).newInstance();
            DiskSchedulingModel.schedulingModel[1] = (SCAN_Scheduling)Class.forName(this.ModelName[1]).newInstance();
            DiskSchedulingModel.schedulingModel[2] = (CSCAN_Scheduling)Class.forName(this.ModelName[2]).newInstance();
            DiskSchedulingModel.multimediaScheduling[0] = (EDF_Scheduling)Class.forName(this.ModelName[3]).newInstance();
            DiskSchedulingModel.multimediaScheduling[1] = (SCANEDF_Scheduling)Class.forName(this.ModelName[4]).newInstance();
            DiskSchedulingModel.multimediaScheduling[2] = (AccurateSCANEDF_Scheduling)Class.forName(this.ModelName[5]).newInstance();
            DiskSchedulingModel.multimediaScheduling[3] = (GroupSweepingScheduling)Class.forName(this.ModelName[6]).newInstance();
            return;
        }
        catch (InstantiationException instantiationException) {
            System.err.println("Exception in Algorithm instantiate: " + instantiationException);
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            System.out.println("Illegal access for Algorithm: " + illegalAccessException);
            return;
        }
    }

    public boolean isFCFS_Active() {
        return this.FCFS_Active;
    }

    public void setFCFS_Active(boolean bl) {
        this.FCFS_Active = bl;
        if (!this.FCFS_Active) {
            schedulingModel[0].resetSearchRun();
        }
    }

    public boolean isSCAN_Active() {
        return this.SCAN_Active;
    }

    public void setSCAN_Active(boolean bl) {
        this.SCAN_Active = bl;
        if (!this.SCAN_Active) {
            schedulingModel[1].resetSearchRun();
        }
    }

    public boolean isCSCAN_Active() {
        return this.CSCAN_Active;
    }

    public void setCSCAN_Active(boolean bl) {
        this.CSCAN_Active = bl;
        if (!this.CSCAN_Active) {
            schedulingModel[2].resetSearchRun();
        }
    }

    public boolean isEDF_Active() {
        return this.EDF_Active;
    }

    public void setEDF_Active(boolean bl) {
        this.EDF_Active = bl;
        if (!this.EDF_Active) {
            multimediaScheduling[0].resetSearchRun();
        }
    }

    public boolean isSCANEDF_Active() {
        return this.SCANEDF_Active;
    }

    public void setSCANEDF_Active(boolean bl) {
        this.SCANEDF_Active = bl;
        if (!this.SCANEDF_Active) {
            multimediaScheduling[1].resetSearchRun();
        }
    }

    public boolean isAccurateSCANEDF_Active() {
        return this.AccurateSCANEDF_Active;
    }

    public void setAccurateSCANEDF_Active(boolean bl) {
        this.AccurateSCANEDF_Active = bl;
        if (!this.AccurateSCANEDF_Active) {
            multimediaScheduling[2].resetSearchRun();
        }
    }

    public boolean isGroupSweeping_Active() {
        return this.GroupSweeping_Active;
    }

    public void setGroupSweeping_Active(boolean bl) {
        this.GroupSweeping_Active = bl;
        if (!this.GroupSweeping_Active) {
            multimediaScheduling[3].resetSearchRun();
        }
    }

    public short[] getInputShortStream() {
        return this.InputShortStream;
    }

    public void setInputShortStream(short[] sArray) {
        this.InputShortStream = sArray;
    }

    public byte[] getInputByteStream() {
        return this.InputByteStream;
    }

    public void setInputByteStream(byte[] byArray) {
        this.InputByteStream = byArray;
    }

    public void setDiskParameter(int[] nArray) {
        int n;
        int n2;
        if (nArray[0] > 0) {
            n2 = 0;
            while (n2 < 3) {
                schedulingModel[n2].setRotationtime(nArray[0]);
                ++n2;
            }
            n = 0;
            while (n < 4) {
                multimediaScheduling[n].setRotationtime(nArray[0]);
                ++n;
            }
        }
        if (nArray[1] > 0) {
            n2 = 0;
            while (n2 < 3) {
                schedulingModel[n2].setSeekReadRatio((float)nArray[1] / 10.0f);
                ++n2;
            }
            n = 0;
            while (n < 4) {
                multimediaScheduling[n].setSeekReadRatio((float)nArray[1] / 10.0f);
                ++n;
            }
        }
    }

    public void setSearchParameter(short[] sArray) {
        int n;
        if (sArray[0] >= 0) {
            n = 0;
            while (n < 3) {
                schedulingModel[n].setRequestedTrack(sArray[1], sArray[0]);
                ++n;
            }
            int n2 = 0;
            while (n2 < 4) {
                multimediaScheduling[n2].setRequestedTrack(sArray[1], sArray[0]);
                ++n2;
            }
        }
        if (sArray[2] >= 0) {
            n = 0;
            while (n < 4) {
                multimediaScheduling[n].setDeadline(sArray[3], sArray[2]);
                ++n;
            }
        }
    }

    public int[][] startSearch(int n) {
        int[][] nArray = new int[7][2];
        if (this.FCFS_Active) {
            nArray[0] = schedulingModel[0].startSearchRun(n);
        }
        if (this.SCAN_Active) {
            nArray[1] = schedulingModel[1].startSearchRun(n);
        }
        if (this.CSCAN_Active) {
            nArray[2] = schedulingModel[2].startSearchRun(n);
        }
        if (this.EDF_Active) {
            nArray[3] = multimediaScheduling[0].startSearchRun(n);
        }
        if (this.SCANEDF_Active) {
            nArray[4] = multimediaScheduling[1].startSearchRun(n);
        }
        if (this.AccurateSCANEDF_Active) {
            nArray[5] = multimediaScheduling[2].startSearchRun(n);
        }
        if (this.GroupSweeping_Active) {
            nArray[6] = multimediaScheduling[3].startSearchRun(n);
        }
        return nArray;
    }

    public void resetSearch() {
        int n = 0;
        while (n < 3) {
            schedulingModel[n].resetSearchRun();
            ++n;
        }
        int n2 = 0;
        while (n2 < 4) {
            multimediaScheduling[n2].resetSearchRun();
            ++n2;
        }
    }
}

