/*
 * Decompiled with CFR 0.152.
 */
package kom.itbeankit.common;

import kom.itbeankit.util.Convert;

public class ItFilename {
    private int beanNumber;
    private int datatype;
    private int iterationNumber;
    private String name;
    private String suffix;
    private boolean iterationNumberIsInName = false;

    public ItFilename() {
        this("default000.xxx");
    }

    public ItFilename(String string) {
        this.suffix = this.extractExtension(string);
        this.iterationNumber = this.extractIterationNumber(string);
        this.name = this.extractName(string);
        this.datatype = this.extractDatatype(string);
        this.beanNumber = this.extractBeanNumber(string);
    }

    public static int countOf(String string, char c) {
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            if (string.charAt(n2) == c) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    private int extractBeanNumber(String string) {
        switch (ItFilename.countOf(string, '-')) {
            case 0: {
                return -1;
            }
            case 1: {
                return -1;
            }
            case 2: {
                if (this.iterationNumberIsInName) {
                    return ItFilename.numberAt(string, 1);
                }
                return -1;
            }
            case 3: {
                return ItFilename.numberAt(string, 1);
            }
        }
        return -1;
    }

    private int extractDatatype(String string) {
        switch (ItFilename.countOf(string, '-')) {
            case 0: {
                return -1;
            }
            case 1: {
                if (this.iterationNumberIsInName) {
                    return ItFilename.numberAt(string, 1);
                }
                return -1;
            }
            case 2: {
                return ItFilename.numberAt(string, 2);
            }
            case 3: {
                return ItFilename.numberAt(string, 3);
            }
        }
        return -1;
    }

    private String extractExtension(String string) {
        int n = string.lastIndexOf(".");
        if (n >= 0) {
            return string.substring(n + 1);
        }
        return "";
    }

    private int extractIterationNumber(String string) {
        char[] cArray = new char[string.length()];
        string.getChars(0, string.length() - 1, cArray, 0);
        int n = cArray.length - 1;
        while (!Character.isDigit(cArray[n]) && n > 0) {
            --n;
        }
        if (cArray[n + 1] == '.') {
            this.iterationNumberIsInName = true;
            return ItFilename.numberAt(string, ItFilename.countOf(string, '-') + 1);
        }
        int n2 = ItFilename.countOf(string, '-');
        switch (n2) {
            case 1: {
                return ItFilename.numberAt(string, 1);
            }
            case 2: {
                return ItFilename.numberAt(string, 1);
            }
            case 3: {
                return ItFilename.numberAt(string, 2);
            }
        }
        return -1;
    }

    private String extractName(String string) {
        int n = string.length() - 1;
        if (this.suffix != "") {
            while (n > 0 && string.charAt(n) != '.') {
                --n;
            }
        }
        while (n > 0 && Character.isDigit(string.charAt(n - 1))) {
            --n;
        }
        int n2 = n;
        while (n2 > 0 && string.charAt(n2 - 1) != '-') {
            --n2;
        }
        return string.substring(n2, n);
    }

    public int getBeanNumber() {
        return this.beanNumber;
    }

    public int getDatatype() {
        return this.datatype;
    }

    public String getFilename() {
        String string = "";
        if (this.beanNumber >= 0 && this.iterationNumber >= 0 && this.datatype >= 0) {
            string = String.valueOf(Convert.int2string(this.beanNumber, 2)) + "-" + Convert.int2string(this.iterationNumber, 3) + "-" + Convert.int2string(this.datatype, 4) + "-" + this.name + "." + this.suffix;
        }
        if (this.beanNumber < 0 && this.iterationNumber >= 0 && this.datatype >= 0) {
            string = String.valueOf(Convert.int2string(this.datatype, 4)) + "-" + this.name + Convert.int2string(this.iterationNumber, 3) + "." + this.suffix;
        }
        if (this.beanNumber < 0 && this.iterationNumber >= 0 && this.datatype < 0) {
            string = String.valueOf(this.name) + Convert.int2string(this.iterationNumber, 3) + "." + this.suffix;
        }
        if (this.beanNumber < 0 && this.iterationNumber < 0 && this.datatype < 0) {
            string = String.valueOf(this.name) + "." + this.suffix;
        }
        return string;
    }

    public int getIterationNumber() {
        return this.iterationNumber;
    }

    public boolean getIterationNumberIsInName() {
        return this.iterationNumberIsInName;
    }

    public String getName() {
        return this.name;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public static int numberAt(String string, int n) {
        char[] cArray = new char[string.length()];
        string.getChars(0, string.length() - 1, cArray, 0);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (true) {
            if (!Character.isDigit(cArray[n2]) && n2 < string.length()) {
                ++n2;
                continue;
            }
            n4 = n2;
            while (Character.isDigit(cArray[n2]) && n2 < string.length()) {
                ++n2;
            }
            n5 = n2;
            if (++n3 >= n || n2 >= string.length()) break;
        }
        if (n2 < string.length()) {
            return Integer.parseInt(string.substring(n4, n5));
        }
        return -1;
    }

    public void setBeanNumber(int n) {
        this.beanNumber = n;
    }

    public void setDatatype(int n) {
        this.datatype = n;
    }

    public void setIterationNumber(int n) {
        this.iterationNumber = n;
    }

    public void setIterationNumberIsInName(boolean bl) {
        this.iterationNumberIsInName = bl;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setSuffix(String string) {
        this.suffix = string;
    }
}

