/*
 * Decompiled with CFR 0.152.
 */
package kom.itbeankit.mm.coding.huffman.view;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.lang.reflect.Array;
import kom.itbeankit.mm.coding.huffman.model.TreeNodeString;
import kom.itbeankit.mm.coding.huffman.view.TreeNodeC;
import symantec.itools.awt.util.Util;

public class TreeNodeC
extends Canvas {
    private String node_Str;
    private int str_Height;
    private int str_Width;
    private boolean node_t = true;
    private Color col = Color.green;
    private int[] endKoord;

    public TreeNodeC() {
        this.setSize(10, 10);
    }

    public TreeNodeC(TreeNodeString treeNode) {
        this.setParameter(treeNode, null);
        this.repaint();
    }

    public TreeNodeC(TreeNodeString treeNode, String root) {
        this.setParameter(treeNode, root);
        this.repaint();
    }

    public void setParameter(TreeNodeString treeNode, String root) {
        String[] stringArray = treeNode.myElement;
        Font myFont = new Font("Dialog", 0, 10);
        if ("root".equals(root)) {
            this.node_Str = "root";
            this.str_Width = Util.getStringWidth(myFont, this.node_Str);
            this.str_Height = Util.getFontHeight(myFont);
            this.col = Color.gray;
            this.setSize(this.str_Width * 2, this.str_Height * 2);
            this.repaint();
        } else if (Array.getLength(stringArray) == 1) {
            this.node_Str = stringArray[0];
            this.str_Width = Util.getStringWidth(myFont, this.node_Str);
            this.str_Height = Util.getFontHeight(myFont);
            this.col = Color.green;
            this.setSize(this.str_Width * 2, this.str_Height * 2);
            this.repaint();
        } else {
            int thisfreq = treeNode.myFreq;
            this.node_Str = String.valueOf(thisfreq);
            this.str_Width = Util.getStringWidth(myFont, this.node_Str);
            this.str_Height = Util.getFontHeight(myFont);
            this.col = Color.red;
            this.setSize(this.str_Width * 2, this.str_Height * 2);
            this.repaint();
        }
    }

    public int[] getEndKoord() {
        this.endKoord = new int[2];
        this.endKoord[0] = this.str_Width * 2;
        this.endKoord[1] = this.str_Height * 2;
        return this.endKoord;
    }

    public void paint(Graphics g) {
        g.setColor(this.col);
        g.fillOval(0, 0, this.str_Width * 2, this.str_Height * 2);
        g.setColor(Color.black);
        g.drawString(this.node_Str, this.str_Width / 3, this.str_Height * 3 / 2);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public static void main(String[] args) {
        new 1.DriverFrame().show();
    }
}

