/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt.shape;

import java.awt.Graphics;
import symantec.itools.awt.shape.Shape;

public class Rect
extends Shape {
    public boolean contains(int x, int y) {
        if (this.fill) {
            return super.contains(x, y);
        }
        if (y == 0 || y == this.height - 1) {
            return x >= 0 && x < this.width;
        }
        if (x == 0 || x == this.width - 1) {
            return y >= 0 && y < this.height;
        }
        return false;
    }

    public void paint(Graphics g) {
        super.paint(g);
        g.clipRect(0, 0, this.width, this.height);
        int w = this.width - 1;
        int h = this.height - 1;
        switch (this.style) {
            case 2: {
                if (this.fill) {
                    g.setColor(this.fillColor);
                    g.fillRect(0, 0, w, h);
                }
                g.setColor(this.getForeground());
                g.drawRect(0, 0, w, h);
                break;
            }
            case 0: {
                if (this.fill) {
                    g.setColor(this.fillColor);
                    g.fillRect(1, 1, w - 1, h - 1);
                }
                g.setColor(this.bevelDarkerColor);
                g.drawLine(0, h, 0, 0);
                g.drawLine(0, 0, w, 0);
                g.setColor(this.bevelLighterColor);
                g.drawLine(w, 0, w, h);
                g.drawLine(w, h, 0, h);
                break;
            }
            case 1: {
                if (this.fill) {
                    g.setColor(this.fillColor);
                    g.fillRect(1, 1, w - 1, h - 1);
                }
                g.setColor(this.bevelLighterColor);
                g.drawLine(0, h, 0, 0);
                g.drawLine(0, 0, w, 0);
                g.setColor(this.bevelDarkerColor);
                g.drawLine(w, 0, w, h);
                g.drawLine(w, h, 0, h);
                break;
            }
            default: {
                if (this.fill) {
                    g.setColor(this.fillColor);
                    g.fillRect(0, 0, this.width, this.height);
                    break;
                }
                g.setColor(this.getForeground());
                g.drawRect(0, 0, w, h);
            }
        }
    }
}

