/*
 * Decompiled with CFR 0.152.
 */
package kom.itbeankit.common.message;

import java.awt.Component;
import java.awt.Frame;
import java.awt.TextArea;
import kom.itbeankit.common.message.MessageDialog;
import kom.itbeankit.common.message.MessageEvent;
import kom.itbeankit.common.message.MessageListener;
import kom.itbeankit.common.message.Messenger;

public class Messenger
extends TextArea
implements MessageListener {
    public Messenger() {
        this.setSize(0, 0);
    }

    public void deliverMessage(MessageEvent messageEvent) {
        if (messageEvent != null) {
            String string = " from " + messageEvent.getMsgSource();
            if (messageEvent.getMsgSource().equals("")) {
                string = "";
            }
            int n = messageEvent.getDisplayType();
            switch (n) {
                case 701: {
                    this.appendText(String.valueOf(this.getEventTypeString(messageEvent.getMsgType())) + string + ": " + messageEvent.getMsg() + "\n");
                    return;
                }
                case 702: {
                    this.openDialog(messageEvent);
                    return;
                }
                case 703: {
                    this.openDialog(messageEvent);
                    this.appendText(String.valueOf(this.getEventTypeString(messageEvent.getMsgType())) + string + ": " + messageEvent.getMsg() + "\n");
                    return;
                }
            }
        }
    }

    void openDialog(MessageEvent messageEvent) {
        Component component = this;
        while (!(component instanceof Frame)) {
            component = component.getParent();
        }
        new MessageDialog((Frame)component, messageEvent).setVisible(true);
    }

    String getEventTypeString(int n) {
        switch (n) {
            case 710: {
                return "INFO";
            }
            case 711: {
                return "WARNING";
            }
            case 712: {
                return "ERROR";
            }
            case 713: {
                return "QUESTION";
            }
        }
        return "";
    }

    public static void main(String[] stringArray) {
        new 1.DriverFrame().show();
    }
}

