/*
 * Decompiled with CFR 0.152.
 */
package kom.itbeankit.common.vcr;

import java.awt.Button;
import java.awt.Color;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import kom.itbeankit.common.vcr.ClkEvent;
import kom.itbeankit.common.vcr.ClkListener;
import kom.itbeankit.common.vcr.VCRClock;

public class ControlButtonPanel
extends Container {
    protected boolean risingClkEdge = false;
    protected Vector clkListeners = new Vector();
    SymAction lSymAction = new SymAction();
    Button stopButton;
    Button stepButton;
    Button backwardsButton;
    Button playButton;
    Button hideButton;
    Button levelDownButton;
    Button levelUpButton;
    Label userComplexityLevelLabel;
    Label blankLabel;
    VCRClock timer1;
    private int theComplexityLevel = 1;
    private int numberOfComplexityLevels = 10;
    private Vector actionListeners = new Vector();
    private boolean play = false;
    private int timerDelay = 1000;
    public static final int STOP_BUTTON = 7000;
    public static final int BACKWARD_BUTTON = 7001;
    public static final int FORWARD_BUTTON = 7002;
    public static final int PLAY_BUTTON = 7003;
    public static final int HIDE_BUTTON = 7004;

    public void fireClkEvent(boolean risingEdge) {
        int i = 0;
        while (i < this.clkListeners.size()) {
            ClkListener cl = (ClkListener)this.clkListeners.elementAt(i);
            cl.clkReceived(new ClkEvent(this, risingEdge));
            ++i;
        }
    }

    public synchronized void removeClkListener(ClkListener l) {
        this.clkListeners.removeElement(l);
    }

    public synchronized void addClkListener(ClkListener l) {
        this.clkListeners.addElement(l);
    }

    public ControlButtonPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.stopButton = new Button();
        this.stopButton.setActionCommand("stop");
        this.stopButton.setLabel("stop");
        this.stopButton.setBackground(new Color(0xC0C0C0));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weighty = 1.0;
        gbc.fill = 3;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.ipadx = 22;
        gbc.ipady = 17;
        ((GridBagLayout)this.getLayout()).setConstraints(this.stopButton, gbc);
        this.add(this.stopButton);
        this.backwardsButton = new Button();
        this.backwardsButton.setActionCommand("backwards");
        this.backwardsButton.setLabel("<< step");
        this.backwardsButton.setBackground(new Color(0xC0C0C0));
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weighty = 1.0;
        gbc.fill = 3;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.ipadx = 22;
        gbc.ipady = 17;
        ((GridBagLayout)this.getLayout()).setConstraints(this.backwardsButton, gbc);
        this.add(this.backwardsButton);
        this.stepButton = new Button();
        this.stepButton.setActionCommand("forwards");
        this.stepButton.setLabel("step >>");
        this.stepButton.setBackground(new Color(0xC0C0C0));
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.weighty = 1.0;
        gbc.fill = 3;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.ipadx = 22;
        gbc.ipady = 17;
        ((GridBagLayout)this.getLayout()).setConstraints(this.stepButton, gbc);
        this.add(this.stepButton);
        this.playButton = new Button();
        this.playButton.setActionCommand("play");
        this.playButton.setLabel("play");
        this.playButton.setBackground(new Color(0xC0C0C0));
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 0;
        gbc.weighty = 1.0;
        gbc.fill = 3;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.ipadx = 24;
        gbc.ipady = 17;
        ((GridBagLayout)this.getLayout()).setConstraints(this.playButton, gbc);
        this.add(this.playButton);
        this.hideButton = new Button();
        this.hideButton.setActionCommand("hide");
        this.hideButton.setLabel("hide");
        this.hideButton.setBackground(new Color(0xC0C0C0));
        gbc = new GridBagConstraints();
        gbc.gridx = 5;
        gbc.gridy = 0;
        gbc.weighty = 1.0;
        gbc.fill = 3;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.ipadx = 11;
        gbc.ipady = 17;
        ((GridBagLayout)this.getLayout()).setConstraints(this.hideButton, gbc);
        this.add(this.hideButton);
        this.blankLabel = new Label();
        this.blankLabel.setBackground(new Color(255, 255, 255));
        gbc = new GridBagConstraints();
        gbc.gridx = 6;
        gbc.gridy = 0;
        gbc.weighty = 1.0;
        gbc.fill = 3;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.ipadx = 11;
        gbc.ipady = 17;
        ((GridBagLayout)this.getLayout()).setConstraints(this.blankLabel, gbc);
        this.add(this.blankLabel);
        this.userComplexityLevelLabel = new Label("Level: " + this.theComplexityLevel, 1);
        this.userComplexityLevelLabel.setBackground(new Color(255, 255, 255));
        gbc = new GridBagConstraints();
        gbc.gridx = 7;
        gbc.gridy = 0;
        gbc.weighty = 1.0;
        gbc.fill = 3;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.ipadx = 11;
        gbc.ipady = 17;
        ((GridBagLayout)this.getLayout()).setConstraints(this.userComplexityLevelLabel, gbc);
        this.add(this.userComplexityLevelLabel);
        this.levelDownButton = new Button();
        this.levelDownButton.setActionCommand("levelDown");
        this.levelDownButton.setLabel("<<");
        this.levelDownButton.setBackground(new Color(0xC0C0C0));
        gbc = new GridBagConstraints();
        gbc.gridx = 8;
        gbc.gridy = 0;
        gbc.weighty = 1.0;
        gbc.fill = 3;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.ipadx = 11;
        gbc.ipady = 17;
        ((GridBagLayout)this.getLayout()).setConstraints(this.levelDownButton, gbc);
        this.add(this.levelDownButton);
        this.levelUpButton = new Button();
        this.levelUpButton.setActionCommand("levelUp");
        this.levelUpButton.setLabel(">>");
        this.levelUpButton.setBackground(new Color(0xC0C0C0));
        gbc = new GridBagConstraints();
        gbc.gridx = 9;
        gbc.gridy = 0;
        gbc.weighty = 1.0;
        gbc.fill = 3;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.ipadx = 11;
        gbc.ipady = 17;
        ((GridBagLayout)this.getLayout()).setConstraints(this.levelUpButton, gbc);
        this.add(this.levelUpButton);
        this.timer1 = new VCRClock(1000L);
        SymAction lSymAction = new SymAction();
        this.playButton.addActionListener(lSymAction);
        this.stopButton.addActionListener(lSymAction);
        this.stepButton.addActionListener(lSymAction);
        this.backwardsButton.addActionListener(lSymAction);
        this.hideButton.addActionListener(lSymAction);
        this.levelDownButton.addActionListener(lSymAction);
        this.levelUpButton.addActionListener(lSymAction);
        this.timer1.addActionListener(lSymAction);
    }

    void playButton_ActionPerformed(ActionEvent event) {
        if (this.play) {
            this.playButton.setLabel("play");
            this.playButton.setActionCommand("pause");
            this.timer1.stop();
            this.fireActionEvent(this.playButton.getActionCommand());
        } else {
            this.playButton.setLabel("pause");
            this.playButton.setActionCommand("play");
            this.timer1.setActionCommand(this.playButton.getActionCommand());
            this.fireActionEvent(this.playButton.getActionCommand());
            this.timer1.stop();
            this.timer1.removeActionListener(this.lSymAction);
            this.timer1 = new VCRClock(this.timerDelay);
            this.timer1.setActionCommand(this.playButton.getActionCommand());
            this.timer1.addActionListener(this.lSymAction);
            this.timer1.start();
        }
        this.play = !this.play;
    }

    void stopButton_ActionPerformed(ActionEvent event) {
        if (this.play) {
            this.playButton.setLabel("play");
        }
        this.play = false;
        this.timer1.stop();
        this.fireActionEvent(this.stopButton.getActionCommand());
    }

    void stepButton_ActionPerformed(ActionEvent event) {
        this.timer1.setActionCommand(this.stepButton.getActionCommand());
        if (this.play) {
            this.playButton.setLabel("play");
        }
        this.play = false;
        this.timer1.stop();
        this.timer1 = new VCRClock(this.timerDelay);
        this.fireActionEvent(this.stepButton.getActionCommand());
        this.timer1.addActionListener(this.lSymAction);
        this.timer1.start();
        try {
            Thread.sleep(200L);
        }
        catch (Exception exception) {}
        this.timer1.stop();
    }

    void backwardsButton_ActionPerformed(ActionEvent event) {
        if (this.play) {
            this.playButton.setLabel("play");
        }
        this.play = false;
        this.timer1.stop();
        this.fireActionEvent(this.backwardsButton.getActionCommand());
    }

    void hideButton_ActionPerformed(ActionEvent event) {
        this.fireActionEvent(this.hideButton.getActionCommand());
    }

    void timer1_ActionPerformed(ActionEvent event) {
        this.fireActionEvent(this.timer1.getActionCommand());
        this.fireClkEvent(true);
        this.fireClkEvent(false);
    }

    public void setNumberOfComplexityLevels(int nc) {
        this.numberOfComplexityLevels = nc;
        if (this.numberOfComplexityLevels == 1) {
            this.levelDownButton.setEnabled(false);
            this.levelUpButton.setEnabled(false);
        }
    }

    public int getNumberOfComplexityLevels() {
        return this.numberOfComplexityLevels;
    }

    void levelDownButton_ActionPerformed(ActionEvent event) {
        this.changeLevelDown();
    }

    void changeLevelDown() {
        if (this.theComplexityLevel == 2) {
            this.levelDownButton.setEnabled(false);
            this.levelUpButton.setEnabled(true);
            --this.theComplexityLevel;
        } else if (this.theComplexityLevel <= this.numberOfComplexityLevels & this.theComplexityLevel > 2) {
            this.levelUpButton.setEnabled(true);
            --this.theComplexityLevel;
        } else if (this.theComplexityLevel == 1) {
            this.levelDownButton.setEnabled(false);
        }
        this.fireActionEvent(this.levelDownButton.getActionCommand());
        this.userComplexityLevelLabel.setText("Level: " + this.theComplexityLevel);
        this.userComplexityLevelLabel.setAlignment(1);
    }

    void levelUpButton_ActionPerformed(ActionEvent event) {
        this.changeLevelUp();
    }

    void changeLevelUp() {
        if (this.theComplexityLevel == this.numberOfComplexityLevels - 1) {
            this.levelUpButton.setEnabled(false);
            this.levelDownButton.setEnabled(true);
            ++this.theComplexityLevel;
        } else if (this.theComplexityLevel >= 1 & this.theComplexityLevel < this.numberOfComplexityLevels) {
            this.levelDownButton.setEnabled(true);
            ++this.theComplexityLevel;
        } else if (this.theComplexityLevel == this.numberOfComplexityLevels) {
            this.levelUpButton.setEnabled(false);
        }
        this.fireActionEvent(this.levelUpButton.getActionCommand());
        this.userComplexityLevelLabel.setText("Level: " + this.theComplexityLevel);
    }

    public synchronized void addActionListener(ActionListener l) {
        this.actionListeners.addElement(l);
    }

    public synchronized void removeActionListener(ActionListener l) {
        this.actionListeners.removeElement(l);
    }

    public void fireActionEvent(ActionEvent evt) {
        String actionCommand = evt.getActionCommand();
        int i = 0;
        while (i < this.actionListeners.size()) {
            ActionListener il = (ActionListener)this.actionListeners.elementAt(i);
            il.actionPerformed(new ActionEvent(this, 1001, actionCommand));
            ++i;
        }
    }

    public void fireActionEvent(String actionCommand) {
        int i = 0;
        while (i < this.actionListeners.size()) {
            ActionListener il = (ActionListener)this.actionListeners.elementAt(i);
            il.actionPerformed(new ActionEvent(this, 1001, actionCommand));
            ++i;
        }
    }

    public void setComplexityLevel(int level) {
        if (level < this.theComplexityLevel) {
            this.theComplexityLevel = level;
            this.changeLevelDown();
        } else if (level > this.theComplexityLevel) {
            this.theComplexityLevel = level;
            this.changeLevelUp();
        }
    }

    public int getComplexityLevel() {
        return this.theComplexityLevel;
    }

    public int getTimerDelay() {
        return this.timerDelay;
    }

    public void setTimerDelay(int delayTime) {
        this.timerDelay = delayTime;
        this.timer1.setDelayTime(this.timerDelay);
    }

    public void setEnabled(boolean flag) {
        if (!flag) {
            this.timer1.suspend();
        }
        this.stopButton.setEnabled(flag);
        this.stepButton.setEnabled(flag);
        this.backwardsButton.setEnabled(flag);
        this.playButton.setEnabled(flag);
    }

    public void setEnabled(int buttonNr, boolean flag) {
        switch (buttonNr) {
            case 7000: {
                this.stopButton.setEnabled(flag);
                break;
            }
            case 7001: {
                this.backwardsButton.setEnabled(flag);
                break;
            }
            case 7002: {
                this.stepButton.setEnabled(flag);
                break;
            }
            case 7003: {
                this.playButton.setEnabled(flag);
                break;
            }
            case 7004: {
                this.hideButton.setEnabled(flag);
                break;
            }
        }
    }

    public void TimerStop() {
        this.timer1.stop();
    }

    class SymAction
    implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == ControlButtonPanel.this.playButton) {
                ControlButtonPanel.this.playButton_ActionPerformed(event);
            } else if (object == ControlButtonPanel.this.stopButton) {
                ControlButtonPanel.this.stopButton_ActionPerformed(event);
            } else if (object == ControlButtonPanel.this.stepButton) {
                ControlButtonPanel.this.stepButton_ActionPerformed(event);
            } else if (object == ControlButtonPanel.this.backwardsButton) {
                ControlButtonPanel.this.backwardsButton_ActionPerformed(event);
            } else if (object == ControlButtonPanel.this.hideButton) {
                ControlButtonPanel.this.hideButton_ActionPerformed(event);
            } else if (object == ControlButtonPanel.this.levelDownButton) {
                ControlButtonPanel.this.levelDownButton_ActionPerformed(event);
            } else if (object == ControlButtonPanel.this.levelUpButton) {
                ControlButtonPanel.this.levelUpButton_ActionPerformed(event);
            } else if (object == ControlButtonPanel.this.timer1) {
                ControlButtonPanel.this.timer1_ActionPerformed(event);
            }
        }

        SymAction() {
            ControlButtonPanel.this = ControlButtonPanel.this;
        }
    }
}

