/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt;

import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.AWTEventMulticaster;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.Beans;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.net.URL;
import java.util.ResourceBundle;
import symantec.itools.awt.util.ColorUtils;
import symantec.itools.beans.PropertyChangeSupport;
import symantec.itools.beans.VetoableChangeSupport;
import symantec.itools.lang.OS;
import symantec.itools.resources.ErrorsBundle;
import symantec.itools.util.GeneralUtils;
import symantec.itools.util.Timer;

public abstract class ButtonBase
extends Canvas {
    protected transient boolean pressed = false;
    protected transient boolean released = true;
    protected transient boolean inButton;
    protected boolean notifyWhilePressed = false;
    protected transient boolean running = false;
    protected transient boolean notified = false;
    protected boolean showFocus = false;
    protected boolean useOffset = false;
    protected boolean showURLStatus = true;
    protected transient boolean isAdded = false;
    protected int bevel = 2;
    protected int tempBevelHeight;
    protected int notifyDelay = 1000;
    protected int pressedAdjustment = 0;
    protected String frame;
    protected Color borderColor;
    protected Color buttonColor;
    protected Timer notifyTimer = null;
    protected transient Image buttonImage;
    protected transient Graphics buttonImageGraphics;
    protected URL linkURL;
    protected transient AppletContext context;
    protected transient ResourceBundle errors;
    String actionCommand;
    ActionListener actionListener;
    transient boolean hasFocus = false;
    private Color hilightColor;
    private Color pressedHilightColor;
    private Color disabledHilightColor;
    private Color shadowColor;
    private Color pressedShadowColor;
    private Color disabledShadowColor;
    private Color disabledBorderColor;
    private Color disabledButtonColor;
    private Color pressedButtonColor;
    private Key key;
    private Focus focus;
    private Action action = new Action();
    private Mouse mouse;
    private BevelVeto bevelVeto;
    private FrameVeto frameVeto;
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    protected ButtonBase() {
        this.tempBevelHeight = this.bevel;
        try {
            this.setBorderColor(Color.black);
            this.setButtonColor(Color.lightGray);
        }
        catch (PropertyVetoException propertyVetoException) {}
        if (OS.isWindows()) {
            try {
                this.setShowFocus(true);
                return;
            }
            catch (PropertyVetoException propertyVetoException) {
                return;
            }
        }
    }

    public void setBevelHeight(int n) throws PropertyVetoException {
        if (this.isAdded) {
            if (this.bevel != n) {
                Integer n2 = new Integer(this.bevel);
                Integer n3 = new Integer(n);
                this.vetos.fireVetoableChange("bevelHeight", n2, n3);
                this.bevel = n;
                this.tempBevelHeight = n;
                this.repaint();
                this.changes.firePropertyChange("bevelHeight", n2, n3);
                return;
            }
        } else {
            this.tempBevelHeight = n;
        }
    }

    public int getBevelHeight() {
        if (this.isAdded) {
            return this.bevel;
        }
        return this.tempBevelHeight;
    }

    public void setNotifyWhilePressed(boolean bl) throws PropertyVetoException {
        if (this.notifyWhilePressed != bl) {
            Boolean bl2 = new Boolean(this.notifyWhilePressed);
            Boolean bl3 = new Boolean(bl);
            this.vetos.fireVetoableChange("notifyWhilePressed", bl2, bl3);
            this.notifyWhilePressed = bl;
            if (this.notifyWhilePressed) {
                this.notifyTimer = new Timer(this.notifyDelay, true);
                this.notifyTimer.addActionListener(this.action);
            } else if (this.notifyTimer != null) {
                this.notifyTimer = null;
            }
            this.changes.firePropertyChange("notifyWhilePressed", bl2, bl3);
        }
    }

    public boolean isNotifyWhilePressed() {
        return this.notifyWhilePressed;
    }

    public boolean getNotifyWhilePressed() {
        return this.isNotifyWhilePressed();
    }

    public void setNotifyDelay(int n) throws PropertyVetoException {
        if (this.notifyDelay != n) {
            Integer n2 = new Integer(this.notifyDelay);
            Integer n3 = new Integer(n);
            this.vetos.fireVetoableChange("notifyDelay", n2, n3);
            this.notifyDelay = n;
            if (this.notifyTimer != null) {
                this.notifyTimer.setDelay(this.notifyDelay);
            }
            this.changes.firePropertyChange("notifyDelay", n2, n3);
        }
    }

    public int getNotifyDelay() {
        return this.notifyDelay;
    }

    public void setUseOffset(boolean bl) throws PropertyVetoException {
        if (this.useOffset != bl) {
            Boolean bl2 = new Boolean(this.useOffset);
            Boolean bl3 = new Boolean(bl);
            this.vetos.fireVetoableChange("useOffset", bl2, bl3);
            this.useOffset = bl;
            this.repaint();
            this.changes.firePropertyChange("useOffset", bl2, bl3);
        }
    }

    public boolean isUseOffset() {
        return this.useOffset;
    }

    public void setShowFocus(boolean bl) throws PropertyVetoException {
        if (this.showFocus != bl) {
            Boolean bl2 = new Boolean(this.showFocus);
            Boolean bl3 = new Boolean(bl);
            this.vetos.fireVetoableChange("showFocus", bl2, bl3);
            this.showFocus = bl;
            this.changes.firePropertyChange("showFocus", bl2, bl3);
        }
    }

    public boolean isShowFocus() {
        return this.showFocus;
    }

    public boolean getShowFocus() {
        return this.isShowFocus();
    }

    public void setShowURLStatus(boolean bl) throws PropertyVetoException {
        if (this.showURLStatus != bl) {
            Boolean bl2 = new Boolean(this.showURLStatus);
            Boolean bl3 = new Boolean(bl);
            this.vetos.fireVetoableChange("showURLStatus", bl2, bl3);
            this.showURLStatus = bl;
            this.changes.firePropertyChange("showURLStatus", bl2, bl3);
        }
    }

    public boolean isShowURLStatus() {
        return this.showURLStatus;
    }

    public void setBorderColor(Color color) throws PropertyVetoException {
        if (!GeneralUtils.objectsEqual(this.borderColor, color)) {
            Color color2 = this.borderColor;
            this.vetos.fireVetoableChange("borderColor", color2, color);
            this.borderColor = color;
            try {
                this.disabledBorderColor = ColorUtils.lighten(this.borderColor, 0.466);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            this.repaint();
            this.changes.firePropertyChange("borderColor", color2, color);
        }
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setButtonColor(Color color) throws PropertyVetoException {
        if (!GeneralUtils.objectsEqual(this.buttonColor, color)) {
            Color color2 = this.buttonColor;
            this.vetos.fireVetoableChange("buttonColor", color2, color);
            this.buttonColor = color;
            try {
                this.hilightColor = ColorUtils.lighten(this.buttonColor, 0.6);
                this.pressedHilightColor = ColorUtils.darken(this.buttonColor, 0.58);
                this.disabledHilightColor = ColorUtils.lighten(this.buttonColor, 0.666);
                this.shadowColor = ColorUtils.darken(this.buttonColor, 0.25);
                this.pressedShadowColor = ColorUtils.darken(this.buttonColor, 0.1);
                this.disabledShadowColor = ColorUtils.darken(this.buttonColor, 0.166);
                this.disabledButtonColor = ColorUtils.lighten(this.buttonColor, 0.333);
                this.pressedButtonColor = ColorUtils.darken(this.buttonColor, 0.25);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            this.repaint();
            this.changes.firePropertyChange("buttonColor", color2, color);
        }
    }

    public Color getButtonColor() {
        return this.buttonColor;
    }

    public void setLinkURL(URL uRL) throws PropertyVetoException {
        if (!GeneralUtils.objectsEqual(this.linkURL, uRL)) {
            URL uRL2 = this.linkURL;
            this.vetos.fireVetoableChange("linkURL", uRL2, uRL);
            this.linkURL = uRL;
            this.context = null;
            this.changes.firePropertyChange("linkURL", uRL2, uRL);
        }
    }

    public URL getLinkURL() {
        return this.linkURL;
    }

    public void setFrame(String string) throws PropertyVetoException {
        String string2 = this.frame;
        this.vetos.fireVetoableChange("frame", string2, string);
        this.frame = string;
        this.changes.firePropertyChange("frame", string2, string);
    }

    public String getFrame() {
        return this.frame;
    }

    public void validate() {
        if (this.context == null) {
            Container container = this.getParent();
            while (container != null) {
                if (container instanceof Applet) {
                    this.setAppletContext(((Applet)container).getAppletContext());
                    return;
                }
                container = container.getParent();
            }
        }
    }

    public void setEnabled(boolean bl) {
        if (this.isEnabled() != bl) {
            if (bl) {
                super.enable();
                this.pressed = false;
                this.pressedAdjustment = 0;
            } else {
                super.disable();
                if (this.notifyTimer != null) {
                    this.notifyTimer.stop();
                }
                this.pressed = false;
                this.pressedAdjustment = 0;
            }
            this.repaint();
        }
    }

    public void enable() {
        this.setEnabled(true);
    }

    public void disable() {
        this.setEnabled(false);
    }

    public synchronized void addNotify() {
        try {
            this.errors = ResourceBundle.getBundle("symantec.itools.resources.ErrorsBundle");
        }
        catch (Throwable throwable) {
            this.errors = new ErrorsBundle();
        }
        if (this.focus == null) {
            this.focus = new Focus();
            this.addFocusListener(this.focus);
        }
        if (this.key == null) {
            this.key = new Key();
            this.addKeyListener(this.key);
        }
        if (this.mouse == null) {
            this.mouse = new Mouse();
            this.addMouseListener(this.mouse);
        }
        if (this.bevelVeto == null) {
            this.bevelVeto = new BevelVeto();
            this.addBevelHeightListener(this.bevelVeto);
        }
        if (this.frameVeto == null) {
            this.frameVeto = new FrameVeto();
            this.addFrameListener(this.frameVeto);
        }
        super.addNotify();
        this.isAdded = true;
        this.verifyContstrainedPropertyValues();
        if (this.context == null) {
            Container container = this.getParent();
            while (container != null) {
                if (container instanceof Applet) {
                    this.setAppletContext(((Applet)container).getAppletContext());
                    return;
                }
                container = container.getParent();
            }
        }
    }

    public synchronized void removeNotify() {
        if (this.focus != null) {
            this.removeFocusListener(this.focus);
            this.focus = null;
        }
        if (this.key != null) {
            this.removeKeyListener(this.key);
            this.key = null;
        }
        if (this.mouse != null) {
            this.removeMouseListener(this.mouse);
            this.mouse = null;
        }
        if (this.bevelVeto != null) {
            this.removeBevelHeightListener(this.bevelVeto);
            this.bevelVeto = null;
        }
        if (this.frameVeto != null) {
            this.removeFrameListener(this.frameVeto);
            this.frameVeto = null;
        }
        super.removeNotify();
        this.isAdded = false;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        this.updateButtonImage();
        graphics.drawImage(this.buttonImage, 0, 0, this);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.bevel + this.bevel + 2, this.bevel + this.bevel + 2);
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void simulateClick() {
        this.requestFocus();
        this.inButton = true;
        this.pressed = true;
        this.released = false;
        if (this.useOffset) {
            this.pressedAdjustment = this.bevel;
        }
        this.paint(this.getGraphics());
        try {
            Thread.sleep(120L);
        }
        catch (InterruptedException interruptedException) {}
        this.inButton = false;
        this.pressed = false;
        this.pressedAdjustment = 0;
        this.linkToURL();
        this.sourceActionEvent();
        this.released = true;
        this.repaint();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.addVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.removeVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized void addBevelHeightListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener("bevelHeight", propertyChangeListener);
    }

    public synchronized void removeBevelHeightListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener("bevelHeight", propertyChangeListener);
    }

    public synchronized void addBevelHeightListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.addVetoableChangeListener("bevelHeight", vetoableChangeListener);
    }

    public synchronized void removeBevelHeightListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.removeVetoableChangeListener("bevelHeight", vetoableChangeListener);
    }

    public synchronized void addFrameListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener("frame", propertyChangeListener);
    }

    public synchronized void removeFrameListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener("frame", propertyChangeListener);
    }

    public synchronized void addFrameListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.addVetoableChangeListener("frame", vetoableChangeListener);
    }

    public synchronized void removeFrameListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.removeVetoableChangeListener("frame", vetoableChangeListener);
    }

    public void setActionCommand(String string) throws PropertyVetoException {
        String string2 = this.actionCommand;
        this.vetos.fireVetoableChange("actionCommand", string2, string);
        this.actionCommand = string;
        this.changes.firePropertyChange("actionCommand", string2, string);
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    protected void sourceActionEvent() {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.actionCommand));
        }
    }

    protected boolean isValidBevelSize(int n) {
        Dimension dimension = this.getSize();
        return n >= 0 && n < dimension.width / 2 && n < dimension.height / 2;
    }

    protected boolean isValidFrame(String string) {
        if (string == null || string.equals("")) {
            return true;
        }
        return string.equals(GeneralUtils.frameTarget_self) || string.equals(GeneralUtils.frameTarget_parent) || string.equals(GeneralUtils.frameTarget_top) || string.equals(GeneralUtils.frameTarget_blank);
    }

    protected void linkToURL() {
        if (this.context != null && this.linkURL != null) {
            if (this.frame == null || this.frame.length() == 0) {
                this.context.showDocument(this.linkURL);
                return;
            }
            this.context.showDocument(this.linkURL, this.frame);
        }
    }

    protected void verifyContstrainedPropertyValues() {
        try {
            this.setBevelHeight(this.tempBevelHeight);
            return;
        }
        catch (PropertyVetoException propertyVetoException) {
            return;
        }
    }

    protected void setAppletContext(AppletContext appletContext) {
        this.context = appletContext;
    }

    protected void updateButtonImage() {
        int n;
        Color color;
        Color color2;
        Color color3;
        Color color4;
        Serializable serializable;
        boolean bl;
        Dimension dimension = this.getSize();
        int n2 = dimension.width;
        int n3 = dimension.height;
        int n4 = this.bevel + 1;
        int n5 = this.bevel + 1;
        int n6 = n2 - 1;
        int n7 = n3 - 1;
        boolean bl2 = bl = !this.pressed || !this.inButton;
        if (this.isButtonImageInvalid()) {
            this.buttonImage = this.createImage(n2, n3);
            try {
                serializable = new MediaTracker(this);
                ((MediaTracker)serializable).addImage(this.buttonImage, 0);
                ((MediaTracker)serializable).waitForID(0);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.buttonImageGraphics = this.buttonImage.getGraphics();
        serializable = this.buttonImageGraphics.getColor();
        if (this.isEnabled()) {
            color4 = this.borderColor;
            if (bl) {
                color3 = this.buttonColor;
                color2 = this.hilightColor;
                color = this.shadowColor;
            } else {
                color3 = this.pressedButtonColor;
                color2 = this.pressedHilightColor;
                color = this.pressedShadowColor;
            }
        } else {
            color4 = this.disabledBorderColor;
            color3 = this.disabledButtonColor;
            color2 = this.disabledHilightColor;
            color = this.disabledShadowColor;
        }
        if (!bl && this.useOffset) {
            this.buttonImageGraphics.setColor(color3);
            this.buttonImageGraphics.fillRect(n4, n5, n6 - n4, n7 - n5);
            this.buttonImageGraphics.setColor(color2);
            n = 1;
            while (n <= this.bevel) {
                this.buttonImageGraphics.drawLine(n, n, n, n7);
                this.buttonImageGraphics.drawLine(n, n, n6, n);
                ++n;
            }
        }
        if (bl || !this.useOffset) {
            this.buttonImageGraphics.setColor(color3);
            this.buttonImageGraphics.fillRect(n4, n5, n6 - n4, n7 - n5);
            this.buttonImageGraphics.setColor(color2);
            n = 1;
            while (n <= this.bevel) {
                this.buttonImageGraphics.drawLine(n, n, n, n7 - n);
                this.buttonImageGraphics.drawLine(n, n, n6 - n, n);
                ++n;
            }
            this.buttonImageGraphics.setColor(color);
            n = 1;
            while (n <= this.bevel) {
                this.buttonImageGraphics.drawLine(n, n7 - n, n6 - n, n7 - n);
                this.buttonImageGraphics.drawLine(n6 - n, n, n6 - n, n7 - n);
                ++n;
            }
        }
        this.buttonImageGraphics.setColor(color4);
        this.buttonImageGraphics.drawLine(1, 0, n6 - 1, 0);
        this.buttonImageGraphics.drawLine(0, 1, 0, n7 - 1);
        this.buttonImageGraphics.drawLine(1, n7, n6 - 1, n7);
        this.buttonImageGraphics.drawLine(n6, n7 - 1, n6, 1);
        if (this.hasFocus && this.showFocus) {
            this.buttonImageGraphics.setColor(Color.darkGray);
            n4 = 3;
            while (n4 <= n6 - 3) {
                this.buttonImageGraphics.drawLine(n4, 3, n4 + 1, 3);
                n4 += 3;
            }
            n5 = 3;
            while (n5 <= n7 - 3) {
                this.buttonImageGraphics.drawLine(3, n5, 3, n5 + 1);
                n5 += 3;
            }
            n4 = 3;
            while (n4 <= n6 - 3) {
                this.buttonImageGraphics.drawLine(n4, n7 - 3, n4 + 1, n7 - 3);
                n4 += 3;
            }
            n5 = 3;
            while (n5 <= n7 - 3) {
                this.buttonImageGraphics.drawLine(n6 - 3, n5, n6 - 3, n5 + 1);
                n5 += 3;
            }
        }
        this.buttonImageGraphics.clipRect(this.bevel + 1, this.bevel + 1, n2 - this.bevel - this.bevel - 2, n3 - this.bevel - this.bevel - 2);
        this.buttonImageGraphics.setColor((Color)serializable);
    }

    protected boolean isButtonImageInvalid() {
        Dimension dimension = this.getSize();
        return this.buttonImage == null || dimension.width != this.buttonImage.getWidth(this) || dimension.height != this.buttonImage.getHeight(this);
    }

    class Focus
    extends FocusAdapter
    implements Serializable {
        public void focusGained(FocusEvent focusEvent) {
            ButtonBase.this.hasFocus = true;
            ButtonBase.this.repaint();
        }

        public void focusLost(FocusEvent focusEvent) {
            ButtonBase.this.hasFocus = false;
            ButtonBase.this.repaint();
        }

        Focus() {
            ButtonBase.this = ButtonBase.this;
        }
    }

    class Key
    extends KeyAdapter
    implements Serializable {
        public void keyPressed(KeyEvent keyEvent) {
            boolean bl;
            boolean bl2 = bl = (keyEvent.getKeyCode() & 0x20) == 32;
            if (bl && ButtonBase.this.hasFocus && ButtonBase.this.showFocus && !OS.isMacintosh()) {
                ButtonBase.this.inButton = true;
                ButtonBase.this.notified = false;
                if (ButtonBase.this.notifyTimer != null && ButtonBase.this.notifyWhilePressed && !ButtonBase.this.running) {
                    ButtonBase.this.running = true;
                    ButtonBase.this.notifyTimer.start();
                }
                ButtonBase.this.pressed = true;
                ButtonBase.this.released = false;
                if (ButtonBase.this.useOffset) {
                    ButtonBase.this.pressedAdjustment = ButtonBase.this.bevel;
                }
                ButtonBase.this.repaint();
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
            boolean bl;
            boolean bl2 = bl = (keyEvent.getKeyCode() & 0x20) == 32;
            if (bl && ButtonBase.this.hasFocus && ButtonBase.this.showFocus && !OS.isMacintosh()) {
                ButtonBase.this.inButton = false;
                if (ButtonBase.this.notifyTimer != null && ButtonBase.this.running) {
                    ButtonBase.this.running = false;
                    ButtonBase.this.notifyTimer.stop();
                }
                if (ButtonBase.this.pressed) {
                    ButtonBase.this.pressed = false;
                    ButtonBase.this.pressedAdjustment = 0;
                    if (!ButtonBase.this.notifyWhilePressed || !ButtonBase.this.notified) {
                        ButtonBase.this.linkToURL();
                        ButtonBase.this.sourceActionEvent();
                    }
                }
                ButtonBase.this.released = true;
                ButtonBase.this.repaint();
            }
        }

        Key() {
            ButtonBase.this = ButtonBase.this;
        }
    }

    class Mouse
    extends MouseAdapter
    implements Serializable {
        public void mousePressed(MouseEvent mouseEvent) {
            ButtonBase.this.requestFocus();
            ButtonBase.this.notified = false;
            if (ButtonBase.this.notifyTimer != null && ButtonBase.this.notifyWhilePressed && !ButtonBase.this.running) {
                ButtonBase.this.running = true;
                ButtonBase.this.notifyTimer.start();
            }
            ButtonBase.this.pressed = true;
            ButtonBase.this.released = false;
            if (ButtonBase.this.useOffset) {
                ButtonBase.this.pressedAdjustment = ButtonBase.this.bevel;
            }
            ButtonBase.this.repaint();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (ButtonBase.this.notifyTimer != null && ButtonBase.this.running) {
                ButtonBase.this.running = false;
                ButtonBase.this.notifyTimer.stop();
            }
            if (ButtonBase.this.pressed) {
                ButtonBase.this.pressed = false;
                ButtonBase.this.pressedAdjustment = 0;
                if (!ButtonBase.this.notifyWhilePressed || !ButtonBase.this.notified) {
                    ButtonBase.this.linkToURL();
                    ButtonBase.this.sourceActionEvent();
                }
            }
            ButtonBase.this.released = true;
            if (ButtonBase.this.inButton) {
                ButtonBase.this.repaint();
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            ButtonBase.this.inButton = true;
            if (ButtonBase.this.showURLStatus && ButtonBase.this.context != null && ButtonBase.this.linkURL != null) {
                ButtonBase.this.context.showStatus(ButtonBase.this.linkURL.toString());
            }
            if (!ButtonBase.this.released) {
                ButtonBase.this.pressed = true;
                if (ButtonBase.this.useOffset) {
                    ButtonBase.this.pressedAdjustment = ButtonBase.this.bevel;
                }
                if (ButtonBase.this.notifyTimer != null && ButtonBase.this.notifyWhilePressed && !ButtonBase.this.running) {
                    ButtonBase.this.running = true;
                    ButtonBase.this.notifyTimer.start();
                }
                ButtonBase.this.repaint();
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            ButtonBase.this.inButton = false;
            if (ButtonBase.this.notifyTimer != null && ButtonBase.this.running) {
                ButtonBase.this.running = false;
                ButtonBase.this.notifyTimer.stop();
            }
            if (ButtonBase.this.pressed) {
                ButtonBase.this.pressed = false;
                ButtonBase.this.pressedAdjustment = 0;
                ButtonBase.this.repaint();
            }
            if (ButtonBase.this.showURLStatus && ButtonBase.this.context != null && ButtonBase.this.linkURL != null) {
                ButtonBase.this.context.showStatus("");
            }
        }

        Mouse() {
            ButtonBase.this = ButtonBase.this;
        }
    }

    class Action
    implements ActionListener,
    Serializable {
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == ButtonBase.this.notifyTimer && ButtonBase.this.notifyWhilePressed && !Beans.isDesignTime()) {
                ButtonBase.this.notified = true;
                ButtonBase.this.sourceActionEvent();
                return;
            }
        }

        Action() {
            ButtonBase.this = ButtonBase.this;
        }
    }

    class BevelVeto
    implements VetoableChangeListener,
    Serializable {
        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            int n = (Integer)propertyChangeEvent.getNewValue();
            if (!ButtonBase.this.isValidBevelSize(n)) {
                throw new PropertyVetoException(String.valueOf(ButtonBase.this.errors.getString("InvalidBevelSize")) + n, propertyChangeEvent);
            }
        }

        BevelVeto() {
            ButtonBase.this = ButtonBase.this;
        }
    }

    class FrameVeto
    implements VetoableChangeListener,
    Serializable {
        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            String string = (String)propertyChangeEvent.getNewValue();
            if (!ButtonBase.this.isValidFrame(string)) {
                throw new PropertyVetoException(String.valueOf(ButtonBase.this.errors.getString("InvalidFrame")) + string, propertyChangeEvent);
            }
        }

        FrameVeto() {
            ButtonBase.this = ButtonBase.this;
        }
    }
}

