/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import symantec.itools.awt.HorizontalSliderThumb;
import symantec.itools.awt.HorizontalSliderThumbBot;
import symantec.itools.awt.HorizontalSliderThumbBoth;
import symantec.itools.awt.HorizontalSliderThumbTop;
import symantec.itools.awt.Slider;
import symantec.itools.awt.SliderTick;

public class HorizontalSlider
extends Slider {
    protected static final int TICK_HEIGHT = 4;
    protected String actionCommand = "HSliderMoved";
    private HorizontalSliderThumb thumb = new HorizontalSliderThumbBoth();
    private Mouse mouse;
    private MouseMtn mouseMotion;

    public HorizontalSlider() {
        this.width = 200;
    }

    public void setTickStyle(int n) throws PropertyVetoException {
        if (this.style != n) {
            super.setTickStyle(n);
            switch (n) {
                case 1: {
                    this.thumb = new HorizontalSliderThumbTop();
                    break;
                }
                case 0: {
                    this.thumb = new HorizontalSliderThumbBot();
                    break;
                }
                default: {
                    this.thumb = new HorizontalSliderThumbBoth();
                }
            }
            this.repaint();
        }
    }

    public synchronized void addNotify() {
        super.addNotify();
        if (this.mouse == null) {
            this.mouse = new Mouse();
            this.addMouseListener(this.mouse);
        }
        if (this.mouseMotion == null) {
            this.mouseMotion = new MouseMtn();
            this.addMouseMotionListener(this.mouseMotion);
        }
    }

    public synchronized void removeNotify() {
        if (this.mouse != null) {
            this.removeMouseListener(this.mouse);
            this.mouse = null;
        }
        if (this.mouseMotion != null) {
            this.removeMouseMotionListener(this.mouseMotion);
            this.mouseMotion = null;
        }
        super.removeNotify();
    }

    protected void do_reshape(int n, int n2) {
        float f = 15.0f;
        float f2 = 10.0f;
        if ((float)n < f) {
            f = n / 4;
        }
        if ((float)n2 < f2) {
            f2 = n2 / 4;
        }
        float f3 = f;
        float f4 = (float)n - f;
        float f5 = f2;
        float f6 = (float)n2 - f2;
        if (f3 == 0.0f) {
            f3 = 1.0f;
        }
        if (f4 == 0.0f) {
            f4 = 1.0f;
        }
        if (f5 == 0.0f) {
            f5 = 1.0f;
        }
        if (f6 == 0.0f) {
            f6 = 1.0f;
        }
        float f7 = (this.max - this.min) / this.freq + 1;
        this.tick = new SliderTick[(int)f7];
        float f8 = (f4 - f3) / (f7 - 1.0f);
        int n3 = 0;
        while ((float)n3 < f7) {
            float f9 = (float)n3 * f8;
            this.tick[n3] = new SliderTick((int)f5, (int)f6, (int)(f3 + f9), (int)f9);
            ++n3;
        }
        this.thumb.resize((int)(f8 / 2.0f), (int)(f6 - f5 - 4.0f - 1.0f));
    }

    public void paint(Graphics graphics) {
        SliderTick sliderTick;
        super.paint(graphics);
        if (this.tick.length == 0) {
            return;
        }
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.width, this.height);
        graphics.setColor(Color.black);
        int n = this.width - 1;
        int n2 = this.height - 1;
        if (this.showBorder) {
            graphics.drawRect(0, 0, n, n2);
        }
        int n3 = 0;
        while (n3 < this.tick.length) {
            boolean bl = n3 == 0 || n3 == this.tick.length - 1;
            sliderTick = this.tick[n3];
            if (this.style == 1 || this.style == 2) {
                graphics.drawLine(sliderTick.c, sliderTick.a + (bl ? 0 : 1), sliderTick.c, sliderTick.a + 4);
            }
            if (this.style == 0 || this.style == 2) {
                graphics.drawLine(sliderTick.c, sliderTick.b - 4, sliderTick.c, sliderTick.b - (bl ? 0 : 1));
            }
            ++n3;
        }
        sliderTick = this.tick[0];
        int n4 = (sliderTick.b + sliderTick.a) / 2;
        int n5 = sliderTick.c - 5;
        int n6 = this.tick[this.tick.length - 1].c + 5;
        graphics.drawLine(n5, n4, n6, n4);
        graphics.setColor(Color.gray);
        graphics.drawLine(n6 + 1, n4 - 1, n5 - 1, n4 - 1);
        graphics.drawLine(n5 - 1, n4 - 1, n5 - 1, n4 + 1);
        graphics.setColor(Color.lightGray);
        graphics.drawLine(n5, n4 + 1, n6 + 1, n4 + 1);
        graphics.drawLine(n6 + 1, n4 + 1, n6 + 1, n4);
        graphics.setColor(Color.white);
        graphics.drawLine(n5 - 1, n4 + 2, n6 + 2, n4 + 2);
        graphics.drawLine(n6 + 2, n4 + 2, n6 + 2, n4 - 1);
        graphics.clipRect(0, 0, this.width, this.height);
        this.thumb.draw(graphics, this.tick[this.curPos]);
        this.prevPos = this.curPos;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.do_reshape(this.width, this.height);
    }

    class Mouse
    extends MouseAdapter
    implements Serializable {
        public void mousePressed(MouseEvent mouseEvent) {
            HorizontalSlider.this.moveThumb(mouseEvent.getX(), true);
        }

        Mouse() {
            HorizontalSlider.this = HorizontalSlider.this;
        }
    }

    class MouseMtn
    extends MouseMotionAdapter
    implements Serializable {
        public void mouseDragged(MouseEvent mouseEvent) {
            HorizontalSlider.this.moveThumb(mouseEvent.getX(), false);
        }

        MouseMtn() {
            HorizontalSlider.this = HorizontalSlider.this;
        }
    }
}

