/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt;

import java.awt.AWTEventMulticaster;
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.util.ResourceBundle;
import symantec.itools.awt.SliderTick;
import symantec.itools.beans.PropertyChangeSupport;
import symantec.itools.beans.VetoableChangeSupport;
import symantec.itools.resources.ErrorsBundle;
import symantec.itools.util.GeneralUtils;

public abstract class Slider
extends Canvas {
    public static final int TICK_LEFT = 0;
    public static final int TICK_RIGHT = 1;
    public static final int TICK_BOTTOM = 0;
    public static final int TICK_TOP = 1;
    public static final int TICK_BOTH = 2;
    public static final int TICK_NONE = 3;
    protected int width;
    protected int height = 50;
    protected Dimension cachedSize;
    protected boolean forceCallDoReshape = false;
    protected int style = 2;
    protected int freq = 1;
    protected int tempTickFreq;
    protected int min = 1;
    protected int tempMinValue;
    protected int max = 10;
    protected int tempMaxValue;
    protected int prevPos = 0;
    protected int curPos = 0;
    protected int tempValue;
    protected boolean showBorder = true;
    protected ActionListener actionListener;
    protected String actionCommand = "Slider Moved";
    protected boolean isAdded = false;
    protected transient SliderTick[] tick = null;
    protected static final int BORDER_X = 15;
    protected static final int BORDER_Y = 10;
    protected transient ResourceBundle errors;
    private MaxVeto maxVeto;
    private MinVeto minVeto;
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    protected Slider() {
        this.tempMinValue = this.min;
        this.tempMaxValue = this.max;
        this.tempTickFreq = this.freq;
        this.tempValue = this.curPos;
    }

    public void setTickStyle(int n) throws PropertyVetoException {
        if (this.style != n) {
            Integer n2 = new Integer(this.style);
            Integer n3 = new Integer(n);
            this.vetos.fireVetoableChange("tickStyle", n2, n3);
            this.style = n;
            this.changes.firePropertyChange("tickStyle", n2, n3);
            this.forceCallDoReshape = true;
        }
    }

    public int getTickStyle() {
        return this.style;
    }

    public void setMinValue(int n) throws PropertyVetoException {
        if (this.isAdded) {
            if (this.min != n) {
                Integer n2 = new Integer(this.min);
                Integer n3 = new Integer(n);
                this.vetos.fireVetoableChange("minValue", n2, n3);
                this.min = n;
                this.tempMinValue = n;
                this.changes.firePropertyChange("minValue", n2, n3);
                this.forceCallDoReshape = true;
                this.repaint();
                return;
            }
        } else {
            this.tempMinValue = n;
        }
    }

    public int getMinValue() {
        if (this.isAdded) {
            return this.min;
        }
        return this.tempMinValue;
    }

    public void setMaxValue(int n) throws PropertyVetoException {
        if (this.isAdded) {
            if (this.max != n) {
                Integer n2 = new Integer(this.max);
                Integer n3 = new Integer(n);
                this.vetos.fireVetoableChange("maxValue", n2, n3);
                this.max = n;
                this.tempMaxValue = n;
                this.changes.firePropertyChange("maxValue", n2, n3);
                this.forceCallDoReshape = true;
                this.repaint();
                return;
            }
        } else {
            this.tempMaxValue = n;
        }
    }

    public int getMaxValue() {
        if (this.isAdded) {
            return this.max;
        }
        return this.tempMaxValue;
    }

    public void setTickFreq(int n) throws PropertyVetoException {
        if (this.isAdded && this.freq != n) {
            if (n >= this.max) {
                n = this.max - 1;
            }
            Integer n2 = new Integer(this.freq);
            Integer n3 = new Integer(n);
            this.vetos.fireVetoableChange("tickFreq", n2, n3);
            int n4 = this.curPos * this.freq + this.min;
            this.freq = n;
            this.doMove((n4 - this.min) / this.freq, false);
            this.changes.firePropertyChange("tickFreq", n2, n3);
            this.forceCallDoReshape = true;
            this.repaint();
        }
        this.tempTickFreq = n;
    }

    public int getTickFreq() {
        if (this.isAdded) {
            return this.freq;
        }
        return this.tempTickFreq;
    }

    public void setValue(int n) throws PropertyVetoException {
        if (this.isAdded) {
            Integer n2 = new Integer(this.curPos * this.freq + this.min);
            Integer n3 = new Integer(n);
            this.vetos.fireVetoableChange("value", n2, n3);
            if (n < this.getMinValue()) {
                n = this.getMinValue();
            } else if (n > this.getMaxValue()) {
                n = this.getMaxValue();
            }
            this.doMove((n - this.min) / this.freq, false);
            this.changes.firePropertyChange("value", n2, n3);
            this.forceCallDoReshape = true;
            this.repaint();
        }
        this.tempValue = n;
    }

    public int getValue() {
        if (this.isAdded) {
            return this.curPos * this.freq + this.min;
        }
        return this.tempValue;
    }

    public void setShowBorder(boolean bl) throws PropertyVetoException {
        if (this.showBorder != bl) {
            Boolean bl2 = new Boolean(this.showBorder);
            Boolean bl3 = new Boolean(bl);
            this.vetos.fireVetoableChange("showBorder", bl2, bl3);
            this.showBorder = bl;
            this.changes.firePropertyChange("showBorder", bl2, bl3);
            this.repaint();
        }
    }

    public boolean getShowBorder() {
        return this.isShowBorder();
    }

    public boolean isShowBorder() {
        return this.showBorder;
    }

    public void setActionCommand(String string) throws PropertyVetoException {
        String string2 = this.actionCommand;
        this.vetos.fireVetoableChange("actionCommand", string2, string);
        this.actionCommand = string;
        this.changes.firePropertyChange("actionCommand", string2, string);
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public synchronized void addNotify() {
        super.addNotify();
        try {
            this.errors = ResourceBundle.getBundle("symantec.itools.resources.ErrorsBundle");
        }
        catch (Throwable throwable) {
            this.errors = new ErrorsBundle();
        }
        if (this.maxVeto == null) {
            this.maxVeto = new MaxVeto();
            this.addMaxValueListener(this.maxVeto);
        }
        if (this.minVeto == null) {
            this.minVeto = new MinVeto();
            this.addMinValueListener(this.minVeto);
        }
        this.isAdded = true;
        this.verifyContstrainedPropertyValues();
    }

    public synchronized void removeNotify() {
        if (this.maxVeto != null) {
            this.removeMaxValueListener(this.maxVeto);
            this.maxVeto = null;
        }
        if (this.minVeto != null) {
            this.removeMinValueListener(this.minVeto);
            this.minVeto = null;
        }
        super.removeNotify();
        this.isAdded = false;
    }

    public synchronized void addMaxValueListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener("maxValue", propertyChangeListener);
    }

    public synchronized void removeMaxValueListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener("maxValue", propertyChangeListener);
    }

    public synchronized void addMaxValueListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.addVetoableChangeListener("maxValue", vetoableChangeListener);
    }

    public synchronized void removeMaxValueListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.removeVetoableChangeListener("maxValue", vetoableChangeListener);
    }

    public synchronized void addMinValueListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener("minValue", propertyChangeListener);
    }

    public synchronized void removeMinValueListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener("minValue", propertyChangeListener);
    }

    public synchronized void addMinValueListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.addVetoableChangeListener("minValue", vetoableChangeListener);
    }

    public synchronized void removeMinValueListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.removeVetoableChangeListener("minValue", vetoableChangeListener);
    }

    protected boolean isValidMaxValue(int n) {
        return n >= this.min;
    }

    protected boolean isValidMinValue(int n) {
        return n <= this.max;
    }

    protected void verifyContstrainedPropertyValues() {
        try {
            this.setMinValue(this.tempMinValue);
        }
        catch (PropertyVetoException propertyVetoException) {}
        try {
            this.setMaxValue(this.tempMaxValue);
        }
        catch (PropertyVetoException propertyVetoException) {}
        try {
            this.setTickFreq(this.tempTickFreq);
        }
        catch (PropertyVetoException propertyVetoException) {}
        try {
            this.setValue(this.tempValue);
            return;
        }
        catch (PropertyVetoException propertyVetoException) {
            return;
        }
    }

    protected abstract void do_reshape(int var1, int var2);

    protected void doMove(int n, boolean bl) {
        if (this.tick == null) {
            this.prevPos = this.curPos = n;
            return;
        }
        if (n >= this.tick.length) {
            n = this.tick.length - 1;
        }
        if (n != this.curPos || bl) {
            this.prevPos = this.curPos;
            this.curPos = n;
            Graphics graphics = this.getGraphics();
            this.paint(graphics);
            if (graphics != null) {
                graphics.dispose();
            }
            graphics = null;
            this.sourceActionEvent();
        }
    }

    public void paint(Graphics graphics) {
        boolean bl = false;
        Dimension dimension = this.getSize();
        if (!GeneralUtils.objectsEqual(this.cachedSize, dimension)) {
            this.cachedSize = dimension;
            this.width = this.cachedSize.width;
            this.height = this.cachedSize.height;
            bl = true;
        }
        if (this.forceCallDoReshape || bl) {
            this.do_reshape(this.width, this.height);
            this.forceCallDoReshape = false;
        }
    }

    protected void moveThumb(int n, boolean bl) {
        if (this.tick.length > 1) {
            int n2 = this.tick[1].c - this.tick[0].c;
            if (n2 == 0) {
                return;
            }
            int n3 = (n - this.tick[0].c) / n2;
            if (n3 < 0) {
                n3 = 0;
            }
            if ((n - this.tick[0].c) % n2 > n2 / 2) {
                ++n3;
            }
            this.doMove(n3, bl);
        }
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.addVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.removeVetoableChangeListener(vetoableChangeListener);
    }

    protected void sourceActionEvent() {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.actionCommand));
        }
    }

    class MaxVeto
    implements VetoableChangeListener,
    Serializable {
        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            int n = (Integer)propertyChangeEvent.getNewValue();
            if (!Slider.this.isValidMaxValue(n)) {
                throw new PropertyVetoException(String.valueOf(Slider.this.errors.getString("InvalidMaxValue")) + n, propertyChangeEvent);
            }
        }

        MaxVeto() {
            Slider.this = Slider.this;
        }
    }

    class MinVeto
    implements VetoableChangeListener,
    Serializable {
        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            int n = (Integer)propertyChangeEvent.getNewValue();
            if (!Slider.this.isValidMinValue(n)) {
                throw new PropertyVetoException(String.valueOf(Slider.this.errors.getString("InvalidMinValue")) + n, propertyChangeEvent);
            }
        }

        MinVeto() {
            Slider.this = Slider.this;
        }
    }
}

