/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.util.ResourceBundle;
import symantec.itools.beans.PropertyChangeSupport;
import symantec.itools.beans.VetoableChangeSupport;
import symantec.itools.resources.ErrorsBundle;
import symantec.itools.util.GeneralUtils;

public class SplitterPanel
extends Panel {
    public static final int SPLIT_VERTICAL = 1;
    public static final int SPLIT_HORIZONTAL = 2;
    public static final int SPLIT_VER = 1;
    public static final int SPLIT_HOR = 2;
    public static final int SPLIT_BOTH = 3;
    public static final int SPLIT_BOTH_V = 4;
    public static final int SPLIT3_LEFT = 5;
    public static final int SPLIT3_RIGHT = 6;
    public static final int SPLIT3_TOP = 7;
    public static final int SPLIT3_BOTTOM = 8;
    protected boolean use3dBdr = true;
    protected Cursor moveSplitCursor = new Cursor(13);
    protected Dimension minDim;
    protected Dimension prefDim;
    protected Dimension curDim;
    protected int iGapWidth;
    protected int iGapHeight;
    protected int oGapWidth;
    protected int oGapHeight;
    protected int iBdrSize;
    protected int oBdrSize;
    protected int splitType;
    protected int moveFromX;
    protected int moveFromY;
    protected static final int SPLIT_NONE = 0;
    protected transient boolean bOsFlag;
    protected boolean enforceMinDim = false;
    protected boolean propResize = true;
    protected boolean isOuter;
    protected boolean heightOnly;
    protected boolean widthOnly;
    protected transient boolean doMoveSplit = false;
    protected transient boolean cursorChanged = false;
    protected boolean allowDynamicMoving;
    protected SplitterPanel sub1;
    protected SplitterPanel sub2;
    protected SplitterPanel innerSP;
    protected SplitterPanel outerSP;
    protected static SplitterPanel cursorCh = null;
    protected Point curLoc;
    protected Component spComponent;
    protected Color gapColor;
    protected transient ResourceBundle errors;
    private Mouse mouse;
    private MouseMtn mouseMotion;
    private STVeto stVeto;
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public SplitterPanel() {
        this(true);
    }

    public SplitterPanel(int n, int n2) {
        this(true);
        if (this == null) {
            return;
        }
        this.resize(n, n2);
    }

    public SplitterPanel(int n, int n2, int n3) {
        this(n3);
        if (this == null) {
            return;
        }
        this.resize(n, n2);
    }

    public SplitterPanel(int n) {
        this(n, null, null, null, null);
    }

    public SplitterPanel(int n, Component component, Component component2, Component component3, Component component4) {
        this(true);
        if (this == null) {
            return;
        }
        switch (n) {
            case 0: {
                if (component == null) break;
                this.add(component);
                return;
            }
            case 1: {
                this.split(1, component, component2);
                return;
            }
            case 2: {
                this.split(2, component, component3);
                return;
            }
            case 3: {
                this.split(2);
                this.getSubPanel(1).split(1, component, component2);
                this.getSubPanel(2).split(1, component3, component4);
                return;
            }
            case 4: {
                this.split(1);
                this.getSubPanel(1).split(2, component, component3);
                this.getSubPanel(2).split(2, component2, component4);
                return;
            }
            case 5: {
                this.split(1, null, component2);
                this.getSubPanel(1).split(2, component, component3);
                return;
            }
            case 6: {
                this.split(1, component, null);
                this.getSubPanel(2).split(2, component2, component4);
                return;
            }
            case 7: {
                this.split(2, null, component3);
                this.getSubPanel(1).split(1, component, component2);
                return;
            }
            case 8: {
                this.split(2, component, null);
                this.getSubPanel(2).split(1, component3, component4);
                return;
            }
        }
    }

    private SplitterPanel(boolean bl) {
        this.isOuter = bl;
        this.heightOnly = false;
        this.widthOnly = false;
        this.allowDynamicMoving = false;
        this.splitType = 0;
        this.minDim = new Dimension(0, 0);
        this.curDim = new Dimension(0, 0);
        this.curLoc = new Point(0, 0);
        this.prefDim = new Dimension(0, 0);
        try {
            this.setGapColor(Color.lightGray);
        }
        catch (PropertyVetoException propertyVetoException) {}
        this.iGapWidth = 3;
        this.iGapHeight = 3;
        this.iBdrSize = 2;
        this.oGapWidth = 3;
        this.oGapHeight = 3;
        this.oBdrSize = 2;
        if (bl) {
            this.innerSP = new SplitterPanel(false);
            super.add((Component)this.innerSP, -1);
            this.outerSP = this;
            this.innerSP.outerSP = this;
            this.layout();
        }
    }

    public void setUse3DBorder(boolean bl) throws PropertyVetoException {
        if (this.use3dBdr != bl) {
            Boolean bl2 = new Boolean(this.use3dBdr);
            Boolean bl3 = new Boolean(bl);
            this.vetos.fireVetoableChange("Use3DBorder", bl2, bl3);
            this.use3dBdr = bl;
            this.changes.firePropertyChange("Use3DBorder", bl2, bl3);
        }
    }

    public boolean isUse3DBorder() {
        return this.use3dBdr;
    }

    public void setAllowDynamicMoving(boolean bl) throws PropertyVetoException {
        if (this.allowDynamicMoving != bl) {
            Boolean bl2 = new Boolean(this.allowDynamicMoving);
            Boolean bl3 = new Boolean(bl);
            this.vetos.fireVetoableChange("AllowDynamicMoving", bl2, bl3);
            this.allowDynamicMoving = bl;
            this.propagateChanges();
            this.changes.firePropertyChange("AllowDynamicMoving", bl2, bl3);
        }
    }

    public boolean isAllowDynamicMoving() {
        return this.allowDynamicMoving;
    }

    public int getSplitType() {
        SplitterPanel splitterPanel = this;
        if (this.isOuter) {
            splitterPanel = this.innerSP;
        }
        return splitterPanel.splitType;
    }

    public void setMoveSplitCursor(Cursor cursor) throws PropertyVetoException {
        if (!GeneralUtils.objectsEqual(this.moveSplitCursor, cursor)) {
            Cursor cursor2 = this.moveSplitCursor;
            this.vetos.fireVetoableChange("MoveSplitCursor", cursor2, cursor);
            this.moveSplitCursor = cursor;
            this.changes.firePropertyChange("MoveSplitCursor", cursor2, cursor);
        }
    }

    public void setMoveSplitCursor(int n) throws PropertyVetoException, IllegalArgumentException {
        this.setMoveSplitCursor(new Cursor(n));
    }

    public Cursor getMoveSplitCursor() {
        return this.moveSplitCursor;
    }

    public void setGapColor(Color color) throws PropertyVetoException {
        if (!GeneralUtils.objectsEqual(this.gapColor, color)) {
            Color color2 = this.gapColor;
            this.vetos.fireVetoableChange("GapColor", color2, color);
            this.gapColor = new Color(color.getRed(), color.getGreen(), color.getBlue());
            this.propagateChanges();
            this.changes.firePropertyChange("GapColor", color2, color);
        }
    }

    public Color getGapColor() {
        return this.gapColor;
    }

    public Color gapColor() {
        return this.getGapColor();
    }

    public void setEnforceMinDim(boolean bl) throws PropertyVetoException {
        if (this.enforceMinDim != bl) {
            Boolean bl2 = new Boolean(this.enforceMinDim);
            Boolean bl3 = new Boolean(bl);
            this.vetos.fireVetoableChange("EnforceMinDim", bl2, bl3);
            this.enforceMinDim = bl;
            this.propagateChanges();
            this.changes.firePropertyChange("EnforceMinDim", bl2, bl3);
        }
    }

    public boolean isEnforceMinDim() {
        return this.enforceMinDim;
    }

    public boolean getEnforceMinDim() {
        return this.isEnforceMinDim();
    }

    public void setPropResize(boolean bl) throws PropertyVetoException {
        if (this.propResize != bl) {
            Boolean bl2 = new Boolean(this.propResize);
            Boolean bl3 = new Boolean(bl);
            this.vetos.fireVetoableChange("PropResize", bl2, bl3);
            this.propResize = bl;
            this.propagateChanges();
            this.changes.firePropertyChange("PropResize", bl2, bl3);
        }
    }

    public boolean isPropResize() {
        return this.propResize;
    }

    public boolean getPropResize() {
        return this.isPropResize();
    }

    public void setGapSizes(int n) {
        this.iGapWidth = n;
        this.iGapHeight = n;
        this.oGapWidth = n;
        this.oGapHeight = n;
        this.adjustOGapBdr();
        this.propagateChanges();
        this.repaint();
    }

    public void setGapSizes(int n, int n2) {
        this.iGapWidth = n;
        this.iGapHeight = n2;
        this.oGapWidth = n;
        this.oGapHeight = n2;
        this.adjustOGapBdr();
        this.propagateChanges();
        this.repaint();
    }

    public void setGapSizes(int n, int n2, int n3, int n4) {
        this.iGapWidth = n;
        this.iGapHeight = n2;
        this.oGapWidth = n3;
        this.oGapHeight = n4;
        this.adjustOGapBdr();
        this.propagateChanges();
        this.repaint();
    }

    public void setBdrSizes(int n, int n2) {
        this.iBdrSize = n;
        this.oBdrSize = n2;
        this.adjustOGapBdr();
        this.propagateChanges();
        this.repaint();
    }

    public void setBdrSizes(int n) {
        this.iBdrSize = n;
        this.oBdrSize = n;
        this.adjustOGapBdr();
        this.propagateChanges();
        this.repaint();
    }

    public SplitterPanel getSubPanel(int n) {
        SplitterPanel splitterPanel = this;
        if (this.isOuter) {
            splitterPanel = this.innerSP;
        }
        if (n == 1) {
            return splitterPanel.sub1;
        }
        if (n == 2) {
            return splitterPanel.sub2;
        }
        return null;
    }

    public SplitterPanel getSubPanel(int n, int n2) {
        if (this.getSplitType() == n2) {
            return this.getSubPanel(n);
        }
        return null;
    }

    public SplitterPanel getSub2Panel(int n, int n2, int n3, int n4) {
        SplitterPanel splitterPanel = this.getSubPanel(n, n2);
        if (splitterPanel != null) {
            return splitterPanel.getSubPanel(n3, n4);
        }
        return null;
    }

    public SplitterPanel getTopPanel() {
        return this.getSubPanel(1, 2);
    }

    public SplitterPanel getBottomPanel() {
        return this.getSubPanel(2, 2);
    }

    public SplitterPanel getLeftPanel() {
        return this.getSubPanel(1, 1);
    }

    public SplitterPanel getRightPanel() {
        return this.getSubPanel(2, 1);
    }

    public SplitterPanel getTopLeftPanel() {
        if (this.getSplitType() == 2) {
            return this.getSub2Panel(1, 2, 1, 1);
        }
        return this.getSub2Panel(1, 1, 1, 2);
    }

    public SplitterPanel getTopRightPanel() {
        if (this.getSplitType() == 2) {
            return this.getSub2Panel(1, 2, 2, 1);
        }
        return this.getSub2Panel(2, 1, 1, 2);
    }

    public SplitterPanel getBottomLeftPanel() {
        if (this.getSplitType() == 2) {
            return this.getSub2Panel(2, 2, 1, 1);
        }
        return this.getSub2Panel(1, 1, 2, 2);
    }

    public SplitterPanel getBottomRightPanel() {
        if (this.getSplitType() == 2) {
            return this.getSub2Panel(2, 2, 2, 1);
        }
        return this.getSub2Panel(2, 1, 2, 2);
    }

    public int iGapWidth() {
        return this.iGapWidth;
    }

    public int iGapHeight() {
        return this.iGapHeight;
    }

    public int oGapWidth() {
        return this.oGapWidth;
    }

    public int oGapHeight() {
        return this.oGapHeight;
    }

    public int iBdrSize() {
        return this.iBdrSize;
    }

    public int oBdrSize() {
        return this.oBdrSize;
    }

    public synchronized void layout() {
        this.placeComponents();
    }

    public void moveSplit(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        if (this.isOuter) {
            this.innerSP.moveSplit(n, n2);
            return;
        }
        Dimension dimension = this.sub1.minimumSize();
        Dimension dimension2 = this.sub2.minimumSize();
        Rectangle rectangle = new Rectangle(this.sub1.curLoc.x, this.sub1.curLoc.y, this.sub1.curDim.width, this.sub1.curDim.height);
        Rectangle rectangle2 = new Rectangle(this.sub2.curLoc.x, this.sub2.curLoc.y, this.sub2.curDim.width, this.sub2.curDim.height);
        int n9 = rectangle.x;
        int n10 = rectangle.y;
        if (this.splitType == 2) {
            if (n2 == 0) {
                return;
            }
            if (n2 > 0) {
                n8 = this.enforceMinDim ? Math.max(rectangle2.height - n2, dimension2.height) : Math.max(rectangle2.height - n2, 2 * this.iBdrSize);
                n7 = rectangle.height + rectangle2.height - n8;
            } else {
                n7 = this.enforceMinDim ? Math.max(rectangle.height + n2, dimension.height) : Math.max(rectangle.height + n2, 2 * this.iBdrSize);
                n8 = rectangle2.height + rectangle.height - n7;
            }
            n6 = rectangle.width;
            n5 = rectangle2.width;
            n4 = rectangle2.x;
            n3 = rectangle2.y - rectangle.height + n7;
            this.sub1.reshapeHeight(n10, n7);
            this.sub2.reshapeHeight(n3, n8);
        }
        if (this.splitType == 1) {
            if (n == 0) {
                return;
            }
            if (n > 0) {
                n5 = this.enforceMinDim ? Math.max(rectangle2.width - n, dimension2.width) : Math.max(rectangle2.width - n, 2 * this.iBdrSize);
                n6 = rectangle.width + rectangle2.width - n5;
            } else {
                n6 = this.enforceMinDim ? Math.max(rectangle.width + n, dimension.width) : Math.max(rectangle.width + n, this.iBdrSize);
                n5 = rectangle2.width + rectangle.width - n6;
            }
            n7 = rectangle.height;
            n8 = rectangle2.height;
            n3 = rectangle2.y;
            n4 = rectangle2.x - rectangle.width + n6;
            this.sub1.reshapeWidth(n9, n6);
            this.sub2.reshapeWidth(n4, n5);
        }
        this.sub1.invalidate();
        this.sub1.validate();
        this.sub1.repaint();
        this.sub2.invalidate();
        this.sub2.validate();
        this.sub2.repaint();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public synchronized void paint(Graphics graphics) {
        Dimension dimension = this.size();
        Color color = this.getBackground();
        graphics.setColor(color);
        if (this.isOuter) {
            graphics.setColor(this.gapColor);
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            this.draw3DBdr(graphics, 0, 0, dimension.width - 1, dimension.height - 1, this.oBdrSize, this.gapColor, true);
        } else if (this.splitType == 0) {
            graphics.setColor(color);
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            this.draw3DBdr(graphics, 0, 0, dimension.width - 1, dimension.height - 1, this.iBdrSize, this.gapColor, false);
        } else {
            graphics.setColor(this.gapColor);
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
        super.paint(graphics);
    }

    public Component getComponent() {
        if (this.isOuter) {
            return this.innerSP.getComponent();
        }
        return this.spComponent;
    }

    public Component[] getComponents() {
        if (this.isOuter) {
            return this.innerSP.getComponents();
        }
        return super.getComponents();
    }

    public int getComponentCount() {
        if (this.isOuter) {
            return this.innerSP.getComponentCount();
        }
        return super.getComponentCount();
    }

    public Dimension preferredSize() {
        Dimension dimension = this.size();
        Dimension dimension2 = this.getMinimumSize();
        return new Dimension(Math.max(dimension.width, dimension2.width), Math.max(dimension.height, dimension2.height));
    }

    public Dimension minimumSize() {
        Dimension dimension;
        if (this.isOuter) {
            dimension = new Dimension(this.innerSP.minimumSize());
            dimension.width += 2 * (this.oGapWidth + this.oBdrSize);
            dimension.height += 2 * (this.oGapHeight + this.oBdrSize);
        } else if (this.splitType == 0) {
            dimension = this.spComponent == null ? new Dimension(0, 0) : new Dimension(this.spComponent.minimumSize());
            dimension.width += 2 * this.iBdrSize;
            dimension.height += 2 * this.iBdrSize;
        } else {
            Dimension dimension2 = this.sub1.minimumSize();
            Dimension dimension3 = this.sub2.minimumSize();
            if (this.splitType == 2) {
                dimension = new Dimension(dimension2.width, dimension2.height + dimension3.height);
                dimension.height += this.iGapHeight;
            } else {
                dimension = new Dimension(dimension2.width + dimension2.width, dimension2.height);
                dimension.width += this.iGapWidth;
            }
        }
        return this.maxDimOf(this.minDim, dimension);
    }

    public void setPreferredSize(Dimension dimension) {
        this.prefDim.width = dimension.width;
        this.prefDim.height = dimension.height;
        this.prefDim = this.maxDimOf(dimension, this.prefDim);
        this.layout();
    }

    public void setMinimumSize(Dimension dimension) {
        this.minDim.width = dimension.width;
        this.minDim.height = dimension.height;
        this.prefDim = this.maxDimOf(dimension, this.prefDim);
        this.layout();
    }

    public synchronized void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        if (this.curDim.width != n3 || this.curDim.height != n4 || this.curLoc.x != n || this.curLoc.y != n2) {
            this.layout();
            this.curDim.width = n3;
            this.curDim.height = n4;
            this.curLoc.x = n;
            this.curLoc.y = n2;
        }
    }

    public synchronized void reshapeWidth(int n, int n2) {
        Rectangle rectangle = new Rectangle(this.curLoc.x, this.curLoc.y, this.curDim.width, this.curDim.height);
        if (this.curDim.width != n2) {
            this.widthOnly = true;
            this.curDim.width = n2;
        }
        this.reshape(n, rectangle.y, n2, rectangle.height);
    }

    public synchronized void reshapeHeight(int n, int n2) {
        Rectangle rectangle = new Rectangle(this.curLoc.x, this.curLoc.y, this.curDim.width, this.curDim.height);
        if (this.curDim.height != n2) {
            this.heightOnly = true;
            this.curDim.height = n2;
        }
        this.reshape(rectangle.x, n, rectangle.width, n2);
    }

    public synchronized Component add(Component component, int n) {
        if (component == null) {
            return null;
        }
        if (this.isOuter) {
            return this.innerSP.add(component, n);
        }
        if (this.spComponent != null) {
            super.remove(this.spComponent);
        }
        this.spComponent = super.add(component, -1);
        this.layout();
        return this.spComponent;
    }

    public Component add(Component component) {
        return this.add(component, -1);
    }

    public synchronized void remove(Component component) {
        if (this.isOuter) {
            this.innerSP.remove(component);
            return;
        }
        if (component == this.spComponent) {
            this.spComponent = null;
            super.remove(component);
            return;
        }
        if (this.sub1 != null) {
            this.sub1.remove(component);
        }
        if (this.sub2 != null) {
            this.sub2.remove(component);
        }
    }

    public synchronized void removeAll() {
        if (this.isOuter) {
            this.innerSP.removeAll();
        } else {
            super.removeAll();
            if (this.sub1 != null) {
                super.add((Component)this.sub1, -1);
                this.sub1.removeAll();
            }
            if (this.sub2 != null) {
                super.add((Component)this.sub2, -1);
                this.sub1.removeAll();
            }
        }
        this.spComponent = null;
    }

    public SplitterPanel split(int n) {
        return this.split(n, null, null);
    }

    public synchronized SplitterPanel split(int n, Component component, Component component2) {
        if (this.isOuter) {
            return this.innerSP.split(n, component, component2);
        }
        if (this.splitType != 0) {
            return null;
        }
        if (n != 1 && n != 2) {
            return null;
        }
        this.sub1 = new SplitterPanel(false);
        if (this.sub1 == null) {
            return null;
        }
        this.sub2 = new SplitterPanel(false);
        if (this.sub2 == null) {
            super.remove(this.sub1);
            return null;
        }
        this.splitType = n;
        this.sub1.outerSP = this.outerSP;
        this.sub2.outerSP = this.outerSP;
        super.add((Component)this.sub1, -1);
        super.add((Component)this.sub2, -1);
        if (component != null) {
            this.sub1.add(component);
        }
        if (component2 != null) {
            this.sub2.add(component2);
        }
        this.propagateChanges();
        return this.sub1;
    }

    public void setLayout(LayoutManager layoutManager) {
    }

    public void oGapThis(int n, int n2) {
        if (!this.doMoveSplit && !this.inGap(n, n2)) {
            this.resetCursor();
        }
    }

    public boolean oGapThis(Event event) {
        this.oGapThis(event.x, event.y);
        return true;
    }

    public String toString() {
        String string = "Bad Panel ";
        if (this.isOuter) {
            string = "Outer ";
        } else {
            if (this.splitType == 0) {
                string = "Unsplit ";
            }
            if (this.splitType == 1) {
                string = "Vertically split ";
            }
            if (this.splitType == 2) {
                string = "Horizontally split ";
            }
        }
        Container container = this.getParent();
        String string2 = container == null ? " with no parent (not added)" : " with parent @" + container.hashCode();
        return String.valueOf(string) + super.toString() + ": @" + this.hashCode() + string2;
    }

    public synchronized void addNotify() {
        super.addNotify();
        try {
            this.errors = ResourceBundle.getBundle("symantec.itools.resources.ErrorsBundle");
        }
        catch (Throwable throwable) {
            this.errors = new ErrorsBundle();
        }
        if (this.mouse == null) {
            this.mouse = new Mouse();
            this.addMouseListener(this.mouse);
        }
        if (this.mouseMotion == null) {
            this.mouseMotion = new MouseMtn();
            this.addMouseMotionListener(this.mouseMotion);
        }
        if (this.stVeto == null) {
            this.stVeto = new STVeto();
            this.addSplitTypeListener(this.stVeto);
        }
    }

    public synchronized void removeNotify() {
        if (this.mouse != null) {
            this.removeMouseListener(this.mouse);
            this.mouse = null;
        }
        if (this.mouseMotion != null) {
            this.removeMouseMotionListener(this.mouseMotion);
            this.mouseMotion = null;
        }
        if (this.stVeto != null) {
            this.removeSplitTypeListener(this.stVeto);
            this.stVeto = null;
        }
        super.removeNotify();
    }

    public boolean isValidSplitType(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.addVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.removeVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized void addSplitTypeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener("SplitType", propertyChangeListener);
    }

    public synchronized void removeSplitTypeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener("SplitType", propertyChangeListener);
    }

    public synchronized void addSplitTypeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.addVetoableChangeListener("SplitType", vetoableChangeListener);
    }

    public synchronized void removeSplitTypeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.removeVetoableChangeListener("SplitType", vetoableChangeListener);
    }

    protected MouseListener getMouseListener() {
        return this.mouse;
    }

    protected int optSize(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        int n8 = Math.max(n2, 0);
        int n9 = Math.max(n3, 1);
        int n10 = Math.max(n4, 1);
        int n11 = Math.max(n5, n9);
        int n12 = n - (n11 + (n7 = Math.max(n6, n10)) + n8);
        if (n12 >= 0) {
            float f = (float)n11 / (float)(n11 + n7);
            return n11 + (int)((float)n12 * f);
        }
        n12 = n - (n9 + n10 + n8);
        if (n12 >= 0) {
            float f = (float)n11 / (float)(n11 + n7);
            return n9 + (int)((float)n12 * f);
        }
        if (n > n8) {
            float f = (float)n9 / (float)(n9 + n10);
            return n9 + (int)((float)n12 * f);
        }
        return n;
    }

    protected void placeComponents() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        Dimension dimension;
        Dimension dimension2;
        Dimension dimension3;
        Dimension dimension4;
        Rectangle rectangle = new Rectangle(this.curLoc.x, this.curLoc.y, this.curDim.width, this.curDim.height);
        if (this.isOuter) {
            int n9 = this.oGapWidth + this.oBdrSize;
            int n10 = this.oGapHeight + this.oBdrSize;
            int n11 = rectangle.width - (2 * this.oGapWidth + this.oBdrSize + 1);
            int n12 = rectangle.height - (2 * this.oGapHeight + this.oBdrSize + 1);
            this.innerSP.reshape(n9, n10, n11, n12);
            return;
        }
        if (this.sub1 == null) {
            dimension4 = new Dimension(1, 1);
            dimension3 = new Dimension(1, 1);
        } else {
            dimension4 = this.sub1.minimumSize();
            dimension3 = this.sub1.preferredSize();
        }
        if (this.sub2 == null) {
            dimension2 = new Dimension(1, 1);
            dimension = new Dimension(1, 1);
        } else {
            dimension2 = this.sub2.minimumSize();
            dimension = this.sub2.preferredSize();
        }
        switch (this.splitType) {
            case 0: {
                if (this.spComponent != null) {
                    int n13 = this.iBdrSize;
                    int n14 = this.iBdrSize;
                    int n15 = rectangle.width - 2 * this.iBdrSize;
                    int n16 = rectangle.height - 2 * this.iBdrSize;
                    if (n15 < 0) {
                        n15 = 0;
                    }
                    if (n16 < 0) {
                        n16 = 0;
                    }
                    if (this.propResize) {
                        this.spComponent.reshape(n13, n14, n15, n16);
                    } else {
                        this.spComponent.move(n13, n14);
                    }
                    this.spComponent.layout();
                    this.spComponent.invalidate();
                    this.spComponent.validate();
                    try {
                        this.spComponent.repaint();
                        return;
                    }
                    catch (Exception exception) {
                        this.repaint();
                        return;
                    }
                }
                return;
            }
            case 1: {
                n8 = 0;
                n7 = 0;
                n6 = this.optSize(rectangle.width, this.iGapWidth, dimension4.width, dimension2.width, dimension3.width, dimension.width);
                n5 = rectangle.height;
                n4 = n6 + this.iGapWidth;
                n3 = 0;
                n2 = rectangle.width - n4;
                n = rectangle.height;
                break;
            }
            case 2: {
                n8 = 0;
                n7 = 0;
                n6 = rectangle.width;
                n5 = this.optSize(rectangle.height, this.iGapHeight, dimension4.height, dimension2.height, dimension3.height, dimension.height);
                n4 = 0;
                n3 = n5 + this.iGapHeight;
                n2 = rectangle.width;
                n = rectangle.height - n3;
                break;
            }
            default: {
                return;
            }
        }
        if (this.heightOnly) {
            this.heightOnly = false;
            this.sub1.reshapeHeight(n7, n5);
            this.sub2.reshapeHeight(n3, n);
        } else if (this.widthOnly) {
            this.widthOnly = false;
            this.sub1.reshapeWidth(n8, n6);
            this.sub2.reshapeWidth(n4, n2);
        } else {
            this.sub1.reshape(n8, n7, n6, n5);
            this.sub2.reshape(n4, n3, n2, n);
        }
        this.sub1.invalidate();
        this.sub1.validate();
        this.sub1.repaint();
        this.sub2.invalidate();
        this.sub2.validate();
        this.sub2.repaint();
    }

    protected void draw3DBdr(Graphics graphics, int n, int n2, int n3, int n4, int n5, Color color, boolean bl) {
        if (n5 < 0) {
            return;
        }
        graphics.setColor(this.use3dBdr ? color : color.darker());
        int n6 = 0;
        while (n6 < n5) {
            if (this.use3dBdr) {
                graphics.draw3DRect(n + n6, n2 + n6, n3 - 2 * n6, n4 - 2 * n6, bl);
            } else {
                graphics.drawRect(n + n6, n2 + n6, n3 - 2 * n6, n4 - 2 * n6);
            }
            ++n6;
        }
    }

    protected void propagateChanges() {
        if (this.innerSP != null) {
            this.propagateChangesSP(this.innerSP);
            this.innerSP.propagateChanges();
        }
        if (this.sub1 != null) {
            this.propagateChangesSP(this.sub1);
            this.sub1.propagateChanges();
        }
        if (this.sub2 != null) {
            this.propagateChangesSP(this.sub2);
            this.sub2.propagateChanges();
        }
    }

    protected void propagateChangesSP(SplitterPanel splitterPanel) {
        splitterPanel.gapColor = this.gapColor;
        splitterPanel.enforceMinDim = this.enforceMinDim;
        splitterPanel.moveSplitCursor = this.moveSplitCursor;
        splitterPanel.propResize = this.propResize;
        if (splitterPanel.oGapWidth != this.oGapWidth || splitterPanel.iGapWidth != this.iGapWidth || splitterPanel.oGapHeight != this.oGapHeight || splitterPanel.iGapHeight != this.iGapHeight || splitterPanel.iBdrSize != this.iBdrSize || splitterPanel.oBdrSize != this.oBdrSize || splitterPanel.use3dBdr != this.use3dBdr || splitterPanel.allowDynamicMoving != this.allowDynamicMoving) {
            splitterPanel.oGapWidth = this.oGapWidth;
            splitterPanel.iGapWidth = this.iGapWidth;
            splitterPanel.oGapHeight = this.oGapHeight;
            splitterPanel.iGapHeight = this.iGapHeight;
            splitterPanel.iBdrSize = this.iBdrSize;
            splitterPanel.oBdrSize = this.oBdrSize;
            splitterPanel.use3dBdr = this.use3dBdr;
            splitterPanel.allowDynamicMoving = this.allowDynamicMoving;
            this.layout();
            splitterPanel.layout();
        }
    }

    protected Dimension maxDimOf(Dimension dimension, Dimension dimension2) {
        return new Dimension(Math.max(dimension.width, dimension2.width), Math.max(dimension.height, dimension2.height));
    }

    protected void resetCursor() {
        if (!this.outerSP.cursorChanged) {
            return;
        }
        try {
            this.setCursor(new Cursor(0));
            this.outerSP.cursorChanged = false;
            cursorCh = null;
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    public synchronized void setCursor(Cursor cursor) {
        if (this.outerSP.cursorChanged) {
            return;
        }
        if (this.isOuter) {
            try {
                super.setCursor(cursor);
                this.cursorChanged = true;
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return;
            }
        }
        this.outerSP.setCursor(cursor);
    }

    protected boolean inComponent(Component component, int n, int n2) {
        Rectangle rectangle = component.bounds();
        rectangle.grow(-this.iBdrSize - 1, -this.iBdrSize - 1);
        return n - rectangle.x >= 0 && n - rectangle.x <= rectangle.width && n2 - rectangle.y >= 0 && n2 - rectangle.y <= rectangle.height;
    }

    protected boolean inGap(int n, int n2) {
        if (this.inGap1(n, n2)) {
            return true;
        }
        if (this.isOuter) {
            return this.innerSP.inGap(n - this.innerSP.curLoc.x, n2 - this.innerSP.curLoc.y);
        }
        if (this.splitType == 2 || this.splitType == 1) {
            return this.sub1.inGap(n - this.sub1.curLoc.x, n2 - this.sub1.curLoc.y) || this.sub2.inGap(n - this.sub2.curLoc.x, n2 - this.sub2.curLoc.y);
        }
        return false;
    }

    protected boolean inGap1(int n, int n2) {
        if (!this.inside(n, n2)) {
            return false;
        }
        if (this.isOuter) {
            return false;
        }
        if (this.inOutBoarder(n, n2)) {
            return false;
        }
        if (this.splitType == 2 || this.splitType == 1) {
            if (this.inComponent(this.sub1, n, n2) || this.inComponent(this.sub2, n, n2)) {
                return false;
            }
            if (this.inComponent(this, n, n2)) {
                cursorCh = this;
            }
            return true;
        }
        return false;
    }

    protected boolean inOutBoarder(int n, int n2) {
        Container container = this;
        Rectangle rectangle = container.bounds();
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        while (container != this.outerSP) {
            container = container.getParent();
            rectangle = container.bounds();
            n3 += rectangle.x;
            n4 += rectangle.y;
        }
        rectangle.grow(-(this.outerSP.iBdrSize + this.outerSP.oBdrSize + this.outerSP.oGapWidth / 2 + 4), -(this.outerSP.iBdrSize + this.outerSP.oBdrSize + this.outerSP.oGapHeight / 2 + 4));
        rectangle.move(rectangle.x + this.outerSP.oGapWidth / 2, rectangle.y + this.outerSP.oGapHeight / 2);
        return !rectangle.inside(n3 + n, n4 + n2);
    }

    protected void adjustOGapBdr() {
        if (this.oGapWidth < this.oBdrSize) {
            this.oGapWidth = Math.max(0, this.oBdrSize);
        }
        if (this.oGapHeight < this.oBdrSize) {
            this.oGapHeight = Math.max(0, this.oBdrSize);
        }
    }

    class Mouse
    extends MouseAdapter
    implements Serializable {
        public void mousePressed(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (SplitterPanel.this.isOuter) {
                SplitterPanel.this.oGapThis(n, n2);
                return;
            }
            if (SplitterPanel.this.splitType == 2 && SplitterPanel.this.outerSP.cursorChanged) {
                SplitterPanel.this.doMoveSplit = true;
                SplitterPanel.this.moveFromX = n;
                SplitterPanel.this.moveFromY = n2;
                return;
            }
            if (SplitterPanel.this.splitType == 1 && SplitterPanel.this.outerSP.cursorChanged) {
                SplitterPanel.this.doMoveSplit = true;
                SplitterPanel.this.moveFromX = n;
                SplitterPanel.this.moveFromY = n2;
                return;
            }
            if (SplitterPanel.this.outerSP.cursorChanged) {
                Mouse mouse;
                Point point = SplitterPanel.this.location();
                SplitterPanel splitterPanel = (SplitterPanel)SplitterPanel.this.getParent();
                if (splitterPanel != null && (mouse = splitterPanel.mouse) != null) {
                    mouse.mousePressed(new MouseEvent(cursorCh, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x + n, point.y + n2, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (SplitterPanel.this.isOuter) {
                SplitterPanel.this.oGapThis(n, n2);
                return;
            }
            if (SplitterPanel.this.doMoveSplit) {
                SplitterPanel.this.moveSplit(n - SplitterPanel.this.moveFromX, n2 - SplitterPanel.this.moveFromY);
                SplitterPanel.this.doMoveSplit = false;
            }
        }

        Mouse() {
            SplitterPanel.this = SplitterPanel.this;
        }
    }

    class MouseMtn
    implements MouseMotionListener,
    Serializable {
        public void mouseMoved(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (SplitterPanel.this.isOuter) {
                SplitterPanel.this.oGapThis(n, n2);
                return;
            }
            if (SplitterPanel.this.splitType == 2 && SplitterPanel.this.inGap1(n, n2)) {
                SplitterPanel.this.setCursor(SplitterPanel.this.moveSplitCursor);
                return;
            }
            if (SplitterPanel.this.splitType == 1 && SplitterPanel.this.inGap1(n, n2)) {
                SplitterPanel.this.setCursor(SplitterPanel.this.moveSplitCursor);
                return;
            }
            if (!SplitterPanel.this.doMoveSplit && !SplitterPanel.this.inGap(n, n2)) {
                SplitterPanel.this.resetCursor();
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (SplitterPanel.this.isOuter) {
                SplitterPanel.this.oGapThis(n, n2);
                return;
            }
            if (SplitterPanel.this.doMoveSplit) {
                SplitterPanel.this.setCursor(SplitterPanel.this.moveSplitCursor);
                if (SplitterPanel.this.allowDynamicMoving) {
                    SplitterPanel.this.moveSplit(n - SplitterPanel.this.moveFromX, n2 - SplitterPanel.this.moveFromY);
                    SplitterPanel.this.moveFromX = n;
                    SplitterPanel.this.moveFromY = n2;
                }
            }
        }

        MouseMtn() {
            SplitterPanel.this = SplitterPanel.this;
        }
    }

    class STVeto
    implements VetoableChangeListener,
    Serializable {
        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            int n = (Integer)propertyChangeEvent.getNewValue();
            if (!SplitterPanel.this.isValidSplitType(n)) {
                throw new PropertyVetoException(String.valueOf(SplitterPanel.this.errors.getString("InvalidSplitType")) + n, propertyChangeEvent);
            }
        }

        STVeto() {
            SplitterPanel.this = SplitterPanel.this;
        }
    }
}

