/*
 * Decompiled with CFR 0.152.
 */
package kom.itbeankit.common.message;

import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import kom.itbeankit.common.message.MessageEvent;
import symantec.itools.awt.WrappingLabel;

public class MessageDialog
extends Dialog {
    Button okButton;
    WrappingLabel wrappingLabel;
    boolean fComponentsAdjusted = false;

    public MessageDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.setLayout(null);
        this.setVisible(false);
        ((Component)this).setSize(297, 144);
        ((Component)this).setFont(new Font("Dialog", 0, 12));
        this.setForeground(new Color(0));
        ((Component)this).setBackground(new Color(0xFFFFFF));
        this.okButton = new Button();
        this.okButton.setLabel("OK");
        this.okButton.setBounds(108, 108, 70, 30);
        this.okButton.setFont(new Font("Dialog", 1, 12));
        this.okButton.setBackground(new Color(0xC0C0C0));
        this.add(this.okButton);
        this.okButton.setCursor(new Cursor(12));
        this.wrappingLabel = new WrappingLabel();
        this.wrappingLabel.setBounds(12, 12, 276, 84);
        this.add(this.wrappingLabel);
        this.setTitle("Info");
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        SymAction lSymAction = new SymAction();
        this.okButton.addActionListener(lSymAction);
    }

    public MessageDialog(Frame parent, MessageEvent me) {
        this(parent, true);
        int msgType = me.getMsgType();
        String title = "";
        String msg = me.getMsg();
        String msgSrc = me.getMsgSource();
        if (!msgSrc.equals("")) {
            msg = String.valueOf(msgSrc) + ": " + msg;
        }
        switch (msgType) {
            case 710: {
                title = "INFO";
                break;
            }
            case 711: {
                title = "WARNING";
                break;
            }
            case 712: {
                title = "ERROR";
                break;
            }
        }
        this.setTitle(title);
        try {
            this.wrappingLabel.setText(msg);
        }
        catch (Exception exception) {}
    }

    public MessageDialog(Frame parent, String title, boolean modal) {
        this(parent, modal);
        this.setTitle(title);
    }

    public void addNotify() {
        Dimension d = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        ((Component)this).setSize(this.insets().left + this.insets().right + d.width, this.insets().top + this.insets().bottom + d.height);
        Component[] components = this.getComponents();
        int i = 0;
        while (i < components.length) {
            Point p = components[i].getLocation();
            p.translate(this.insets().left, this.insets().top);
            components[i].setLocation(p);
            ++i;
        }
        this.fComponentsAdjusted = true;
    }

    public void setVisible(boolean b) {
        if (b) {
            Rectangle bounds = this.getParent().bounds();
            Rectangle abounds = this.bounds();
            this.move(bounds.x + (bounds.width - abounds.width) / 2, bounds.y + (bounds.height - abounds.height) / 2);
        }
        super.setVisible(b);
    }

    void MessageDialog_WindowClosing(WindowEvent event) {
        this.dispose();
    }

    void okButton_Clicked(ActionEvent event) {
        this.dispose();
    }

    class SymWindow
    extends WindowAdapter {
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == MessageDialog.this) {
                MessageDialog.this.MessageDialog_WindowClosing(event);
            }
        }

        SymWindow() {
            MessageDialog.this = MessageDialog.this;
        }
    }

    class SymAction
    implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == MessageDialog.this.okButton) {
                MessageDialog.this.okButton_Clicked(event);
            }
        }

        SymAction() {
            MessageDialog.this = MessageDialog.this;
        }
    }
}

