/*
 * Decompiled with CFR 0.152.
 */
package kom.itbeankit.nw.ethernet;

import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import kom.itbeankit.common.message.MessageEvent;
import kom.itbeankit.nw.ethernet.EthernetInterface;
import kom.itbeankit.nw.ethernet.Host;

public class HostDialog
extends Dialog
implements EthernetInterface {
    Button applyButton;
    Button doneButton;
    Label destinationLabel;
    Choice destinationChoice;
    Label farmeSizeLabel;
    Button helpButton;
    Choice frameSizeChoice;
    Label repeatLabel;
    Choice repeatChoice;
    Host host;
    boolean fComponentsAdjusted = false;

    public HostDialog(Frame parent, boolean modal) {
        super(parent, modal);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.setVisible(false);
        ((Component)this).setSize(200, 160);
        ((Component)this).setFont(new Font("Dialog", 0, 12));
        ((Component)this).setBackground(new Color(0xC0C0C0));
        this.applyButton = new Button();
        this.applyButton.setLabel(" Apply ");
        this.applyButton.setBounds(5, 128, 49, 23);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = new Insets(2, 5, 2, 0);
        ((GridBagLayout)this.getLayout()).setConstraints(this.applyButton, gbc);
        this.add(this.applyButton);
        this.applyButton.setCursor(new Cursor(12));
        this.doneButton = new Button();
        this.doneButton.setLabel(" Done ");
        this.doneButton.setBounds(145, 128, 50, 23);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 13;
        gbc.fill = 0;
        gbc.insets = new Insets(2, 0, 2, 5);
        ((GridBagLayout)this.getLayout()).setConstraints(this.doneButton, gbc);
        this.add(this.doneButton);
        this.doneButton.setCursor(new Cursor(12));
        this.destinationLabel = new Label("Destination");
        this.destinationLabel.setBounds(5, 0, 74, 33);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.insets = new Insets(2, 5, 2, 0);
        ((GridBagLayout)this.getLayout()).setConstraints(this.destinationLabel, gbc);
        this.add(this.destinationLabel);
        this.destinationChoice = new Choice();
        this.destinationChoice.addItem("None");
        this.destinationChoice.addItem("Broadcast");
        this.destinationChoice.addItem("1");
        this.destinationChoice.addItem("2");
        this.destinationChoice.addItem("3");
        this.destinationChoice.addItem("4");
        this.destinationChoice.addItem("5");
        this.destinationChoice.addItem("6");
        this.destinationChoice.addItem("7");
        this.destinationChoice.addItem("8");
        try {
            this.destinationChoice.select(0);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.destinationChoice.setBounds(114, 9, 77, 21);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 0, 2, 5);
        ((GridBagLayout)this.getLayout()).setConstraints(this.destinationChoice, gbc);
        this.add(this.destinationChoice);
        this.destinationChoice.setCursor(new Cursor(12));
        this.farmeSizeLabel = new Label("Frame Size");
        this.farmeSizeLabel.setBounds(5, 40, 74, 33);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.insets = new Insets(2, 5, 2, 0);
        ((GridBagLayout)this.getLayout()).setConstraints(this.farmeSizeLabel, gbc);
        this.add(this.farmeSizeLabel);
        this.helpButton = new Button();
        this.helpButton.setLabel("?");
        this.helpButton.setBounds(83, 48, 21, 23);
        this.helpButton.setFont(new Font("Dialog", 1, 12));
        this.helpButton.setForeground(new Color(255));
        this.helpButton.setBackground(new Color(0xC0C0C0));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = new Insets(2, 0, 2, 10);
        ((GridBagLayout)this.getLayout()).setConstraints(this.helpButton, gbc);
        this.add(this.helpButton);
        this.frameSizeChoice = new Choice();
        this.frameSizeChoice.addItem("Normal");
        this.frameSizeChoice.addItem("too short");
        this.frameSizeChoice.addItem("too long");
        try {
            this.frameSizeChoice.select(0);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.frameSizeChoice.setBounds(114, 49, 81, 21);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 0, 2, 5);
        ((GridBagLayout)this.getLayout()).setConstraints(this.frameSizeChoice, gbc);
        this.add(this.frameSizeChoice);
        this.frameSizeChoice.setCursor(new Cursor(12));
        this.repeatLabel = new Label("Auto Repeat");
        this.repeatLabel.setBounds(5, 80, 78, 40);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.insets = new Insets(2, 5, 2, 0);
        ((GridBagLayout)this.getLayout()).setConstraints(this.repeatLabel, gbc);
        this.add(this.repeatLabel);
        this.repeatChoice = new Choice();
        this.repeatChoice.addItem("NO");
        this.repeatChoice.addItem("YES");
        try {
            this.repeatChoice.select(0);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.repeatChoice.setBounds(114, 89, 81, 21);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 0, 2, 5);
        ((GridBagLayout)this.getLayout()).setConstraints(this.repeatChoice, gbc);
        this.add(this.repeatChoice);
        this.repeatChoice.setCursor(new Cursor(12));
        this.setTitle("Host No. ");
        this.setResizable(false);
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        SymAction lSymAction = new SymAction();
        this.applyButton.addActionListener(lSymAction);
        this.doneButton.addActionListener(lSymAction);
        this.helpButton.addActionListener(lSymAction);
    }

    public HostDialog(Frame parent, Host host) {
        this(parent, false);
        this.host = host;
        String hostID = new Integer(host.getID()).toString();
        this.setTitle(String.valueOf(this.getTitle()) + hostID);
        this.destinationChoice.remove(host.getID() + 1);
        this.setDestinationHost(host.getDestinationHost());
        this.setFrameSize(host.getFrameSize());
        this.setAutoRepeat(host.isAutoRepeat());
    }

    public HostDialog(Frame parent, String title, boolean modal) {
        this(parent, modal);
        this.setTitle(title);
    }

    public void addNotify() {
        Dimension d = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        ((Component)this).setSize(this.insets().left + this.insets().right + d.width, this.insets().top + this.insets().bottom + d.height);
        Component[] components = this.getComponents();
        int i = 0;
        while (i < components.length) {
            Point p = components[i].getLocation();
            p.translate(this.insets().left, this.insets().top);
            components[i].setLocation(p);
            ++i;
        }
        this.fComponentsAdjusted = true;
    }

    public void setVisible(boolean b) {
        if (b) {
            Rectangle bounds = this.getParent().bounds();
            Rectangle abounds = this.bounds();
            ((Component)this).setLocation(bounds.x + (bounds.width - abounds.width) / 2, bounds.y + (bounds.height - abounds.height));
        }
        super.setVisible(b);
    }

    void HostDialog_WindowClosing(WindowEvent event) {
        this.host.hostDialog = null;
        this.host = null;
        this.dispose();
    }

    void doneButton_Clicked(ActionEvent event) {
        this.applyButton_Clicked(event);
        this.host.hostDialog = null;
        this.host = null;
        this.dispose();
    }

    void applyButton_Clicked(ActionEvent event) {
        this.host.setFrameSize(this.getFrameSize());
        this.host.setAutoRepeat(this.isAutoRepeat());
        this.host.setDestinationHost(this.getDestinationHost());
    }

    public int getFrameSize() {
        int frameSize = 0;
        switch (this.frameSizeChoice.getSelectedIndex()) {
            case 0: {
                frameSize = 56;
                break;
            }
            case 1: {
                frameSize = 16;
                break;
            }
            case 2: {
                frameSize = 192;
                break;
            }
        }
        return frameSize;
    }

    public int getDestinationHost() {
        String destination = this.destinationChoice.getSelectedItem();
        int index = this.destinationChoice.getSelectedIndex();
        switch (index) {
            case 0: {
                return -1;
            }
            case 1: {
                return 0;
            }
        }
        return new Integer(destination);
    }

    public boolean isAutoRepeat() {
        return this.repeatChoice.getSelectedIndex() == 1;
    }

    public void setFrameSize(int frameSize) {
        int index = 0;
        switch (frameSize) {
            case 16: {
                index = 1;
                break;
            }
            case 192: {
                index = 2;
                break;
            }
        }
        this.frameSizeChoice.select(index);
    }

    public void setDestinationHost(int DestinationHost) {
        switch (DestinationHost) {
            case -1: {
                this.destinationChoice.select(0);
                break;
            }
            case 0: {
                this.destinationChoice.select(1);
                break;
            }
            default: {
                this.destinationChoice.select(new Integer(DestinationHost).toString());
            }
        }
    }

    public void setAutoRepeat(boolean autoRepeat) {
        int index = 0;
        if (autoRepeat) {
            index = 1;
        }
        this.repeatChoice.select(index);
    }

    void helpButton_ActionPerformed(ActionEvent event) {
        this.host.fireMessageEvent(new MessageEvent(this.host, 702, 710, "Host Dialog", "Sending too short frames may avoid collision detection. Try the related scenario to see the effect. Too long frames produce long delay times."));
    }

    class SymWindow
    extends WindowAdapter {
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == HostDialog.this) {
                HostDialog.this.HostDialog_WindowClosing(event);
            }
        }

        SymWindow() {
            HostDialog.this = HostDialog.this;
        }
    }

    class SymAction
    implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == HostDialog.this.applyButton) {
                HostDialog.this.applyButton_Clicked(event);
            } else if (object == HostDialog.this.doneButton) {
                HostDialog.this.doneButton_Clicked(event);
            } else if (object == HostDialog.this.helpButton) {
                HostDialog.this.helpButton_ActionPerformed(event);
            }
        }

        SymAction() {
            HostDialog.this = HostDialog.this;
        }
    }
}

