/*
 * Decompiled with CFR 0.152.
 */
package kom.itbeankit.nw.ethernet;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.util.Vector;
import kom.itbeankit.common.message.MessageEvent;
import kom.itbeankit.common.message.MessageListener;
import kom.itbeankit.common.vcr.ClkEvent;
import kom.itbeankit.common.vcr.ClkListener;
import kom.itbeankit.nw.ethernet.AlgorithmInterface;
import kom.itbeankit.nw.ethernet.DataEvent;
import kom.itbeankit.nw.ethernet.DataListener;
import kom.itbeankit.nw.ethernet.EthernetInterface;
import kom.itbeankit.nw.ethernet.Host;
import kom.itbeankit.nw.ethernet.Hub;
import kom.itbeankit.nw.ethernet.Hubap;
import symantec.itools.awt.BorderPanel;
import symantec.itools.awt.VerticalSlider;

public class Hubap
extends Container
implements EthernetInterface,
ClkListener,
MessageListener {
    protected AlgorithmInterface algorithm;
    protected boolean usePadField;
    protected int numOfHosts = 6;
    private Vector messageListeners = new Vector();
    protected int scenario = 0;
    Panel hubapPanel = new Panel();
    Panel hostTopPanel;
    Panel busPanel;
    Hub hub1;
    Hub hub2;
    Panel hostBottomPanel;
    BorderPanel efficiencyPanel;
    VerticalSlider performanceSlider;
    Label maxLabel;
    Label minLabel;
    Button helpButton;
    Host host1;
    Host host2;
    Host host3;
    Host host4;
    Host host5;
    Host host6;

    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.host1.setEnabled(b);
        this.host2.setEnabled(b);
        this.host3.setEnabled(b);
        this.host4.setEnabled(b);
        this.host5.setEnabled(b);
        this.host6.setEnabled(b);
    }

    public void doScenario(ClkEvent e) {
        switch (this.scenario) {
            case 0: {
                this.scenarioNone(e);
                break;
            }
            case 1: {
                this.scenarioNormal(e);
                break;
            }
            case 2: {
                this.scenarioCollision(e);
                break;
            }
        }
    }

    void scenarioNone(ClkEvent e) {
        if (e.isRisingEdge()) {
            this.showEfficiency();
        }
        this.hub1.clkReceived(e);
        this.host1.clkReceived(e);
        this.host2.clkReceived(e);
        this.host3.clkReceived(e);
        if (this.numOfHosts > 3) {
            this.host4.clkReceived(e);
            this.host5.clkReceived(e);
            this.host6.clkReceived(e);
            this.hub2.clkReceived(e);
        }
    }

    void scenarioNormal(ClkEvent e) {
        if (this.numOfHosts == 3) {
            this.msg("scenario normal operation", "\n  in this scenario host3 sends\n   a frame to host1.If we had had\na cable instead of a hub that would\nhave not worked because an\nEthernet cable needs all its ways \nout closed with a Host or with 50 ohm");
            this.host3.setFrameSize(56);
            this.host3.setAutoRepeat(false);
            this.host3.setDestinationHost(1);
            this.scenario = 0;
        } else if (this.numOfHosts == 6) {
            this.msg("scenario normal operation", "\n  in this scenario host5 sends\n   a frame to host1");
            this.host5.setFrameSize(56);
            this.host5.setAutoRepeat(false);
            this.host5.setDestinationHost(1);
            this.scenario = 0;
        }
    }

    void scenarioCollision(ClkEvent e) {
        if (this.numOfHosts == 3) {
            this.msg("scenario collision", "\n   in this scenario host2 and\n   host3 send frames at the same\n   time to host3 and host1");
            this.host3.setFrameSize(56);
            this.host3.setAutoRepeat(false);
            this.host2.setFrameSize(56);
            this.host2.setAutoRepeat(false);
            this.host2.setDestinationHost(3);
            this.host3.setDestinationHost(1);
            this.scenario = 0;
        } else if (this.numOfHosts == 6) {
            this.msg("scenario collision", "\n   in this scenario host2 and\n   host6 send frames at the same\n   time to host5 and host1");
            this.host6.setFrameSize(56);
            this.host6.setAutoRepeat(false);
            this.host2.setFrameSize(56);
            this.host2.setAutoRepeat(false);
            this.host2.setDestinationHost(5);
            this.host6.setDestinationHost(1);
            this.scenario = 0;
        }
    }

    public void setScenario(int scenario) {
        this.scenario = scenario;
    }

    public int getScenario() {
        return this.scenario;
    }

    void msg(String subject, String message) {
        this.deliverMessage(new MessageEvent(this, 701, 710, subject, message));
    }

    public void deliverMessage(MessageEvent me) {
        MessageEvent event = new MessageEvent(this, me);
        int i = 0;
        while (i < this.messageListeners.size()) {
            MessageListener ml = (MessageListener)this.messageListeners.elementAt(i);
            ml.deliverMessage(event);
            ++i;
        }
    }

    public synchronized void addMessageListener(MessageListener lis) {
        this.messageListeners.addElement(lis);
    }

    public synchronized void removeMessageListener(MessageListener lis) {
        this.messageListeners.removeElement(lis);
    }

    public void setNumOfHosts(int num) {
        switch (num) {
            case 3: {
                this.numOfHosts = 3;
                this.set2ndPairVisible(false);
                break;
            }
            case 6: {
                this.numOfHosts = 6;
                this.set2ndPairVisible(true);
                break;
            }
        }
    }

    void set2ndPairVisible(boolean b) {
        this.host4.setVisible(b);
        this.host5.setVisible(b);
        this.host6.setVisible(b);
        this.hub2.setVisible(b);
        if (!b) {
            this.host4.reset();
            this.host5.reset();
            this.host6.reset();
            this.hub2.reset();
        }
    }

    public int getNumOfHosts() {
        return this.numOfHosts;
    }

    public void setAlgorithm(String algorithmName) {
        this.algorithm = this.algorithm;
        this.host1.setAlgorithm(algorithmName);
        this.host2.setAlgorithm(algorithmName);
        this.host3.setAlgorithm(algorithmName);
        this.host4.setAlgorithm(algorithmName);
        this.host5.setAlgorithm(algorithmName);
        this.host6.setAlgorithm(algorithmName);
    }

    public AlgorithmInterface getAlgorithm() {
        return this.algorithm;
    }

    public void setUsePadField(boolean usePadField) {
        this.usePadField = usePadField;
        this.host1.setUsePadField(usePadField);
        this.host2.setUsePadField(usePadField);
        this.host3.setUsePadField(usePadField);
        this.host4.setUsePadField(usePadField);
        this.host5.setUsePadField(usePadField);
        this.host6.setUsePadField(usePadField);
    }

    public boolean isUsePadField() {
        return this.usePadField;
    }

    public Hubap() {
        this.hubapPanel.setLayout(null);
        this.hubapPanel.setBounds(0, 0, 425, 240);
        this.add(this.hubapPanel);
        this.hostTopPanel = new Panel();
        this.hostTopPanel.setLayout(null);
        this.hostTopPanel.setBounds(10, 10, 400, 74);
        this.host3 = new Host();
        this.host3.setID(3);
        this.host3.setBounds(98, 0, 80, 74);
        this.hostTopPanel.add(this.host3);
        this.host3.setCursor(new Cursor(12));
        this.host5 = new Host();
        this.host5.setID(5);
        this.host5.setBounds(230, 0, 80, 74);
        this.hostTopPanel.add(this.host5);
        this.host5.setCursor(new Cursor(12));
        this.hubapPanel.add(this.hostTopPanel);
        this.busPanel = new Panel();
        this.busPanel.setLayout(null);
        this.busPanel.setBounds(80, 84, 260, 76);
        this.hubapPanel.add(this.busPanel);
        this.hub1 = new Hub();
        this.hub1.setHubLabel("");
        this.hub1.setLayout(new BorderLayout(0, 0));
        this.hub1.setBounds(0, 0, 130, 76);
        this.busPanel.add(this.hub1);
        this.hub2 = new Hub();
        this.hub2.setHubLabel("");
        this.hub2.setLayout(new BorderLayout(0, 0));
        this.hub2.setBounds(130, 0, 130, 76);
        this.busPanel.add(this.hub2);
        this.hostBottomPanel = new Panel();
        this.hostBottomPanel.setLayout(null);
        this.hostBottomPanel.setBounds(10, 160, 400, 74);
        this.hubapPanel.add(this.hostBottomPanel);
        this.host2 = new Host();
        this.host2.setOverTheBus(false);
        this.host2.setID(2);
        this.host2.setBounds(92, 0, 80, 74);
        this.hostBottomPanel.add(this.host2);
        this.host2.setCursor(new Cursor(12));
        this.host4 = new Host();
        this.host4.setOverTheBus(false);
        this.host4.setID(4);
        this.host4.setBounds(224, 0, 80, 74);
        this.hostBottomPanel.add(this.host4);
        this.host4.setCursor(new Cursor(12));
        this.host6 = new Host();
        this.host6.setOverTheBus(false);
        this.host6.setID(6);
        this.host6.setBounds(336, 56, 80, 74);
        this.hubapPanel.add(this.host6);
        this.host6.setCursor(new Cursor(12));
        this.host1 = new Host();
        this.host1.setBounds(0, 76, 80, 74);
        this.hubapPanel.add(this.host1);
        this.host1.setCursor(new Cursor(12));
        this.efficiencyPanel = new BorderPanel();
        try {
            this.efficiencyPanel.setLabel("Efficiency");
        }
        catch (PropertyVetoException propertyVetoException) {}
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.efficiencyPanel.setLayout(gridBagLayout);
        this.efficiencyPanel.setBounds(420, 0, 80, 240);
        this.add(this.efficiencyPanel);
        this.performanceSlider = new VerticalSlider();
        try {
            this.performanceSlider.setMaxValue(100);
        }
        catch (PropertyVetoException propertyVetoException) {}
        try {
            this.performanceSlider.setMinValue(0);
        }
        catch (PropertyVetoException propertyVetoException) {}
        try {
            this.performanceSlider.setValue(100);
        }
        catch (PropertyVetoException propertyVetoException) {}
        try {
            this.performanceSlider.setTickFreq(10);
        }
        catch (PropertyVetoException propertyVetoException) {}
        try {
            this.performanceSlider.setTickStyle(0);
        }
        catch (PropertyVetoException propertyVetoException) {}
        this.performanceSlider.setBounds(5, 0, 20, 196);
        this.performanceSlider.setBackground(new Color(0xC0C0C0));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 5, -20, 0);
        gbc.ipadx = 12;
        ((GridBagLayout)this.efficiencyPanel.getLayout()).setConstraints(this.performanceSlider, gbc);
        this.efficiencyPanel.add(this.performanceSlider);
        this.performanceSlider.setEnabled(false);
        this.maxLabel = new Label("100%", 2);
        this.maxLabel.setBounds(25, 0, 34, 23);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 0, 0, 0);
        ((GridBagLayout)this.efficiencyPanel.getLayout()).setConstraints(this.maxLabel, gbc);
        this.efficiencyPanel.add(this.maxLabel);
        this.minLabel = new Label("0%", 2);
        this.minLabel.setBounds(35, 176, 24, 23);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.anchor = 13;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 10, 0, 0);
        ((GridBagLayout)this.efficiencyPanel.getLayout()).setConstraints(this.minLabel, gbc);
        this.efficiencyPanel.add(this.minLabel);
        this.helpButton = new Button();
        this.helpButton.setLabel("?");
        this.helpButton.setBounds(36, 88, 21, 23);
        this.helpButton.setFont(new Font("Dialog", 1, 12));
        this.helpButton.setForeground(new Color(255));
        this.helpButton.setBackground(new Color(0xC0C0C0));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 10, 0, 0);
        ((GridBagLayout)this.efficiencyPanel.getLayout()).setConstraints(this.helpButton, gbc);
        this.efficiencyPanel.add(this.helpButton);
        this.helpButton.setCursor(new Cursor(12));
        this.hub1.setHubLabel("HUB1");
        this.hub2.setHubLabel("HUB2");
        try {
            this.efficiencyPanel.setLabel("Efficiency");
        }
        catch (PropertyVetoException propertyVetoException) {}
        this.setAlgorithm("kom.itbeankit.nw.ethernet.OnePersistentAlgorithm");
        this.setNumOfHosts(6);
        SymData lSymData = new SymData();
        this.host1.addDataListener(lSymData);
        this.host2.addDataListener(lSymData);
        this.host3.addDataListener(lSymData);
        this.host5.addDataListener(lSymData);
        this.host4.addDataListener(lSymData);
        this.host6.addDataListener(lSymData);
        SymMessage lSymMessage = new SymMessage();
        this.host1.addMessageListener(lSymMessage);
        this.host2.addMessageListener(lSymMessage);
        this.host3.addMessageListener(lSymMessage);
        this.host4.addMessageListener(lSymMessage);
        this.host5.addMessageListener(lSymMessage);
        this.host6.addMessageListener(lSymMessage);
        SymAction lSymAction = new SymAction();
        this.helpButton.addActionListener(lSymAction);
        this.hub1.addDataListener(lSymData);
        this.hub2.addDataListener(lSymData);
    }

    public void clkReceived(ClkEvent e) {
        this.doScenario(e);
    }

    public void reset() {
        this.hub1.reset();
        this.hub2.reset();
        this.host1.reset();
        this.host2.reset();
        this.host3.reset();
        this.host4.reset();
        this.host5.reset();
        this.host6.reset();
        this.clkReceived(new ClkEvent(this, true));
        this.clkReceived(new ClkEvent(this, false));
        this.clkReceived(new ClkEvent(this, true));
    }

    public void resetDataSize() {
        try {
            this.performanceSlider.setValue(100);
        }
        catch (PropertyVetoException propertyVetoException) {}
        this.host1.resetDataSize();
        this.host2.resetDataSize();
        this.host3.resetDataSize();
        this.host4.resetDataSize();
        this.host5.resetDataSize();
        this.host6.resetDataSize();
    }

    public int getEfficiency() {
        double sentDataSize = 0.0;
        double receivedDataSize = 0.0;
        sentDataSize = this.host1.getSentDataSize() + this.host2.getSentDataSize() + this.host3.getSentDataSize() + this.host4.getSentDataSize() + this.host5.getSentDataSize() + this.host6.getSentDataSize();
        receivedDataSize = this.host1.getReceivedDataSize() + this.host2.getReceivedDataSize() + this.host3.getReceivedDataSize() + this.host4.getReceivedDataSize() + this.host5.getReceivedDataSize() + this.host6.getReceivedDataSize();
        double returnValue = -1.0;
        if (sentDataSize != 0.0) {
            returnValue = receivedDataSize / sentDataSize * 100.0;
        }
        return (int)returnValue;
    }

    void showEfficiency() {
        block2: {
            int eff = this.getEfficiency();
            if (eff == -1) break block2;
            try {
                this.performanceSlider.setValue(100 - eff);
            }
            catch (Exception exception) {}
        }
    }

    public static void main(String[] args) {
        new 1.DriverFrame().show();
    }

    void host_deliverMessage(MessageEvent event) {
        this.deliverMessage(event);
    }

    void helpButton_ActionPerformed(ActionEvent event) {
        this.deliverMessage(new MessageEvent(this, 702, 710, "Efficiency", " Shows the proportion of received data to the sent data by all hosts."));
    }

    void host2_dataToTop(DataEvent event) {
        this.hub1.dataFromBottom(event);
    }

    void host3_dataToBottom(DataEvent event) {
        this.hub1.dataFromTop(event);
    }

    void host5_dataToBottom(DataEvent event) {
        this.hub2.dataFromTop(event);
    }

    void host6_dataToTop(DataEvent event) {
        this.hub2.dataFromRight(event);
    }

    void host1_dataToBottom(DataEvent event) {
        this.hub1.dataFromLeft(event);
    }

    void host4_dataToTop(DataEvent event) {
        this.hub2.dataFromBottom(event);
    }

    void hub1_dataToRight(DataEvent event) {
        this.hub2.dataFromLeft(event);
    }

    void hub2_dataToLeft(DataEvent event) {
        this.hub1.dataFromRight(event);
    }

    void hub1_dataToLeft(DataEvent event) {
        this.host1.dataFromTop(event);
    }

    void hub2_dataToRight(DataEvent event) {
        this.host6.dataFromTop(event);
    }

    void hub1_dataToTop(DataEvent event) {
        this.host3.dataFromBottom(event);
    }

    void hub2_dataToTop(DataEvent event) {
        this.host5.dataFromBottom(event);
    }

    void hub1_dataToBottom(DataEvent event) {
        this.host2.dataFromTop(event);
    }

    void hub2_dataToBottom(DataEvent event) {
        this.host4.dataFromTop(event);
    }

    class SymMessage
    implements MessageListener {
        public void deliverMessage(MessageEvent event) {
            Hubap.this.host_deliverMessage(event);
        }

        SymMessage() {
            Hubap.this = Hubap.this;
        }
    }

    class SymAction
    implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == Hubap.this.helpButton) {
                Hubap.this.helpButton_ActionPerformed(event);
            }
        }

        SymAction() {
            Hubap.this = Hubap.this;
        }
    }

    class SymData
    implements DataListener {
        public void dataToRight(DataEvent event) {
            Object object = event.getSource();
            if (object == Hubap.this.hub1) {
                Hubap.this.hub1_dataToRight(event);
            } else if (object == Hubap.this.hub2) {
                Hubap.this.hub2_dataToRight(event);
            }
        }

        public void dataToTop(DataEvent event) {
            Object object = event.getSource();
            if (object == Hubap.this.hub1) {
                Hubap.this.hub1_dataToTop(event);
            } else if (object == Hubap.this.hub2) {
                Hubap.this.hub2_dataToTop(event);
            } else if (object == Hubap.this.host2) {
                Hubap.this.host2_dataToTop(event);
            } else if (object == Hubap.this.host4) {
                Hubap.this.host4_dataToTop(event);
            } else if (object == Hubap.this.host6) {
                Hubap.this.host6_dataToTop(event);
            }
        }

        public void dataToBottom(DataEvent event) {
            Object object = event.getSource();
            if (object == Hubap.this.host3) {
                Hubap.this.host3_dataToBottom(event);
            } else if (object == Hubap.this.host5) {
                Hubap.this.host5_dataToBottom(event);
            } else if (object == Hubap.this.host1) {
                Hubap.this.host1_dataToBottom(event);
            } else if (object == Hubap.this.hub1) {
                Hubap.this.hub1_dataToBottom(event);
            } else if (object == Hubap.this.hub2) {
                Hubap.this.hub2_dataToBottom(event);
            }
        }

        public void dataToLeft(DataEvent event) {
            Object object = event.getSource();
            if (object == Hubap.this.hub2) {
                Hubap.this.hub2_dataToLeft(event);
            } else if (object == Hubap.this.hub1) {
                Hubap.this.hub1_dataToLeft(event);
            }
        }

        SymData() {
            Hubap.this = Hubap.this;
        }
    }
}

