/*
 * Decompiled with CFR 0.152.
 */
package kom.itbeankit.applet.jpeg;

public class PreDCT {
    protected int N = 8;
    protected int ROWS;
    protected int COLS;
    protected int QUALITY = 1;
    protected double[][] c = new double[this.N][this.N];
    protected double[][] cT = new double[this.N][this.N];
    protected int[][] resultDCT = new int[this.ROWS][this.COLS];
    protected double aConst;
    protected double bConst;
    protected double cConst;
    protected double dConst;
    protected double eConst;
    protected double fConst;

    public PreDCT() {
        this.initMatrix(this.QUALITY, 2.0, 1.0, 16.0);
    }

    public void setDCTConstants(double d, double d2, double d3, double d4, double d5, double d6) {
        this.aConst = d;
        this.bConst = d2;
        this.cConst = d3;
        this.dConst = d4;
        this.eConst = d5;
        this.fConst = d6;
    }

    public void initMatrix(int n, double d, double d2, double d3) {
        double d4;
        System.out.println("dins initMatrix");
        int n2 = 0;
        while (n2 < this.N) {
            d4 = this.N;
            this.c[0][n2] = 1.0 / Math.sqrt(d4);
            this.cT[n2][0] = this.c[0][n2];
            ++n2;
        }
        int n3 = 1;
        while (n3 < 8) {
            n2 = 0;
            while (n2 < 8) {
                d4 = n3;
                double d5 = n2;
                this.c[n3][n2] = Math.sqrt(0.25) * Math.cos((d * d5 + d2) * d4 * Math.PI / d3);
                this.cT[n2][n3] = this.c[n3][n2];
                ++n2;
            }
            ++n3;
        }
    }

    public double[][] forwardDCTNew(int[][] nArray) {
        int n;
        double[][] dArray = new double[this.N][this.N];
        int n2 = 0;
        while (n2 < 8) {
            n = 0;
            while (n < 8) {
                dArray[n2][n] = 0.0;
                ++n;
            }
            ++n2;
        }
        n = 0;
        while (n < 8) {
            int n3 = 0;
            while (n3 < 8) {
                int n4 = 0;
                while (n4 < 8) {
                    int n5 = 0;
                    while (n5 < 8) {
                        double d = n;
                        double d2 = n3;
                        double d3 = n4;
                        double d4 = n5;
                        double d5 = 0.25 * (Math.cos((this.aConst * d3 + this.bConst) * d * Math.PI / this.cConst) * Math.cos((this.dConst * d4 + this.eConst) * d2 * Math.PI / this.fConst) * (double)(nArray[n4][n5] - 128));
                        dArray[n][n3] = dArray[n][n3] + d5;
                        ++n5;
                    }
                    ++n4;
                }
                if (n == 0) {
                    dArray[n][n3] = dArray[n][n3] / Math.sqrt(2.0);
                }
                if (n3 == 0) {
                    dArray[n][n3] = dArray[n][n3] / Math.sqrt(2.0);
                }
                ++n3;
            }
            ++n;
        }
        return dArray;
    }

    public double[][] forwardDCT(int[][] nArray) {
        int n;
        int n2;
        double[][] dArray = new double[this.N][this.N];
        double[][] dArray2 = new double[this.N][this.N];
        int n3 = 0;
        while (n3 < this.N) {
            n2 = 0;
            while (n2 < this.N) {
                dArray2[n3][n2] = 0.0;
                n = 0;
                while (n < this.N) {
                    double[] dArray3 = dArray2[n3];
                    int n4 = n2;
                    dArray3[n4] = dArray3[n4] + ((double)nArray[n3][n] - 128.0) * this.cT[n][n2];
                    ++n;
                }
                ++n2;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < this.N) {
            n2 = 0;
            while (n2 < this.N) {
                double d = 0.0;
                n = 0;
                while (n < this.N) {
                    d += this.c[n3][n] * dArray2[n][n2];
                    ++n;
                }
                dArray[n3][n2] = d;
                ++n2;
            }
            ++n3;
        }
        return dArray;
    }

    public int[][] inverseDCTNew(short[][] sArray) {
        int n;
        int[][] nArray = new int[this.N][this.N];
        double[][] dArray = new double[this.N][this.N];
        int n2 = 0;
        while (n2 < 8) {
            n = 0;
            while (n < 8) {
                nArray[n2][n] = 0;
                dArray[n2][n] = 0.0;
                ++n;
            }
            ++n2;
        }
        n = 0;
        while (n < 8) {
            int n3 = 0;
            while (n3 < 8) {
                int n4 = 0;
                while (n4 < 8) {
                    int n5 = 0;
                    while (n5 < 8) {
                        double d = n4;
                        double d2 = n5;
                        double d3 = n;
                        double d4 = n3;
                        double d5 = Math.floor(Math.cos((this.aConst * d3 + this.bConst) * d * Math.PI / this.cConst) * Math.cos((this.dConst * d4 + this.eConst) * d2 * Math.PI / this.fConst) * (double)sArray[n4][n5]);
                        if (n4 == 0) {
                            d5 /= Math.sqrt(2.0);
                        }
                        if (n5 == 0) {
                            d5 /= Math.sqrt(2.0);
                        }
                        dArray[n][n3] = dArray[n][n3] + d5;
                        ++n5;
                    }
                    ++n4;
                }
                dArray[n][n3] = dArray[n][n3] / 4.0;
                nArray[n][n3] = (int)(dArray[n][n3] + 128.0);
                ++n3;
            }
            ++n;
        }
        return nArray;
    }

    public int[][] inverseDCT(short[][] sArray) {
        int n;
        int n2;
        int[][] nArray = new int[this.N][this.N];
        double[][] dArray = new double[this.N][this.N];
        int n3 = 0;
        while (n3 < this.N) {
            n2 = 0;
            while (n2 < this.N) {
                dArray[n3][n2] = 0.0;
                n = 0;
                while (n < this.N) {
                    double[] dArray2 = dArray[n3];
                    int n4 = n2;
                    dArray2[n4] = dArray2[n4] + (double)sArray[n3][n] * this.c[n][n2];
                    ++n;
                }
                ++n2;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < this.N) {
            n2 = 0;
            while (n2 < this.N) {
                double d = 0.0;
                n = 0;
                while (n < this.N) {
                    d += this.cT[n3][n] * dArray[n][n2];
                    ++n;
                }
                nArray[n3][n2] = (d += 128.0) < 0.0 ? 0 : (d > 255.0 ? 255 : (int)Math.round(d));
                ++n2;
            }
            ++n3;
        }
        return nArray;
    }
}

