/*
 * Decompiled with CFR 0.152.
 */
package kom.itbeankit.mm.compression.mva.model;

import java.awt.Point;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kom.itbeankit.mm.compression.mva.model.MacroBlockMatrix;
import kom.itbeankit.mm.compression.mva.model.RGBByteMap;
import kom.itbeankit.mm.compression.mva.model.YUVByteMap;
import kom.itbeankit.util.Convert;

public class MotionVectorMatrix
implements Cloneable {
    Point[][] vectors;
    int width;
    int height;

    protected MotionVectorMatrix(int n, int n2) {
        this.vectors = new Point[n][n2];
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < n) {
                this.vectors[n4][n3] = new Point(0, 0);
                ++n4;
            }
            ++n3;
        }
        this.width = n;
        this.height = n2;
    }

    protected MotionVectorMatrix(MacroBlockMatrix macroBlockMatrix, YUVByteMap yUVByteMap, int n, int n2) {
        this(macroBlockMatrix.xNumber, macroBlockMatrix.yNumber);
        this.calculateVectors(macroBlockMatrix, yUVByteMap, n, n2);
    }

    protected void calculateVectors(MacroBlockMatrix macroBlockMatrix, YUVByteMap yUVByteMap, int n, int n2) {
        Point point = new Point(0, 0);
        Point point2 = new Point(0, 0);
        int n3 = 0;
        while (n3 < this.height) {
            int n4 = 0;
            while (n4 < this.width) {
                point.x = n4 * 16;
                point.y = n3 * 16;
                this.vectors[n4][n3] = macroBlockMatrix.mbm[n4][n3].searchMotionVector(yUVByteMap, point, point2, n, n2);
                point2 = point2.x == Integer.MIN_VALUE || point2.y == Integer.MIN_VALUE ? new Point(0, 0) : this.vectors[n4][n3];
                ++n4;
            }
            point2 = this.vectors[0][n3].x == Integer.MIN_VALUE || this.vectors[0][n3].y == Integer.MIN_VALUE ? new Point(0, 0) : this.vectors[0][n3];
            ++n3;
        }
    }

    public Object clone() {
        MotionVectorMatrix motionVectorMatrix = new MotionVectorMatrix(this.width, this.height);
        int n = 0;
        while (n < this.height) {
            int n2 = 0;
            while (n2 < this.width) {
                motionVectorMatrix.vectors[n2][n].x = this.vectors[n2][n].x;
                motionVectorMatrix.vectors[n2][n].y = this.vectors[n2][n].y;
                ++n2;
            }
            ++n;
        }
        return motionVectorMatrix;
    }

    private static void drawVector(RGBByteMap rGBByteMap, int n, int n2, int n3, int n4) {
        if (n < 0 || n2 < 0 || n3 < 0 || n4 < 0 || n == n3 && n2 == n4) {
            return;
        }
        Point point = new Point(n3 - n, n4 - n2);
        int n5 = (int)Math.round(Math.sqrt(point.x * point.x + point.y * point.y));
        float f = ((float)n3 - (float)n) / (float)n5;
        float f2 = ((float)n4 - (float)n2) / (float)n5;
        float f3 = 0.0f;
        float f4 = 0.0f;
        int n6 = 0;
        int n7 = 0;
        int n8 = -1;
        int n9 = -1;
        int n10 = Convert.int2byte((rGBByteMap.Map0.theMap[n][n2] + rGBByteMap.Map0.theMap[n][n2] + rGBByteMap.Map0.theMap[n][n2]) / 3);
        n10 = n10 < 0 ? 0 : -1;
        int n11 = 0;
        while (n11 <= n5) {
            n8 = n6;
            n9 = n7;
            n6 = (int)(f3 += f) + n;
            n7 = (int)(f4 += f2) + n2;
            if ((n6 != n8 || n7 != n9) && n6 < rGBByteMap.width && n7 < rGBByteMap.height) {
                rGBByteMap.Map0.theMap[n6][n7] = n10;
                rGBByteMap.Map1.theMap[n6][n7] = n10;
                rGBByteMap.Map2.theMap[n6][n7] = n10;
            }
            ++n11;
        }
    }

    public void drawVectors(RGBByteMap rGBByteMap) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < this.height) {
            n3 = n5 * 16;
            int n6 = 0;
            while (n6 < this.width) {
                if (this.vectors[n6][n5] != null && this.vectors[n6][n5].x != Integer.MIN_VALUE && this.vectors[n6][n5].y != Integer.MIN_VALUE) {
                    n = n6 * 16;
                    n2 = n + this.vectors[n6][n5].x;
                    n4 = n3 + this.vectors[n6][n5].y;
                    MotionVectorMatrix.drawVector(rGBByteMap, n, n3, n2, n4);
                }
                ++n6;
            }
            Thread.yield();
            ++n5;
        }
    }

    public static MotionVectorMatrix getIntraMVM(int n, int n2) {
        MotionVectorMatrix motionVectorMatrix = new MotionVectorMatrix(n, n2);
        int n3 = 0;
        while (n3 < motionVectorMatrix.height) {
            int n4 = 0;
            while (n4 < motionVectorMatrix.width) {
                motionVectorMatrix.vectors[n4][n3].x = Integer.MIN_VALUE;
                motionVectorMatrix.vectors[n4][n3].y = Integer.MIN_VALUE;
                ++n4;
            }
            ++n3;
        }
        return motionVectorMatrix;
    }

    public boolean isIntra() {
        int n = 0;
        while (n < this.height) {
            int n2 = 0;
            while (n2 < this.width) {
                if (this.vectors[n2][n].x != Integer.MIN_VALUE || this.vectors[n2][n].y != Integer.MIN_VALUE) {
                    return false;
                }
                ++n2;
            }
            ++n;
        }
        return true;
    }

    public static int length(Point point) {
        return (int)Math.round(Math.sqrt(point.x * point.x + point.y * point.y));
    }

    public void read(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[4];
        if (inputStream != null) {
            int n = 0;
            while (n < this.height) {
                int n2 = 0;
                while (n2 < this.width) {
                    inputStream.read(byArray, 0, 4);
                    this.vectors[n2][n].x = Convert.byteArray2int(byArray);
                    inputStream.read(byArray, 0, 4);
                    this.vectors[n2][n].y = Convert.byteArray2int(byArray);
                    ++n2;
                }
                ++n;
            }
        }
    }

    public void write(OutputStream outputStream) throws IOException {
        if (outputStream != null) {
            int n = 0;
            while (n < this.height) {
                int n2 = 0;
                while (n2 < this.width) {
                    outputStream.write(Convert.int2byteArray(this.vectors[n2][n].x));
                    outputStream.write(Convert.int2byteArray(this.vectors[n2][n].y));
                    ++n2;
                }
                ++n;
            }
        }
        outputStream.flush();
    }
}

