/*
 * Decompiled with CFR 0.152.
 */
package kom.itbeankit.mm.diskscheduling;

import java.awt.Checkbox;
import java.awt.Frame;
import java.beans.Beans;
import java.util.TooManyListenersException;
import kom.itbeankit.common.ItBean;
import kom.itbeankit.common.itbeanframe.ErrorDialog;
import kom.itbeankit.common.itbeanframe.ItBeanFrame;
import kom.itbeankit.common.itbeanframe.ItBeanFrameEvent;
import kom.itbeankit.common.itbeanframe.ItBeanFrameListener;
import kom.itbeankit.common.itbeanframe.QuitDialog;
import kom.itbeankit.common.ittexttypes.MainLanguage;
import kom.itbeankit.common.message.MessageEvent;
import kom.itbeankit.common.message.Messenger;
import kom.itbeankit.mm.diskscheduling.schedulingcontroller.DataPanelEvent;
import kom.itbeankit.mm.diskscheduling.schedulingcontroller.DataPanelListener;
import kom.itbeankit.mm.diskscheduling.schedulingcontroller.MainPanelEvent;
import kom.itbeankit.mm.diskscheduling.schedulingcontroller.MainPanelListener;
import kom.itbeankit.mm.diskscheduling.schedulingmodel.DiskSchedulingModel;
import kom.itbeankit.mm.diskscheduling.schedulingmodel.MultimediaDiskScheduling;
import kom.itbeankit.mm.diskscheduling.schedulingmodel.Scheduling;
import kom.itbeankit.mm.diskscheduling.schedulingmodel.TrackFoundEvent;
import kom.itbeankit.mm.diskscheduling.schedulingmodel.TrackFoundListener;
import kom.itbeankit.mm.diskscheduling.schedulingtexttypes.MySchedulingLanguage;
import kom.itbeankit.mm.diskscheduling.schedulingview.SchedulingDataPanel;
import kom.itbeankit.mm.diskscheduling.schedulingview.SchedulingMainPanel;

public class ItBeanScheduling
extends ItBean
implements ItBeanFrameListener,
DataPanelListener,
MainPanelListener,
TrackFoundListener {
    private static final int[] InitialDeadlines;
    private static final int[] InitialRequests;
    private int IterationIndex;
    private int[] deadlines = new int[10];
    private int[] requests = new int[10];
    private int rotationTime = 12000;
    private float seekreadRatio = 0.2f;
    private Scheduling schedulingAlgorithm;
    private MultimediaDiskScheduling multimediaAlgorithm;
    private DiskSchedulingModel myModel;
    private int TrackFound;
    private int BufferIndex;
    protected boolean startIteration = false;
    protected MainLanguage DTT;
    protected MySchedulingLanguage MDTT;
    protected SchedulingDataPanel myDataPanel;
    protected SchedulingMainPanel myMainPanel;
    protected ItBeanFrame myFrame;
    protected String Topic = "DiskScheduling";
    protected String Subject;
    protected String Language = "language1";
    protected int LearningLevel;
    protected int MaximumLevel;
    protected int Granularity;
    protected boolean OtherSubjectsAreAllowed = false;
    protected String[] Needs = new String[10];

    public ItBeanScheduling() {
        this("", "language1", 0, "true");
    }

    public ItBeanScheduling(String string) {
        this(string, "language1", 0, "true");
    }

    public ItBeanScheduling(String string, String string2) {
        this(string, string2, 0, "true");
    }

    public ItBeanScheduling(String string, String string2, int n) {
        this(string, string2, n, "true");
    }

    public ItBeanScheduling(String string, String string2, int n, String string3) {
        this.initSearchParameter();
        this.initializeBean();
        this.setLanguage(string2);
        if (n > 0) {
            this.setLearningLevel(n);
        } else {
            this.setLearningLevel(1);
        }
        this.setSubject(string);
        if (string3.equalsIgnoreCase("false") && !this.Subject.equals("")) {
            this.setOtherSubjectsAreAllowed(false);
            return;
        }
        this.setOtherSubjectsAreAllowed(true);
    }

    public void makeVisible() {
        if (!this.visible) {
            this.myFrame.show();
        }
        this.visible = true;
    }

    public void makeInvisible() {
        if (this.visible) {
            this.myFrame.setVisible(false);
        }
        this.visible = false;
    }

    public void startIteration() {
        this.startIteration = true;
    }

    public void mainloop() {
        int[][] nArray = new int[2][2];
        if (this.IterationIndex == 0) {
            if (this.LearningLevel != 3) {
                this.myFrame.appendText(this.MDTT.INFO_RUN_SINGLE);
                this.myFrame.appendText(this.MDTT.INFO_RUN_GRAPH);
                this.myFrame.appendText(this.MDTT.INFO_RUN_TEXTS);
            } else {
                this.myFrame.appendText(this.MDTT.INFO_RUN_ALL);
                this.myFrame.appendText(this.MDTT.INFO_RUN_GRAPH);
            }
        }
        if (this.LearningLevel != 3) {
            try {
                nArray[0] = this.schedulingAlgorithm == null ? this.multimediaAlgorithm.startSearchRun(this.IterationIndex) : this.schedulingAlgorithm.startSearchRun(this.IterationIndex);
            }
            catch (NullPointerException nullPointerException) {
                this.IterationIndex = -1;
                ErrorDialog errorDialog = new ErrorDialog(this.myFrame, this.MDTT.ERR_ALGORITHM_HEAD, false, this.MDTT.ERR_ALGORITHM_NOSELECT, this.MDTT.ERR_ALGORITHM_NORUNNING);
                errorDialog.setVisible(true);
            }
            this.myMainPanel.paintAlgorithm(nArray, true);
        } else {
            this.myMainPanel.paintAlgorithm(this.myModel.startSearch(this.IterationIndex), true);
        }
        ++this.IterationIndex;
    }

    public String getTopic() {
        return this.Topic;
    }

    public String getSubject() {
        return this.Subject;
    }

    public void setSubject(String string) {
        this.Subject = string;
        if (this.Subject.equalsIgnoreCase(this.MDTT.FCFS_LABEL)) {
            this.Needs[0] = new String("");
            this.myFrame.setTitle(String.valueOf(this.Topic) + " - " + this.MDTT.FCFS_LABEL);
        } else if (this.Subject.equalsIgnoreCase(this.MDTT.SCAN_LABEL)) {
            this.Needs[0] = new String("");
            this.myFrame.setTitle(String.valueOf(this.Topic) + " - " + this.MDTT.SCAN_LABEL);
        } else if (this.Subject.equalsIgnoreCase(this.MDTT.CSCAN_LABEL)) {
            this.Needs[0] = new String(this.MDTT.SCAN_LABEL);
            this.myFrame.setTitle(String.valueOf(this.Topic) + " - " + this.MDTT.CSCAN_LABEL);
        } else if (this.Subject.equalsIgnoreCase(this.MDTT.EDF_LABEL)) {
            this.Needs[0] = new String("");
            this.myFrame.setTitle(String.valueOf(this.Topic) + " - " + this.MDTT.EDF_LABEL);
        } else if (this.Subject.equalsIgnoreCase(this.MDTT.SCANEDF_LABEL)) {
            this.Needs[0] = new String(this.MDTT.SCAN_LABEL);
            this.Needs[1] = new String(this.MDTT.EDF_LABEL);
            this.myFrame.setTitle(String.valueOf(this.Topic) + " - " + this.MDTT.SCANEDF_LABEL);
        } else if (!this.Subject.equals("") && this.MDTT.ACCUSCANEDF_LABEL.toLowerCase().startsWith(this.Subject.toLowerCase())) {
            this.Needs[0] = new String(this.MDTT.SCAN_LABEL);
            this.Needs[1] = new String(this.MDTT.EDF_LABEL);
            this.Needs[2] = new String(this.MDTT.SCANEDF_LABEL);
            this.Subject = this.MDTT.ACCUSCANEDF_LABEL;
            this.myFrame.setTitle(String.valueOf(this.Topic) + " - " + this.Subject);
        } else if (!this.Subject.equals("") && this.MDTT.GROUPSWEEP_LABEL.toLowerCase().startsWith(this.Subject.toLowerCase())) {
            this.Needs[0] = new String(this.MDTT.SCAN_LABEL);
            this.Subject = this.MDTT.GROUPSWEEP_LABEL;
            this.myFrame.setTitle(String.valueOf(this.Topic) + " - " + this.Subject);
        } else {
            this.Needs[0] = new String("");
            this.Subject = "";
            this.myFrame.setTitle(this.Topic);
        }
        this.changeSubject();
        this.myFrame.repaint();
    }

    public String getLanguage() {
        return this.Language;
    }

    public void setLanguage(String string) {
        this.Language = (string = string.toLowerCase()).startsWith("language", 0) ? string : (string.equals("de") ? "language2" : (string.equals("sp") ? "language3" : "language1"));
        this.setTheDTT(this.Language);
        this.myFrame.repaint();
    }

    public int getLearningLevel() {
        return this.LearningLevel;
    }

    public void setLearningLevel(int n) {
        if (n > 0 && n < 5) {
            this.LearningLevel = n;
            this.changeLearningLevel();
            this.myFrame.repaint();
            return;
        }
        ErrorDialog errorDialog = new ErrorDialog(this.myFrame, this.MDTT.ERR_LEVEL_HEAD, false, this.MDTT.ERR_LEVEL_NOVALID, this.MDTT.ERR_LEVEL_NUMBER);
        errorDialog.setVisible(true);
    }

    public int getMaximumLevel() {
        return this.MaximumLevel;
    }

    public void setMaximumLevel(int n) {
        this.MaximumLevel = n;
        this.myFrame.setNumberOfLevels(this.MaximumLevel);
    }

    public int getGranularity() {
        return this.Granularity;
    }

    public boolean isOtherSubjectsAreAllowed() {
        return this.OtherSubjectsAreAllowed;
    }

    public void setOtherSubjectsAreAllowed(boolean bl) {
        this.OtherSubjectsAreAllowed = bl;
        this.myMainPanel.setOtherSubjectsAreAllowed(this.OtherSubjectsAreAllowed);
        this.myDataPanel.setAlgorithmVisibility(this.OtherSubjectsAreAllowed);
    }

    public String[] getNeeds() {
        return this.Needs;
    }

    public void setTheDTT(String string) {
        this.DTT = null;
        if (string.equals("language2")) {
            try {
                this.DTT = (MainLanguage)Class.forName("kom.itbeankit.common.ittexttypes.MainLanguage_De").newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println("MainLanguage_De.java = German not found");
            }
            catch (InstantiationException instantiationException) {
                System.out.println("InstantiationException German");
            }
            catch (IllegalAccessException illegalAccessException) {
                System.out.println("IllegalAccessException German");
            }
            try {
                this.MDTT = (MySchedulingLanguage)Class.forName("kom.itbeankit.mm.diskscheduling.schedulingtexttypes.MySchedulingLanguage_De").newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println("MySchedulingLanguage_De.java = German not found");
            }
            catch (InstantiationException instantiationException) {
                System.out.println("InstantiationException German");
            }
            catch (IllegalAccessException illegalAccessException) {
                System.out.println("IllegalAccessException German");
            }
        } else if (string.equals("language3")) {
            try {
                this.DTT = (MainLanguage)Class.forName("kom.itbeankit.common.ittexttypes.MainLanguage_Sp").newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println("MainLanguage_Sp.java = Spanish not found");
            }
            catch (InstantiationException instantiationException) {
                System.out.println("InstantiationException spanish");
            }
            catch (IllegalAccessException illegalAccessException) {
                System.out.println("IllegalAccessException spanish");
            }
            try {
                this.MDTT = (MySchedulingLanguage)Class.forName("kom.itbeankit.mm.diskscheduling.schedulingtexttypes.MySchedulingLanguage_Sp").newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println("MySchedulingLanguageSp.java = Spanish not found");
            }
            catch (InstantiationException instantiationException) {
                System.out.println("InstantiationException spanish");
            }
            catch (IllegalAccessException illegalAccessException) {
                System.out.println("IllegalAccessException spanish");
            }
        } else {
            try {
                this.DTT = (MainLanguage)Class.forName("kom.itbeankit.common.ittexttypes.MainLanguage").newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println("MainLanguage.java = english not found");
            }
            catch (InstantiationException instantiationException) {
                System.out.println("InstantiationException english");
            }
            catch (IllegalAccessException illegalAccessException) {
                System.out.println("IllegalAccessException english");
            }
            try {
                this.MDTT = (MySchedulingLanguage)Class.forName("kom.itbeankit.mm.diskscheduling.schedulingtexttypes.MySchedulingLanguage").newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println("MySchedulingLanguage.java = english not found");
            }
            catch (InstantiationException instantiationException) {
                System.out.println("InstantiationException english");
            }
            catch (IllegalAccessException illegalAccessException) {
                System.out.println("IllegalAccessException english");
            }
        }
        this.initItBeanFrameMenu();
        this.initItBeanScheduling();
    }

    public void initializeBean() {
        this.myDataPanel = new SchedulingDataPanel();
        try {
            this.myDataPanel.addDataPanelListener(this);
        }
        catch (TooManyListenersException tooManyListenersException) {
            System.out.println("Already a listener " + tooManyListenersException);
        }
        this.myMainPanel = new SchedulingMainPanel();
        this.myMainPanel.initializeBean(this.deadlines, this.requests);
        try {
            this.myMainPanel.addMainPanelListener(this);
        }
        catch (TooManyListenersException tooManyListenersException) {
            System.out.println("Already a listener " + tooManyListenersException);
        }
        this.myFrame = new ItBeanFrame(this.Topic);
        this.initmyFrame();
        try {
            this.myFrame.addItBeanFrameListener(this);
        }
        catch (TooManyListenersException tooManyListenersException) {
            System.out.println("Already a listener " + tooManyListenersException);
        }
        this.myFrame.SplitVertically();
        this.myFrame.setLeftComponent(this.myMainPanel);
        this.myFrame.setBottomRightComponent(this.myDataPanel);
        this.myFrame.setNumberOfLevels(4);
        this.myFrame.enableButtons(7001, false);
        this.myFrame.enableButtons(7004, false);
        this.myFrame.setVisible(true);
        this.myFrame.setTimerToBeUsed(true);
        this.myFrame.setStepDelayTime(200);
    }

    public void initmyFrame() {
        this.setTheDTT(this.Language);
    }

    public void initItBeanFrameMenu() {
        this.myFrame.FileMenu.setLabel(this.DTT.FILE_MENU_LABEL);
        this.myFrame.itBeanNew.setLabel(this.DTT.NEW_ITEM_LABEL);
        this.myFrame.itBeanOpen.setLabel(this.DTT.OPEN_ITEM_LABEL);
        this.myFrame.itBeanSave.setLabel(this.DTT.SAVE_ITEM_LABEL);
        this.myFrame.itBeanSaveAs.setLabel(this.DTT.SAVEAS_ITEM_LABEL);
        this.myFrame.itBeanExit.setLabel(this.DTT.EXIT_ITEM_LABEL);
        this.myFrame.OptionsMenu.setLabel(this.DTT.OPTIONS_MENU_LABEL);
        this.myFrame.languageMenu.setLabel(this.DTT.LANGUAGE_MENU_LABEL);
        this.myFrame.language1MenuItem.setLabel(this.DTT.LANGUAGE1_ITEM_LABEL);
        this.myFrame.language2MenuItem.setLabel(this.DTT.LANGUAGE2_ITEM_LABEL);
        this.myFrame.language3MenuItem.setLabel(this.DTT.LANGUAGE3_ITEM_LABEL);
        this.myFrame.ExplanationMenu.setLabel(this.DTT.EXPLANATION_MENU_LABEL);
        this.myFrame.checkboxMenuItem1.setLabel(this.DTT.EXPLANATION1_ITEM_LABEL);
        this.myFrame.checkboxMenuItem2.setLabel(this.DTT.EXPLANATION2_ITEM_LABEL);
        this.myFrame.checkboxMenuItem3.setLabel(this.DTT.EXPLANATION3_ITEM_LABEL);
        this.myFrame.helpMenu.setLabel(this.DTT.HELP_MENU_LABEL);
        this.myFrame.itBeanGuidedTour.setLabel(this.DTT.GUIDEDTOUR_ITEM_LABEL);
        this.myFrame.itBeanAbout.setLabel(this.DTT.ABOUT_ITEM_LABEL);
    }

    public void initItBeanScheduling() {
        this.myMainPanel.DeadlineLabel.setText(this.MDTT.DEADLINELABEL);
        this.myMainPanel.TrackLabel.setText(this.MDTT.TRACKLABEL);
        try {
            if (this.Subject.equalsIgnoreCase(this.MDTT.FCFS_LABEL)) {
                this.myMainPanel.ExplainLabel.setText(this.MDTT.EXPLAIN_FCFS);
            } else if (this.Subject.equalsIgnoreCase(this.MDTT.SCAN_LABEL)) {
                this.myMainPanel.ExplainLabel.setText(this.MDTT.EXPLAIN_SCAN);
            } else if (this.Subject.equalsIgnoreCase(this.MDTT.CSCAN_LABEL)) {
                this.myMainPanel.ExplainLabel.setText(this.MDTT.EXPLAIN_CSCAN);
            } else if (this.Subject.equalsIgnoreCase(this.MDTT.EDF_LABEL)) {
                this.myMainPanel.ExplainLabel.setText(this.MDTT.EXPLAIN_EDF);
            } else if (this.Subject.equalsIgnoreCase(this.MDTT.SCANEDF_LABEL)) {
                this.myMainPanel.ExplainLabel.setText(this.MDTT.EXPLAIN_SCANEDF);
            } else if (this.Subject.equalsIgnoreCase(this.MDTT.ACCUSCANEDF_LABEL)) {
                this.myMainPanel.ExplainLabel.setText(this.MDTT.EXPLAIN_ACCU);
            } else if (this.Subject.equalsIgnoreCase(this.MDTT.GROUPSWEEP_LABEL)) {
                this.myMainPanel.ExplainLabel.setText(this.MDTT.EXPLAIN_GROUP);
            } else {
                this.myMainPanel.ExplainLabel.setText("");
            }
        }
        catch (NullPointerException nullPointerException) {
            this.myMainPanel.ExplainLabel.setText("");
        }
        this.myDataPanel.RotationLabel.setText(this.MDTT.ROTATIONLABEL);
        this.myDataPanel.SeekReadLabel.setText(this.MDTT.SEEKREADLABEL);
        this.myDataPanel.TimebaseLabel.setText(this.MDTT.TIMEBASELABEL);
        this.myDataPanel.AnimationLabel.setText(this.MDTT.ANIMATIONLABEL);
        this.myDataPanel.AnimSpeedHigh.setText(this.MDTT.ANIMATION_HIGH);
        this.myDataPanel.AnimSpeedLow.setText(this.MDTT.ANIMATION_LOW);
        this.myDataPanel.AlgorithmLabel.setText(this.MDTT.ALGORITHMLABEL);
        this.myDataPanel.FCFS_Scheduling.setLabel(this.MDTT.FCFS_LABEL);
        this.myDataPanel.SCAN_Scheduling.setLabel(this.MDTT.SCAN_LABEL);
        this.myDataPanel.CSCAN_Scheduling.setLabel(this.MDTT.CSCAN_LABEL);
        this.myDataPanel.EDF_Scheduling.setLabel(this.MDTT.EDF_LABEL);
        this.myDataPanel.SCANEDF_Scheduling.setLabel(this.MDTT.SCANEDF_LABEL);
        this.myDataPanel.AccuSCANEDF_Scheduling.setLabel(this.MDTT.ACCUSCANEDF_LABEL);
        this.myDataPanel.GroupSweeping.setLabel(this.MDTT.GROUPSWEEP_LABEL);
        this.myMainPanel.changeLanguage(this.MDTT.X_AXIS_LABEL, this.MDTT.Y_AXIS_LABEL);
        this.myFrame.clearTextArea();
        this.myFrame.appendText(this.MDTT.INFO_BEGIN_BEAN);
        this.myFrame.appendText(this.MDTT.INFO_BEGIN_DISKSCHED);
    }

    public void play(ItBeanFrameEvent itBeanFrameEvent) {
        this.myDataPanel.setDiskParameter(false);
        this.mainloop();
    }

    public void newFile(ItBeanFrameEvent itBeanFrameEvent) {
    }

    public void stop(ItBeanFrameEvent itBeanFrameEvent) {
        block7: {
            if (this.LearningLevel != 3) {
                try {
                    if (this.schedulingAlgorithm == null) {
                        this.multimediaAlgorithm.resetSearchRun();
                        break block7;
                    }
                    this.schedulingAlgorithm.resetSearchRun();
                }
                catch (NullPointerException nullPointerException) {}
            } else {
                try {
                    this.myModel.resetSearch();
                }
                catch (NullPointerException nullPointerException) {}
            }
        }
        this.BufferIndex = 0;
        this.TrackFound = 0;
        this.myMainPanel.resetAlgorithm();
        this.IterationIndex = 0;
        this.myDataPanel.setDiskParameter(true);
        this.myFrame.repaint();
    }

    public void pause(ItBeanFrameEvent itBeanFrameEvent) {
    }

    public void hide(ItBeanFrameEvent itBeanFrameEvent) {
        if (this.LearningLevel == 4) {
            QuitDialog quitDialog = new QuitDialog((Frame)this.myFrame, false);
            quitDialog.setVisible(true);
            if (quitDialog.getResponse()) {
                this.myFrame.dispose();
                return;
            }
        } else {
            this.makeInvisible();
        }
    }

    public void backwards(ItBeanFrameEvent itBeanFrameEvent) {
    }

    public void forwards(ItBeanFrameEvent itBeanFrameEvent) {
        this.myDataPanel.setDiskParameter(false);
        this.mainloop();
    }

    public void toBegin(ItBeanFrameEvent itBeanFrameEvent) {
        block7: {
            if (this.LearningLevel != 3) {
                try {
                    if (this.schedulingAlgorithm == null) {
                        this.multimediaAlgorithm.resetSearchRun();
                        break block7;
                    }
                    this.schedulingAlgorithm.resetSearchRun();
                }
                catch (NullPointerException nullPointerException) {}
            } else {
                try {
                    this.myModel.resetSearch();
                }
                catch (NullPointerException nullPointerException) {}
            }
        }
        this.BufferIndex = 0;
        this.TrackFound = 0;
        this.IterationIndex = 0;
        this.initSearchParameter();
        this.myDataPanel.setDiskParameter(true);
        this.myMainPanel.resetAlgorithm();
        this.myMainPanel.initializeBean(this.deadlines, this.requests);
        this.myFrame.repaint();
    }

    public void openURL(ItBeanFrameEvent itBeanFrameEvent) {
    }

    public void save(ItBeanFrameEvent itBeanFrameEvent) {
    }

    public void saveAs(ItBeanFrameEvent itBeanFrameEvent) {
    }

    public void exit(ItBeanFrameEvent itBeanFrameEvent) {
        QuitDialog quitDialog = new QuitDialog((Frame)this.myFrame, false);
        quitDialog.setVisible(true);
        if (quitDialog.getResponse()) {
            System.exit(0);
        }
    }

    public void levelUp(ItBeanFrameEvent itBeanFrameEvent) {
        this.setLearningLevel(this.myFrame.getComplexityLevel());
    }

    public void levelDown(ItBeanFrameEvent itBeanFrameEvent) {
        this.setLearningLevel(this.myFrame.getComplexityLevel());
    }

    public void levelChanged(ItBeanFrameEvent itBeanFrameEvent) {
        this.setLearningLevel(this.myFrame.getComplexityLevel());
    }

    public void languageChanged(ItBeanFrameEvent itBeanFrameEvent) {
        this.setLanguage(itBeanFrameEvent.getCommand());
    }

    public void explanationChanged(ItBeanFrameEvent itBeanFrameEvent) {
    }

    public void guidedTour(ItBeanFrameEvent itBeanFrameEvent) {
        Messenger messenger = null;
        MessageEvent messageEvent = new MessageEvent(this.myFrame, 702, 710, "Guided-Tour", "This Window explain the Controls of the DiskScheduling-itBean.With the Rotation-Radiobuttons can the rotation of the disk be selectedThe Seek/Read-ratio SpinButton selects the ratio of seek/read of the discWith the Animation-Slider you change the speed of the animation.");
        try {
            messenger = (Messenger)Beans.instantiate(null, "kom.itbeankit.common.message.Messenger");
        }
        catch (Exception exception) {
            System.err.println("Exception:");
            System.err.println(exception);
        }
        messenger.deliverMessage(messageEvent);
    }

    public void about(ItBeanFrameEvent itBeanFrameEvent) {
    }

    public void changeRotation(DataPanelEvent dataPanelEvent) {
        int[] nArray = new int[2];
        nArray[1] = 0;
        if (dataPanelEvent.getCommand().equals("5400")) {
            nArray[0] = 5400;
        }
        if (dataPanelEvent.getCommand().equals("7200")) {
            nArray[0] = 7200;
        }
        if (dataPanelEvent.getCommand().equals("10200")) {
            nArray[0] = 10200;
        }
        if (dataPanelEvent.getCommand().equals("12000")) {
            nArray[0] = 12000;
        }
        this.rotationTime = nArray[0];
        if (this.LearningLevel != 3) {
            try {
                if (this.schedulingAlgorithm == null) {
                    this.multimediaAlgorithm.setRotationtime(nArray[0]);
                    return;
                }
                this.schedulingAlgorithm.setRotationtime(nArray[0]);
                return;
            }
            catch (NullPointerException nullPointerException) {
                return;
            }
        }
        try {
            this.myModel.setDiskParameter(nArray);
            return;
        }
        catch (NullPointerException nullPointerException) {
            return;
        }
    }

    public void changeSeekRead(DataPanelEvent dataPanelEvent) {
        int[] nArray = new int[]{0, dataPanelEvent.getValue()};
        this.seekreadRatio = (float)nArray[1] / 10.0f;
        if (this.LearningLevel != 3) {
            try {
                if (this.schedulingAlgorithm == null) {
                    this.multimediaAlgorithm.setSeekReadRatio(this.seekreadRatio);
                    return;
                }
                this.schedulingAlgorithm.setSeekReadRatio(this.seekreadRatio);
                return;
            }
            catch (NullPointerException nullPointerException) {
                return;
            }
        }
        try {
            this.myModel.setDiskParameter(nArray);
            return;
        }
        catch (NullPointerException nullPointerException) {
            return;
        }
    }

    public void changeAnimation(DataPanelEvent dataPanelEvent) {
        this.myFrame.setStepDelayTime(dataPanelEvent.getValue() + 49);
    }

    public void changeTimebase(DataPanelEvent dataPanelEvent) {
        this.myMainPanel.setTimebase(dataPanelEvent.getValue());
        this.myFrame.repaint();
    }

    public void changeAlgorithm(DataPanelEvent dataPanelEvent) {
        switch (this.LearningLevel) {
            case 3: {
                this.addAlgorithm(dataPanelEvent.getCommand());
                break;
            }
            case 4: {
                Checkbox checkbox = (Checkbox)dataPanelEvent.getSource();
                checkbox.setState(false);
                new ItBeanScheduling(dataPanelEvent.getCommand(), this.Language, 4);
                break;
            }
            default: {
                this.setSubject(dataPanelEvent.getCommand());
            }
        }
        this.myFrame.repaint();
    }

    public void changeDeadline(MainPanelEvent mainPanelEvent) {
        short[] sArray = new short[4];
        sArray[0] = -1;
        sArray[2] = (short)mainPanelEvent.getValue();
        if (mainPanelEvent.getCommand().equals("panel4")) {
            sArray[3] = 0;
        }
        if (mainPanelEvent.getCommand().equals("panel6")) {
            sArray[3] = 1;
        }
        if (mainPanelEvent.getCommand().equals("panel8")) {
            sArray[3] = 2;
        }
        if (mainPanelEvent.getCommand().equals("panel10")) {
            sArray[3] = 3;
        }
        if (mainPanelEvent.getCommand().equals("panel12")) {
            sArray[3] = 4;
        }
        if (mainPanelEvent.getCommand().equals("panel14")) {
            sArray[3] = 5;
        }
        if (mainPanelEvent.getCommand().equals("panel16")) {
            sArray[3] = 6;
        }
        if (mainPanelEvent.getCommand().equals("panel18")) {
            sArray[3] = 7;
        }
        if (mainPanelEvent.getCommand().equals("panel20")) {
            sArray[3] = 8;
        }
        if (mainPanelEvent.getCommand().equals("panel22")) {
            sArray[3] = 9;
        }
        this.deadlines[sArray[3]] = mainPanelEvent.getValue();
        if (this.LearningLevel != 3) {
            try {
                this.multimediaAlgorithm.setDeadline(sArray[3], sArray[2]);
                return;
            }
            catch (NullPointerException nullPointerException) {
                return;
            }
        }
        try {
            this.myModel.setSearchParameter(sArray);
            return;
        }
        catch (NullPointerException nullPointerException) {
            return;
        }
    }

    public void changeTrack(MainPanelEvent mainPanelEvent) {
        short[] sArray = new short[4];
        sArray[0] = mainPanelEvent.getValue() > 128 ? 128 : (mainPanelEvent.getValue() < 0 ? 0 : (int)mainPanelEvent.getValue());
        sArray[2] = -1;
        if (mainPanelEvent.getCommand().equals("textfield12")) {
            sArray[1] = 0;
        }
        if (mainPanelEvent.getCommand().equals("textfield13")) {
            sArray[1] = 1;
        }
        if (mainPanelEvent.getCommand().equals("textfield14")) {
            sArray[1] = 2;
        }
        if (mainPanelEvent.getCommand().equals("textfield15")) {
            sArray[1] = 3;
        }
        if (mainPanelEvent.getCommand().equals("textfield16")) {
            sArray[1] = 4;
        }
        if (mainPanelEvent.getCommand().equals("textfield17")) {
            sArray[1] = 5;
        }
        if (mainPanelEvent.getCommand().equals("textfield18")) {
            sArray[1] = 6;
        }
        if (mainPanelEvent.getCommand().equals("textfield19")) {
            sArray[1] = 7;
        }
        if (mainPanelEvent.getCommand().equals("textfield20")) {
            sArray[1] = 8;
        }
        if (mainPanelEvent.getCommand().equals("textfield21")) {
            sArray[1] = 9;
        }
        this.requests[sArray[1]] = mainPanelEvent.getValue();
        if (this.LearningLevel != 3) {
            try {
                if (this.schedulingAlgorithm == null) {
                    this.multimediaAlgorithm.setRequestedTrack(sArray[1], sArray[0]);
                    return;
                }
                this.schedulingAlgorithm.setRequestedTrack(sArray[1], sArray[0]);
                return;
            }
            catch (NullPointerException nullPointerException) {
                return;
            }
        }
        try {
            this.myModel.setSearchParameter(sArray);
            return;
        }
        catch (NullPointerException nullPointerException) {
            return;
        }
    }

    public void trackFound(TrackFoundEvent trackFoundEvent) {
        if (this.LearningLevel != 3 && this.TrackFound != trackFoundEvent.getTrack()) {
            this.TrackFound = trackFoundEvent.getTrack();
            if (this.multimediaAlgorithm == null) {
                this.myMainPanel.setBufferValues(this.BufferIndex, this.schedulingAlgorithm.getTrackBuffers());
            } else if (this.Subject.equalsIgnoreCase(this.MDTT.GROUPSWEEP_LABEL)) {
                System.out.println("Pufferwert: " + this.BufferIndex);
                if (this.BufferIndex % 3 == 0) {
                    this.myMainPanel.setBufferValues(this.BufferIndex, this.multimediaAlgorithm.getTrackBuffers());
                }
            } else {
                this.myMainPanel.setBufferValues(this.BufferIndex, this.multimediaAlgorithm.getTrackBuffers());
            }
            ++this.BufferIndex;
            this.myFrame.repaint();
        }
    }

    private void changeSubject() {
        if (this.LearningLevel != 3) {
            try {
                this.schedulingAlgorithm.removeTrackFoundListener(this);
                this.multimediaAlgorithm.removeTrackFoundListener(this);
            }
            catch (NullPointerException nullPointerException) {}
            this.schedulingAlgorithm = null;
            this.multimediaAlgorithm = null;
            if (this.Subject.equalsIgnoreCase(this.MDTT.FCFS_LABEL)) {
                try {
                    this.schedulingAlgorithm = (Scheduling)Class.forName("kom.itbeankit.mm.diskscheduling.schedulingmodel.FCFS_Scheduling").newInstance();
                    this.initSchedulingAlgorithm();
                    this.myMainPanel.ExplainLabel.setText(this.MDTT.EXPLAIN_FCFS);
                    this.myMainPanel.setSchedulingGraph("FCFS-Scheduling", 1, 10);
                    this.myMainPanel.setSearchParameter(1);
                    this.myDataPanel.setDiskParameter(true);
                    this.myFrame.appendText(this.MDTT.INFO_FCFS);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.myMainPanel.removeSchedulingGraph();
                    this.myMainPanel.setSearchParameter(0);
                    this.myDataPanel.setDiskParameter(false);
                    this.setSubject("");
                    ErrorDialog errorDialog = new ErrorDialog(this.myFrame, this.MDTT.ERR_ALGORITHM_HEAD, false, this.MDTT.ERR_ALGORITHM_NORUN, this.MDTT.ERR_ALGORITHM_NOFCFS);
                    errorDialog.setVisible(true);
                }
                catch (InstantiationException instantiationException) {
                    System.out.println("InstantiationException FCFS-Algorithm");
                    this.myMainPanel.removeSchedulingGraph();
                    this.myMainPanel.setSearchParameter(0);
                    this.myDataPanel.setDiskParameter(false);
                    this.setSubject("");
                }
                catch (IllegalAccessException illegalAccessException) {
                    System.out.println("IllegalAccessException FCFS-Algorithm");
                    this.myMainPanel.removeSchedulingGraph();
                    this.myMainPanel.setSearchParameter(0);
                    this.myDataPanel.setDiskParameter(false);
                    this.setSubject("");
                }
            } else if (this.Subject.equalsIgnoreCase(this.MDTT.SCAN_LABEL)) {
                try {
                    this.schedulingAlgorithm = (Scheduling)Class.forName("kom.itbeankit.mm.diskscheduling.schedulingmodel.SCAN_Scheduling").newInstance();
                    this.initSchedulingAlgorithm();
                    this.myMainPanel.ExplainLabel.setText(this.MDTT.EXPLAIN_SCAN);
                    this.myMainPanel.setSchedulingGraph("SCAN-Scheduling", 3, 7);
                    this.myMainPanel.setSearchParameter(1);
                    this.myDataPanel.setDiskParameter(true);
                    this.myFrame.appendText(this.MDTT.INFO_SCAN1);
                    this.myFrame.appendText(this.MDTT.INFO_SCAN2);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.myMainPanel.removeSchedulingGraph();
                    this.myMainPanel.setSearchParameter(0);
                    this.myDataPanel.setDiskParameter(false);
                    this.setSubject("");
                    ErrorDialog errorDialog = new ErrorDialog(this.myFrame, this.MDTT.ERR_ALGORITHM_HEAD, false, this.MDTT.ERR_ALGORITHM_NORUN, this.MDTT.ERR_ALGORITHM_NOSCAN);
                    errorDialog.setVisible(true);
                }
                catch (InstantiationException instantiationException) {
                    System.out.println("InstantiationException SCAN-Algorithm");
                    this.myMainPanel.removeSchedulingGraph();
                    this.myMainPanel.setSearchParameter(0);
                    this.myDataPanel.setDiskParameter(false);
                    this.setSubject("");
                }
                catch (IllegalAccessException illegalAccessException) {
                    System.out.println("IllegalAccessException SCAN-Algorithm");
                    this.myMainPanel.removeSchedulingGraph();
                    this.myMainPanel.setSearchParameter(0);
                    this.myDataPanel.setDiskParameter(false);
                    this.setSubject("");
                }
            } else if (this.Subject.equalsIgnoreCase(this.MDTT.CSCAN_LABEL)) {
                try {
                    this.schedulingAlgorithm = (Scheduling)Class.forName("kom.itbeankit.mm.diskscheduling.schedulingmodel.CSCAN_Scheduling").newInstance();
                    this.initSchedulingAlgorithm();
                    this.myMainPanel.ExplainLabel.setText(this.MDTT.EXPLAIN_CSCAN);
                    this.myMainPanel.setSchedulingGraph("C-SCAN-Scheduling", 3, 7);
                    this.myMainPanel.setSearchParameter(1);
                    this.myDataPanel.setDiskParameter(true);
                    this.myFrame.appendText(this.MDTT.INFO_CSCAN1);
                    this.myFrame.appendText(this.MDTT.INFO_CSCAN2);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.myMainPanel.removeSchedulingGraph();
                    this.myMainPanel.setSearchParameter(0);
                    this.myDataPanel.setDiskParameter(false);
                    this.setSubject("");
                    ErrorDialog errorDialog = new ErrorDialog(this.myFrame, this.MDTT.ERR_ALGORITHM_HEAD, false, this.MDTT.ERR_ALGORITHM_NORUN, this.MDTT.ERR_ALGORITHM_NOCSCAN);
                    errorDialog.setVisible(true);
                }
                catch (InstantiationException instantiationException) {
                    System.out.println("InstantiationException C-SCAN-Algorithm");
                    this.myMainPanel.removeSchedulingGraph();
                    this.myMainPanel.setSearchParameter(0);
                    this.myDataPanel.setDiskParameter(false);
                    this.setSubject("");
                }
                catch (IllegalAccessException illegalAccessException) {
                    System.out.println("IllegalAccessException C-SCAN-Algorithm");
                    this.myMainPanel.removeSchedulingGraph();
                    this.myMainPanel.setSearchParameter(0);
                    this.myDataPanel.setDiskParameter(false);
                    this.setSubject("");
                }
            } else if (this.Subject.equalsIgnoreCase(this.MDTT.EDF_LABEL)) {
                try {
                    this.multimediaAlgorithm = (MultimediaDiskScheduling)Class.forName("kom.itbeankit.mm.diskscheduling.schedulingmodel.EDF_Scheduling").newInstance();
                    this.initMultimediaAlgorithm();
                    this.myMainPanel.ExplainLabel.setText(this.MDTT.EXPLAIN_EDF);
                    this.myMainPanel.setSchedulingGraph("EDF-Scheduling", 3, 7);
                    this.myMainPanel.setSearchParameter(2);
                    this.myDataPanel.setDiskParameter(true);
                    this.myFrame.appendText(this.MDTT.INFO_EDF);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.myMainPanel.removeSchedulingGraph();
                    this.myMainPanel.setSearchParameter(0);
                    this.myDataPanel.setDiskParameter(false);
                    this.setSubject("");
                    ErrorDialog errorDialog = new ErrorDialog(this.myFrame, this.MDTT.ERR_ALGORITHM_HEAD, false, this.MDTT.ERR_ALGORITHM_NORUN, this.MDTT.ERR_ALGORITHM_NOEDF);
                    errorDialog.setVisible(true);
                }
                catch (InstantiationException instantiationException) {
                    System.out.println("InstantiationException EDF-Algorithm");
                    this.myMainPanel.removeSchedulingGraph();
                    this.myMainPanel.setSearchParameter(0);
                    this.myDataPanel.setDiskParameter(false);
                    this.setSubject("");
                }
                catch (IllegalAccessException illegalAccessException) {
                    System.out.println("IllegalAccessException EDF-Algorithm");
                    this.myMainPanel.removeSchedulingGraph();
                    this.myMainPanel.setSearchParameter(0);
                    this.myDataPanel.setDiskParameter(false);
                    this.setSubject("");
                }
            } else if (this.Subject.equalsIgnoreCase(this.MDTT.SCANEDF_LABEL)) {
                try {
                    this.multimediaAlgorithm = (MultimediaDiskScheduling)Class.forName("kom.itbeankit.mm.diskscheduling.schedulingmodel.SCANEDF_Scheduling").newInstance();
                    this.initMultimediaAlgorithm();
                    this.myMainPanel.ExplainLabel.setText(this.MDTT.EXPLAIN_SCANEDF);
                    this.myMainPanel.setSchedulingGraph("SCAN-EDF-Scheduling", 3, 7);
                    this.myMainPanel.setSearchParameter(2);
                    this.myDataPanel.setDiskParameter(true);
                    this.myFrame.appendText(this.MDTT.INFO_SCANEDF);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.myMainPanel.removeSchedulingGraph();
                    this.myMainPanel.setSearchParameter(0);
                    this.myDataPanel.setDiskParameter(false);
                    this.setSubject("");
                    ErrorDialog errorDialog = new ErrorDialog(this.myFrame, this.MDTT.ERR_ALGORITHM_HEAD, false, this.MDTT.ERR_ALGORITHM_NORUN, this.MDTT.ERR_ALGORITHM_NOSCANEDF);
                    errorDialog.setVisible(true);
                }
                catch (InstantiationException instantiationException) {
                    System.out.println("InstantiationException SCAN-EDF-Algorithm");
                    this.myMainPanel.removeSchedulingGraph();
                    this.myMainPanel.setSearchParameter(0);
                    this.myDataPanel.setDiskParameter(false);
                    this.setSubject("");
                }
                catch (IllegalAccessException illegalAccessException) {
                    System.out.println("IllegalAccessException SCAN-EDF-Algorithm");
                    this.myMainPanel.removeSchedulingGraph();
                    this.myMainPanel.setSearchParameter(0);
                    this.myDataPanel.setDiskParameter(false);
                    this.setSubject("");
                }
            } else if (this.Subject.equalsIgnoreCase(this.MDTT.ACCUSCANEDF_LABEL)) {
                try {
                    this.multimediaAlgorithm = (MultimediaDiskScheduling)Class.forName("kom.itbeankit.mm.diskscheduling.schedulingmodel.AccurateSCANEDF_Scheduling").newInstance();
                    this.initMultimediaAlgorithm();
                    this.myMainPanel.ExplainLabel.setText(this.MDTT.EXPLAIN_ACCU);
                    this.myMainPanel.setSchedulingGraph("Accurate SCAN-EDF", 3, 7);
                    this.myMainPanel.setSearchParameter(2);
                    this.myDataPanel.setDiskParameter(true);
                    this.myFrame.appendText(this.MDTT.INFO_ACCUSCAN1);
                    this.myFrame.appendText(this.MDTT.INFO_ACCUSCAN2);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.myMainPanel.removeSchedulingGraph();
                    this.myMainPanel.setSearchParameter(0);
                    this.myDataPanel.setDiskParameter(false);
                    this.setSubject("");
                    ErrorDialog errorDialog = new ErrorDialog(this.myFrame, this.MDTT.ERR_ALGORITHM_HEAD, false, this.MDTT.ERR_ALGORITHM_NORUN, this.MDTT.ERR_ALGORITHM_NOACCUSCAN);
                    errorDialog.setVisible(true);
                }
                catch (InstantiationException instantiationException) {
                    System.out.println("InstantiationException Accurate SCAN-EDF-Algorithm");
                    this.myMainPanel.removeSchedulingGraph();
                    this.myMainPanel.setSearchParameter(0);
                    this.myDataPanel.setDiskParameter(false);
                    this.setSubject("");
                }
                catch (IllegalAccessException illegalAccessException) {
                    System.out.println("IllegalAccessException Accurate SCAN-EDF-Algorithm");
                    this.myMainPanel.removeSchedulingGraph();
                    this.myMainPanel.setSearchParameter(0);
                    this.myDataPanel.setDiskParameter(false);
                    this.setSubject("");
                }
            } else if (this.Subject.equalsIgnoreCase(this.MDTT.GROUPSWEEP_LABEL)) {
                try {
                    this.multimediaAlgorithm = (MultimediaDiskScheduling)Class.forName("kom.itbeankit.mm.diskscheduling.schedulingmodel.GroupSweepingScheduling").newInstance();
                    this.initMultimediaAlgorithm();
                    this.myMainPanel.ExplainLabel.setText(this.MDTT.EXPLAIN_GROUP);
                    this.myMainPanel.setSchedulingGraph("Group Sweeping-Scheduling", 3, 10);
                    this.myMainPanel.setSearchParameter(2);
                    this.myDataPanel.setDiskParameter(true);
                    this.myFrame.appendText(this.MDTT.INFO_GROUPSWEEP1);
                    this.myFrame.appendText(this.MDTT.INFO_GROUPSWEEP2);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.myMainPanel.removeSchedulingGraph();
                    this.myMainPanel.setSearchParameter(0);
                    this.myDataPanel.setDiskParameter(false);
                    this.setSubject("");
                    ErrorDialog errorDialog = new ErrorDialog(this.myFrame, this.MDTT.ERR_ALGORITHM_HEAD, false, this.MDTT.ERR_ALGORITHM_NORUN, this.MDTT.ERR_ALGORITHM_NOGROUP);
                    errorDialog.setVisible(true);
                }
                catch (InstantiationException instantiationException) {
                    System.out.println("InstantiationException Group Sweeping-Algorithm");
                    this.myMainPanel.removeSchedulingGraph();
                    this.myMainPanel.setSearchParameter(0);
                    this.myDataPanel.setDiskParameter(false);
                    this.setSubject("");
                }
                catch (IllegalAccessException illegalAccessException) {
                    System.out.println("IllegalAccessException Group Sweeping-Algorithm");
                    this.myMainPanel.removeSchedulingGraph();
                    this.myMainPanel.setSearchParameter(0);
                    this.myDataPanel.setDiskParameter(false);
                    this.setSubject("");
                }
            } else {
                this.myMainPanel.ExplainLabel.setText("");
            }
        }
        this.myMainPanel.changeLanguage(this.MDTT.X_AXIS_LABEL, this.MDTT.Y_AXIS_LABEL);
        this.myFrame.repaint();
    }

    private void clearSubject() {
        this.myMainPanel.removeSchedulingGraph();
        this.myMainPanel.setSearchParameter(0);
        this.myDataPanel.setDiskParameter(false);
        this.setSubject("");
    }

    private void changeLearningLevel() {
        this.myDataPanel.setUserLevel(this.LearningLevel);
        this.myMainPanel.setUserLevel(this.LearningLevel);
        this.myFrame.setComplexityLevel(this.LearningLevel);
        if (this.OtherSubjectsAreAllowed) {
            switch (this.LearningLevel) {
                case 1: {
                    this.myModel = null;
                    try {
                        if (this.schedulingAlgorithm == null) {
                            this.multimediaAlgorithm.resetSearchRun();
                        } else {
                            this.schedulingAlgorithm.resetSearchRun();
                        }
                    }
                    catch (NullPointerException nullPointerException) {}
                    this.initSearchParameter();
                    int n = 0;
                    while (n < 7) {
                        this.myMainPanel.removeSchedulingGraphs(n);
                        ++n;
                    }
                    this.myFrame.enableButtons(7002, false);
                    this.myFrame.enableButtons(7003, false);
                    this.myDataPanel.setDiskParameter(false);
                    this.myMainPanel.setSearchParameter(0);
                    this.myMainPanel.initializeBean(this.deadlines, this.requests);
                    break;
                }
                case 3: {
                    try {
                        this.myModel = (DiskSchedulingModel)Class.forName("kom.itbeankit.mm.diskscheduling.schedulingmodel.DiskSchedulingModel").newInstance();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        ErrorDialog errorDialog = new ErrorDialog(this.myFrame, this.MDTT.ERR_LEVEL_HEAD, false, this.MDTT.ERR_LEVEL_CHANGE, this.MDTT.ERR_LEVEL_NOFILES);
                        errorDialog.setVisible(true);
                        this.setLearningLevel(2);
                    }
                    catch (InstantiationException instantiationException) {
                        System.out.println("InstantiationException Group Sweeping-Algorithm");
                        this.setLearningLevel(2);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        System.out.println("IllegalAccessException Group Sweeping-Algorithm");
                        this.setLearningLevel(2);
                    }
                    this.myMainPanel.removeSchedulingGraph();
                    this.myMainPanel.setSearchParameter(2);
                    this.myDataPanel.setDiskParameter(true);
                    this.myFrame.enableButtons(7002, true);
                    this.myFrame.enableButtons(7003, true);
                    break;
                }
                default: {
                    this.myModel = null;
                    try {
                        if (this.schedulingAlgorithm == null) {
                            this.multimediaAlgorithm.resetSearchRun();
                        } else {
                            this.schedulingAlgorithm.resetSearchRun();
                        }
                    }
                    catch (NullPointerException nullPointerException) {}
                    int n = 0;
                    while (n < 7) {
                        this.myMainPanel.removeSchedulingGraphs(n);
                        ++n;
                    }
                    this.myMainPanel.setSearchParameter(0);
                    this.myDataPanel.setDiskParameter(false);
                    this.myFrame.enableButtons(7002, false);
                    this.myFrame.enableButtons(7003, false);
                }
            }
            this.setSubject("");
            this.myMainPanel.resetAlgorithm();
        }
        this.BufferIndex = 0;
        this.TrackFound = 0;
        this.IterationIndex = 0;
        this.myFrame.repaint();
    }

    private void addAlgorithm(String string) {
        if (string.equalsIgnoreCase(this.MDTT.FCFS_LABEL)) {
            if (this.myModel.isFCFS_Active()) {
                this.myModel.setFCFS_Active(false);
                this.myMainPanel.removeSchedulingGraphs(0);
            } else {
                this.myModel.setFCFS_Active(true);
                this.myMainPanel.addSchedulingGraph("FCFS-Scheduling", 0);
                this.myMainPanel.resetAlgorithm();
                this.IterationIndex = 0;
                this.myFrame.appendText(this.MDTT.INFO_FCFS);
            }
        }
        if (string.equalsIgnoreCase(this.MDTT.SCAN_LABEL)) {
            if (this.myModel.isSCAN_Active()) {
                this.myModel.setSCAN_Active(false);
                this.myMainPanel.removeSchedulingGraphs(1);
            } else {
                this.myModel.setSCAN_Active(true);
                this.myMainPanel.addSchedulingGraph("SCAN-Scheduling", 1);
                this.myMainPanel.resetAlgorithm();
                this.IterationIndex = 0;
                this.myFrame.appendText(this.MDTT.INFO_SCAN1);
                this.myFrame.appendText(this.MDTT.INFO_SCAN2);
            }
        }
        if (string.equalsIgnoreCase(this.MDTT.CSCAN_LABEL)) {
            if (this.myModel.isCSCAN_Active()) {
                this.myModel.setCSCAN_Active(false);
                this.myMainPanel.removeSchedulingGraphs(2);
            } else {
                this.myModel.setCSCAN_Active(true);
                this.myMainPanel.addSchedulingGraph("C-SCAN-Scheduling", 2);
                this.myMainPanel.resetAlgorithm();
                this.IterationIndex = 0;
                this.myFrame.appendText(this.MDTT.INFO_CSCAN1);
                this.myFrame.appendText(this.MDTT.INFO_CSCAN2);
            }
        }
        if (string.equalsIgnoreCase(this.MDTT.EDF_LABEL)) {
            if (this.myModel.isEDF_Active()) {
                this.myModel.setEDF_Active(false);
                this.myMainPanel.removeSchedulingGraphs(3);
            } else {
                this.myModel.setEDF_Active(true);
                this.myMainPanel.addSchedulingGraph("EDF-Scheduling", 3);
                this.myMainPanel.resetAlgorithm();
                this.IterationIndex = 0;
                this.myFrame.appendText(this.MDTT.INFO_EDF);
            }
        }
        if (string.equalsIgnoreCase(this.MDTT.SCANEDF_LABEL)) {
            if (this.myModel.isSCANEDF_Active()) {
                this.myModel.setSCANEDF_Active(false);
                this.myMainPanel.removeSchedulingGraphs(4);
            } else {
                this.myModel.setSCANEDF_Active(true);
                this.myMainPanel.addSchedulingGraph("SCAN-EDF-Scheduling", 4);
                this.myMainPanel.resetAlgorithm();
                this.IterationIndex = 0;
                this.myFrame.appendText(this.MDTT.INFO_SCANEDF);
            }
        }
        if (string.equalsIgnoreCase(this.MDTT.ACCUSCANEDF_LABEL)) {
            if (this.myModel.isAccurateSCANEDF_Active()) {
                this.myModel.setAccurateSCANEDF_Active(false);
                this.myMainPanel.removeSchedulingGraphs(5);
            } else {
                this.myModel.setAccurateSCANEDF_Active(true);
                this.myMainPanel.addSchedulingGraph("Accurate SCAN-EDF", 5);
                this.myMainPanel.resetAlgorithm();
                this.IterationIndex = 0;
                this.myFrame.appendText(this.MDTT.INFO_ACCUSCAN1);
                this.myFrame.appendText(this.MDTT.INFO_ACCUSCAN2);
            }
        }
        if (string.equalsIgnoreCase(this.MDTT.GROUPSWEEP_LABEL)) {
            if (this.myModel.isGroupSweeping_Active()) {
                this.myModel.setGroupSweeping_Active(false);
                this.myMainPanel.removeSchedulingGraphs(6);
            } else {
                this.myModel.setGroupSweeping_Active(true);
                this.myMainPanel.addSchedulingGraph("Group Sweeping-Scheduling", 6);
                this.myMainPanel.resetAlgorithm();
                this.IterationIndex = 0;
                this.myFrame.appendText(this.MDTT.INFO_GROUPSWEEP1);
                this.myFrame.appendText(this.MDTT.INFO_GROUPSWEEP2);
            }
        }
        this.myModel.resetSearch();
        this.myMainPanel.changeLanguage(this.MDTT.X_AXIS_LABEL, this.MDTT.Y_AXIS_LABEL);
        this.myFrame.repaint();
    }

    private void initSchedulingAlgorithm() {
        try {
            int n = 0;
            while (n < 10) {
                this.schedulingAlgorithm.setRequestedTrack(n, (short)this.requests[n]);
                ++n;
            }
            this.schedulingAlgorithm.setRotationtime(this.rotationTime);
            this.schedulingAlgorithm.setSeekReadRatio(this.seekreadRatio);
            this.schedulingAlgorithm.addTrackFoundListener(this);
        }
        catch (NullPointerException nullPointerException) {}
        this.BufferIndex = 0;
        this.TrackFound = 0;
        this.myMainPanel.resetAlgorithm();
        this.IterationIndex = 0;
        this.myFrame.enableButtons(7002, true);
        this.myFrame.enableButtons(7003, true);
        this.myFrame.repaint();
    }

    private void initMultimediaAlgorithm() {
        try {
            int n = 0;
            while (n < 10) {
                this.multimediaAlgorithm.setRequestedTrack(n, (short)this.requests[n]);
                this.multimediaAlgorithm.setDeadline(n, (short)this.deadlines[n]);
                ++n;
            }
            this.multimediaAlgorithm.setRotationtime(this.rotationTime);
            this.multimediaAlgorithm.setSeekReadRatio(this.seekreadRatio);
            this.multimediaAlgorithm.addTrackFoundListener(this);
        }
        catch (NullPointerException nullPointerException) {}
        this.BufferIndex = 0;
        this.TrackFound = 0;
        this.myMainPanel.resetAlgorithm();
        this.IterationIndex = 0;
        this.myFrame.enableButtons(7002, true);
        this.myFrame.enableButtons(7003, true);
        this.myFrame.repaint();
    }

    private void initSearchParameter() {
        int n = 0;
        while (n < 10) {
            this.deadlines[n] = InitialDeadlines[n];
            this.requests[n] = InitialRequests[n];
            ++n;
        }
    }

    public static void main(String[] stringArray) {
        ItBeanScheduling itBeanScheduling = null;
        if (stringArray.length > 4) {
            System.out.println("uncount number of arguments; only up to three arguments are allowed:");
            System.out.println("subject language learninglevel otherSubjectsAreAllowed");
            return;
        }
        switch (stringArray.length) {
            case 1: {
                itBeanScheduling = new ItBeanScheduling(stringArray[0]);
                break;
            }
            case 2: {
                itBeanScheduling = new ItBeanScheduling(stringArray[0], stringArray[1]);
                break;
            }
            case 3: {
                try {
                    itBeanScheduling = new ItBeanScheduling(stringArray[0], stringArray[1], Integer.parseInt(stringArray[2]));
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("the third argument must be between zero (0) and ten (10)!!!!");
                    return;
                }
            }
            case 4: {
                try {
                    itBeanScheduling = new ItBeanScheduling(stringArray[0], stringArray[1], Integer.parseInt(stringArray[2]), stringArray[3]);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("the third argument must be between zero (0) and ten (10)!!!!");
                    return;
                }
            }
            default: {
                itBeanScheduling = new ItBeanScheduling();
            }
        }
        itBeanScheduling = null;
    }

    static {
        int[] nArray = new int[10];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[5] = 2;
        nArray[6] = 3;
        nArray[7] = 2;
        nArray[8] = 3;
        nArray[9] = 3;
        InitialDeadlines = nArray;
        InitialRequests = new int[]{20, 22, 40, 12, 45, 42, 50, 16, 30, 24};
    }
}

