/*
 * Decompiled with CFR 0.152.
 */
package kom.itbeankit.nw.ethernet;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import kom.itbeankit.common.message.MessageEvent;
import kom.itbeankit.common.message.MessageListener;
import kom.itbeankit.common.vcr.ClkEvent;
import kom.itbeankit.common.vcr.ClkListener;
import kom.itbeankit.nw.ethernet.AlgorithmInterface;
import kom.itbeankit.nw.ethernet.BusSegment;
import kom.itbeankit.nw.ethernet.DataEvent;
import kom.itbeankit.nw.ethernet.DataListener;
import kom.itbeankit.nw.ethernet.Ethernet;
import kom.itbeankit.nw.ethernet.EthernetInterface;
import kom.itbeankit.nw.ethernet.Host;

public class Ethernet
extends Container
implements EthernetInterface,
ClkListener,
MessageListener {
    protected AlgorithmInterface algorithm;
    protected boolean usePadField;
    protected int numOfHosts = 8;
    private Vector messageListeners = new Vector();
    protected int scenario = 1;
    Panel ethernetPanel;
    Panel hostTopPanel;
    Host host1;
    Host host3;
    Host host5;
    Host host7;
    Panel busPanel;
    BusSegment busSegment1;
    BusSegment busSegment2;
    BusSegment busSegment3;
    BusSegment busSegment4;
    Panel hostBottomPanel;
    Host host2;
    Host host4;
    Host host6;
    Host host8;
    Button button1;

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.host1.setEnabled(bl);
        this.host2.setEnabled(bl);
        this.host3.setEnabled(bl);
        this.host4.setEnabled(bl);
        this.host5.setEnabled(bl);
        this.host6.setEnabled(bl);
        this.host7.setEnabled(bl);
        this.host8.setEnabled(bl);
    }

    public void doScenario(ClkEvent clkEvent) {
        switch (this.scenario) {
            case 0: {
                this.scenarioNone(clkEvent);
                return;
            }
            case 1: {
                this.scenarioNormal(clkEvent);
                return;
            }
            case 2: {
                this.scenarioCollision(clkEvent);
                return;
            }
            case 3: {
                this.scenarioBroadcast(clkEvent);
                return;
            }
            case 4: {
                this.scenarioShortFrame(clkEvent);
                return;
            }
        }
    }

    void scenarioNone(ClkEvent clkEvent) {
        if (clkEvent.isRisingEdge()) {
            this.showEfficiency();
        }
        this.busSegment1.clkReceived(clkEvent);
        this.host1.clkReceived(clkEvent);
        this.host2.clkReceived(clkEvent);
        if (this.numOfHosts > 2) {
            this.host3.clkReceived(clkEvent);
            this.host4.clkReceived(clkEvent);
            this.busSegment2.clkReceived(clkEvent);
        }
        if (this.numOfHosts > 4) {
            this.host5.clkReceived(clkEvent);
            this.host6.clkReceived(clkEvent);
            this.busSegment3.clkReceived(clkEvent);
        }
        if (this.numOfHosts > 6) {
            this.busSegment4.clkReceived(clkEvent);
            this.host7.clkReceived(clkEvent);
            this.host8.clkReceived(clkEvent);
        }
    }

    void scenarioNormal(ClkEvent clkEvent) {
        this.setNumOfHosts(8);
        this.msg("scenario normal operation", "\n  in this scenario host5 sends\n   a frame to host8");
        this.host5.setFrameSize(56);
        this.host5.setAutoRepeat(false);
        this.host5.setDestinationHost(8);
        this.scenario = 0;
    }

    void scenarioCollision(ClkEvent clkEvent) {
        this.setNumOfHosts(8);
        this.msg("scenario collision", "\n   in this scenario host2 and\n   host7 send frames at the same\n   time to host5 and host1");
        this.host2.setFrameSize(56);
        this.host2.setAutoRepeat(false);
        this.host7.setFrameSize(56);
        this.host7.setAutoRepeat(false);
        this.host2.setDestinationHost(5);
        this.host7.setDestinationHost(1);
        this.scenario = 0;
    }

    void scenarioBroadcast(ClkEvent clkEvent) {
        this.setNumOfHosts(8);
        this.msg("scenario broadcast", "\n  in this scenario host4 sends\n   a frame to all other hosts");
        this.host4.setFrameSize(56);
        this.host4.setAutoRepeat(false);
        this.host4.setDestinationHost(0);
        this.scenario = 0;
    }

    void scenarioShortFrame(ClkEvent clkEvent) {
        this.setNumOfHosts(8);
        this.msg("scenario short frame", "\n   in this scenario host1 and\n   host8 send frames at the same\n   time to host5 and host2. host1\n   sends a too short frame and cannot\n   detect that a collision happens\n   try this scenario with and without\n   use of pad field to see the difference");
        this.host1.setFrameSize(16);
        this.host1.setAutoRepeat(false);
        this.host8.setFrameSize(56);
        this.host8.setAutoRepeat(false);
        this.host1.setDestinationHost(5);
        this.host8.setDestinationHost(2);
        this.scenario = 0;
    }

    public void setScenario(int n) {
        this.scenario = n;
    }

    public int getScenario() {
        return this.scenario;
    }

    void msg(String string, String string2) {
        this.deliverMessage(new MessageEvent(this, 701, 710, string, string2));
    }

    public void deliverMessage(MessageEvent messageEvent) {
        MessageEvent messageEvent2 = new MessageEvent(this, messageEvent);
        int n = 0;
        while (n < this.messageListeners.size()) {
            MessageListener messageListener = (MessageListener)this.messageListeners.elementAt(n);
            messageListener.deliverMessage(messageEvent2);
            ++n;
        }
    }

    public synchronized void addMessageListener(MessageListener messageListener) {
        this.messageListeners.addElement(messageListener);
    }

    public synchronized void removeMessageListener(MessageListener messageListener) {
        this.messageListeners.removeElement(messageListener);
    }

    public void setNumOfHosts(int n) {
        switch (n) {
            case 2: {
                this.numOfHosts = 2;
                this.set2ndPairVisible(false);
                this.set3rdPairVisible(false);
                this.set4thPairVisible(false);
                return;
            }
            case 4: {
                this.numOfHosts = 4;
                this.set2ndPairVisible(true);
                this.set3rdPairVisible(false);
                this.set4thPairVisible(false);
                return;
            }
            case 6: {
                this.numOfHosts = 6;
                this.set2ndPairVisible(true);
                this.set3rdPairVisible(true);
                this.set4thPairVisible(false);
                return;
            }
            case 8: {
                this.numOfHosts = 8;
                this.set2ndPairVisible(true);
                this.set3rdPairVisible(true);
                this.set4thPairVisible(true);
                return;
            }
        }
    }

    void set2ndPairVisible(boolean bl) {
        this.host3.setVisible(bl);
        this.host4.setVisible(bl);
        this.busSegment2.setVisible(bl);
        if (!bl) {
            this.host3.reset();
            this.host4.reset();
            this.busSegment2.reset();
        }
    }

    void set3rdPairVisible(boolean bl) {
        this.host5.setVisible(bl);
        this.host6.setVisible(bl);
        this.busSegment3.setVisible(bl);
        if (!bl) {
            this.host5.reset();
            this.host6.reset();
            this.busSegment3.reset();
        }
    }

    void set4thPairVisible(boolean bl) {
        this.host7.setVisible(bl);
        this.host8.setVisible(bl);
        this.busSegment4.setVisible(bl);
        if (!bl) {
            this.host7.reset();
            this.host8.reset();
            this.busSegment4.reset();
        }
    }

    public int getNumOfHosts() {
        return this.numOfHosts;
    }

    public void setAlgorithm(String string) {
        this.algorithm = this.algorithm;
        this.host1.setAlgorithm(string);
        this.host2.setAlgorithm(string);
        this.host3.setAlgorithm(string);
        this.host4.setAlgorithm(string);
        this.host5.setAlgorithm(string);
        this.host6.setAlgorithm(string);
        this.host7.setAlgorithm(string);
        this.host8.setAlgorithm(string);
    }

    public AlgorithmInterface getAlgorithm() {
        return this.algorithm;
    }

    public void setUsePadField(boolean bl) {
        this.usePadField = bl;
        this.host1.setUsePadField(bl);
        this.host2.setUsePadField(bl);
        this.host3.setUsePadField(bl);
        this.host4.setUsePadField(bl);
        this.host5.setUsePadField(bl);
        this.host6.setUsePadField(bl);
        this.host7.setUsePadField(bl);
        this.host8.setUsePadField(bl);
    }

    public boolean isUsePadField() {
        return this.usePadField;
    }

    public Ethernet() {
        this.setLayout(new BorderLayout(0, 0));
        this.setSize(612, 439);
        this.ethernetPanel = new Panel();
        this.ethernetPanel.setLayout(null);
        this.ethernetPanel.setBounds(0, 0, 612, 416);
        this.add("Center", this.ethernetPanel);
        this.hostTopPanel = new Panel();
        this.hostTopPanel.setLayout(null);
        this.hostTopPanel.setBounds(10, 10, 400, 74);
        this.ethernetPanel.add(this.hostTopPanel);
        this.host1 = new Host();
        this.host1.setLayout(null);
        this.host1.setBounds(0, 0, 80, 74);
        this.hostTopPanel.add(this.host1);
        this.host1.setCursor(new Cursor(12));
        this.host3 = new Host();
        this.host3.setID(3);
        this.host3.setLayout(null);
        this.host3.setBounds(90, 0, 80, 74);
        this.hostTopPanel.add(this.host3);
        this.host3.setCursor(new Cursor(12));
        this.host5 = new Host();
        this.host5.setID(5);
        this.host5.setLayout(null);
        this.host5.setBounds(180, 0, 80, 74);
        this.hostTopPanel.add(this.host5);
        this.host5.setCursor(new Cursor(12));
        this.host7 = new Host();
        this.host7.setID(7);
        this.host7.setLayout(null);
        this.host7.setBounds(270, 0, 80, 74);
        this.hostTopPanel.add(this.host7);
        this.host7.setCursor(new Cursor(12));
        this.busPanel = new Panel();
        this.busPanel.setLayout(null);
        this.busPanel.setBounds(10, 84, 400, 45);
        this.ethernetPanel.add(this.busPanel);
        this.busSegment1 = new BusSegment();
        this.busSegment1.setLayout(null);
        this.busSegment1.setBounds(0, 0, 90, 45);
        this.busPanel.add(this.busSegment1);
        this.busSegment2 = new BusSegment();
        this.busSegment2.setLayout(null);
        this.busSegment2.setBounds(90, 0, 90, 45);
        this.busPanel.add(this.busSegment2);
        this.busSegment3 = new BusSegment();
        this.busSegment3.setLayout(null);
        this.busSegment3.setBounds(180, 0, 90, 45);
        this.busPanel.add(this.busSegment3);
        this.busSegment4 = new BusSegment();
        this.busSegment4.setLayout(null);
        this.busSegment4.setBounds(270, 0, 90, 45);
        this.busPanel.add(this.busSegment4);
        this.hostBottomPanel = new Panel();
        this.hostBottomPanel.setLayout(null);
        this.hostBottomPanel.setBounds(10, 129, 400, 74);
        this.ethernetPanel.add(this.hostBottomPanel);
        this.host2 = new Host();
        this.host2.setOverTheBus(false);
        this.host2.setID(2);
        this.host2.setLayout(null);
        this.host2.setBounds(25, 0, 80, 74);
        this.hostBottomPanel.add(this.host2);
        this.host2.setCursor(new Cursor(12));
        this.host4 = new Host();
        this.host4.setOverTheBus(false);
        this.host4.setID(4);
        this.host4.setLayout(null);
        this.host4.setBounds(115, 0, 80, 74);
        this.hostBottomPanel.add(this.host4);
        this.host4.setCursor(new Cursor(12));
        this.host6 = new Host();
        this.host6.setOverTheBus(false);
        this.host6.setID(6);
        this.host6.setLayout(null);
        this.host6.setBounds(205, 0, 80, 74);
        this.hostBottomPanel.add(this.host6);
        this.host6.setCursor(new Cursor(12));
        this.host8 = new Host();
        this.host8.setOverTheBus(false);
        this.host8.setID(8);
        this.host8.setLayout(null);
        this.host8.setBounds(295, 0, 80, 74);
        this.hostBottomPanel.add(this.host8);
        this.host8.setCursor(new Cursor(12));
        this.button1 = new Button();
        this.button1.setLabel("button");
        this.button1.setBounds(0, 416, 612, 23);
        this.button1.setBackground(new Color(0xC0C0C0));
        this.add("South", this.button1);
        this.setAlgorithm("kom.itbeankit.nw.ethernet.OnePersistentAlgorithm");
        this.setNumOfHosts(8);
        SymData symData = new SymData();
        this.busSegment1.addDataListener(symData);
        this.busSegment2.addDataListener(symData);
        this.busSegment3.addDataListener(symData);
        this.busSegment4.addDataListener(symData);
        this.host1.addDataListener(symData);
        this.host2.addDataListener(symData);
        this.host3.addDataListener(symData);
        this.host5.addDataListener(symData);
        this.host7.addDataListener(symData);
        this.host4.addDataListener(symData);
        this.host6.addDataListener(symData);
        this.host8.addDataListener(symData);
        SymMessage symMessage = new SymMessage();
        this.host1.addMessageListener(symMessage);
        this.host2.addMessageListener(symMessage);
        this.host3.addMessageListener(symMessage);
        this.host4.addMessageListener(symMessage);
        this.host5.addMessageListener(symMessage);
        this.host6.addMessageListener(symMessage);
        this.host7.addMessageListener(symMessage);
        this.host8.addMessageListener(symMessage);
        SymAction symAction = new SymAction();
        this.button1.addActionListener(symAction);
    }

    public void clkReceived(ClkEvent clkEvent) {
        this.doScenario(clkEvent);
    }

    public void reset() {
        this.busSegment1.reset();
        this.busSegment2.reset();
        this.busSegment3.reset();
        this.busSegment4.reset();
        this.host1.reset();
        this.host2.reset();
        this.host3.reset();
        this.host4.reset();
        this.host5.reset();
        this.host6.reset();
        this.host7.reset();
        this.host8.reset();
        this.clkReceived(new ClkEvent(this, true));
        this.clkReceived(new ClkEvent(this, false));
        this.clkReceived(new ClkEvent(this, true));
    }

    public void resetDataSize() {
        this.host1.resetDataSize();
        this.host2.resetDataSize();
        this.host3.resetDataSize();
        this.host4.resetDataSize();
        this.host5.resetDataSize();
        this.host6.resetDataSize();
        this.host7.resetDataSize();
        this.host8.resetDataSize();
    }

    public int getEfficiency() {
        double d = 0.0;
        double d2 = 0.0;
        d = this.host1.getSentDataSize() + this.host2.getSentDataSize() + this.host3.getSentDataSize() + this.host4.getSentDataSize() + this.host5.getSentDataSize() + this.host6.getSentDataSize() + this.host7.getSentDataSize() + this.host8.getSentDataSize();
        d2 = this.host1.getReceivedDataSize() + this.host2.getReceivedDataSize() + this.host3.getReceivedDataSize() + this.host4.getReceivedDataSize() + this.host5.getReceivedDataSize() + this.host6.getReceivedDataSize() + this.host7.getReceivedDataSize() + this.host8.getReceivedDataSize();
        double d3 = -1.0;
        if (d != 0.0) {
            d3 = d2 / d * 100.0;
        }
        return (int)d3;
    }

    void showEfficiency() {
        int n = this.getEfficiency();
    }

    public static void main(String[] stringArray) {
        new 1.DriverFrame().show();
    }

    void busSegment1_dataToRight(DataEvent dataEvent) {
        this.busSegment2.dataFromLeft(dataEvent);
    }

    void busSegment2_dataToRight(DataEvent dataEvent) {
        this.busSegment3.dataFromLeft(dataEvent);
    }

    void busSegment3_dataToRight(DataEvent dataEvent) {
        this.busSegment4.dataFromLeft(dataEvent);
    }

    void busSegment4_dataToLeft(DataEvent dataEvent) {
        this.busSegment3.dataFromRight(dataEvent);
    }

    void busSegment3_dataToLeft(DataEvent dataEvent) {
        this.busSegment2.dataFromRight(dataEvent);
    }

    void busSegment2_dataToLeft(DataEvent dataEvent) {
        this.busSegment1.dataFromRight(dataEvent);
    }

    void busSegment1_dataToTop(DataEvent dataEvent) {
        this.host1.dataFromBottom(dataEvent);
    }

    void busSegment1_dataToBottom(DataEvent dataEvent) {
        this.host2.dataFromTop(dataEvent);
    }

    void busSegment2_dataToTop(DataEvent dataEvent) {
        this.host3.dataFromBottom(dataEvent);
    }

    void busSegment2_dataToBottom(DataEvent dataEvent) {
        this.host4.dataFromTop(dataEvent);
    }

    void busSegment3_dataToTop(DataEvent dataEvent) {
        this.host5.dataFromBottom(dataEvent);
    }

    void busSegment3_dataToBottom(DataEvent dataEvent) {
        this.host6.dataFromTop(dataEvent);
    }

    void busSegment4_dataToTop(DataEvent dataEvent) {
        this.host7.dataFromBottom(dataEvent);
    }

    void busSegment4_dataToBottom(DataEvent dataEvent) {
        this.host8.dataFromTop(dataEvent);
    }

    void host1_dataToBottom(DataEvent dataEvent) {
        this.busSegment1.dataFromTop(dataEvent);
    }

    void host2_dataToTop(DataEvent dataEvent) {
        this.busSegment1.dataFromBottom(dataEvent);
    }

    void host3_dataToBottom(DataEvent dataEvent) {
        this.busSegment2.dataFromTop(dataEvent);
    }

    void host5_dataToBottom(DataEvent dataEvent) {
        this.busSegment3.dataFromTop(dataEvent);
    }

    void host7_dataToBottom(DataEvent dataEvent) {
        this.busSegment4.dataFromTop(dataEvent);
    }

    void host4_dataToTop(DataEvent dataEvent) {
        this.busSegment2.dataFromBottom(dataEvent);
    }

    void host6_dataToTop(DataEvent dataEvent) {
        this.busSegment3.dataFromBottom(dataEvent);
    }

    void host8_dataToTop(DataEvent dataEvent) {
        this.busSegment4.dataFromBottom(dataEvent);
    }

    void host_deliverMessage(MessageEvent messageEvent) {
        this.deliverMessage(messageEvent);
    }

    void helpButton_ActionPerformed(ActionEvent actionEvent) {
        this.deliverMessage(new MessageEvent(this, 702, 710, "Efficiency", " Shows the proportion of received data to the sent data by all hosts."));
    }

    void button1_ActionPerformed(ActionEvent actionEvent) {
        this.clkReceived(new ClkEvent(this, true));
    }

    class SymData
    implements DataListener {
        public void dataToRight(DataEvent dataEvent) {
            Object object = dataEvent.getSource();
            if (object == Ethernet.this.busSegment1) {
                Ethernet.this.busSegment1_dataToRight(dataEvent);
                return;
            }
            if (object == Ethernet.this.busSegment2) {
                Ethernet.this.busSegment2_dataToRight(dataEvent);
                return;
            }
            if (object == Ethernet.this.busSegment3) {
                Ethernet.this.busSegment3_dataToRight(dataEvent);
            }
        }

        public void dataToTop(DataEvent dataEvent) {
            Object object = dataEvent.getSource();
            if (object == Ethernet.this.busSegment1) {
                Ethernet.this.busSegment1_dataToTop(dataEvent);
                return;
            }
            if (object == Ethernet.this.busSegment2) {
                Ethernet.this.busSegment2_dataToTop(dataEvent);
                return;
            }
            if (object == Ethernet.this.busSegment3) {
                Ethernet.this.busSegment3_dataToTop(dataEvent);
                return;
            }
            if (object == Ethernet.this.busSegment4) {
                Ethernet.this.busSegment4_dataToTop(dataEvent);
                return;
            }
            if (object == Ethernet.this.host2) {
                Ethernet.this.host2_dataToTop(dataEvent);
                return;
            }
            if (object == Ethernet.this.host4) {
                Ethernet.this.host4_dataToTop(dataEvent);
                return;
            }
            if (object == Ethernet.this.host6) {
                Ethernet.this.host6_dataToTop(dataEvent);
                return;
            }
            if (object == Ethernet.this.host8) {
                Ethernet.this.host8_dataToTop(dataEvent);
            }
        }

        public void dataToBottom(DataEvent dataEvent) {
            Object object = dataEvent.getSource();
            if (object == Ethernet.this.busSegment1) {
                Ethernet.this.busSegment1_dataToBottom(dataEvent);
                return;
            }
            if (object == Ethernet.this.busSegment2) {
                Ethernet.this.busSegment2_dataToBottom(dataEvent);
                return;
            }
            if (object == Ethernet.this.busSegment3) {
                Ethernet.this.busSegment3_dataToBottom(dataEvent);
                return;
            }
            if (object == Ethernet.this.busSegment4) {
                Ethernet.this.busSegment4_dataToBottom(dataEvent);
                return;
            }
            if (object == Ethernet.this.host1) {
                Ethernet.this.host1_dataToBottom(dataEvent);
                return;
            }
            if (object == Ethernet.this.host3) {
                Ethernet.this.host3_dataToBottom(dataEvent);
                return;
            }
            if (object == Ethernet.this.host5) {
                Ethernet.this.host5_dataToBottom(dataEvent);
                return;
            }
            if (object == Ethernet.this.host7) {
                Ethernet.this.host7_dataToBottom(dataEvent);
            }
        }

        public void dataToLeft(DataEvent dataEvent) {
            Object object = dataEvent.getSource();
            if (object == Ethernet.this.busSegment4) {
                Ethernet.this.busSegment4_dataToLeft(dataEvent);
                return;
            }
            if (object == Ethernet.this.busSegment3) {
                Ethernet.this.busSegment3_dataToLeft(dataEvent);
                return;
            }
            if (object == Ethernet.this.busSegment2) {
                Ethernet.this.busSegment2_dataToLeft(dataEvent);
            }
        }

        SymData() {
            Ethernet.this = Ethernet.this;
        }
    }

    class SymMessage
    implements MessageListener {
        public void deliverMessage(MessageEvent messageEvent) {
            Ethernet.this.host_deliverMessage(messageEvent);
        }

        SymMessage() {
            Ethernet.this = Ethernet.this;
        }
    }

    class SymAction
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == Ethernet.this.button1) {
                Ethernet.this.button1_ActionPerformed(actionEvent);
            }
        }

        SymAction() {
            Ethernet.this = Ethernet.this;
        }
    }
}

