/*
 * Decompiled with CFR 0.152.
 */
package kom.itbeankit.nw.ethernet;

import java.util.Random;
import kom.itbeankit.common.message.MessageEvent;
import kom.itbeankit.nw.ethernet.AlgorithmInterface;
import kom.itbeankit.nw.ethernet.DataEvent;
import kom.itbeankit.nw.ethernet.EthernetInterface;
import kom.itbeankit.nw.ethernet.Host;

class OnePersistentAlgorithm
implements AlgorithmInterface,
EthernetInterface {
    protected Random random = new Random();
    protected Host host;
    protected DataEvent dataEvent;

    public void setHost(Host host) {
        this.host = host;
    }

    public void cleanup() {
        this.host = null;
        this.dataEvent = null;
    }

    public void processStatus(int n) {
        this.dataEvent = this.host.oldReceiveDataEvent;
        switch (n) {
            case 0: {
                this.onIdle();
                return;
            }
            case 2: {
                this.onCarrierSense();
                return;
            }
            case 1: {
                this.onCountdown();
                return;
            }
            case 11: {
                this.onReceiving();
                return;
            }
            case 12: {
                this.onReceiving();
                return;
            }
            case 13: {
                this.onSendingData();
                return;
            }
            case 14: {
                this.onSendingPad();
                return;
            }
            case 15: {
                this.onSendingNoise();
                return;
            }
        }
    }

    void onIdle() {
        this.host.carrierSense = 0;
        this.host.collisionDetect = 0;
        this.host.sendDataEvent = null;
        if (this.isNewFrameReceived()) {
            this.msg(710, "begin receiving from host" + this.dataEvent.getSourceHost() + ".");
            this.beginReceiving();
            return;
        }
        if (this.isDataToSend()) {
            this.host.carrierSense = 1;
            this.msg(710, "sensing carrier.");
            this.host.onStatus(2);
            return;
        }
        this.host.onStatus(0);
    }

    void onCarrierSense() {
        this.host.carrierSense = 1;
        this.host.collisionDetect = 0;
        this.host.sendDataEvent = null;
        if (this.dataEvent != null) {
            this.host.carrierSense = 2;
            if (this.isNewFrameReceived()) {
                this.msg(711, "abort sensing carrier, \n   begin receiving from host" + this.dataEvent.getSourceHost() + ".");
                this.beginReceiving();
                return;
            }
            this.msg(711, "bus is busy, \n   continue sensing carrier.");
            this.host.onStatus(2);
            return;
        }
        if (this.isDataToSend()) {
            int n = this.host.frameSize;
            if (n == 16 && this.host.usePadField) {
                n = 56;
            }
            this.host.sendDataEvent = new DataEvent(this.host, 2, n, this.host.ID, this.host.destinationHost, true, false);
            this.host.remainingSendDataSize = this.host.frameSize - 1;
            ++this.host.sentDataSize;
            this.host.carrierSense = 0;
            this.host.collisionDetect = 1;
            this.msg(710, "bus is free, \n   begin sending to " + this.getDestinationString(this.host.destinationHost) + ".");
            this.host.onStatus(13);
            return;
        }
        this.msg(711, "nothing to do, going idle.");
        this.host.onStatus(0);
    }

    void onCountdown() {
        this.host.carrierSense = 0;
        this.host.collisionDetect = 0;
        this.host.sendDataEvent = null;
        if (this.isNewFrameReceived()) {
            this.msg(710, "abort countdown, \n   begin receiving from host" + this.dataEvent.getSourceHost() + ".");
            this.beginReceiving();
            return;
        }
        if (this.host.countdownTime > 0) {
            --this.host.countdownTime;
            this.host.onStatus(1);
            return;
        }
        if (this.isDataToSend()) {
            this.host.carrierSense = 1;
            this.msg(710, "sensing carrier.");
            this.host.onStatus(2);
            return;
        }
        this.msg(711, "nothing to do, going idle.");
        this.host.onStatus(0);
    }

    void onReceiving() {
        this.host.carrierSense = 0;
        this.host.collisionDetect = 0;
        this.host.sendDataEvent = null;
        if (this.dataEvent != null) {
            if (this.isDataEventForHost() && (this.dataEvent.getDataType() == 2 || this.dataEvent.getDataType() == 3)) {
                if (this.dataEvent.getSourceHost() == this.host.sourceHost) {
                    ++this.host.bufferedReceivedDataSize;
                    --this.host.remainingReceiveDataSize;
                    if (this.host.remainingReceiveDataSize > 0) {
                        if (this.dataEvent.getDataType() == 2) {
                            this.host.onStatus(11);
                            return;
                        }
                        this.host.onStatus(12);
                        return;
                    }
                    if (this.dataEvent.hasStopBit()) {
                        this.host.receivedDataSize += this.host.bufferedReceivedDataSize;
                        this.msg(710, "complete receiving from host" + this.host.sourceHost + ".");
                        this.abortReceiving();
                        return;
                    }
                    this.msg(712, "abort receiving from host" + this.host.sourceHost + ".");
                    this.abortReceiving();
                    return;
                }
                if (this.dataEvent.hasStartBit()) {
                    this.beginReceiving();
                    this.msg(710, "begin receiving from host" + this.dataEvent.getSourceHost() + ".");
                    return;
                }
                this.abortReceiving();
                return;
            }
            this.msg(712, "corrupt data received,\n   abort receiving from host" + this.host.sourceHost + ".");
            this.abortReceiving();
            return;
        }
        this.msg(712, "reception interrupted,\n   abort receiving from host" + this.host.sourceHost + ".");
        this.abortReceiving();
    }

    void onSendingData() {
        this.host.carrierSense = 0;
        this.host.collisionDetect = 1;
        this.host.sendDataEvent = null;
        if (this.dataEvent != null) {
            this.msg(712, "collision detected, \n   abort sending and begin\n   sending noise burst.");
            this.collisionDetect();
            return;
        }
        if (this.host.frameSize == 16 && this.host.usePadField && this.host.remainingSendDataSize == 1) {
            this.host.remainingSendDataSize = 40;
            ++this.host.sentDataSize;
            this.host.sendDataEvent = new DataEvent(this.host, 3, 56, this.host.ID, this.host.destinationHost, false, false);
            this.msg(711, "frame too short,\n   sending pad field.");
            this.host.onStatus(14);
            return;
        }
        ++this.host.sentDataSize;
        --this.host.remainingSendDataSize;
        if (this.host.remainingSendDataSize <= 0) {
            this.msg(710, "complete sending to" + this.getDestinationString(this.host.destinationHost) + ".");
            this.sendLastData();
            return;
        }
        this.host.sendDataEvent = new DataEvent(this.host, 2, 56, this.host.ID, this.host.destinationHost, false, false);
        this.host.onStatus(13);
    }

    void onSendingPad() {
        this.host.carrierSense = 0;
        this.host.collisionDetect = 1;
        this.host.sendDataEvent = null;
        if (this.dataEvent != null) {
            this.msg(712, "collision detected, \n   abort sending and begin\n   sending noise burst.");
            this.collisionDetect();
            return;
        }
        ++this.host.sentDataSize;
        --this.host.remainingSendDataSize;
        if (this.host.remainingSendDataSize <= 0) {
            this.msg(710, "complete sending to" + this.getDestinationString(this.host.destinationHost) + ".");
            this.sendLastData();
            return;
        }
        this.host.sendDataEvent = new DataEvent(this.host, 3, 56, this.host.ID, this.host.destinationHost, false, false);
        this.host.onStatus(14);
    }

    void onSendingNoise() {
        this.host.carrierSense = 0;
        this.host.collisionDetect = 2;
        this.host.sendDataEvent = null;
        if (this.host.remainingSendDataSize <= 0) {
            this.host.collisionDetect = 0;
            if (this.host.collisionCount < this.host.maxCollisionCount) {
                this.host.countdownTime = this.getBackoffTime();
                this.msg(710, "begin countdown.");
                this.host.onStatus(1);
                return;
            }
            this.host.collisionCount = 0;
            this.msg(712, "too many collisions,\n   discard frame.");
            this.endSending();
            return;
        }
        ++this.host.sentDataSize;
        --this.host.remainingSendDataSize;
        this.host.sendDataEvent = new DataEvent(this.host, 4, 56, this.host.ID, 0, false, false);
        this.host.onStatus(15);
    }

    boolean isNewFrameReceived() {
        boolean bl = false;
        if (this.dataEvent != null && this.dataEvent.getDataType() == 2 && this.dataEvent.hasStartBit() && this.isDataEventForHost()) {
            bl = true;
        }
        return bl;
    }

    boolean isDataToSend() {
        boolean bl = false;
        if (this.host.destinationHost != -1 && this.host.frameSize > 0) {
            bl = true;
        }
        return bl;
    }

    void beginReceiving() {
        this.host.sourceHost = this.dataEvent.getSourceHost();
        this.host.bufferedReceivedDataSize = 1;
        this.host.remainingReceiveDataSize = this.dataEvent.getDataSize() - 1;
        this.host.onStatus(11);
    }

    void abortReceiving() {
        this.host.bufferedReceivedDataSize = 1;
        this.host.remainingReceiveDataSize = 0;
        this.host.onStatus(0);
    }

    boolean isDataEventForHost() {
        return this.dataEvent.getDestinationHost() == this.host.ID || this.dataEvent.getDestinationHost() == 0;
    }

    void collisionDetect() {
        this.host.collisionDetect = 2;
        ++this.host.collisionCount;
        this.host.remainingSendDataSize = 23;
        ++this.host.sentDataSize;
        this.host.sendDataEvent = new DataEvent(this.host, 4, 24, this.host.ID, 0, false, false);
        this.host.onStatus(15);
    }

    void sendLastData() {
        this.host.sendDataEvent = new DataEvent(this.host, 2, this.host.frameSize, this.host.ID, this.host.destinationHost, false, true);
        this.host.collisionDetect = 0;
        this.endSending();
    }

    void endSending() {
        if (this.host.autoRepeat) {
            this.host.countdownTime = this.getRandomTime();
            this.host.onStatus(1);
            return;
        }
        this.host.setDestinationHost(-1);
        this.host.onStatus(0);
    }

    int getRandomTime() {
        double d = Math.random() * 49.99;
        return (int)d;
    }

    int getRandomTime(double d) {
        double d2 = Math.random() * d;
        return (int)d2;
    }

    int getBackoffTime() {
        int n = 1;
        int n2 = 0;
        while (n2 < this.host.collisionCount) {
            n = 2 * n;
            ++n2;
        }
        double d = Math.random() * ((double)n + 49.99);
        return (int)d;
    }

    void msg(int n, String string) {
        this.host.msgEvent = new MessageEvent(this.host, 701, n, "host" + this.host.ID, string);
    }

    String getDestinationString(int n) {
        if (n == 0) {
            return "all";
        }
        return "host" + new Integer(this.host.destinationHost).toString();
    }

    OnePersistentAlgorithm() {
    }
}

