/*
 * Decompiled with CFR 0.152.
 */
package kom.itbeankit.mm.compression.dct.view;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;

public class ImagePanel
extends Panel {
    static final int preferredWidth = 351;
    static final int preferredHeight = 288;
    static final int preferredBorder = 5;
    static final Color preferredBorderColor = Color.black;
    private Graphics g;
    private int width;
    private int height;
    private int border;
    private Image output;
    private Color borderColor;

    public ImagePanel() {
        this(351, 288, 5);
    }

    public ImagePanel(int w, int h, int b) {
        this.setWidth(w);
        this.setHeight(h);
        this.setBorder(b);
        this.setBorderColor(preferredBorderColor);
        this.g = this.getGraphics();
        this.repaint();
    }

    public int getBorder() {
        return this.border;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public int getHeight() {
        return this.height;
    }

    public Image getOutput() {
        return this.output;
    }

    public int getWidth() {
        return this.width;
    }

    public void paint(Graphics g) {
        this.paintBorder(g);
        if (this.output != null) {
            g.drawImage(this.output, this.border, this.border, this);
        }
    }

    private void paintBorder(Graphics g) {
        int i = 0;
        while (i < this.border) {
            g.setColor(this.borderColor);
            g.drawRect(i, i, this.width - 2 * i, this.height - 2 * i);
            ++i;
        }
    }

    public void setBorder(int b) {
        this.border = b;
    }

    public void setBorderColor(Color c) {
        this.borderColor = c;
        this.repaint();
    }

    public void setHeight(int h) {
        this.height = h;
        this.setSize(this.width, this.height);
    }

    public synchronized void setOutput(Image img) {
        this.output = img.getScaledInstance(this.width - 2 * this.border, this.height - 2 * this.border, 2);
        this.repaint();
    }

    public void setWidth(int w) {
        this.width = w;
        this.setSize(this.width, this.height);
    }

    public void update(Graphics g) {
        this.paint(g);
    }
}

