/*
 * Decompiled with CFR 0.152.
 */
package kom.itbeankit.mm.compression.mva.model;

import java.awt.Dimension;
import java.io.File;
import java.io.FilenameFilter;

public abstract class MVAFilenameFilter
implements FilenameFilter {
    public static final Dimension[] acceptableDimensions = new Dimension[]{new Dimension(352, 288), new Dimension(352, 240), new Dimension(176, 144), new Dimension(176, 128), new Dimension(96, 80)};
    private int dimensionFactor;
    private String workingDirectory;
    private String[] names;

    public MVAFilenameFilter(String workDir) {
        this.workingDirectory = workDir;
    }

    public MVAFilenameFilter(String workDir, String[] names) {
        this.workingDirectory = workDir;
        this.names = names;
    }

    public boolean accept(File dir, String name) {
        return dir.canRead() && dir.isFile() && this.checkName(name) && this.checkLength(dir.length());
    }

    public boolean checkLength(long length) {
        return MVAFilenameFilter.getDimension(length, this.dimensionFactor) != null;
    }

    public boolean checkName(String name) {
        int i = 0;
        while (i < this.names.length) {
            if (name.endsWith(this.names[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static Dimension getDimension(long availableBytes, int dimensionFactor) {
        int i = 0;
        while (i < acceptableDimensions.length) {
            long a = MVAFilenameFilter.acceptableDimensions[i].width * MVAFilenameFilter.acceptableDimensions[i].height;
            if (a == availableBytes || a * (long)dimensionFactor / 100L == availableBytes || (float)(a * (long)dimensionFactor / 100L) > (float)availableBytes && (float)(a * (long)dimensionFactor / 100L) < (float)availableBytes) {
                return acceptableDimensions[i];
            }
            ++i;
        }
        return null;
    }

    public int getDimensionFactor() {
        return this.dimensionFactor;
    }

    public static Dimension[] getLowerDimensions(Dimension dim) {
        Dimension[] lower = new Dimension[acceptableDimensions.length];
        int count = 0;
        int i = 0;
        while (i < lower.length) {
            if (dim.width >= MVAFilenameFilter.acceptableDimensions[i].width && dim.height >= MVAFilenameFilter.acceptableDimensions[i].height) {
                lower[count++] = acceptableDimensions[i];
            }
            ++i;
        }
        return lower;
    }

    public String[] getNames() {
        return this.names;
    }

    protected void setDimensionFactor(int factor) {
        this.dimensionFactor = factor;
    }

    protected void setNames(String[] names) {
        this.names = names;
    }
}

